/*
 * Copyright 2014 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.openhft.collect.map.hash;

import net.openhft.function.DoubleIntConsumer;

import java.util.Map;
import java.util.ServiceLoader;


/**
 * This class consists only of static factory methods to construct {@code HashDoubleIntMap}s, and
 * the default {@link HashDoubleIntMapFactory} static provider ({@link #getDefaultFactory()}).
 *
 * @see HashDoubleIntMap
 */
public final class HashDoubleIntMaps {

    

    private static final ServiceLoader<HashDoubleIntMapFactory> LOADER =
            ServiceLoader.load(HashDoubleIntMapFactory.class);
    private static HashDoubleIntMapFactory defaultFactory = null;

    public static HashDoubleIntMapFactory getDefaultFactory() {
        if (defaultFactory != null) {
            return defaultFactory;
        } else {
            // synchronization?
            return defaultFactory = LOADER.iterator().next();
        }
    }

    

    

    

    public static  HashDoubleIntMap newMutableMap() {
        return getDefaultFactory().newMutableMap();
    }

    public static  HashDoubleIntMap newMutableMap(int expectedSize) {
        return getDefaultFactory().newMutableMap(expectedSize);
    }



    
    


    public static  HashDoubleIntMap newMutableMap(Map<Double, Integer> map1,
            Map<Double, Integer> map2, int expectedSize) {
        return getDefaultFactory().newMutableMap(map1, map2, expectedSize);
    }

    public static  HashDoubleIntMap newMutableMap(Map<Double, Integer> map1,
            Map<Double, Integer> map2, Map<Double, Integer> map3, int expectedSize) {
        return getDefaultFactory().newMutableMap(map1, map2, map3, expectedSize);
    }

    public static  HashDoubleIntMap newMutableMap(Map<Double, Integer> map1,
            Map<Double, Integer> map2, Map<Double, Integer> map3,
            Map<Double, Integer> map4, int expectedSize) {
        return getDefaultFactory().newMutableMap(map1, map2, map3, map4, expectedSize);
    }

    public static  HashDoubleIntMap newMutableMap(Map<Double, Integer> map1,
            Map<Double, Integer> map2, Map<Double, Integer> map3,
            Map<Double, Integer> map4, Map<Double, Integer> map5, int expectedSize) {
        return getDefaultFactory().newMutableMap(map1, map2, map3, map4, map5, expectedSize);
    }

    
    

    
    public static  HashDoubleIntMap newMutableMap(
            Map<Double, Integer> map) {
        return getDefaultFactory().newMutableMap(map);
    }

    public static  HashDoubleIntMap newMutableMap(Map<Double, Integer> map1,
            Map<Double, Integer> map2) {
        return getDefaultFactory().newMutableMap(map1, map2);
    }

    public static  HashDoubleIntMap newMutableMap(Map<Double, Integer> map1,
            Map<Double, Integer> map2, Map<Double, Integer> map3) {
        return getDefaultFactory().newMutableMap(map1, map2, map3);
    }

    public static  HashDoubleIntMap newMutableMap(Map<Double, Integer> map1,
            Map<Double, Integer> map2, Map<Double, Integer> map3,
            Map<Double, Integer> map4) {
        return getDefaultFactory().newMutableMap(map1, map2, map3, map4);
    }

    public static  HashDoubleIntMap newMutableMap(Map<Double, Integer> map1,
            Map<Double, Integer> map2, Map<Double, Integer> map3,
            Map<Double, Integer> map4, Map<Double, Integer> map5) {
        return getDefaultFactory().newMutableMap(map1, map2, map3, map4, map5);
    }


    public static  HashDoubleIntMap newMutableMap(
            net.openhft.function.Consumer<DoubleIntConsumer> entriesSupplier) {
        return getDefaultFactory().newMutableMap(entriesSupplier);
    }

    public static  HashDoubleIntMap newMutableMap(
            net.openhft.function.Consumer<DoubleIntConsumer> entriesSupplier,
            int expectedSize) {
        return getDefaultFactory().newMutableMap(entriesSupplier, expectedSize);
    }

    public static  HashDoubleIntMap newMutableMap(
            double[] keys, int[] values) {
        return getDefaultFactory().newMutableMap(keys, values);
    }

    public static  HashDoubleIntMap newMutableMap(
            double[] keys, int[] values, int expectedSize) {
        return getDefaultFactory().newMutableMap(keys, values, expectedSize);
    }

    public static  HashDoubleIntMap newMutableMap(
            Double[] keys, Integer[] values) {
        return getDefaultFactory().newMutableMap(keys, values);
    }

    public static  HashDoubleIntMap newMutableMap(
            Double[] keys, Integer[] values, int expectedSize) {
        return getDefaultFactory().newMutableMap(keys, values, expectedSize);
    }

    public static  HashDoubleIntMap newMutableMap(Iterable<Double> keys,
            Iterable<Integer> values) {
        return getDefaultFactory().newMutableMap(keys, values);
    }

    public static  HashDoubleIntMap newMutableMap(Iterable<Double> keys,
            Iterable<Integer> values, int expectedSize) {
        return getDefaultFactory().newMutableMap(keys, values, expectedSize);
    }


    public static  HashDoubleIntMap newMutableMapOf(
            double k1, int v1) {
        return getDefaultFactory().newMutableMapOf(k1, v1);
    }

    public static  HashDoubleIntMap newMutableMapOf(
            double k1, int v1, double k2, int v2) {
        return getDefaultFactory().newMutableMapOf(k1, v1, k2, v2);
    }

    public static  HashDoubleIntMap newMutableMapOf(
            double k1, int v1, double k2, int v2,
            double k3, int v3) {
        return getDefaultFactory().newMutableMapOf(k1, v1, k2, v2, k3, v3);
    }

    public static  HashDoubleIntMap newMutableMapOf(
            double k1, int v1, double k2, int v2,
            double k3, int v3, double k4, int v4) {
        return getDefaultFactory().newMutableMapOf(k1, v1, k2, v2, k3, v3, k4, v4);
    }

    public static  HashDoubleIntMap newMutableMapOf(
            double k1, int v1, double k2, int v2,
            double k3, int v3, double k4, int v4,
            double k5, int v5) {
        return getDefaultFactory().newMutableMapOf(k1, v1, k2, v2, k3, v3, k4, v4, k5, v5);
    }

    
    


    public static  HashDoubleIntMap newUpdatableMap(Map<Double, Integer> map1,
            Map<Double, Integer> map2, int expectedSize) {
        return getDefaultFactory().newUpdatableMap(map1, map2, expectedSize);
    }

    public static  HashDoubleIntMap newUpdatableMap(Map<Double, Integer> map1,
            Map<Double, Integer> map2, Map<Double, Integer> map3, int expectedSize) {
        return getDefaultFactory().newUpdatableMap(map1, map2, map3, expectedSize);
    }

    public static  HashDoubleIntMap newUpdatableMap(Map<Double, Integer> map1,
            Map<Double, Integer> map2, Map<Double, Integer> map3,
            Map<Double, Integer> map4, int expectedSize) {
        return getDefaultFactory().newUpdatableMap(map1, map2, map3, map4, expectedSize);
    }

    public static  HashDoubleIntMap newUpdatableMap(Map<Double, Integer> map1,
            Map<Double, Integer> map2, Map<Double, Integer> map3,
            Map<Double, Integer> map4, Map<Double, Integer> map5, int expectedSize) {
        return getDefaultFactory().newUpdatableMap(map1, map2, map3, map4, map5, expectedSize);
    }

    
    

    
    public static  HashDoubleIntMap newUpdatableMap(
            Map<Double, Integer> map) {
        return getDefaultFactory().newUpdatableMap(map);
    }

    public static  HashDoubleIntMap newUpdatableMap(Map<Double, Integer> map1,
            Map<Double, Integer> map2) {
        return getDefaultFactory().newUpdatableMap(map1, map2);
    }

    public static  HashDoubleIntMap newUpdatableMap(Map<Double, Integer> map1,
            Map<Double, Integer> map2, Map<Double, Integer> map3) {
        return getDefaultFactory().newUpdatableMap(map1, map2, map3);
    }

    public static  HashDoubleIntMap newUpdatableMap(Map<Double, Integer> map1,
            Map<Double, Integer> map2, Map<Double, Integer> map3,
            Map<Double, Integer> map4) {
        return getDefaultFactory().newUpdatableMap(map1, map2, map3, map4);
    }

    public static  HashDoubleIntMap newUpdatableMap(Map<Double, Integer> map1,
            Map<Double, Integer> map2, Map<Double, Integer> map3,
            Map<Double, Integer> map4, Map<Double, Integer> map5) {
        return getDefaultFactory().newUpdatableMap(map1, map2, map3, map4, map5);
    }


    public static  HashDoubleIntMap newUpdatableMap(
            net.openhft.function.Consumer<DoubleIntConsumer> entriesSupplier) {
        return getDefaultFactory().newUpdatableMap(entriesSupplier);
    }

    public static  HashDoubleIntMap newUpdatableMap(
            net.openhft.function.Consumer<DoubleIntConsumer> entriesSupplier,
            int expectedSize) {
        return getDefaultFactory().newUpdatableMap(entriesSupplier, expectedSize);
    }

    public static  HashDoubleIntMap newUpdatableMap(
            double[] keys, int[] values) {
        return getDefaultFactory().newUpdatableMap(keys, values);
    }

    public static  HashDoubleIntMap newUpdatableMap(
            double[] keys, int[] values, int expectedSize) {
        return getDefaultFactory().newUpdatableMap(keys, values, expectedSize);
    }

    public static  HashDoubleIntMap newUpdatableMap(
            Double[] keys, Integer[] values) {
        return getDefaultFactory().newUpdatableMap(keys, values);
    }

    public static  HashDoubleIntMap newUpdatableMap(
            Double[] keys, Integer[] values, int expectedSize) {
        return getDefaultFactory().newUpdatableMap(keys, values, expectedSize);
    }

    public static  HashDoubleIntMap newUpdatableMap(Iterable<Double> keys,
            Iterable<Integer> values) {
        return getDefaultFactory().newUpdatableMap(keys, values);
    }

    public static  HashDoubleIntMap newUpdatableMap(Iterable<Double> keys,
            Iterable<Integer> values, int expectedSize) {
        return getDefaultFactory().newUpdatableMap(keys, values, expectedSize);
    }


    public static  HashDoubleIntMap newUpdatableMapOf(
            double k1, int v1) {
        return getDefaultFactory().newUpdatableMapOf(k1, v1);
    }

    public static  HashDoubleIntMap newUpdatableMapOf(
            double k1, int v1, double k2, int v2) {
        return getDefaultFactory().newUpdatableMapOf(k1, v1, k2, v2);
    }

    public static  HashDoubleIntMap newUpdatableMapOf(
            double k1, int v1, double k2, int v2,
            double k3, int v3) {
        return getDefaultFactory().newUpdatableMapOf(k1, v1, k2, v2, k3, v3);
    }

    public static  HashDoubleIntMap newUpdatableMapOf(
            double k1, int v1, double k2, int v2,
            double k3, int v3, double k4, int v4) {
        return getDefaultFactory().newUpdatableMapOf(k1, v1, k2, v2, k3, v3, k4, v4);
    }

    public static  HashDoubleIntMap newUpdatableMapOf(
            double k1, int v1, double k2, int v2,
            double k3, int v3, double k4, int v4,
            double k5, int v5) {
        return getDefaultFactory().newUpdatableMapOf(k1, v1, k2, v2, k3, v3, k4, v4, k5, v5);
    }

    
    


    public static  HashDoubleIntMap newImmutableMap(Map<Double, Integer> map1,
            Map<Double, Integer> map2, int expectedSize) {
        return getDefaultFactory().newImmutableMap(map1, map2, expectedSize);
    }

    public static  HashDoubleIntMap newImmutableMap(Map<Double, Integer> map1,
            Map<Double, Integer> map2, Map<Double, Integer> map3, int expectedSize) {
        return getDefaultFactory().newImmutableMap(map1, map2, map3, expectedSize);
    }

    public static  HashDoubleIntMap newImmutableMap(Map<Double, Integer> map1,
            Map<Double, Integer> map2, Map<Double, Integer> map3,
            Map<Double, Integer> map4, int expectedSize) {
        return getDefaultFactory().newImmutableMap(map1, map2, map3, map4, expectedSize);
    }

    public static  HashDoubleIntMap newImmutableMap(Map<Double, Integer> map1,
            Map<Double, Integer> map2, Map<Double, Integer> map3,
            Map<Double, Integer> map4, Map<Double, Integer> map5, int expectedSize) {
        return getDefaultFactory().newImmutableMap(map1, map2, map3, map4, map5, expectedSize);
    }

    
    

    
    public static  HashDoubleIntMap newImmutableMap(
            Map<Double, Integer> map) {
        return getDefaultFactory().newImmutableMap(map);
    }

    public static  HashDoubleIntMap newImmutableMap(Map<Double, Integer> map1,
            Map<Double, Integer> map2) {
        return getDefaultFactory().newImmutableMap(map1, map2);
    }

    public static  HashDoubleIntMap newImmutableMap(Map<Double, Integer> map1,
            Map<Double, Integer> map2, Map<Double, Integer> map3) {
        return getDefaultFactory().newImmutableMap(map1, map2, map3);
    }

    public static  HashDoubleIntMap newImmutableMap(Map<Double, Integer> map1,
            Map<Double, Integer> map2, Map<Double, Integer> map3,
            Map<Double, Integer> map4) {
        return getDefaultFactory().newImmutableMap(map1, map2, map3, map4);
    }

    public static  HashDoubleIntMap newImmutableMap(Map<Double, Integer> map1,
            Map<Double, Integer> map2, Map<Double, Integer> map3,
            Map<Double, Integer> map4, Map<Double, Integer> map5) {
        return getDefaultFactory().newImmutableMap(map1, map2, map3, map4, map5);
    }


    public static  HashDoubleIntMap newImmutableMap(
            net.openhft.function.Consumer<DoubleIntConsumer> entriesSupplier) {
        return getDefaultFactory().newImmutableMap(entriesSupplier);
    }

    public static  HashDoubleIntMap newImmutableMap(
            net.openhft.function.Consumer<DoubleIntConsumer> entriesSupplier,
            int expectedSize) {
        return getDefaultFactory().newImmutableMap(entriesSupplier, expectedSize);
    }

    public static  HashDoubleIntMap newImmutableMap(
            double[] keys, int[] values) {
        return getDefaultFactory().newImmutableMap(keys, values);
    }

    public static  HashDoubleIntMap newImmutableMap(
            double[] keys, int[] values, int expectedSize) {
        return getDefaultFactory().newImmutableMap(keys, values, expectedSize);
    }

    public static  HashDoubleIntMap newImmutableMap(
            Double[] keys, Integer[] values) {
        return getDefaultFactory().newImmutableMap(keys, values);
    }

    public static  HashDoubleIntMap newImmutableMap(
            Double[] keys, Integer[] values, int expectedSize) {
        return getDefaultFactory().newImmutableMap(keys, values, expectedSize);
    }

    public static  HashDoubleIntMap newImmutableMap(Iterable<Double> keys,
            Iterable<Integer> values) {
        return getDefaultFactory().newImmutableMap(keys, values);
    }

    public static  HashDoubleIntMap newImmutableMap(Iterable<Double> keys,
            Iterable<Integer> values, int expectedSize) {
        return getDefaultFactory().newImmutableMap(keys, values, expectedSize);
    }


    public static  HashDoubleIntMap newImmutableMapOf(
            double k1, int v1) {
        return getDefaultFactory().newImmutableMapOf(k1, v1);
    }

    public static  HashDoubleIntMap newImmutableMapOf(
            double k1, int v1, double k2, int v2) {
        return getDefaultFactory().newImmutableMapOf(k1, v1, k2, v2);
    }

    public static  HashDoubleIntMap newImmutableMapOf(
            double k1, int v1, double k2, int v2,
            double k3, int v3) {
        return getDefaultFactory().newImmutableMapOf(k1, v1, k2, v2, k3, v3);
    }

    public static  HashDoubleIntMap newImmutableMapOf(
            double k1, int v1, double k2, int v2,
            double k3, int v3, double k4, int v4) {
        return getDefaultFactory().newImmutableMapOf(k1, v1, k2, v2, k3, v3, k4, v4);
    }

    public static  HashDoubleIntMap newImmutableMapOf(
            double k1, int v1, double k2, int v2,
            double k3, int v3, double k4, int v4,
            double k5, int v5) {
        return getDefaultFactory().newImmutableMapOf(k1, v1, k2, v2, k3, v3, k4, v4, k5, v5);
    }

    private HashDoubleIntMaps() {}
}

