/*
 * Copyright 2014 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.openhft.collect.map.hash;

import net.openhft.collect.*;
import net.openhft.collect.hash.*;
import net.openhft.function.DoubleIntConsumer;
import net.openhft.collect.map.*;
import javax.annotation.Nullable;

import java.util.Map;


/**
 * An immutable factory of {@code HashDoubleIntMaps}
 *
 * @see HashDoubleIntMap
 * @see HashDoubleIntMaps#getDefaultFactory()
 */
public interface HashDoubleIntMapFactory extends DoubleIntMapFactory
        , HashContainerFactory<HashDoubleIntMapFactory> {

    

    

    

    

    

    
    

    
    


    @Override
    HashDoubleIntMapFactory withDefaultValue(int defaultValue);

    @Override
     HashDoubleIntMap newMutableMap();

    @Override
     HashDoubleIntMap newMutableMap(int expectedSize);

    


    @Override
     HashDoubleIntMap newMutableMap(Map<Double, Integer> map1,
            Map<Double, Integer> map2, int expectedSize);

    @Override
     HashDoubleIntMap newMutableMap(Map<Double, Integer> map1,
            Map<Double, Integer> map2, Map<Double, Integer> map3, int expectedSize);

    @Override
     HashDoubleIntMap newMutableMap(Map<Double, Integer> map1,
            Map<Double, Integer> map2, Map<Double, Integer> map3,
            Map<Double, Integer> map4, int expectedSize);

    @Override
     HashDoubleIntMap newMutableMap(Map<Double, Integer> map1,
            Map<Double, Integer> map2, Map<Double, Integer> map3,
            Map<Double, Integer> map4, Map<Double, Integer> map5, int expectedSize);

    

    
    @Override
     HashDoubleIntMap newMutableMap(Map<Double, Integer> map);

    @Override
     HashDoubleIntMap newMutableMap(Map<Double, Integer> map1,
            Map<Double, Integer> map2);

    @Override
     HashDoubleIntMap newMutableMap(Map<Double, Integer> map1,
            Map<Double, Integer> map2, Map<Double, Integer> map3);

    @Override
     HashDoubleIntMap newMutableMap(Map<Double, Integer> map1,
            Map<Double, Integer> map2, Map<Double, Integer> map3,
            Map<Double, Integer> map4);

    @Override
     HashDoubleIntMap newMutableMap(Map<Double, Integer> map1,
            Map<Double, Integer> map2, Map<Double, Integer> map3,
            Map<Double, Integer> map4, Map<Double, Integer> map5);


    @Override
     HashDoubleIntMap newMutableMap(
            net.openhft.function.Consumer<DoubleIntConsumer> entriesSupplier);

    @Override
     HashDoubleIntMap newMutableMap(
            net.openhft.function.Consumer<DoubleIntConsumer> entriesSupplier,
            int expectedSize);

    @Override
     HashDoubleIntMap newMutableMap(double[] keys, int[] values);

    @Override
     HashDoubleIntMap newMutableMap(double[] keys, int[] values,
            int expectedSize);

    @Override
     HashDoubleIntMap newMutableMap(
            Double[] keys, Integer[] values);

    @Override
     HashDoubleIntMap newMutableMap(
            Double[] keys, Integer[] values, int expectedSize);

    @Override
     HashDoubleIntMap newMutableMap(Iterable<Double> keys,
            Iterable<Integer> values);

    @Override
     HashDoubleIntMap newMutableMap(Iterable<Double> keys,
            Iterable<Integer> values, int expectedSize);


    @Override
     HashDoubleIntMap newMutableMapOf(double k1, int v1);

    @Override
     HashDoubleIntMap newMutableMapOf(double k1, int v1,
            double k2, int v2);

    @Override
     HashDoubleIntMap newMutableMapOf(double k1, int v1,
            double k2, int v2, double k3, int v3);

    @Override
     HashDoubleIntMap newMutableMapOf(double k1, int v1,
            double k2, int v2, double k3, int v3,
            double k4, int v4);

    @Override
     HashDoubleIntMap newMutableMapOf(double k1, int v1,
            double k2, int v2, double k3, int v3,
            double k4, int v4, double k5, int v5);
    @Override
     HashDoubleIntMap newUpdatableMap();

    @Override
     HashDoubleIntMap newUpdatableMap(int expectedSize);

    


    @Override
     HashDoubleIntMap newUpdatableMap(Map<Double, Integer> map1,
            Map<Double, Integer> map2, int expectedSize);

    @Override
     HashDoubleIntMap newUpdatableMap(Map<Double, Integer> map1,
            Map<Double, Integer> map2, Map<Double, Integer> map3, int expectedSize);

    @Override
     HashDoubleIntMap newUpdatableMap(Map<Double, Integer> map1,
            Map<Double, Integer> map2, Map<Double, Integer> map3,
            Map<Double, Integer> map4, int expectedSize);

    @Override
     HashDoubleIntMap newUpdatableMap(Map<Double, Integer> map1,
            Map<Double, Integer> map2, Map<Double, Integer> map3,
            Map<Double, Integer> map4, Map<Double, Integer> map5, int expectedSize);

    

    
    @Override
     HashDoubleIntMap newUpdatableMap(Map<Double, Integer> map);

    @Override
     HashDoubleIntMap newUpdatableMap(Map<Double, Integer> map1,
            Map<Double, Integer> map2);

    @Override
     HashDoubleIntMap newUpdatableMap(Map<Double, Integer> map1,
            Map<Double, Integer> map2, Map<Double, Integer> map3);

    @Override
     HashDoubleIntMap newUpdatableMap(Map<Double, Integer> map1,
            Map<Double, Integer> map2, Map<Double, Integer> map3,
            Map<Double, Integer> map4);

    @Override
     HashDoubleIntMap newUpdatableMap(Map<Double, Integer> map1,
            Map<Double, Integer> map2, Map<Double, Integer> map3,
            Map<Double, Integer> map4, Map<Double, Integer> map5);


    @Override
     HashDoubleIntMap newUpdatableMap(
            net.openhft.function.Consumer<DoubleIntConsumer> entriesSupplier);

    @Override
     HashDoubleIntMap newUpdatableMap(
            net.openhft.function.Consumer<DoubleIntConsumer> entriesSupplier,
            int expectedSize);

    @Override
     HashDoubleIntMap newUpdatableMap(double[] keys, int[] values);

    @Override
     HashDoubleIntMap newUpdatableMap(double[] keys, int[] values,
            int expectedSize);

    @Override
     HashDoubleIntMap newUpdatableMap(
            Double[] keys, Integer[] values);

    @Override
     HashDoubleIntMap newUpdatableMap(
            Double[] keys, Integer[] values, int expectedSize);

    @Override
     HashDoubleIntMap newUpdatableMap(Iterable<Double> keys,
            Iterable<Integer> values);

    @Override
     HashDoubleIntMap newUpdatableMap(Iterable<Double> keys,
            Iterable<Integer> values, int expectedSize);


    @Override
     HashDoubleIntMap newUpdatableMapOf(double k1, int v1);

    @Override
     HashDoubleIntMap newUpdatableMapOf(double k1, int v1,
            double k2, int v2);

    @Override
     HashDoubleIntMap newUpdatableMapOf(double k1, int v1,
            double k2, int v2, double k3, int v3);

    @Override
     HashDoubleIntMap newUpdatableMapOf(double k1, int v1,
            double k2, int v2, double k3, int v3,
            double k4, int v4);

    @Override
     HashDoubleIntMap newUpdatableMapOf(double k1, int v1,
            double k2, int v2, double k3, int v3,
            double k4, int v4, double k5, int v5);

    


    @Override
     HashDoubleIntMap newImmutableMap(Map<Double, Integer> map1,
            Map<Double, Integer> map2, int expectedSize);

    @Override
     HashDoubleIntMap newImmutableMap(Map<Double, Integer> map1,
            Map<Double, Integer> map2, Map<Double, Integer> map3, int expectedSize);

    @Override
     HashDoubleIntMap newImmutableMap(Map<Double, Integer> map1,
            Map<Double, Integer> map2, Map<Double, Integer> map3,
            Map<Double, Integer> map4, int expectedSize);

    @Override
     HashDoubleIntMap newImmutableMap(Map<Double, Integer> map1,
            Map<Double, Integer> map2, Map<Double, Integer> map3,
            Map<Double, Integer> map4, Map<Double, Integer> map5, int expectedSize);

    

    
    @Override
     HashDoubleIntMap newImmutableMap(Map<Double, Integer> map);

    @Override
     HashDoubleIntMap newImmutableMap(Map<Double, Integer> map1,
            Map<Double, Integer> map2);

    @Override
     HashDoubleIntMap newImmutableMap(Map<Double, Integer> map1,
            Map<Double, Integer> map2, Map<Double, Integer> map3);

    @Override
     HashDoubleIntMap newImmutableMap(Map<Double, Integer> map1,
            Map<Double, Integer> map2, Map<Double, Integer> map3,
            Map<Double, Integer> map4);

    @Override
     HashDoubleIntMap newImmutableMap(Map<Double, Integer> map1,
            Map<Double, Integer> map2, Map<Double, Integer> map3,
            Map<Double, Integer> map4, Map<Double, Integer> map5);


    @Override
     HashDoubleIntMap newImmutableMap(
            net.openhft.function.Consumer<DoubleIntConsumer> entriesSupplier);

    @Override
     HashDoubleIntMap newImmutableMap(
            net.openhft.function.Consumer<DoubleIntConsumer> entriesSupplier,
            int expectedSize);

    @Override
     HashDoubleIntMap newImmutableMap(double[] keys, int[] values);

    @Override
     HashDoubleIntMap newImmutableMap(double[] keys, int[] values,
            int expectedSize);

    @Override
     HashDoubleIntMap newImmutableMap(
            Double[] keys, Integer[] values);

    @Override
     HashDoubleIntMap newImmutableMap(
            Double[] keys, Integer[] values, int expectedSize);

    @Override
     HashDoubleIntMap newImmutableMap(Iterable<Double> keys,
            Iterable<Integer> values);

    @Override
     HashDoubleIntMap newImmutableMap(Iterable<Double> keys,
            Iterable<Integer> values, int expectedSize);


    @Override
     HashDoubleIntMap newImmutableMapOf(double k1, int v1);

    @Override
     HashDoubleIntMap newImmutableMapOf(double k1, int v1,
            double k2, int v2);

    @Override
     HashDoubleIntMap newImmutableMapOf(double k1, int v1,
            double k2, int v2, double k3, int v3);

    @Override
     HashDoubleIntMap newImmutableMapOf(double k1, int v1,
            double k2, int v2, double k3, int v3,
            double k4, int v4);

    @Override
     HashDoubleIntMap newImmutableMapOf(double k1, int v1,
            double k2, int v2, double k3, int v3,
            double k4, int v4, double k5, int v5);
}

