/*
 * Copyright 2014 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.openhft.collect.map.hash;

import net.openhft.function.DoubleFloatConsumer;

import java.util.Map;
import java.util.ServiceLoader;


/**
 * This class consists only of static factory methods to construct {@code HashDoubleFloatMap}s, and
 * the default {@link HashDoubleFloatMapFactory} static provider ({@link #getDefaultFactory()}).
 *
 * @see HashDoubleFloatMap
 */
public final class HashDoubleFloatMaps {

    

    private static final ServiceLoader<HashDoubleFloatMapFactory> LOADER =
            ServiceLoader.load(HashDoubleFloatMapFactory.class);
    private static HashDoubleFloatMapFactory defaultFactory = null;

    public static HashDoubleFloatMapFactory getDefaultFactory() {
        if (defaultFactory != null) {
            return defaultFactory;
        } else {
            // synchronization?
            return defaultFactory = LOADER.iterator().next();
        }
    }

    

    

    

    public static  HashDoubleFloatMap newMutableMap() {
        return getDefaultFactory().newMutableMap();
    }

    public static  HashDoubleFloatMap newMutableMap(int expectedSize) {
        return getDefaultFactory().newMutableMap(expectedSize);
    }



    
    


    public static  HashDoubleFloatMap newMutableMap(Map<Double, Float> map1,
            Map<Double, Float> map2, int expectedSize) {
        return getDefaultFactory().newMutableMap(map1, map2, expectedSize);
    }

    public static  HashDoubleFloatMap newMutableMap(Map<Double, Float> map1,
            Map<Double, Float> map2, Map<Double, Float> map3, int expectedSize) {
        return getDefaultFactory().newMutableMap(map1, map2, map3, expectedSize);
    }

    public static  HashDoubleFloatMap newMutableMap(Map<Double, Float> map1,
            Map<Double, Float> map2, Map<Double, Float> map3,
            Map<Double, Float> map4, int expectedSize) {
        return getDefaultFactory().newMutableMap(map1, map2, map3, map4, expectedSize);
    }

    public static  HashDoubleFloatMap newMutableMap(Map<Double, Float> map1,
            Map<Double, Float> map2, Map<Double, Float> map3,
            Map<Double, Float> map4, Map<Double, Float> map5, int expectedSize) {
        return getDefaultFactory().newMutableMap(map1, map2, map3, map4, map5, expectedSize);
    }

    
    

    
    public static  HashDoubleFloatMap newMutableMap(
            Map<Double, Float> map) {
        return getDefaultFactory().newMutableMap(map);
    }

    public static  HashDoubleFloatMap newMutableMap(Map<Double, Float> map1,
            Map<Double, Float> map2) {
        return getDefaultFactory().newMutableMap(map1, map2);
    }

    public static  HashDoubleFloatMap newMutableMap(Map<Double, Float> map1,
            Map<Double, Float> map2, Map<Double, Float> map3) {
        return getDefaultFactory().newMutableMap(map1, map2, map3);
    }

    public static  HashDoubleFloatMap newMutableMap(Map<Double, Float> map1,
            Map<Double, Float> map2, Map<Double, Float> map3,
            Map<Double, Float> map4) {
        return getDefaultFactory().newMutableMap(map1, map2, map3, map4);
    }

    public static  HashDoubleFloatMap newMutableMap(Map<Double, Float> map1,
            Map<Double, Float> map2, Map<Double, Float> map3,
            Map<Double, Float> map4, Map<Double, Float> map5) {
        return getDefaultFactory().newMutableMap(map1, map2, map3, map4, map5);
    }


    public static  HashDoubleFloatMap newMutableMap(
            net.openhft.function.Consumer<DoubleFloatConsumer> entriesSupplier) {
        return getDefaultFactory().newMutableMap(entriesSupplier);
    }

    public static  HashDoubleFloatMap newMutableMap(
            net.openhft.function.Consumer<DoubleFloatConsumer> entriesSupplier,
            int expectedSize) {
        return getDefaultFactory().newMutableMap(entriesSupplier, expectedSize);
    }

    public static  HashDoubleFloatMap newMutableMap(
            double[] keys, float[] values) {
        return getDefaultFactory().newMutableMap(keys, values);
    }

    public static  HashDoubleFloatMap newMutableMap(
            double[] keys, float[] values, int expectedSize) {
        return getDefaultFactory().newMutableMap(keys, values, expectedSize);
    }

    public static  HashDoubleFloatMap newMutableMap(
            Double[] keys, Float[] values) {
        return getDefaultFactory().newMutableMap(keys, values);
    }

    public static  HashDoubleFloatMap newMutableMap(
            Double[] keys, Float[] values, int expectedSize) {
        return getDefaultFactory().newMutableMap(keys, values, expectedSize);
    }

    public static  HashDoubleFloatMap newMutableMap(Iterable<Double> keys,
            Iterable<Float> values) {
        return getDefaultFactory().newMutableMap(keys, values);
    }

    public static  HashDoubleFloatMap newMutableMap(Iterable<Double> keys,
            Iterable<Float> values, int expectedSize) {
        return getDefaultFactory().newMutableMap(keys, values, expectedSize);
    }


    public static  HashDoubleFloatMap newMutableMapOf(
            double k1, float v1) {
        return getDefaultFactory().newMutableMapOf(k1, v1);
    }

    public static  HashDoubleFloatMap newMutableMapOf(
            double k1, float v1, double k2, float v2) {
        return getDefaultFactory().newMutableMapOf(k1, v1, k2, v2);
    }

    public static  HashDoubleFloatMap newMutableMapOf(
            double k1, float v1, double k2, float v2,
            double k3, float v3) {
        return getDefaultFactory().newMutableMapOf(k1, v1, k2, v2, k3, v3);
    }

    public static  HashDoubleFloatMap newMutableMapOf(
            double k1, float v1, double k2, float v2,
            double k3, float v3, double k4, float v4) {
        return getDefaultFactory().newMutableMapOf(k1, v1, k2, v2, k3, v3, k4, v4);
    }

    public static  HashDoubleFloatMap newMutableMapOf(
            double k1, float v1, double k2, float v2,
            double k3, float v3, double k4, float v4,
            double k5, float v5) {
        return getDefaultFactory().newMutableMapOf(k1, v1, k2, v2, k3, v3, k4, v4, k5, v5);
    }

    
    


    public static  HashDoubleFloatMap newUpdatableMap(Map<Double, Float> map1,
            Map<Double, Float> map2, int expectedSize) {
        return getDefaultFactory().newUpdatableMap(map1, map2, expectedSize);
    }

    public static  HashDoubleFloatMap newUpdatableMap(Map<Double, Float> map1,
            Map<Double, Float> map2, Map<Double, Float> map3, int expectedSize) {
        return getDefaultFactory().newUpdatableMap(map1, map2, map3, expectedSize);
    }

    public static  HashDoubleFloatMap newUpdatableMap(Map<Double, Float> map1,
            Map<Double, Float> map2, Map<Double, Float> map3,
            Map<Double, Float> map4, int expectedSize) {
        return getDefaultFactory().newUpdatableMap(map1, map2, map3, map4, expectedSize);
    }

    public static  HashDoubleFloatMap newUpdatableMap(Map<Double, Float> map1,
            Map<Double, Float> map2, Map<Double, Float> map3,
            Map<Double, Float> map4, Map<Double, Float> map5, int expectedSize) {
        return getDefaultFactory().newUpdatableMap(map1, map2, map3, map4, map5, expectedSize);
    }

    
    

    
    public static  HashDoubleFloatMap newUpdatableMap(
            Map<Double, Float> map) {
        return getDefaultFactory().newUpdatableMap(map);
    }

    public static  HashDoubleFloatMap newUpdatableMap(Map<Double, Float> map1,
            Map<Double, Float> map2) {
        return getDefaultFactory().newUpdatableMap(map1, map2);
    }

    public static  HashDoubleFloatMap newUpdatableMap(Map<Double, Float> map1,
            Map<Double, Float> map2, Map<Double, Float> map3) {
        return getDefaultFactory().newUpdatableMap(map1, map2, map3);
    }

    public static  HashDoubleFloatMap newUpdatableMap(Map<Double, Float> map1,
            Map<Double, Float> map2, Map<Double, Float> map3,
            Map<Double, Float> map4) {
        return getDefaultFactory().newUpdatableMap(map1, map2, map3, map4);
    }

    public static  HashDoubleFloatMap newUpdatableMap(Map<Double, Float> map1,
            Map<Double, Float> map2, Map<Double, Float> map3,
            Map<Double, Float> map4, Map<Double, Float> map5) {
        return getDefaultFactory().newUpdatableMap(map1, map2, map3, map4, map5);
    }


    public static  HashDoubleFloatMap newUpdatableMap(
            net.openhft.function.Consumer<DoubleFloatConsumer> entriesSupplier) {
        return getDefaultFactory().newUpdatableMap(entriesSupplier);
    }

    public static  HashDoubleFloatMap newUpdatableMap(
            net.openhft.function.Consumer<DoubleFloatConsumer> entriesSupplier,
            int expectedSize) {
        return getDefaultFactory().newUpdatableMap(entriesSupplier, expectedSize);
    }

    public static  HashDoubleFloatMap newUpdatableMap(
            double[] keys, float[] values) {
        return getDefaultFactory().newUpdatableMap(keys, values);
    }

    public static  HashDoubleFloatMap newUpdatableMap(
            double[] keys, float[] values, int expectedSize) {
        return getDefaultFactory().newUpdatableMap(keys, values, expectedSize);
    }

    public static  HashDoubleFloatMap newUpdatableMap(
            Double[] keys, Float[] values) {
        return getDefaultFactory().newUpdatableMap(keys, values);
    }

    public static  HashDoubleFloatMap newUpdatableMap(
            Double[] keys, Float[] values, int expectedSize) {
        return getDefaultFactory().newUpdatableMap(keys, values, expectedSize);
    }

    public static  HashDoubleFloatMap newUpdatableMap(Iterable<Double> keys,
            Iterable<Float> values) {
        return getDefaultFactory().newUpdatableMap(keys, values);
    }

    public static  HashDoubleFloatMap newUpdatableMap(Iterable<Double> keys,
            Iterable<Float> values, int expectedSize) {
        return getDefaultFactory().newUpdatableMap(keys, values, expectedSize);
    }


    public static  HashDoubleFloatMap newUpdatableMapOf(
            double k1, float v1) {
        return getDefaultFactory().newUpdatableMapOf(k1, v1);
    }

    public static  HashDoubleFloatMap newUpdatableMapOf(
            double k1, float v1, double k2, float v2) {
        return getDefaultFactory().newUpdatableMapOf(k1, v1, k2, v2);
    }

    public static  HashDoubleFloatMap newUpdatableMapOf(
            double k1, float v1, double k2, float v2,
            double k3, float v3) {
        return getDefaultFactory().newUpdatableMapOf(k1, v1, k2, v2, k3, v3);
    }

    public static  HashDoubleFloatMap newUpdatableMapOf(
            double k1, float v1, double k2, float v2,
            double k3, float v3, double k4, float v4) {
        return getDefaultFactory().newUpdatableMapOf(k1, v1, k2, v2, k3, v3, k4, v4);
    }

    public static  HashDoubleFloatMap newUpdatableMapOf(
            double k1, float v1, double k2, float v2,
            double k3, float v3, double k4, float v4,
            double k5, float v5) {
        return getDefaultFactory().newUpdatableMapOf(k1, v1, k2, v2, k3, v3, k4, v4, k5, v5);
    }

    
    


    public static  HashDoubleFloatMap newImmutableMap(Map<Double, Float> map1,
            Map<Double, Float> map2, int expectedSize) {
        return getDefaultFactory().newImmutableMap(map1, map2, expectedSize);
    }

    public static  HashDoubleFloatMap newImmutableMap(Map<Double, Float> map1,
            Map<Double, Float> map2, Map<Double, Float> map3, int expectedSize) {
        return getDefaultFactory().newImmutableMap(map1, map2, map3, expectedSize);
    }

    public static  HashDoubleFloatMap newImmutableMap(Map<Double, Float> map1,
            Map<Double, Float> map2, Map<Double, Float> map3,
            Map<Double, Float> map4, int expectedSize) {
        return getDefaultFactory().newImmutableMap(map1, map2, map3, map4, expectedSize);
    }

    public static  HashDoubleFloatMap newImmutableMap(Map<Double, Float> map1,
            Map<Double, Float> map2, Map<Double, Float> map3,
            Map<Double, Float> map4, Map<Double, Float> map5, int expectedSize) {
        return getDefaultFactory().newImmutableMap(map1, map2, map3, map4, map5, expectedSize);
    }

    
    

    
    public static  HashDoubleFloatMap newImmutableMap(
            Map<Double, Float> map) {
        return getDefaultFactory().newImmutableMap(map);
    }

    public static  HashDoubleFloatMap newImmutableMap(Map<Double, Float> map1,
            Map<Double, Float> map2) {
        return getDefaultFactory().newImmutableMap(map1, map2);
    }

    public static  HashDoubleFloatMap newImmutableMap(Map<Double, Float> map1,
            Map<Double, Float> map2, Map<Double, Float> map3) {
        return getDefaultFactory().newImmutableMap(map1, map2, map3);
    }

    public static  HashDoubleFloatMap newImmutableMap(Map<Double, Float> map1,
            Map<Double, Float> map2, Map<Double, Float> map3,
            Map<Double, Float> map4) {
        return getDefaultFactory().newImmutableMap(map1, map2, map3, map4);
    }

    public static  HashDoubleFloatMap newImmutableMap(Map<Double, Float> map1,
            Map<Double, Float> map2, Map<Double, Float> map3,
            Map<Double, Float> map4, Map<Double, Float> map5) {
        return getDefaultFactory().newImmutableMap(map1, map2, map3, map4, map5);
    }


    public static  HashDoubleFloatMap newImmutableMap(
            net.openhft.function.Consumer<DoubleFloatConsumer> entriesSupplier) {
        return getDefaultFactory().newImmutableMap(entriesSupplier);
    }

    public static  HashDoubleFloatMap newImmutableMap(
            net.openhft.function.Consumer<DoubleFloatConsumer> entriesSupplier,
            int expectedSize) {
        return getDefaultFactory().newImmutableMap(entriesSupplier, expectedSize);
    }

    public static  HashDoubleFloatMap newImmutableMap(
            double[] keys, float[] values) {
        return getDefaultFactory().newImmutableMap(keys, values);
    }

    public static  HashDoubleFloatMap newImmutableMap(
            double[] keys, float[] values, int expectedSize) {
        return getDefaultFactory().newImmutableMap(keys, values, expectedSize);
    }

    public static  HashDoubleFloatMap newImmutableMap(
            Double[] keys, Float[] values) {
        return getDefaultFactory().newImmutableMap(keys, values);
    }

    public static  HashDoubleFloatMap newImmutableMap(
            Double[] keys, Float[] values, int expectedSize) {
        return getDefaultFactory().newImmutableMap(keys, values, expectedSize);
    }

    public static  HashDoubleFloatMap newImmutableMap(Iterable<Double> keys,
            Iterable<Float> values) {
        return getDefaultFactory().newImmutableMap(keys, values);
    }

    public static  HashDoubleFloatMap newImmutableMap(Iterable<Double> keys,
            Iterable<Float> values, int expectedSize) {
        return getDefaultFactory().newImmutableMap(keys, values, expectedSize);
    }


    public static  HashDoubleFloatMap newImmutableMapOf(
            double k1, float v1) {
        return getDefaultFactory().newImmutableMapOf(k1, v1);
    }

    public static  HashDoubleFloatMap newImmutableMapOf(
            double k1, float v1, double k2, float v2) {
        return getDefaultFactory().newImmutableMapOf(k1, v1, k2, v2);
    }

    public static  HashDoubleFloatMap newImmutableMapOf(
            double k1, float v1, double k2, float v2,
            double k3, float v3) {
        return getDefaultFactory().newImmutableMapOf(k1, v1, k2, v2, k3, v3);
    }

    public static  HashDoubleFloatMap newImmutableMapOf(
            double k1, float v1, double k2, float v2,
            double k3, float v3, double k4, float v4) {
        return getDefaultFactory().newImmutableMapOf(k1, v1, k2, v2, k3, v3, k4, v4);
    }

    public static  HashDoubleFloatMap newImmutableMapOf(
            double k1, float v1, double k2, float v2,
            double k3, float v3, double k4, float v4,
            double k5, float v5) {
        return getDefaultFactory().newImmutableMapOf(k1, v1, k2, v2, k3, v3, k4, v4, k5, v5);
    }

    private HashDoubleFloatMaps() {}
}

