/*
 * Copyright 2014 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.openhft.collect.map.hash;

import net.openhft.collect.*;
import net.openhft.collect.hash.*;
import net.openhft.function.DoubleFloatConsumer;
import net.openhft.collect.map.*;
import javax.annotation.Nullable;

import java.util.Map;


/**
 * An immutable factory of {@code HashDoubleFloatMaps}
 *
 * @see HashDoubleFloatMap
 * @see HashDoubleFloatMaps#getDefaultFactory()
 */
public interface HashDoubleFloatMapFactory extends DoubleFloatMapFactory
        , HashContainerFactory<HashDoubleFloatMapFactory> {

    

    

    

    

    

    
    

    
    


    @Override
    HashDoubleFloatMapFactory withDefaultValue(float defaultValue);

    @Override
     HashDoubleFloatMap newMutableMap();

    @Override
     HashDoubleFloatMap newMutableMap(int expectedSize);

    


    @Override
     HashDoubleFloatMap newMutableMap(Map<Double, Float> map1,
            Map<Double, Float> map2, int expectedSize);

    @Override
     HashDoubleFloatMap newMutableMap(Map<Double, Float> map1,
            Map<Double, Float> map2, Map<Double, Float> map3, int expectedSize);

    @Override
     HashDoubleFloatMap newMutableMap(Map<Double, Float> map1,
            Map<Double, Float> map2, Map<Double, Float> map3,
            Map<Double, Float> map4, int expectedSize);

    @Override
     HashDoubleFloatMap newMutableMap(Map<Double, Float> map1,
            Map<Double, Float> map2, Map<Double, Float> map3,
            Map<Double, Float> map4, Map<Double, Float> map5, int expectedSize);

    

    
    @Override
     HashDoubleFloatMap newMutableMap(Map<Double, Float> map);

    @Override
     HashDoubleFloatMap newMutableMap(Map<Double, Float> map1,
            Map<Double, Float> map2);

    @Override
     HashDoubleFloatMap newMutableMap(Map<Double, Float> map1,
            Map<Double, Float> map2, Map<Double, Float> map3);

    @Override
     HashDoubleFloatMap newMutableMap(Map<Double, Float> map1,
            Map<Double, Float> map2, Map<Double, Float> map3,
            Map<Double, Float> map4);

    @Override
     HashDoubleFloatMap newMutableMap(Map<Double, Float> map1,
            Map<Double, Float> map2, Map<Double, Float> map3,
            Map<Double, Float> map4, Map<Double, Float> map5);


    @Override
     HashDoubleFloatMap newMutableMap(
            net.openhft.function.Consumer<DoubleFloatConsumer> entriesSupplier);

    @Override
     HashDoubleFloatMap newMutableMap(
            net.openhft.function.Consumer<DoubleFloatConsumer> entriesSupplier,
            int expectedSize);

    @Override
     HashDoubleFloatMap newMutableMap(double[] keys, float[] values);

    @Override
     HashDoubleFloatMap newMutableMap(double[] keys, float[] values,
            int expectedSize);

    @Override
     HashDoubleFloatMap newMutableMap(
            Double[] keys, Float[] values);

    @Override
     HashDoubleFloatMap newMutableMap(
            Double[] keys, Float[] values, int expectedSize);

    @Override
     HashDoubleFloatMap newMutableMap(Iterable<Double> keys,
            Iterable<Float> values);

    @Override
     HashDoubleFloatMap newMutableMap(Iterable<Double> keys,
            Iterable<Float> values, int expectedSize);


    @Override
     HashDoubleFloatMap newMutableMapOf(double k1, float v1);

    @Override
     HashDoubleFloatMap newMutableMapOf(double k1, float v1,
            double k2, float v2);

    @Override
     HashDoubleFloatMap newMutableMapOf(double k1, float v1,
            double k2, float v2, double k3, float v3);

    @Override
     HashDoubleFloatMap newMutableMapOf(double k1, float v1,
            double k2, float v2, double k3, float v3,
            double k4, float v4);

    @Override
     HashDoubleFloatMap newMutableMapOf(double k1, float v1,
            double k2, float v2, double k3, float v3,
            double k4, float v4, double k5, float v5);
    @Override
     HashDoubleFloatMap newUpdatableMap();

    @Override
     HashDoubleFloatMap newUpdatableMap(int expectedSize);

    


    @Override
     HashDoubleFloatMap newUpdatableMap(Map<Double, Float> map1,
            Map<Double, Float> map2, int expectedSize);

    @Override
     HashDoubleFloatMap newUpdatableMap(Map<Double, Float> map1,
            Map<Double, Float> map2, Map<Double, Float> map3, int expectedSize);

    @Override
     HashDoubleFloatMap newUpdatableMap(Map<Double, Float> map1,
            Map<Double, Float> map2, Map<Double, Float> map3,
            Map<Double, Float> map4, int expectedSize);

    @Override
     HashDoubleFloatMap newUpdatableMap(Map<Double, Float> map1,
            Map<Double, Float> map2, Map<Double, Float> map3,
            Map<Double, Float> map4, Map<Double, Float> map5, int expectedSize);

    

    
    @Override
     HashDoubleFloatMap newUpdatableMap(Map<Double, Float> map);

    @Override
     HashDoubleFloatMap newUpdatableMap(Map<Double, Float> map1,
            Map<Double, Float> map2);

    @Override
     HashDoubleFloatMap newUpdatableMap(Map<Double, Float> map1,
            Map<Double, Float> map2, Map<Double, Float> map3);

    @Override
     HashDoubleFloatMap newUpdatableMap(Map<Double, Float> map1,
            Map<Double, Float> map2, Map<Double, Float> map3,
            Map<Double, Float> map4);

    @Override
     HashDoubleFloatMap newUpdatableMap(Map<Double, Float> map1,
            Map<Double, Float> map2, Map<Double, Float> map3,
            Map<Double, Float> map4, Map<Double, Float> map5);


    @Override
     HashDoubleFloatMap newUpdatableMap(
            net.openhft.function.Consumer<DoubleFloatConsumer> entriesSupplier);

    @Override
     HashDoubleFloatMap newUpdatableMap(
            net.openhft.function.Consumer<DoubleFloatConsumer> entriesSupplier,
            int expectedSize);

    @Override
     HashDoubleFloatMap newUpdatableMap(double[] keys, float[] values);

    @Override
     HashDoubleFloatMap newUpdatableMap(double[] keys, float[] values,
            int expectedSize);

    @Override
     HashDoubleFloatMap newUpdatableMap(
            Double[] keys, Float[] values);

    @Override
     HashDoubleFloatMap newUpdatableMap(
            Double[] keys, Float[] values, int expectedSize);

    @Override
     HashDoubleFloatMap newUpdatableMap(Iterable<Double> keys,
            Iterable<Float> values);

    @Override
     HashDoubleFloatMap newUpdatableMap(Iterable<Double> keys,
            Iterable<Float> values, int expectedSize);


    @Override
     HashDoubleFloatMap newUpdatableMapOf(double k1, float v1);

    @Override
     HashDoubleFloatMap newUpdatableMapOf(double k1, float v1,
            double k2, float v2);

    @Override
     HashDoubleFloatMap newUpdatableMapOf(double k1, float v1,
            double k2, float v2, double k3, float v3);

    @Override
     HashDoubleFloatMap newUpdatableMapOf(double k1, float v1,
            double k2, float v2, double k3, float v3,
            double k4, float v4);

    @Override
     HashDoubleFloatMap newUpdatableMapOf(double k1, float v1,
            double k2, float v2, double k3, float v3,
            double k4, float v4, double k5, float v5);

    


    @Override
     HashDoubleFloatMap newImmutableMap(Map<Double, Float> map1,
            Map<Double, Float> map2, int expectedSize);

    @Override
     HashDoubleFloatMap newImmutableMap(Map<Double, Float> map1,
            Map<Double, Float> map2, Map<Double, Float> map3, int expectedSize);

    @Override
     HashDoubleFloatMap newImmutableMap(Map<Double, Float> map1,
            Map<Double, Float> map2, Map<Double, Float> map3,
            Map<Double, Float> map4, int expectedSize);

    @Override
     HashDoubleFloatMap newImmutableMap(Map<Double, Float> map1,
            Map<Double, Float> map2, Map<Double, Float> map3,
            Map<Double, Float> map4, Map<Double, Float> map5, int expectedSize);

    

    
    @Override
     HashDoubleFloatMap newImmutableMap(Map<Double, Float> map);

    @Override
     HashDoubleFloatMap newImmutableMap(Map<Double, Float> map1,
            Map<Double, Float> map2);

    @Override
     HashDoubleFloatMap newImmutableMap(Map<Double, Float> map1,
            Map<Double, Float> map2, Map<Double, Float> map3);

    @Override
     HashDoubleFloatMap newImmutableMap(Map<Double, Float> map1,
            Map<Double, Float> map2, Map<Double, Float> map3,
            Map<Double, Float> map4);

    @Override
     HashDoubleFloatMap newImmutableMap(Map<Double, Float> map1,
            Map<Double, Float> map2, Map<Double, Float> map3,
            Map<Double, Float> map4, Map<Double, Float> map5);


    @Override
     HashDoubleFloatMap newImmutableMap(
            net.openhft.function.Consumer<DoubleFloatConsumer> entriesSupplier);

    @Override
     HashDoubleFloatMap newImmutableMap(
            net.openhft.function.Consumer<DoubleFloatConsumer> entriesSupplier,
            int expectedSize);

    @Override
     HashDoubleFloatMap newImmutableMap(double[] keys, float[] values);

    @Override
     HashDoubleFloatMap newImmutableMap(double[] keys, float[] values,
            int expectedSize);

    @Override
     HashDoubleFloatMap newImmutableMap(
            Double[] keys, Float[] values);

    @Override
     HashDoubleFloatMap newImmutableMap(
            Double[] keys, Float[] values, int expectedSize);

    @Override
     HashDoubleFloatMap newImmutableMap(Iterable<Double> keys,
            Iterable<Float> values);

    @Override
     HashDoubleFloatMap newImmutableMap(Iterable<Double> keys,
            Iterable<Float> values, int expectedSize);


    @Override
     HashDoubleFloatMap newImmutableMapOf(double k1, float v1);

    @Override
     HashDoubleFloatMap newImmutableMapOf(double k1, float v1,
            double k2, float v2);

    @Override
     HashDoubleFloatMap newImmutableMapOf(double k1, float v1,
            double k2, float v2, double k3, float v3);

    @Override
     HashDoubleFloatMap newImmutableMapOf(double k1, float v1,
            double k2, float v2, double k3, float v3,
            double k4, float v4);

    @Override
     HashDoubleFloatMap newImmutableMapOf(double k1, float v1,
            double k2, float v2, double k3, float v3,
            double k4, float v4, double k5, float v5);
}

