/*
 * Copyright 2014 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.openhft.collect.map.hash;

import net.openhft.function.DoubleDoubleConsumer;

import java.util.Map;
import java.util.ServiceLoader;


/**
 * This class consists only of static factory methods to construct {@code HashDoubleDoubleMap}s, and
 * the default {@link HashDoubleDoubleMapFactory} static provider ({@link #getDefaultFactory()}).
 *
 * @see HashDoubleDoubleMap
 */
public final class HashDoubleDoubleMaps {

    

    private static final ServiceLoader<HashDoubleDoubleMapFactory> LOADER =
            ServiceLoader.load(HashDoubleDoubleMapFactory.class);
    private static HashDoubleDoubleMapFactory defaultFactory = null;

    public static HashDoubleDoubleMapFactory getDefaultFactory() {
        if (defaultFactory != null) {
            return defaultFactory;
        } else {
            // synchronization?
            return defaultFactory = LOADER.iterator().next();
        }
    }

    

    

    

    public static  HashDoubleDoubleMap newMutableMap() {
        return getDefaultFactory().newMutableMap();
    }

    public static  HashDoubleDoubleMap newMutableMap(int expectedSize) {
        return getDefaultFactory().newMutableMap(expectedSize);
    }



    
    


    public static  HashDoubleDoubleMap newMutableMap(Map<Double, Double> map1,
            Map<Double, Double> map2, int expectedSize) {
        return getDefaultFactory().newMutableMap(map1, map2, expectedSize);
    }

    public static  HashDoubleDoubleMap newMutableMap(Map<Double, Double> map1,
            Map<Double, Double> map2, Map<Double, Double> map3, int expectedSize) {
        return getDefaultFactory().newMutableMap(map1, map2, map3, expectedSize);
    }

    public static  HashDoubleDoubleMap newMutableMap(Map<Double, Double> map1,
            Map<Double, Double> map2, Map<Double, Double> map3,
            Map<Double, Double> map4, int expectedSize) {
        return getDefaultFactory().newMutableMap(map1, map2, map3, map4, expectedSize);
    }

    public static  HashDoubleDoubleMap newMutableMap(Map<Double, Double> map1,
            Map<Double, Double> map2, Map<Double, Double> map3,
            Map<Double, Double> map4, Map<Double, Double> map5, int expectedSize) {
        return getDefaultFactory().newMutableMap(map1, map2, map3, map4, map5, expectedSize);
    }

    
    

    
    public static  HashDoubleDoubleMap newMutableMap(
            Map<Double, Double> map) {
        return getDefaultFactory().newMutableMap(map);
    }

    public static  HashDoubleDoubleMap newMutableMap(Map<Double, Double> map1,
            Map<Double, Double> map2) {
        return getDefaultFactory().newMutableMap(map1, map2);
    }

    public static  HashDoubleDoubleMap newMutableMap(Map<Double, Double> map1,
            Map<Double, Double> map2, Map<Double, Double> map3) {
        return getDefaultFactory().newMutableMap(map1, map2, map3);
    }

    public static  HashDoubleDoubleMap newMutableMap(Map<Double, Double> map1,
            Map<Double, Double> map2, Map<Double, Double> map3,
            Map<Double, Double> map4) {
        return getDefaultFactory().newMutableMap(map1, map2, map3, map4);
    }

    public static  HashDoubleDoubleMap newMutableMap(Map<Double, Double> map1,
            Map<Double, Double> map2, Map<Double, Double> map3,
            Map<Double, Double> map4, Map<Double, Double> map5) {
        return getDefaultFactory().newMutableMap(map1, map2, map3, map4, map5);
    }


    public static  HashDoubleDoubleMap newMutableMap(
            net.openhft.function.Consumer<DoubleDoubleConsumer> entriesSupplier) {
        return getDefaultFactory().newMutableMap(entriesSupplier);
    }

    public static  HashDoubleDoubleMap newMutableMap(
            net.openhft.function.Consumer<DoubleDoubleConsumer> entriesSupplier,
            int expectedSize) {
        return getDefaultFactory().newMutableMap(entriesSupplier, expectedSize);
    }

    public static  HashDoubleDoubleMap newMutableMap(
            double[] keys, double[] values) {
        return getDefaultFactory().newMutableMap(keys, values);
    }

    public static  HashDoubleDoubleMap newMutableMap(
            double[] keys, double[] values, int expectedSize) {
        return getDefaultFactory().newMutableMap(keys, values, expectedSize);
    }

    public static  HashDoubleDoubleMap newMutableMap(
            Double[] keys, Double[] values) {
        return getDefaultFactory().newMutableMap(keys, values);
    }

    public static  HashDoubleDoubleMap newMutableMap(
            Double[] keys, Double[] values, int expectedSize) {
        return getDefaultFactory().newMutableMap(keys, values, expectedSize);
    }

    public static  HashDoubleDoubleMap newMutableMap(Iterable<Double> keys,
            Iterable<Double> values) {
        return getDefaultFactory().newMutableMap(keys, values);
    }

    public static  HashDoubleDoubleMap newMutableMap(Iterable<Double> keys,
            Iterable<Double> values, int expectedSize) {
        return getDefaultFactory().newMutableMap(keys, values, expectedSize);
    }


    public static  HashDoubleDoubleMap newMutableMapOf(
            double k1, double v1) {
        return getDefaultFactory().newMutableMapOf(k1, v1);
    }

    public static  HashDoubleDoubleMap newMutableMapOf(
            double k1, double v1, double k2, double v2) {
        return getDefaultFactory().newMutableMapOf(k1, v1, k2, v2);
    }

    public static  HashDoubleDoubleMap newMutableMapOf(
            double k1, double v1, double k2, double v2,
            double k3, double v3) {
        return getDefaultFactory().newMutableMapOf(k1, v1, k2, v2, k3, v3);
    }

    public static  HashDoubleDoubleMap newMutableMapOf(
            double k1, double v1, double k2, double v2,
            double k3, double v3, double k4, double v4) {
        return getDefaultFactory().newMutableMapOf(k1, v1, k2, v2, k3, v3, k4, v4);
    }

    public static  HashDoubleDoubleMap newMutableMapOf(
            double k1, double v1, double k2, double v2,
            double k3, double v3, double k4, double v4,
            double k5, double v5) {
        return getDefaultFactory().newMutableMapOf(k1, v1, k2, v2, k3, v3, k4, v4, k5, v5);
    }

    
    


    public static  HashDoubleDoubleMap newUpdatableMap(Map<Double, Double> map1,
            Map<Double, Double> map2, int expectedSize) {
        return getDefaultFactory().newUpdatableMap(map1, map2, expectedSize);
    }

    public static  HashDoubleDoubleMap newUpdatableMap(Map<Double, Double> map1,
            Map<Double, Double> map2, Map<Double, Double> map3, int expectedSize) {
        return getDefaultFactory().newUpdatableMap(map1, map2, map3, expectedSize);
    }

    public static  HashDoubleDoubleMap newUpdatableMap(Map<Double, Double> map1,
            Map<Double, Double> map2, Map<Double, Double> map3,
            Map<Double, Double> map4, int expectedSize) {
        return getDefaultFactory().newUpdatableMap(map1, map2, map3, map4, expectedSize);
    }

    public static  HashDoubleDoubleMap newUpdatableMap(Map<Double, Double> map1,
            Map<Double, Double> map2, Map<Double, Double> map3,
            Map<Double, Double> map4, Map<Double, Double> map5, int expectedSize) {
        return getDefaultFactory().newUpdatableMap(map1, map2, map3, map4, map5, expectedSize);
    }

    
    

    
    public static  HashDoubleDoubleMap newUpdatableMap(
            Map<Double, Double> map) {
        return getDefaultFactory().newUpdatableMap(map);
    }

    public static  HashDoubleDoubleMap newUpdatableMap(Map<Double, Double> map1,
            Map<Double, Double> map2) {
        return getDefaultFactory().newUpdatableMap(map1, map2);
    }

    public static  HashDoubleDoubleMap newUpdatableMap(Map<Double, Double> map1,
            Map<Double, Double> map2, Map<Double, Double> map3) {
        return getDefaultFactory().newUpdatableMap(map1, map2, map3);
    }

    public static  HashDoubleDoubleMap newUpdatableMap(Map<Double, Double> map1,
            Map<Double, Double> map2, Map<Double, Double> map3,
            Map<Double, Double> map4) {
        return getDefaultFactory().newUpdatableMap(map1, map2, map3, map4);
    }

    public static  HashDoubleDoubleMap newUpdatableMap(Map<Double, Double> map1,
            Map<Double, Double> map2, Map<Double, Double> map3,
            Map<Double, Double> map4, Map<Double, Double> map5) {
        return getDefaultFactory().newUpdatableMap(map1, map2, map3, map4, map5);
    }


    public static  HashDoubleDoubleMap newUpdatableMap(
            net.openhft.function.Consumer<DoubleDoubleConsumer> entriesSupplier) {
        return getDefaultFactory().newUpdatableMap(entriesSupplier);
    }

    public static  HashDoubleDoubleMap newUpdatableMap(
            net.openhft.function.Consumer<DoubleDoubleConsumer> entriesSupplier,
            int expectedSize) {
        return getDefaultFactory().newUpdatableMap(entriesSupplier, expectedSize);
    }

    public static  HashDoubleDoubleMap newUpdatableMap(
            double[] keys, double[] values) {
        return getDefaultFactory().newUpdatableMap(keys, values);
    }

    public static  HashDoubleDoubleMap newUpdatableMap(
            double[] keys, double[] values, int expectedSize) {
        return getDefaultFactory().newUpdatableMap(keys, values, expectedSize);
    }

    public static  HashDoubleDoubleMap newUpdatableMap(
            Double[] keys, Double[] values) {
        return getDefaultFactory().newUpdatableMap(keys, values);
    }

    public static  HashDoubleDoubleMap newUpdatableMap(
            Double[] keys, Double[] values, int expectedSize) {
        return getDefaultFactory().newUpdatableMap(keys, values, expectedSize);
    }

    public static  HashDoubleDoubleMap newUpdatableMap(Iterable<Double> keys,
            Iterable<Double> values) {
        return getDefaultFactory().newUpdatableMap(keys, values);
    }

    public static  HashDoubleDoubleMap newUpdatableMap(Iterable<Double> keys,
            Iterable<Double> values, int expectedSize) {
        return getDefaultFactory().newUpdatableMap(keys, values, expectedSize);
    }


    public static  HashDoubleDoubleMap newUpdatableMapOf(
            double k1, double v1) {
        return getDefaultFactory().newUpdatableMapOf(k1, v1);
    }

    public static  HashDoubleDoubleMap newUpdatableMapOf(
            double k1, double v1, double k2, double v2) {
        return getDefaultFactory().newUpdatableMapOf(k1, v1, k2, v2);
    }

    public static  HashDoubleDoubleMap newUpdatableMapOf(
            double k1, double v1, double k2, double v2,
            double k3, double v3) {
        return getDefaultFactory().newUpdatableMapOf(k1, v1, k2, v2, k3, v3);
    }

    public static  HashDoubleDoubleMap newUpdatableMapOf(
            double k1, double v1, double k2, double v2,
            double k3, double v3, double k4, double v4) {
        return getDefaultFactory().newUpdatableMapOf(k1, v1, k2, v2, k3, v3, k4, v4);
    }

    public static  HashDoubleDoubleMap newUpdatableMapOf(
            double k1, double v1, double k2, double v2,
            double k3, double v3, double k4, double v4,
            double k5, double v5) {
        return getDefaultFactory().newUpdatableMapOf(k1, v1, k2, v2, k3, v3, k4, v4, k5, v5);
    }

    
    


    public static  HashDoubleDoubleMap newImmutableMap(Map<Double, Double> map1,
            Map<Double, Double> map2, int expectedSize) {
        return getDefaultFactory().newImmutableMap(map1, map2, expectedSize);
    }

    public static  HashDoubleDoubleMap newImmutableMap(Map<Double, Double> map1,
            Map<Double, Double> map2, Map<Double, Double> map3, int expectedSize) {
        return getDefaultFactory().newImmutableMap(map1, map2, map3, expectedSize);
    }

    public static  HashDoubleDoubleMap newImmutableMap(Map<Double, Double> map1,
            Map<Double, Double> map2, Map<Double, Double> map3,
            Map<Double, Double> map4, int expectedSize) {
        return getDefaultFactory().newImmutableMap(map1, map2, map3, map4, expectedSize);
    }

    public static  HashDoubleDoubleMap newImmutableMap(Map<Double, Double> map1,
            Map<Double, Double> map2, Map<Double, Double> map3,
            Map<Double, Double> map4, Map<Double, Double> map5, int expectedSize) {
        return getDefaultFactory().newImmutableMap(map1, map2, map3, map4, map5, expectedSize);
    }

    
    

    
    public static  HashDoubleDoubleMap newImmutableMap(
            Map<Double, Double> map) {
        return getDefaultFactory().newImmutableMap(map);
    }

    public static  HashDoubleDoubleMap newImmutableMap(Map<Double, Double> map1,
            Map<Double, Double> map2) {
        return getDefaultFactory().newImmutableMap(map1, map2);
    }

    public static  HashDoubleDoubleMap newImmutableMap(Map<Double, Double> map1,
            Map<Double, Double> map2, Map<Double, Double> map3) {
        return getDefaultFactory().newImmutableMap(map1, map2, map3);
    }

    public static  HashDoubleDoubleMap newImmutableMap(Map<Double, Double> map1,
            Map<Double, Double> map2, Map<Double, Double> map3,
            Map<Double, Double> map4) {
        return getDefaultFactory().newImmutableMap(map1, map2, map3, map4);
    }

    public static  HashDoubleDoubleMap newImmutableMap(Map<Double, Double> map1,
            Map<Double, Double> map2, Map<Double, Double> map3,
            Map<Double, Double> map4, Map<Double, Double> map5) {
        return getDefaultFactory().newImmutableMap(map1, map2, map3, map4, map5);
    }


    public static  HashDoubleDoubleMap newImmutableMap(
            net.openhft.function.Consumer<DoubleDoubleConsumer> entriesSupplier) {
        return getDefaultFactory().newImmutableMap(entriesSupplier);
    }

    public static  HashDoubleDoubleMap newImmutableMap(
            net.openhft.function.Consumer<DoubleDoubleConsumer> entriesSupplier,
            int expectedSize) {
        return getDefaultFactory().newImmutableMap(entriesSupplier, expectedSize);
    }

    public static  HashDoubleDoubleMap newImmutableMap(
            double[] keys, double[] values) {
        return getDefaultFactory().newImmutableMap(keys, values);
    }

    public static  HashDoubleDoubleMap newImmutableMap(
            double[] keys, double[] values, int expectedSize) {
        return getDefaultFactory().newImmutableMap(keys, values, expectedSize);
    }

    public static  HashDoubleDoubleMap newImmutableMap(
            Double[] keys, Double[] values) {
        return getDefaultFactory().newImmutableMap(keys, values);
    }

    public static  HashDoubleDoubleMap newImmutableMap(
            Double[] keys, Double[] values, int expectedSize) {
        return getDefaultFactory().newImmutableMap(keys, values, expectedSize);
    }

    public static  HashDoubleDoubleMap newImmutableMap(Iterable<Double> keys,
            Iterable<Double> values) {
        return getDefaultFactory().newImmutableMap(keys, values);
    }

    public static  HashDoubleDoubleMap newImmutableMap(Iterable<Double> keys,
            Iterable<Double> values, int expectedSize) {
        return getDefaultFactory().newImmutableMap(keys, values, expectedSize);
    }


    public static  HashDoubleDoubleMap newImmutableMapOf(
            double k1, double v1) {
        return getDefaultFactory().newImmutableMapOf(k1, v1);
    }

    public static  HashDoubleDoubleMap newImmutableMapOf(
            double k1, double v1, double k2, double v2) {
        return getDefaultFactory().newImmutableMapOf(k1, v1, k2, v2);
    }

    public static  HashDoubleDoubleMap newImmutableMapOf(
            double k1, double v1, double k2, double v2,
            double k3, double v3) {
        return getDefaultFactory().newImmutableMapOf(k1, v1, k2, v2, k3, v3);
    }

    public static  HashDoubleDoubleMap newImmutableMapOf(
            double k1, double v1, double k2, double v2,
            double k3, double v3, double k4, double v4) {
        return getDefaultFactory().newImmutableMapOf(k1, v1, k2, v2, k3, v3, k4, v4);
    }

    public static  HashDoubleDoubleMap newImmutableMapOf(
            double k1, double v1, double k2, double v2,
            double k3, double v3, double k4, double v4,
            double k5, double v5) {
        return getDefaultFactory().newImmutableMapOf(k1, v1, k2, v2, k3, v3, k4, v4, k5, v5);
    }

    private HashDoubleDoubleMaps() {}
}

