/*
 * Copyright 2014 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.openhft.collect.map.hash;

import net.openhft.collect.*;
import net.openhft.collect.hash.*;
import net.openhft.function.DoubleDoubleConsumer;
import net.openhft.collect.map.*;
import javax.annotation.Nullable;

import java.util.Map;


/**
 * An immutable factory of {@code HashDoubleDoubleMaps}
 *
 * @see HashDoubleDoubleMap
 * @see HashDoubleDoubleMaps#getDefaultFactory()
 */
public interface HashDoubleDoubleMapFactory extends DoubleDoubleMapFactory
        , HashContainerFactory<HashDoubleDoubleMapFactory> {

    

    

    

    

    

    
    

    
    


    @Override
    HashDoubleDoubleMapFactory withDefaultValue(double defaultValue);

    @Override
     HashDoubleDoubleMap newMutableMap();

    @Override
     HashDoubleDoubleMap newMutableMap(int expectedSize);

    


    @Override
     HashDoubleDoubleMap newMutableMap(Map<Double, Double> map1,
            Map<Double, Double> map2, int expectedSize);

    @Override
     HashDoubleDoubleMap newMutableMap(Map<Double, Double> map1,
            Map<Double, Double> map2, Map<Double, Double> map3, int expectedSize);

    @Override
     HashDoubleDoubleMap newMutableMap(Map<Double, Double> map1,
            Map<Double, Double> map2, Map<Double, Double> map3,
            Map<Double, Double> map4, int expectedSize);

    @Override
     HashDoubleDoubleMap newMutableMap(Map<Double, Double> map1,
            Map<Double, Double> map2, Map<Double, Double> map3,
            Map<Double, Double> map4, Map<Double, Double> map5, int expectedSize);

    

    
    @Override
     HashDoubleDoubleMap newMutableMap(Map<Double, Double> map);

    @Override
     HashDoubleDoubleMap newMutableMap(Map<Double, Double> map1,
            Map<Double, Double> map2);

    @Override
     HashDoubleDoubleMap newMutableMap(Map<Double, Double> map1,
            Map<Double, Double> map2, Map<Double, Double> map3);

    @Override
     HashDoubleDoubleMap newMutableMap(Map<Double, Double> map1,
            Map<Double, Double> map2, Map<Double, Double> map3,
            Map<Double, Double> map4);

    @Override
     HashDoubleDoubleMap newMutableMap(Map<Double, Double> map1,
            Map<Double, Double> map2, Map<Double, Double> map3,
            Map<Double, Double> map4, Map<Double, Double> map5);


    @Override
     HashDoubleDoubleMap newMutableMap(
            net.openhft.function.Consumer<DoubleDoubleConsumer> entriesSupplier);

    @Override
     HashDoubleDoubleMap newMutableMap(
            net.openhft.function.Consumer<DoubleDoubleConsumer> entriesSupplier,
            int expectedSize);

    @Override
     HashDoubleDoubleMap newMutableMap(double[] keys, double[] values);

    @Override
     HashDoubleDoubleMap newMutableMap(double[] keys, double[] values,
            int expectedSize);

    @Override
     HashDoubleDoubleMap newMutableMap(
            Double[] keys, Double[] values);

    @Override
     HashDoubleDoubleMap newMutableMap(
            Double[] keys, Double[] values, int expectedSize);

    @Override
     HashDoubleDoubleMap newMutableMap(Iterable<Double> keys,
            Iterable<Double> values);

    @Override
     HashDoubleDoubleMap newMutableMap(Iterable<Double> keys,
            Iterable<Double> values, int expectedSize);


    @Override
     HashDoubleDoubleMap newMutableMapOf(double k1, double v1);

    @Override
     HashDoubleDoubleMap newMutableMapOf(double k1, double v1,
            double k2, double v2);

    @Override
     HashDoubleDoubleMap newMutableMapOf(double k1, double v1,
            double k2, double v2, double k3, double v3);

    @Override
     HashDoubleDoubleMap newMutableMapOf(double k1, double v1,
            double k2, double v2, double k3, double v3,
            double k4, double v4);

    @Override
     HashDoubleDoubleMap newMutableMapOf(double k1, double v1,
            double k2, double v2, double k3, double v3,
            double k4, double v4, double k5, double v5);
    @Override
     HashDoubleDoubleMap newUpdatableMap();

    @Override
     HashDoubleDoubleMap newUpdatableMap(int expectedSize);

    


    @Override
     HashDoubleDoubleMap newUpdatableMap(Map<Double, Double> map1,
            Map<Double, Double> map2, int expectedSize);

    @Override
     HashDoubleDoubleMap newUpdatableMap(Map<Double, Double> map1,
            Map<Double, Double> map2, Map<Double, Double> map3, int expectedSize);

    @Override
     HashDoubleDoubleMap newUpdatableMap(Map<Double, Double> map1,
            Map<Double, Double> map2, Map<Double, Double> map3,
            Map<Double, Double> map4, int expectedSize);

    @Override
     HashDoubleDoubleMap newUpdatableMap(Map<Double, Double> map1,
            Map<Double, Double> map2, Map<Double, Double> map3,
            Map<Double, Double> map4, Map<Double, Double> map5, int expectedSize);

    

    
    @Override
     HashDoubleDoubleMap newUpdatableMap(Map<Double, Double> map);

    @Override
     HashDoubleDoubleMap newUpdatableMap(Map<Double, Double> map1,
            Map<Double, Double> map2);

    @Override
     HashDoubleDoubleMap newUpdatableMap(Map<Double, Double> map1,
            Map<Double, Double> map2, Map<Double, Double> map3);

    @Override
     HashDoubleDoubleMap newUpdatableMap(Map<Double, Double> map1,
            Map<Double, Double> map2, Map<Double, Double> map3,
            Map<Double, Double> map4);

    @Override
     HashDoubleDoubleMap newUpdatableMap(Map<Double, Double> map1,
            Map<Double, Double> map2, Map<Double, Double> map3,
            Map<Double, Double> map4, Map<Double, Double> map5);


    @Override
     HashDoubleDoubleMap newUpdatableMap(
            net.openhft.function.Consumer<DoubleDoubleConsumer> entriesSupplier);

    @Override
     HashDoubleDoubleMap newUpdatableMap(
            net.openhft.function.Consumer<DoubleDoubleConsumer> entriesSupplier,
            int expectedSize);

    @Override
     HashDoubleDoubleMap newUpdatableMap(double[] keys, double[] values);

    @Override
     HashDoubleDoubleMap newUpdatableMap(double[] keys, double[] values,
            int expectedSize);

    @Override
     HashDoubleDoubleMap newUpdatableMap(
            Double[] keys, Double[] values);

    @Override
     HashDoubleDoubleMap newUpdatableMap(
            Double[] keys, Double[] values, int expectedSize);

    @Override
     HashDoubleDoubleMap newUpdatableMap(Iterable<Double> keys,
            Iterable<Double> values);

    @Override
     HashDoubleDoubleMap newUpdatableMap(Iterable<Double> keys,
            Iterable<Double> values, int expectedSize);


    @Override
     HashDoubleDoubleMap newUpdatableMapOf(double k1, double v1);

    @Override
     HashDoubleDoubleMap newUpdatableMapOf(double k1, double v1,
            double k2, double v2);

    @Override
     HashDoubleDoubleMap newUpdatableMapOf(double k1, double v1,
            double k2, double v2, double k3, double v3);

    @Override
     HashDoubleDoubleMap newUpdatableMapOf(double k1, double v1,
            double k2, double v2, double k3, double v3,
            double k4, double v4);

    @Override
     HashDoubleDoubleMap newUpdatableMapOf(double k1, double v1,
            double k2, double v2, double k3, double v3,
            double k4, double v4, double k5, double v5);

    


    @Override
     HashDoubleDoubleMap newImmutableMap(Map<Double, Double> map1,
            Map<Double, Double> map2, int expectedSize);

    @Override
     HashDoubleDoubleMap newImmutableMap(Map<Double, Double> map1,
            Map<Double, Double> map2, Map<Double, Double> map3, int expectedSize);

    @Override
     HashDoubleDoubleMap newImmutableMap(Map<Double, Double> map1,
            Map<Double, Double> map2, Map<Double, Double> map3,
            Map<Double, Double> map4, int expectedSize);

    @Override
     HashDoubleDoubleMap newImmutableMap(Map<Double, Double> map1,
            Map<Double, Double> map2, Map<Double, Double> map3,
            Map<Double, Double> map4, Map<Double, Double> map5, int expectedSize);

    

    
    @Override
     HashDoubleDoubleMap newImmutableMap(Map<Double, Double> map);

    @Override
     HashDoubleDoubleMap newImmutableMap(Map<Double, Double> map1,
            Map<Double, Double> map2);

    @Override
     HashDoubleDoubleMap newImmutableMap(Map<Double, Double> map1,
            Map<Double, Double> map2, Map<Double, Double> map3);

    @Override
     HashDoubleDoubleMap newImmutableMap(Map<Double, Double> map1,
            Map<Double, Double> map2, Map<Double, Double> map3,
            Map<Double, Double> map4);

    @Override
     HashDoubleDoubleMap newImmutableMap(Map<Double, Double> map1,
            Map<Double, Double> map2, Map<Double, Double> map3,
            Map<Double, Double> map4, Map<Double, Double> map5);


    @Override
     HashDoubleDoubleMap newImmutableMap(
            net.openhft.function.Consumer<DoubleDoubleConsumer> entriesSupplier);

    @Override
     HashDoubleDoubleMap newImmutableMap(
            net.openhft.function.Consumer<DoubleDoubleConsumer> entriesSupplier,
            int expectedSize);

    @Override
     HashDoubleDoubleMap newImmutableMap(double[] keys, double[] values);

    @Override
     HashDoubleDoubleMap newImmutableMap(double[] keys, double[] values,
            int expectedSize);

    @Override
     HashDoubleDoubleMap newImmutableMap(
            Double[] keys, Double[] values);

    @Override
     HashDoubleDoubleMap newImmutableMap(
            Double[] keys, Double[] values, int expectedSize);

    @Override
     HashDoubleDoubleMap newImmutableMap(Iterable<Double> keys,
            Iterable<Double> values);

    @Override
     HashDoubleDoubleMap newImmutableMap(Iterable<Double> keys,
            Iterable<Double> values, int expectedSize);


    @Override
     HashDoubleDoubleMap newImmutableMapOf(double k1, double v1);

    @Override
     HashDoubleDoubleMap newImmutableMapOf(double k1, double v1,
            double k2, double v2);

    @Override
     HashDoubleDoubleMap newImmutableMapOf(double k1, double v1,
            double k2, double v2, double k3, double v3);

    @Override
     HashDoubleDoubleMap newImmutableMapOf(double k1, double v1,
            double k2, double v2, double k3, double v3,
            double k4, double v4);

    @Override
     HashDoubleDoubleMap newImmutableMapOf(double k1, double v1,
            double k2, double v2, double k3, double v3,
            double k4, double v4, double k5, double v5);
}

