/*
 * Copyright 2014 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.openhft.collect.map.hash;

import net.openhft.collect.*;
import net.openhft.collect.hash.*;
import net.openhft.function.DoubleCharConsumer;
import net.openhft.collect.map.*;
import javax.annotation.Nullable;

import java.util.Map;


/**
 * An immutable factory of {@code HashDoubleCharMaps}
 *
 * @see HashDoubleCharMap
 * @see HashDoubleCharMaps#getDefaultFactory()
 */
public interface HashDoubleCharMapFactory extends DoubleCharMapFactory
        , HashContainerFactory<HashDoubleCharMapFactory> {

    

    

    

    

    

    
    

    
    


    @Override
    HashDoubleCharMapFactory withDefaultValue(char defaultValue);

    @Override
     HashDoubleCharMap newMutableMap();

    @Override
     HashDoubleCharMap newMutableMap(int expectedSize);

    


    @Override
     HashDoubleCharMap newMutableMap(Map<Double, Character> map1,
            Map<Double, Character> map2, int expectedSize);

    @Override
     HashDoubleCharMap newMutableMap(Map<Double, Character> map1,
            Map<Double, Character> map2, Map<Double, Character> map3, int expectedSize);

    @Override
     HashDoubleCharMap newMutableMap(Map<Double, Character> map1,
            Map<Double, Character> map2, Map<Double, Character> map3,
            Map<Double, Character> map4, int expectedSize);

    @Override
     HashDoubleCharMap newMutableMap(Map<Double, Character> map1,
            Map<Double, Character> map2, Map<Double, Character> map3,
            Map<Double, Character> map4, Map<Double, Character> map5, int expectedSize);

    

    
    @Override
     HashDoubleCharMap newMutableMap(Map<Double, Character> map);

    @Override
     HashDoubleCharMap newMutableMap(Map<Double, Character> map1,
            Map<Double, Character> map2);

    @Override
     HashDoubleCharMap newMutableMap(Map<Double, Character> map1,
            Map<Double, Character> map2, Map<Double, Character> map3);

    @Override
     HashDoubleCharMap newMutableMap(Map<Double, Character> map1,
            Map<Double, Character> map2, Map<Double, Character> map3,
            Map<Double, Character> map4);

    @Override
     HashDoubleCharMap newMutableMap(Map<Double, Character> map1,
            Map<Double, Character> map2, Map<Double, Character> map3,
            Map<Double, Character> map4, Map<Double, Character> map5);


    @Override
     HashDoubleCharMap newMutableMap(
            net.openhft.function.Consumer<DoubleCharConsumer> entriesSupplier);

    @Override
     HashDoubleCharMap newMutableMap(
            net.openhft.function.Consumer<DoubleCharConsumer> entriesSupplier,
            int expectedSize);

    @Override
     HashDoubleCharMap newMutableMap(double[] keys, char[] values);

    @Override
     HashDoubleCharMap newMutableMap(double[] keys, char[] values,
            int expectedSize);

    @Override
     HashDoubleCharMap newMutableMap(
            Double[] keys, Character[] values);

    @Override
     HashDoubleCharMap newMutableMap(
            Double[] keys, Character[] values, int expectedSize);

    @Override
     HashDoubleCharMap newMutableMap(Iterable<Double> keys,
            Iterable<Character> values);

    @Override
     HashDoubleCharMap newMutableMap(Iterable<Double> keys,
            Iterable<Character> values, int expectedSize);


    @Override
     HashDoubleCharMap newMutableMapOf(double k1, char v1);

    @Override
     HashDoubleCharMap newMutableMapOf(double k1, char v1,
            double k2, char v2);

    @Override
     HashDoubleCharMap newMutableMapOf(double k1, char v1,
            double k2, char v2, double k3, char v3);

    @Override
     HashDoubleCharMap newMutableMapOf(double k1, char v1,
            double k2, char v2, double k3, char v3,
            double k4, char v4);

    @Override
     HashDoubleCharMap newMutableMapOf(double k1, char v1,
            double k2, char v2, double k3, char v3,
            double k4, char v4, double k5, char v5);
    @Override
     HashDoubleCharMap newUpdatableMap();

    @Override
     HashDoubleCharMap newUpdatableMap(int expectedSize);

    


    @Override
     HashDoubleCharMap newUpdatableMap(Map<Double, Character> map1,
            Map<Double, Character> map2, int expectedSize);

    @Override
     HashDoubleCharMap newUpdatableMap(Map<Double, Character> map1,
            Map<Double, Character> map2, Map<Double, Character> map3, int expectedSize);

    @Override
     HashDoubleCharMap newUpdatableMap(Map<Double, Character> map1,
            Map<Double, Character> map2, Map<Double, Character> map3,
            Map<Double, Character> map4, int expectedSize);

    @Override
     HashDoubleCharMap newUpdatableMap(Map<Double, Character> map1,
            Map<Double, Character> map2, Map<Double, Character> map3,
            Map<Double, Character> map4, Map<Double, Character> map5, int expectedSize);

    

    
    @Override
     HashDoubleCharMap newUpdatableMap(Map<Double, Character> map);

    @Override
     HashDoubleCharMap newUpdatableMap(Map<Double, Character> map1,
            Map<Double, Character> map2);

    @Override
     HashDoubleCharMap newUpdatableMap(Map<Double, Character> map1,
            Map<Double, Character> map2, Map<Double, Character> map3);

    @Override
     HashDoubleCharMap newUpdatableMap(Map<Double, Character> map1,
            Map<Double, Character> map2, Map<Double, Character> map3,
            Map<Double, Character> map4);

    @Override
     HashDoubleCharMap newUpdatableMap(Map<Double, Character> map1,
            Map<Double, Character> map2, Map<Double, Character> map3,
            Map<Double, Character> map4, Map<Double, Character> map5);


    @Override
     HashDoubleCharMap newUpdatableMap(
            net.openhft.function.Consumer<DoubleCharConsumer> entriesSupplier);

    @Override
     HashDoubleCharMap newUpdatableMap(
            net.openhft.function.Consumer<DoubleCharConsumer> entriesSupplier,
            int expectedSize);

    @Override
     HashDoubleCharMap newUpdatableMap(double[] keys, char[] values);

    @Override
     HashDoubleCharMap newUpdatableMap(double[] keys, char[] values,
            int expectedSize);

    @Override
     HashDoubleCharMap newUpdatableMap(
            Double[] keys, Character[] values);

    @Override
     HashDoubleCharMap newUpdatableMap(
            Double[] keys, Character[] values, int expectedSize);

    @Override
     HashDoubleCharMap newUpdatableMap(Iterable<Double> keys,
            Iterable<Character> values);

    @Override
     HashDoubleCharMap newUpdatableMap(Iterable<Double> keys,
            Iterable<Character> values, int expectedSize);


    @Override
     HashDoubleCharMap newUpdatableMapOf(double k1, char v1);

    @Override
     HashDoubleCharMap newUpdatableMapOf(double k1, char v1,
            double k2, char v2);

    @Override
     HashDoubleCharMap newUpdatableMapOf(double k1, char v1,
            double k2, char v2, double k3, char v3);

    @Override
     HashDoubleCharMap newUpdatableMapOf(double k1, char v1,
            double k2, char v2, double k3, char v3,
            double k4, char v4);

    @Override
     HashDoubleCharMap newUpdatableMapOf(double k1, char v1,
            double k2, char v2, double k3, char v3,
            double k4, char v4, double k5, char v5);

    


    @Override
     HashDoubleCharMap newImmutableMap(Map<Double, Character> map1,
            Map<Double, Character> map2, int expectedSize);

    @Override
     HashDoubleCharMap newImmutableMap(Map<Double, Character> map1,
            Map<Double, Character> map2, Map<Double, Character> map3, int expectedSize);

    @Override
     HashDoubleCharMap newImmutableMap(Map<Double, Character> map1,
            Map<Double, Character> map2, Map<Double, Character> map3,
            Map<Double, Character> map4, int expectedSize);

    @Override
     HashDoubleCharMap newImmutableMap(Map<Double, Character> map1,
            Map<Double, Character> map2, Map<Double, Character> map3,
            Map<Double, Character> map4, Map<Double, Character> map5, int expectedSize);

    

    
    @Override
     HashDoubleCharMap newImmutableMap(Map<Double, Character> map);

    @Override
     HashDoubleCharMap newImmutableMap(Map<Double, Character> map1,
            Map<Double, Character> map2);

    @Override
     HashDoubleCharMap newImmutableMap(Map<Double, Character> map1,
            Map<Double, Character> map2, Map<Double, Character> map3);

    @Override
     HashDoubleCharMap newImmutableMap(Map<Double, Character> map1,
            Map<Double, Character> map2, Map<Double, Character> map3,
            Map<Double, Character> map4);

    @Override
     HashDoubleCharMap newImmutableMap(Map<Double, Character> map1,
            Map<Double, Character> map2, Map<Double, Character> map3,
            Map<Double, Character> map4, Map<Double, Character> map5);


    @Override
     HashDoubleCharMap newImmutableMap(
            net.openhft.function.Consumer<DoubleCharConsumer> entriesSupplier);

    @Override
     HashDoubleCharMap newImmutableMap(
            net.openhft.function.Consumer<DoubleCharConsumer> entriesSupplier,
            int expectedSize);

    @Override
     HashDoubleCharMap newImmutableMap(double[] keys, char[] values);

    @Override
     HashDoubleCharMap newImmutableMap(double[] keys, char[] values,
            int expectedSize);

    @Override
     HashDoubleCharMap newImmutableMap(
            Double[] keys, Character[] values);

    @Override
     HashDoubleCharMap newImmutableMap(
            Double[] keys, Character[] values, int expectedSize);

    @Override
     HashDoubleCharMap newImmutableMap(Iterable<Double> keys,
            Iterable<Character> values);

    @Override
     HashDoubleCharMap newImmutableMap(Iterable<Double> keys,
            Iterable<Character> values, int expectedSize);


    @Override
     HashDoubleCharMap newImmutableMapOf(double k1, char v1);

    @Override
     HashDoubleCharMap newImmutableMapOf(double k1, char v1,
            double k2, char v2);

    @Override
     HashDoubleCharMap newImmutableMapOf(double k1, char v1,
            double k2, char v2, double k3, char v3);

    @Override
     HashDoubleCharMap newImmutableMapOf(double k1, char v1,
            double k2, char v2, double k3, char v3,
            double k4, char v4);

    @Override
     HashDoubleCharMap newImmutableMapOf(double k1, char v1,
            double k2, char v2, double k3, char v3,
            double k4, char v4, double k5, char v5);
}

