/*
 * Copyright 2014 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.openhft.collect.map.hash;

import net.openhft.collect.*;
import net.openhft.collect.hash.*;
import net.openhft.function.DoubleByteConsumer;
import net.openhft.collect.map.*;
import javax.annotation.Nullable;

import java.util.Map;


/**
 * An immutable factory of {@code HashDoubleByteMaps}
 *
 * @see HashDoubleByteMap
 * @see HashDoubleByteMaps#getDefaultFactory()
 */
public interface HashDoubleByteMapFactory extends DoubleByteMapFactory
        , HashContainerFactory<HashDoubleByteMapFactory> {

    

    

    

    

    

    
    

    
    


    @Override
    HashDoubleByteMapFactory withDefaultValue(byte defaultValue);

    @Override
     HashDoubleByteMap newMutableMap();

    @Override
     HashDoubleByteMap newMutableMap(int expectedSize);

    


    @Override
     HashDoubleByteMap newMutableMap(Map<Double, Byte> map1,
            Map<Double, Byte> map2, int expectedSize);

    @Override
     HashDoubleByteMap newMutableMap(Map<Double, Byte> map1,
            Map<Double, Byte> map2, Map<Double, Byte> map3, int expectedSize);

    @Override
     HashDoubleByteMap newMutableMap(Map<Double, Byte> map1,
            Map<Double, Byte> map2, Map<Double, Byte> map3,
            Map<Double, Byte> map4, int expectedSize);

    @Override
     HashDoubleByteMap newMutableMap(Map<Double, Byte> map1,
            Map<Double, Byte> map2, Map<Double, Byte> map3,
            Map<Double, Byte> map4, Map<Double, Byte> map5, int expectedSize);

    

    
    @Override
     HashDoubleByteMap newMutableMap(Map<Double, Byte> map);

    @Override
     HashDoubleByteMap newMutableMap(Map<Double, Byte> map1,
            Map<Double, Byte> map2);

    @Override
     HashDoubleByteMap newMutableMap(Map<Double, Byte> map1,
            Map<Double, Byte> map2, Map<Double, Byte> map3);

    @Override
     HashDoubleByteMap newMutableMap(Map<Double, Byte> map1,
            Map<Double, Byte> map2, Map<Double, Byte> map3,
            Map<Double, Byte> map4);

    @Override
     HashDoubleByteMap newMutableMap(Map<Double, Byte> map1,
            Map<Double, Byte> map2, Map<Double, Byte> map3,
            Map<Double, Byte> map4, Map<Double, Byte> map5);


    @Override
     HashDoubleByteMap newMutableMap(
            net.openhft.function.Consumer<DoubleByteConsumer> entriesSupplier);

    @Override
     HashDoubleByteMap newMutableMap(
            net.openhft.function.Consumer<DoubleByteConsumer> entriesSupplier,
            int expectedSize);

    @Override
     HashDoubleByteMap newMutableMap(double[] keys, byte[] values);

    @Override
     HashDoubleByteMap newMutableMap(double[] keys, byte[] values,
            int expectedSize);

    @Override
     HashDoubleByteMap newMutableMap(
            Double[] keys, Byte[] values);

    @Override
     HashDoubleByteMap newMutableMap(
            Double[] keys, Byte[] values, int expectedSize);

    @Override
     HashDoubleByteMap newMutableMap(Iterable<Double> keys,
            Iterable<Byte> values);

    @Override
     HashDoubleByteMap newMutableMap(Iterable<Double> keys,
            Iterable<Byte> values, int expectedSize);


    @Override
     HashDoubleByteMap newMutableMapOf(double k1, byte v1);

    @Override
     HashDoubleByteMap newMutableMapOf(double k1, byte v1,
            double k2, byte v2);

    @Override
     HashDoubleByteMap newMutableMapOf(double k1, byte v1,
            double k2, byte v2, double k3, byte v3);

    @Override
     HashDoubleByteMap newMutableMapOf(double k1, byte v1,
            double k2, byte v2, double k3, byte v3,
            double k4, byte v4);

    @Override
     HashDoubleByteMap newMutableMapOf(double k1, byte v1,
            double k2, byte v2, double k3, byte v3,
            double k4, byte v4, double k5, byte v5);
    @Override
     HashDoubleByteMap newUpdatableMap();

    @Override
     HashDoubleByteMap newUpdatableMap(int expectedSize);

    


    @Override
     HashDoubleByteMap newUpdatableMap(Map<Double, Byte> map1,
            Map<Double, Byte> map2, int expectedSize);

    @Override
     HashDoubleByteMap newUpdatableMap(Map<Double, Byte> map1,
            Map<Double, Byte> map2, Map<Double, Byte> map3, int expectedSize);

    @Override
     HashDoubleByteMap newUpdatableMap(Map<Double, Byte> map1,
            Map<Double, Byte> map2, Map<Double, Byte> map3,
            Map<Double, Byte> map4, int expectedSize);

    @Override
     HashDoubleByteMap newUpdatableMap(Map<Double, Byte> map1,
            Map<Double, Byte> map2, Map<Double, Byte> map3,
            Map<Double, Byte> map4, Map<Double, Byte> map5, int expectedSize);

    

    
    @Override
     HashDoubleByteMap newUpdatableMap(Map<Double, Byte> map);

    @Override
     HashDoubleByteMap newUpdatableMap(Map<Double, Byte> map1,
            Map<Double, Byte> map2);

    @Override
     HashDoubleByteMap newUpdatableMap(Map<Double, Byte> map1,
            Map<Double, Byte> map2, Map<Double, Byte> map3);

    @Override
     HashDoubleByteMap newUpdatableMap(Map<Double, Byte> map1,
            Map<Double, Byte> map2, Map<Double, Byte> map3,
            Map<Double, Byte> map4);

    @Override
     HashDoubleByteMap newUpdatableMap(Map<Double, Byte> map1,
            Map<Double, Byte> map2, Map<Double, Byte> map3,
            Map<Double, Byte> map4, Map<Double, Byte> map5);


    @Override
     HashDoubleByteMap newUpdatableMap(
            net.openhft.function.Consumer<DoubleByteConsumer> entriesSupplier);

    @Override
     HashDoubleByteMap newUpdatableMap(
            net.openhft.function.Consumer<DoubleByteConsumer> entriesSupplier,
            int expectedSize);

    @Override
     HashDoubleByteMap newUpdatableMap(double[] keys, byte[] values);

    @Override
     HashDoubleByteMap newUpdatableMap(double[] keys, byte[] values,
            int expectedSize);

    @Override
     HashDoubleByteMap newUpdatableMap(
            Double[] keys, Byte[] values);

    @Override
     HashDoubleByteMap newUpdatableMap(
            Double[] keys, Byte[] values, int expectedSize);

    @Override
     HashDoubleByteMap newUpdatableMap(Iterable<Double> keys,
            Iterable<Byte> values);

    @Override
     HashDoubleByteMap newUpdatableMap(Iterable<Double> keys,
            Iterable<Byte> values, int expectedSize);


    @Override
     HashDoubleByteMap newUpdatableMapOf(double k1, byte v1);

    @Override
     HashDoubleByteMap newUpdatableMapOf(double k1, byte v1,
            double k2, byte v2);

    @Override
     HashDoubleByteMap newUpdatableMapOf(double k1, byte v1,
            double k2, byte v2, double k3, byte v3);

    @Override
     HashDoubleByteMap newUpdatableMapOf(double k1, byte v1,
            double k2, byte v2, double k3, byte v3,
            double k4, byte v4);

    @Override
     HashDoubleByteMap newUpdatableMapOf(double k1, byte v1,
            double k2, byte v2, double k3, byte v3,
            double k4, byte v4, double k5, byte v5);

    


    @Override
     HashDoubleByteMap newImmutableMap(Map<Double, Byte> map1,
            Map<Double, Byte> map2, int expectedSize);

    @Override
     HashDoubleByteMap newImmutableMap(Map<Double, Byte> map1,
            Map<Double, Byte> map2, Map<Double, Byte> map3, int expectedSize);

    @Override
     HashDoubleByteMap newImmutableMap(Map<Double, Byte> map1,
            Map<Double, Byte> map2, Map<Double, Byte> map3,
            Map<Double, Byte> map4, int expectedSize);

    @Override
     HashDoubleByteMap newImmutableMap(Map<Double, Byte> map1,
            Map<Double, Byte> map2, Map<Double, Byte> map3,
            Map<Double, Byte> map4, Map<Double, Byte> map5, int expectedSize);

    

    
    @Override
     HashDoubleByteMap newImmutableMap(Map<Double, Byte> map);

    @Override
     HashDoubleByteMap newImmutableMap(Map<Double, Byte> map1,
            Map<Double, Byte> map2);

    @Override
     HashDoubleByteMap newImmutableMap(Map<Double, Byte> map1,
            Map<Double, Byte> map2, Map<Double, Byte> map3);

    @Override
     HashDoubleByteMap newImmutableMap(Map<Double, Byte> map1,
            Map<Double, Byte> map2, Map<Double, Byte> map3,
            Map<Double, Byte> map4);

    @Override
     HashDoubleByteMap newImmutableMap(Map<Double, Byte> map1,
            Map<Double, Byte> map2, Map<Double, Byte> map3,
            Map<Double, Byte> map4, Map<Double, Byte> map5);


    @Override
     HashDoubleByteMap newImmutableMap(
            net.openhft.function.Consumer<DoubleByteConsumer> entriesSupplier);

    @Override
     HashDoubleByteMap newImmutableMap(
            net.openhft.function.Consumer<DoubleByteConsumer> entriesSupplier,
            int expectedSize);

    @Override
     HashDoubleByteMap newImmutableMap(double[] keys, byte[] values);

    @Override
     HashDoubleByteMap newImmutableMap(double[] keys, byte[] values,
            int expectedSize);

    @Override
     HashDoubleByteMap newImmutableMap(
            Double[] keys, Byte[] values);

    @Override
     HashDoubleByteMap newImmutableMap(
            Double[] keys, Byte[] values, int expectedSize);

    @Override
     HashDoubleByteMap newImmutableMap(Iterable<Double> keys,
            Iterable<Byte> values);

    @Override
     HashDoubleByteMap newImmutableMap(Iterable<Double> keys,
            Iterable<Byte> values, int expectedSize);


    @Override
     HashDoubleByteMap newImmutableMapOf(double k1, byte v1);

    @Override
     HashDoubleByteMap newImmutableMapOf(double k1, byte v1,
            double k2, byte v2);

    @Override
     HashDoubleByteMap newImmutableMapOf(double k1, byte v1,
            double k2, byte v2, double k3, byte v3);

    @Override
     HashDoubleByteMap newImmutableMapOf(double k1, byte v1,
            double k2, byte v2, double k3, byte v3,
            double k4, byte v4);

    @Override
     HashDoubleByteMap newImmutableMapOf(double k1, byte v1,
            double k2, byte v2, double k3, byte v3,
            double k4, byte v4, double k5, byte v5);
}

