/*
 * Copyright 2014 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.openhft.collect.map.hash;

import net.openhft.function.CharObjConsumer;

import java.util.Map;
import java.util.ServiceLoader;


/**
 * This class consists only of static factory methods to construct {@code HashCharObjMap}s, and
 * the default {@link HashCharObjMapFactory} static provider ({@link #getDefaultFactory()}).
 *
 * @see HashCharObjMap
 */
public final class HashCharObjMaps {

    

    private static final ServiceLoader<HashCharObjMapFactory> LOADER =
            ServiceLoader.load(HashCharObjMapFactory.class);
    private static HashCharObjMapFactory<Object> defaultFactory = null;

    public static HashCharObjMapFactory<Object> getDefaultFactory() {
        if (defaultFactory != null) {
            return defaultFactory;
        } else {
            // synchronization?
            return defaultFactory = LOADER.iterator().next();
        }
    }

    

    

    

    public static <V> HashCharObjMap<V> newMutableMap() {
        return getDefaultFactory().newMutableMap();
    }

    public static <V> HashCharObjMap<V> newMutableMap(int expectedSize) {
        return getDefaultFactory().newMutableMap(expectedSize);
    }



    
    


    public static <V> HashCharObjMap<V> newMutableMap(Map<Character, ? extends V> map1,
            Map<Character, ? extends V> map2, int expectedSize) {
        return getDefaultFactory().newMutableMap(map1, map2, expectedSize);
    }

    public static <V> HashCharObjMap<V> newMutableMap(Map<Character, ? extends V> map1,
            Map<Character, ? extends V> map2, Map<Character, ? extends V> map3, int expectedSize) {
        return getDefaultFactory().newMutableMap(map1, map2, map3, expectedSize);
    }

    public static <V> HashCharObjMap<V> newMutableMap(Map<Character, ? extends V> map1,
            Map<Character, ? extends V> map2, Map<Character, ? extends V> map3,
            Map<Character, ? extends V> map4, int expectedSize) {
        return getDefaultFactory().newMutableMap(map1, map2, map3, map4, expectedSize);
    }

    public static <V> HashCharObjMap<V> newMutableMap(Map<Character, ? extends V> map1,
            Map<Character, ? extends V> map2, Map<Character, ? extends V> map3,
            Map<Character, ? extends V> map4, Map<Character, ? extends V> map5, int expectedSize) {
        return getDefaultFactory().newMutableMap(map1, map2, map3, map4, map5, expectedSize);
    }

    
    

    
    public static <V> HashCharObjMap<V> newMutableMap(
            Map<Character, ? extends V> map) {
        return getDefaultFactory().newMutableMap(map);
    }

    public static <V> HashCharObjMap<V> newMutableMap(Map<Character, ? extends V> map1,
            Map<Character, ? extends V> map2) {
        return getDefaultFactory().newMutableMap(map1, map2);
    }

    public static <V> HashCharObjMap<V> newMutableMap(Map<Character, ? extends V> map1,
            Map<Character, ? extends V> map2, Map<Character, ? extends V> map3) {
        return getDefaultFactory().newMutableMap(map1, map2, map3);
    }

    public static <V> HashCharObjMap<V> newMutableMap(Map<Character, ? extends V> map1,
            Map<Character, ? extends V> map2, Map<Character, ? extends V> map3,
            Map<Character, ? extends V> map4) {
        return getDefaultFactory().newMutableMap(map1, map2, map3, map4);
    }

    public static <V> HashCharObjMap<V> newMutableMap(Map<Character, ? extends V> map1,
            Map<Character, ? extends V> map2, Map<Character, ? extends V> map3,
            Map<Character, ? extends V> map4, Map<Character, ? extends V> map5) {
        return getDefaultFactory().newMutableMap(map1, map2, map3, map4, map5);
    }


    public static <V> HashCharObjMap<V> newMutableMap(
            net.openhft.function.Consumer<CharObjConsumer<V>> entriesSupplier) {
        return getDefaultFactory().newMutableMap(entriesSupplier);
    }

    public static <V> HashCharObjMap<V> newMutableMap(
            net.openhft.function.Consumer<CharObjConsumer<V>> entriesSupplier,
            int expectedSize) {
        return getDefaultFactory().newMutableMap(entriesSupplier, expectedSize);
    }

    public static <V> HashCharObjMap<V> newMutableMap(
            char[] keys, V[] values) {
        return getDefaultFactory().newMutableMap(keys, values);
    }

    public static <V> HashCharObjMap<V> newMutableMap(
            char[] keys, V[] values, int expectedSize) {
        return getDefaultFactory().newMutableMap(keys, values, expectedSize);
    }

    public static <V> HashCharObjMap<V> newMutableMap(
            Character[] keys, V[] values) {
        return getDefaultFactory().newMutableMap(keys, values);
    }

    public static <V> HashCharObjMap<V> newMutableMap(
            Character[] keys, V[] values, int expectedSize) {
        return getDefaultFactory().newMutableMap(keys, values, expectedSize);
    }

    public static <V> HashCharObjMap<V> newMutableMap(Iterable<Character> keys,
            Iterable<? extends V> values) {
        return getDefaultFactory().newMutableMap(keys, values);
    }

    public static <V> HashCharObjMap<V> newMutableMap(Iterable<Character> keys,
            Iterable<? extends V> values, int expectedSize) {
        return getDefaultFactory().newMutableMap(keys, values, expectedSize);
    }


    public static <V> HashCharObjMap<V> newMutableMapOf(
            char k1, V v1) {
        return getDefaultFactory().newMutableMapOf(k1, v1);
    }

    public static <V> HashCharObjMap<V> newMutableMapOf(
            char k1, V v1, char k2, V v2) {
        return getDefaultFactory().newMutableMapOf(k1, v1, k2, v2);
    }

    public static <V> HashCharObjMap<V> newMutableMapOf(
            char k1, V v1, char k2, V v2,
            char k3, V v3) {
        return getDefaultFactory().newMutableMapOf(k1, v1, k2, v2, k3, v3);
    }

    public static <V> HashCharObjMap<V> newMutableMapOf(
            char k1, V v1, char k2, V v2,
            char k3, V v3, char k4, V v4) {
        return getDefaultFactory().newMutableMapOf(k1, v1, k2, v2, k3, v3, k4, v4);
    }

    public static <V> HashCharObjMap<V> newMutableMapOf(
            char k1, V v1, char k2, V v2,
            char k3, V v3, char k4, V v4,
            char k5, V v5) {
        return getDefaultFactory().newMutableMapOf(k1, v1, k2, v2, k3, v3, k4, v4, k5, v5);
    }

    
    


    public static <V> HashCharObjMap<V> newUpdatableMap(Map<Character, ? extends V> map1,
            Map<Character, ? extends V> map2, int expectedSize) {
        return getDefaultFactory().newUpdatableMap(map1, map2, expectedSize);
    }

    public static <V> HashCharObjMap<V> newUpdatableMap(Map<Character, ? extends V> map1,
            Map<Character, ? extends V> map2, Map<Character, ? extends V> map3, int expectedSize) {
        return getDefaultFactory().newUpdatableMap(map1, map2, map3, expectedSize);
    }

    public static <V> HashCharObjMap<V> newUpdatableMap(Map<Character, ? extends V> map1,
            Map<Character, ? extends V> map2, Map<Character, ? extends V> map3,
            Map<Character, ? extends V> map4, int expectedSize) {
        return getDefaultFactory().newUpdatableMap(map1, map2, map3, map4, expectedSize);
    }

    public static <V> HashCharObjMap<V> newUpdatableMap(Map<Character, ? extends V> map1,
            Map<Character, ? extends V> map2, Map<Character, ? extends V> map3,
            Map<Character, ? extends V> map4, Map<Character, ? extends V> map5, int expectedSize) {
        return getDefaultFactory().newUpdatableMap(map1, map2, map3, map4, map5, expectedSize);
    }

    
    

    
    public static <V> HashCharObjMap<V> newUpdatableMap(
            Map<Character, ? extends V> map) {
        return getDefaultFactory().newUpdatableMap(map);
    }

    public static <V> HashCharObjMap<V> newUpdatableMap(Map<Character, ? extends V> map1,
            Map<Character, ? extends V> map2) {
        return getDefaultFactory().newUpdatableMap(map1, map2);
    }

    public static <V> HashCharObjMap<V> newUpdatableMap(Map<Character, ? extends V> map1,
            Map<Character, ? extends V> map2, Map<Character, ? extends V> map3) {
        return getDefaultFactory().newUpdatableMap(map1, map2, map3);
    }

    public static <V> HashCharObjMap<V> newUpdatableMap(Map<Character, ? extends V> map1,
            Map<Character, ? extends V> map2, Map<Character, ? extends V> map3,
            Map<Character, ? extends V> map4) {
        return getDefaultFactory().newUpdatableMap(map1, map2, map3, map4);
    }

    public static <V> HashCharObjMap<V> newUpdatableMap(Map<Character, ? extends V> map1,
            Map<Character, ? extends V> map2, Map<Character, ? extends V> map3,
            Map<Character, ? extends V> map4, Map<Character, ? extends V> map5) {
        return getDefaultFactory().newUpdatableMap(map1, map2, map3, map4, map5);
    }


    public static <V> HashCharObjMap<V> newUpdatableMap(
            net.openhft.function.Consumer<CharObjConsumer<V>> entriesSupplier) {
        return getDefaultFactory().newUpdatableMap(entriesSupplier);
    }

    public static <V> HashCharObjMap<V> newUpdatableMap(
            net.openhft.function.Consumer<CharObjConsumer<V>> entriesSupplier,
            int expectedSize) {
        return getDefaultFactory().newUpdatableMap(entriesSupplier, expectedSize);
    }

    public static <V> HashCharObjMap<V> newUpdatableMap(
            char[] keys, V[] values) {
        return getDefaultFactory().newUpdatableMap(keys, values);
    }

    public static <V> HashCharObjMap<V> newUpdatableMap(
            char[] keys, V[] values, int expectedSize) {
        return getDefaultFactory().newUpdatableMap(keys, values, expectedSize);
    }

    public static <V> HashCharObjMap<V> newUpdatableMap(
            Character[] keys, V[] values) {
        return getDefaultFactory().newUpdatableMap(keys, values);
    }

    public static <V> HashCharObjMap<V> newUpdatableMap(
            Character[] keys, V[] values, int expectedSize) {
        return getDefaultFactory().newUpdatableMap(keys, values, expectedSize);
    }

    public static <V> HashCharObjMap<V> newUpdatableMap(Iterable<Character> keys,
            Iterable<? extends V> values) {
        return getDefaultFactory().newUpdatableMap(keys, values);
    }

    public static <V> HashCharObjMap<V> newUpdatableMap(Iterable<Character> keys,
            Iterable<? extends V> values, int expectedSize) {
        return getDefaultFactory().newUpdatableMap(keys, values, expectedSize);
    }


    public static <V> HashCharObjMap<V> newUpdatableMapOf(
            char k1, V v1) {
        return getDefaultFactory().newUpdatableMapOf(k1, v1);
    }

    public static <V> HashCharObjMap<V> newUpdatableMapOf(
            char k1, V v1, char k2, V v2) {
        return getDefaultFactory().newUpdatableMapOf(k1, v1, k2, v2);
    }

    public static <V> HashCharObjMap<V> newUpdatableMapOf(
            char k1, V v1, char k2, V v2,
            char k3, V v3) {
        return getDefaultFactory().newUpdatableMapOf(k1, v1, k2, v2, k3, v3);
    }

    public static <V> HashCharObjMap<V> newUpdatableMapOf(
            char k1, V v1, char k2, V v2,
            char k3, V v3, char k4, V v4) {
        return getDefaultFactory().newUpdatableMapOf(k1, v1, k2, v2, k3, v3, k4, v4);
    }

    public static <V> HashCharObjMap<V> newUpdatableMapOf(
            char k1, V v1, char k2, V v2,
            char k3, V v3, char k4, V v4,
            char k5, V v5) {
        return getDefaultFactory().newUpdatableMapOf(k1, v1, k2, v2, k3, v3, k4, v4, k5, v5);
    }

    
    


    public static <V> HashCharObjMap<V> newImmutableMap(Map<Character, ? extends V> map1,
            Map<Character, ? extends V> map2, int expectedSize) {
        return getDefaultFactory().newImmutableMap(map1, map2, expectedSize);
    }

    public static <V> HashCharObjMap<V> newImmutableMap(Map<Character, ? extends V> map1,
            Map<Character, ? extends V> map2, Map<Character, ? extends V> map3, int expectedSize) {
        return getDefaultFactory().newImmutableMap(map1, map2, map3, expectedSize);
    }

    public static <V> HashCharObjMap<V> newImmutableMap(Map<Character, ? extends V> map1,
            Map<Character, ? extends V> map2, Map<Character, ? extends V> map3,
            Map<Character, ? extends V> map4, int expectedSize) {
        return getDefaultFactory().newImmutableMap(map1, map2, map3, map4, expectedSize);
    }

    public static <V> HashCharObjMap<V> newImmutableMap(Map<Character, ? extends V> map1,
            Map<Character, ? extends V> map2, Map<Character, ? extends V> map3,
            Map<Character, ? extends V> map4, Map<Character, ? extends V> map5, int expectedSize) {
        return getDefaultFactory().newImmutableMap(map1, map2, map3, map4, map5, expectedSize);
    }

    
    

    
    public static <V> HashCharObjMap<V> newImmutableMap(
            Map<Character, ? extends V> map) {
        return getDefaultFactory().newImmutableMap(map);
    }

    public static <V> HashCharObjMap<V> newImmutableMap(Map<Character, ? extends V> map1,
            Map<Character, ? extends V> map2) {
        return getDefaultFactory().newImmutableMap(map1, map2);
    }

    public static <V> HashCharObjMap<V> newImmutableMap(Map<Character, ? extends V> map1,
            Map<Character, ? extends V> map2, Map<Character, ? extends V> map3) {
        return getDefaultFactory().newImmutableMap(map1, map2, map3);
    }

    public static <V> HashCharObjMap<V> newImmutableMap(Map<Character, ? extends V> map1,
            Map<Character, ? extends V> map2, Map<Character, ? extends V> map3,
            Map<Character, ? extends V> map4) {
        return getDefaultFactory().newImmutableMap(map1, map2, map3, map4);
    }

    public static <V> HashCharObjMap<V> newImmutableMap(Map<Character, ? extends V> map1,
            Map<Character, ? extends V> map2, Map<Character, ? extends V> map3,
            Map<Character, ? extends V> map4, Map<Character, ? extends V> map5) {
        return getDefaultFactory().newImmutableMap(map1, map2, map3, map4, map5);
    }


    public static <V> HashCharObjMap<V> newImmutableMap(
            net.openhft.function.Consumer<CharObjConsumer<V>> entriesSupplier) {
        return getDefaultFactory().newImmutableMap(entriesSupplier);
    }

    public static <V> HashCharObjMap<V> newImmutableMap(
            net.openhft.function.Consumer<CharObjConsumer<V>> entriesSupplier,
            int expectedSize) {
        return getDefaultFactory().newImmutableMap(entriesSupplier, expectedSize);
    }

    public static <V> HashCharObjMap<V> newImmutableMap(
            char[] keys, V[] values) {
        return getDefaultFactory().newImmutableMap(keys, values);
    }

    public static <V> HashCharObjMap<V> newImmutableMap(
            char[] keys, V[] values, int expectedSize) {
        return getDefaultFactory().newImmutableMap(keys, values, expectedSize);
    }

    public static <V> HashCharObjMap<V> newImmutableMap(
            Character[] keys, V[] values) {
        return getDefaultFactory().newImmutableMap(keys, values);
    }

    public static <V> HashCharObjMap<V> newImmutableMap(
            Character[] keys, V[] values, int expectedSize) {
        return getDefaultFactory().newImmutableMap(keys, values, expectedSize);
    }

    public static <V> HashCharObjMap<V> newImmutableMap(Iterable<Character> keys,
            Iterable<? extends V> values) {
        return getDefaultFactory().newImmutableMap(keys, values);
    }

    public static <V> HashCharObjMap<V> newImmutableMap(Iterable<Character> keys,
            Iterable<? extends V> values, int expectedSize) {
        return getDefaultFactory().newImmutableMap(keys, values, expectedSize);
    }


    public static <V> HashCharObjMap<V> newImmutableMapOf(
            char k1, V v1) {
        return getDefaultFactory().newImmutableMapOf(k1, v1);
    }

    public static <V> HashCharObjMap<V> newImmutableMapOf(
            char k1, V v1, char k2, V v2) {
        return getDefaultFactory().newImmutableMapOf(k1, v1, k2, v2);
    }

    public static <V> HashCharObjMap<V> newImmutableMapOf(
            char k1, V v1, char k2, V v2,
            char k3, V v3) {
        return getDefaultFactory().newImmutableMapOf(k1, v1, k2, v2, k3, v3);
    }

    public static <V> HashCharObjMap<V> newImmutableMapOf(
            char k1, V v1, char k2, V v2,
            char k3, V v3, char k4, V v4) {
        return getDefaultFactory().newImmutableMapOf(k1, v1, k2, v2, k3, v3, k4, v4);
    }

    public static <V> HashCharObjMap<V> newImmutableMapOf(
            char k1, V v1, char k2, V v2,
            char k3, V v3, char k4, V v4,
            char k5, V v5) {
        return getDefaultFactory().newImmutableMapOf(k1, v1, k2, v2, k3, v3, k4, v4, k5, v5);
    }

    private HashCharObjMaps() {}
}

