/*
 * Copyright 2014 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.openhft.collect.map.hash;

import net.openhft.function.CharLongConsumer;

import java.util.Map;
import java.util.ServiceLoader;


/**
 * This class consists only of static factory methods to construct {@code HashCharLongMap}s, and
 * the default {@link HashCharLongMapFactory} static provider ({@link #getDefaultFactory()}).
 *
 * @see HashCharLongMap
 */
public final class HashCharLongMaps {

    

    private static final ServiceLoader<HashCharLongMapFactory> LOADER =
            ServiceLoader.load(HashCharLongMapFactory.class);
    private static HashCharLongMapFactory defaultFactory = null;

    public static HashCharLongMapFactory getDefaultFactory() {
        if (defaultFactory != null) {
            return defaultFactory;
        } else {
            // synchronization?
            return defaultFactory = LOADER.iterator().next();
        }
    }

    

    

    

    public static  HashCharLongMap newMutableMap() {
        return getDefaultFactory().newMutableMap();
    }

    public static  HashCharLongMap newMutableMap(int expectedSize) {
        return getDefaultFactory().newMutableMap(expectedSize);
    }



    
    


    public static  HashCharLongMap newMutableMap(Map<Character, Long> map1,
            Map<Character, Long> map2, int expectedSize) {
        return getDefaultFactory().newMutableMap(map1, map2, expectedSize);
    }

    public static  HashCharLongMap newMutableMap(Map<Character, Long> map1,
            Map<Character, Long> map2, Map<Character, Long> map3, int expectedSize) {
        return getDefaultFactory().newMutableMap(map1, map2, map3, expectedSize);
    }

    public static  HashCharLongMap newMutableMap(Map<Character, Long> map1,
            Map<Character, Long> map2, Map<Character, Long> map3,
            Map<Character, Long> map4, int expectedSize) {
        return getDefaultFactory().newMutableMap(map1, map2, map3, map4, expectedSize);
    }

    public static  HashCharLongMap newMutableMap(Map<Character, Long> map1,
            Map<Character, Long> map2, Map<Character, Long> map3,
            Map<Character, Long> map4, Map<Character, Long> map5, int expectedSize) {
        return getDefaultFactory().newMutableMap(map1, map2, map3, map4, map5, expectedSize);
    }

    
    

    
    public static  HashCharLongMap newMutableMap(
            Map<Character, Long> map) {
        return getDefaultFactory().newMutableMap(map);
    }

    public static  HashCharLongMap newMutableMap(Map<Character, Long> map1,
            Map<Character, Long> map2) {
        return getDefaultFactory().newMutableMap(map1, map2);
    }

    public static  HashCharLongMap newMutableMap(Map<Character, Long> map1,
            Map<Character, Long> map2, Map<Character, Long> map3) {
        return getDefaultFactory().newMutableMap(map1, map2, map3);
    }

    public static  HashCharLongMap newMutableMap(Map<Character, Long> map1,
            Map<Character, Long> map2, Map<Character, Long> map3,
            Map<Character, Long> map4) {
        return getDefaultFactory().newMutableMap(map1, map2, map3, map4);
    }

    public static  HashCharLongMap newMutableMap(Map<Character, Long> map1,
            Map<Character, Long> map2, Map<Character, Long> map3,
            Map<Character, Long> map4, Map<Character, Long> map5) {
        return getDefaultFactory().newMutableMap(map1, map2, map3, map4, map5);
    }


    public static  HashCharLongMap newMutableMap(
            net.openhft.function.Consumer<CharLongConsumer> entriesSupplier) {
        return getDefaultFactory().newMutableMap(entriesSupplier);
    }

    public static  HashCharLongMap newMutableMap(
            net.openhft.function.Consumer<CharLongConsumer> entriesSupplier,
            int expectedSize) {
        return getDefaultFactory().newMutableMap(entriesSupplier, expectedSize);
    }

    public static  HashCharLongMap newMutableMap(
            char[] keys, long[] values) {
        return getDefaultFactory().newMutableMap(keys, values);
    }

    public static  HashCharLongMap newMutableMap(
            char[] keys, long[] values, int expectedSize) {
        return getDefaultFactory().newMutableMap(keys, values, expectedSize);
    }

    public static  HashCharLongMap newMutableMap(
            Character[] keys, Long[] values) {
        return getDefaultFactory().newMutableMap(keys, values);
    }

    public static  HashCharLongMap newMutableMap(
            Character[] keys, Long[] values, int expectedSize) {
        return getDefaultFactory().newMutableMap(keys, values, expectedSize);
    }

    public static  HashCharLongMap newMutableMap(Iterable<Character> keys,
            Iterable<Long> values) {
        return getDefaultFactory().newMutableMap(keys, values);
    }

    public static  HashCharLongMap newMutableMap(Iterable<Character> keys,
            Iterable<Long> values, int expectedSize) {
        return getDefaultFactory().newMutableMap(keys, values, expectedSize);
    }


    public static  HashCharLongMap newMutableMapOf(
            char k1, long v1) {
        return getDefaultFactory().newMutableMapOf(k1, v1);
    }

    public static  HashCharLongMap newMutableMapOf(
            char k1, long v1, char k2, long v2) {
        return getDefaultFactory().newMutableMapOf(k1, v1, k2, v2);
    }

    public static  HashCharLongMap newMutableMapOf(
            char k1, long v1, char k2, long v2,
            char k3, long v3) {
        return getDefaultFactory().newMutableMapOf(k1, v1, k2, v2, k3, v3);
    }

    public static  HashCharLongMap newMutableMapOf(
            char k1, long v1, char k2, long v2,
            char k3, long v3, char k4, long v4) {
        return getDefaultFactory().newMutableMapOf(k1, v1, k2, v2, k3, v3, k4, v4);
    }

    public static  HashCharLongMap newMutableMapOf(
            char k1, long v1, char k2, long v2,
            char k3, long v3, char k4, long v4,
            char k5, long v5) {
        return getDefaultFactory().newMutableMapOf(k1, v1, k2, v2, k3, v3, k4, v4, k5, v5);
    }

    
    


    public static  HashCharLongMap newUpdatableMap(Map<Character, Long> map1,
            Map<Character, Long> map2, int expectedSize) {
        return getDefaultFactory().newUpdatableMap(map1, map2, expectedSize);
    }

    public static  HashCharLongMap newUpdatableMap(Map<Character, Long> map1,
            Map<Character, Long> map2, Map<Character, Long> map3, int expectedSize) {
        return getDefaultFactory().newUpdatableMap(map1, map2, map3, expectedSize);
    }

    public static  HashCharLongMap newUpdatableMap(Map<Character, Long> map1,
            Map<Character, Long> map2, Map<Character, Long> map3,
            Map<Character, Long> map4, int expectedSize) {
        return getDefaultFactory().newUpdatableMap(map1, map2, map3, map4, expectedSize);
    }

    public static  HashCharLongMap newUpdatableMap(Map<Character, Long> map1,
            Map<Character, Long> map2, Map<Character, Long> map3,
            Map<Character, Long> map4, Map<Character, Long> map5, int expectedSize) {
        return getDefaultFactory().newUpdatableMap(map1, map2, map3, map4, map5, expectedSize);
    }

    
    

    
    public static  HashCharLongMap newUpdatableMap(
            Map<Character, Long> map) {
        return getDefaultFactory().newUpdatableMap(map);
    }

    public static  HashCharLongMap newUpdatableMap(Map<Character, Long> map1,
            Map<Character, Long> map2) {
        return getDefaultFactory().newUpdatableMap(map1, map2);
    }

    public static  HashCharLongMap newUpdatableMap(Map<Character, Long> map1,
            Map<Character, Long> map2, Map<Character, Long> map3) {
        return getDefaultFactory().newUpdatableMap(map1, map2, map3);
    }

    public static  HashCharLongMap newUpdatableMap(Map<Character, Long> map1,
            Map<Character, Long> map2, Map<Character, Long> map3,
            Map<Character, Long> map4) {
        return getDefaultFactory().newUpdatableMap(map1, map2, map3, map4);
    }

    public static  HashCharLongMap newUpdatableMap(Map<Character, Long> map1,
            Map<Character, Long> map2, Map<Character, Long> map3,
            Map<Character, Long> map4, Map<Character, Long> map5) {
        return getDefaultFactory().newUpdatableMap(map1, map2, map3, map4, map5);
    }


    public static  HashCharLongMap newUpdatableMap(
            net.openhft.function.Consumer<CharLongConsumer> entriesSupplier) {
        return getDefaultFactory().newUpdatableMap(entriesSupplier);
    }

    public static  HashCharLongMap newUpdatableMap(
            net.openhft.function.Consumer<CharLongConsumer> entriesSupplier,
            int expectedSize) {
        return getDefaultFactory().newUpdatableMap(entriesSupplier, expectedSize);
    }

    public static  HashCharLongMap newUpdatableMap(
            char[] keys, long[] values) {
        return getDefaultFactory().newUpdatableMap(keys, values);
    }

    public static  HashCharLongMap newUpdatableMap(
            char[] keys, long[] values, int expectedSize) {
        return getDefaultFactory().newUpdatableMap(keys, values, expectedSize);
    }

    public static  HashCharLongMap newUpdatableMap(
            Character[] keys, Long[] values) {
        return getDefaultFactory().newUpdatableMap(keys, values);
    }

    public static  HashCharLongMap newUpdatableMap(
            Character[] keys, Long[] values, int expectedSize) {
        return getDefaultFactory().newUpdatableMap(keys, values, expectedSize);
    }

    public static  HashCharLongMap newUpdatableMap(Iterable<Character> keys,
            Iterable<Long> values) {
        return getDefaultFactory().newUpdatableMap(keys, values);
    }

    public static  HashCharLongMap newUpdatableMap(Iterable<Character> keys,
            Iterable<Long> values, int expectedSize) {
        return getDefaultFactory().newUpdatableMap(keys, values, expectedSize);
    }


    public static  HashCharLongMap newUpdatableMapOf(
            char k1, long v1) {
        return getDefaultFactory().newUpdatableMapOf(k1, v1);
    }

    public static  HashCharLongMap newUpdatableMapOf(
            char k1, long v1, char k2, long v2) {
        return getDefaultFactory().newUpdatableMapOf(k1, v1, k2, v2);
    }

    public static  HashCharLongMap newUpdatableMapOf(
            char k1, long v1, char k2, long v2,
            char k3, long v3) {
        return getDefaultFactory().newUpdatableMapOf(k1, v1, k2, v2, k3, v3);
    }

    public static  HashCharLongMap newUpdatableMapOf(
            char k1, long v1, char k2, long v2,
            char k3, long v3, char k4, long v4) {
        return getDefaultFactory().newUpdatableMapOf(k1, v1, k2, v2, k3, v3, k4, v4);
    }

    public static  HashCharLongMap newUpdatableMapOf(
            char k1, long v1, char k2, long v2,
            char k3, long v3, char k4, long v4,
            char k5, long v5) {
        return getDefaultFactory().newUpdatableMapOf(k1, v1, k2, v2, k3, v3, k4, v4, k5, v5);
    }

    
    


    public static  HashCharLongMap newImmutableMap(Map<Character, Long> map1,
            Map<Character, Long> map2, int expectedSize) {
        return getDefaultFactory().newImmutableMap(map1, map2, expectedSize);
    }

    public static  HashCharLongMap newImmutableMap(Map<Character, Long> map1,
            Map<Character, Long> map2, Map<Character, Long> map3, int expectedSize) {
        return getDefaultFactory().newImmutableMap(map1, map2, map3, expectedSize);
    }

    public static  HashCharLongMap newImmutableMap(Map<Character, Long> map1,
            Map<Character, Long> map2, Map<Character, Long> map3,
            Map<Character, Long> map4, int expectedSize) {
        return getDefaultFactory().newImmutableMap(map1, map2, map3, map4, expectedSize);
    }

    public static  HashCharLongMap newImmutableMap(Map<Character, Long> map1,
            Map<Character, Long> map2, Map<Character, Long> map3,
            Map<Character, Long> map4, Map<Character, Long> map5, int expectedSize) {
        return getDefaultFactory().newImmutableMap(map1, map2, map3, map4, map5, expectedSize);
    }

    
    

    
    public static  HashCharLongMap newImmutableMap(
            Map<Character, Long> map) {
        return getDefaultFactory().newImmutableMap(map);
    }

    public static  HashCharLongMap newImmutableMap(Map<Character, Long> map1,
            Map<Character, Long> map2) {
        return getDefaultFactory().newImmutableMap(map1, map2);
    }

    public static  HashCharLongMap newImmutableMap(Map<Character, Long> map1,
            Map<Character, Long> map2, Map<Character, Long> map3) {
        return getDefaultFactory().newImmutableMap(map1, map2, map3);
    }

    public static  HashCharLongMap newImmutableMap(Map<Character, Long> map1,
            Map<Character, Long> map2, Map<Character, Long> map3,
            Map<Character, Long> map4) {
        return getDefaultFactory().newImmutableMap(map1, map2, map3, map4);
    }

    public static  HashCharLongMap newImmutableMap(Map<Character, Long> map1,
            Map<Character, Long> map2, Map<Character, Long> map3,
            Map<Character, Long> map4, Map<Character, Long> map5) {
        return getDefaultFactory().newImmutableMap(map1, map2, map3, map4, map5);
    }


    public static  HashCharLongMap newImmutableMap(
            net.openhft.function.Consumer<CharLongConsumer> entriesSupplier) {
        return getDefaultFactory().newImmutableMap(entriesSupplier);
    }

    public static  HashCharLongMap newImmutableMap(
            net.openhft.function.Consumer<CharLongConsumer> entriesSupplier,
            int expectedSize) {
        return getDefaultFactory().newImmutableMap(entriesSupplier, expectedSize);
    }

    public static  HashCharLongMap newImmutableMap(
            char[] keys, long[] values) {
        return getDefaultFactory().newImmutableMap(keys, values);
    }

    public static  HashCharLongMap newImmutableMap(
            char[] keys, long[] values, int expectedSize) {
        return getDefaultFactory().newImmutableMap(keys, values, expectedSize);
    }

    public static  HashCharLongMap newImmutableMap(
            Character[] keys, Long[] values) {
        return getDefaultFactory().newImmutableMap(keys, values);
    }

    public static  HashCharLongMap newImmutableMap(
            Character[] keys, Long[] values, int expectedSize) {
        return getDefaultFactory().newImmutableMap(keys, values, expectedSize);
    }

    public static  HashCharLongMap newImmutableMap(Iterable<Character> keys,
            Iterable<Long> values) {
        return getDefaultFactory().newImmutableMap(keys, values);
    }

    public static  HashCharLongMap newImmutableMap(Iterable<Character> keys,
            Iterable<Long> values, int expectedSize) {
        return getDefaultFactory().newImmutableMap(keys, values, expectedSize);
    }


    public static  HashCharLongMap newImmutableMapOf(
            char k1, long v1) {
        return getDefaultFactory().newImmutableMapOf(k1, v1);
    }

    public static  HashCharLongMap newImmutableMapOf(
            char k1, long v1, char k2, long v2) {
        return getDefaultFactory().newImmutableMapOf(k1, v1, k2, v2);
    }

    public static  HashCharLongMap newImmutableMapOf(
            char k1, long v1, char k2, long v2,
            char k3, long v3) {
        return getDefaultFactory().newImmutableMapOf(k1, v1, k2, v2, k3, v3);
    }

    public static  HashCharLongMap newImmutableMapOf(
            char k1, long v1, char k2, long v2,
            char k3, long v3, char k4, long v4) {
        return getDefaultFactory().newImmutableMapOf(k1, v1, k2, v2, k3, v3, k4, v4);
    }

    public static  HashCharLongMap newImmutableMapOf(
            char k1, long v1, char k2, long v2,
            char k3, long v3, char k4, long v4,
            char k5, long v5) {
        return getDefaultFactory().newImmutableMapOf(k1, v1, k2, v2, k3, v3, k4, v4, k5, v5);
    }

    private HashCharLongMaps() {}
}

