/*
 * Copyright 2014 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.openhft.collect.map.hash;

import net.openhft.collect.*;
import net.openhft.collect.hash.*;
import net.openhft.function.CharLongConsumer;
import net.openhft.collect.map.*;
import javax.annotation.Nullable;

import java.util.Map;


/**
 * An immutable factory of {@code HashCharLongMaps}
 *
 * @see HashCharLongMap
 * @see HashCharLongMaps#getDefaultFactory()
 */
public interface HashCharLongMapFactory extends CharLongMapFactory
        , CharHashFactory<HashCharLongMapFactory>
         {

    

    

    

    

    

    
    

    
    


    @Override
    HashCharLongMapFactory withDefaultValue(long defaultValue);

    @Override
     HashCharLongMap newMutableMap();

    @Override
     HashCharLongMap newMutableMap(int expectedSize);

    


    @Override
     HashCharLongMap newMutableMap(Map<Character, Long> map1,
            Map<Character, Long> map2, int expectedSize);

    @Override
     HashCharLongMap newMutableMap(Map<Character, Long> map1,
            Map<Character, Long> map2, Map<Character, Long> map3, int expectedSize);

    @Override
     HashCharLongMap newMutableMap(Map<Character, Long> map1,
            Map<Character, Long> map2, Map<Character, Long> map3,
            Map<Character, Long> map4, int expectedSize);

    @Override
     HashCharLongMap newMutableMap(Map<Character, Long> map1,
            Map<Character, Long> map2, Map<Character, Long> map3,
            Map<Character, Long> map4, Map<Character, Long> map5, int expectedSize);

    

    
    @Override
     HashCharLongMap newMutableMap(Map<Character, Long> map);

    @Override
     HashCharLongMap newMutableMap(Map<Character, Long> map1,
            Map<Character, Long> map2);

    @Override
     HashCharLongMap newMutableMap(Map<Character, Long> map1,
            Map<Character, Long> map2, Map<Character, Long> map3);

    @Override
     HashCharLongMap newMutableMap(Map<Character, Long> map1,
            Map<Character, Long> map2, Map<Character, Long> map3,
            Map<Character, Long> map4);

    @Override
     HashCharLongMap newMutableMap(Map<Character, Long> map1,
            Map<Character, Long> map2, Map<Character, Long> map3,
            Map<Character, Long> map4, Map<Character, Long> map5);


    @Override
     HashCharLongMap newMutableMap(
            net.openhft.function.Consumer<CharLongConsumer> entriesSupplier);

    @Override
     HashCharLongMap newMutableMap(
            net.openhft.function.Consumer<CharLongConsumer> entriesSupplier,
            int expectedSize);

    @Override
     HashCharLongMap newMutableMap(char[] keys, long[] values);

    @Override
     HashCharLongMap newMutableMap(char[] keys, long[] values,
            int expectedSize);

    @Override
     HashCharLongMap newMutableMap(
            Character[] keys, Long[] values);

    @Override
     HashCharLongMap newMutableMap(
            Character[] keys, Long[] values, int expectedSize);

    @Override
     HashCharLongMap newMutableMap(Iterable<Character> keys,
            Iterable<Long> values);

    @Override
     HashCharLongMap newMutableMap(Iterable<Character> keys,
            Iterable<Long> values, int expectedSize);


    @Override
     HashCharLongMap newMutableMapOf(char k1, long v1);

    @Override
     HashCharLongMap newMutableMapOf(char k1, long v1,
            char k2, long v2);

    @Override
     HashCharLongMap newMutableMapOf(char k1, long v1,
            char k2, long v2, char k3, long v3);

    @Override
     HashCharLongMap newMutableMapOf(char k1, long v1,
            char k2, long v2, char k3, long v3,
            char k4, long v4);

    @Override
     HashCharLongMap newMutableMapOf(char k1, long v1,
            char k2, long v2, char k3, long v3,
            char k4, long v4, char k5, long v5);
    @Override
     HashCharLongMap newUpdatableMap();

    @Override
     HashCharLongMap newUpdatableMap(int expectedSize);

    


    @Override
     HashCharLongMap newUpdatableMap(Map<Character, Long> map1,
            Map<Character, Long> map2, int expectedSize);

    @Override
     HashCharLongMap newUpdatableMap(Map<Character, Long> map1,
            Map<Character, Long> map2, Map<Character, Long> map3, int expectedSize);

    @Override
     HashCharLongMap newUpdatableMap(Map<Character, Long> map1,
            Map<Character, Long> map2, Map<Character, Long> map3,
            Map<Character, Long> map4, int expectedSize);

    @Override
     HashCharLongMap newUpdatableMap(Map<Character, Long> map1,
            Map<Character, Long> map2, Map<Character, Long> map3,
            Map<Character, Long> map4, Map<Character, Long> map5, int expectedSize);

    

    
    @Override
     HashCharLongMap newUpdatableMap(Map<Character, Long> map);

    @Override
     HashCharLongMap newUpdatableMap(Map<Character, Long> map1,
            Map<Character, Long> map2);

    @Override
     HashCharLongMap newUpdatableMap(Map<Character, Long> map1,
            Map<Character, Long> map2, Map<Character, Long> map3);

    @Override
     HashCharLongMap newUpdatableMap(Map<Character, Long> map1,
            Map<Character, Long> map2, Map<Character, Long> map3,
            Map<Character, Long> map4);

    @Override
     HashCharLongMap newUpdatableMap(Map<Character, Long> map1,
            Map<Character, Long> map2, Map<Character, Long> map3,
            Map<Character, Long> map4, Map<Character, Long> map5);


    @Override
     HashCharLongMap newUpdatableMap(
            net.openhft.function.Consumer<CharLongConsumer> entriesSupplier);

    @Override
     HashCharLongMap newUpdatableMap(
            net.openhft.function.Consumer<CharLongConsumer> entriesSupplier,
            int expectedSize);

    @Override
     HashCharLongMap newUpdatableMap(char[] keys, long[] values);

    @Override
     HashCharLongMap newUpdatableMap(char[] keys, long[] values,
            int expectedSize);

    @Override
     HashCharLongMap newUpdatableMap(
            Character[] keys, Long[] values);

    @Override
     HashCharLongMap newUpdatableMap(
            Character[] keys, Long[] values, int expectedSize);

    @Override
     HashCharLongMap newUpdatableMap(Iterable<Character> keys,
            Iterable<Long> values);

    @Override
     HashCharLongMap newUpdatableMap(Iterable<Character> keys,
            Iterable<Long> values, int expectedSize);


    @Override
     HashCharLongMap newUpdatableMapOf(char k1, long v1);

    @Override
     HashCharLongMap newUpdatableMapOf(char k1, long v1,
            char k2, long v2);

    @Override
     HashCharLongMap newUpdatableMapOf(char k1, long v1,
            char k2, long v2, char k3, long v3);

    @Override
     HashCharLongMap newUpdatableMapOf(char k1, long v1,
            char k2, long v2, char k3, long v3,
            char k4, long v4);

    @Override
     HashCharLongMap newUpdatableMapOf(char k1, long v1,
            char k2, long v2, char k3, long v3,
            char k4, long v4, char k5, long v5);

    


    @Override
     HashCharLongMap newImmutableMap(Map<Character, Long> map1,
            Map<Character, Long> map2, int expectedSize);

    @Override
     HashCharLongMap newImmutableMap(Map<Character, Long> map1,
            Map<Character, Long> map2, Map<Character, Long> map3, int expectedSize);

    @Override
     HashCharLongMap newImmutableMap(Map<Character, Long> map1,
            Map<Character, Long> map2, Map<Character, Long> map3,
            Map<Character, Long> map4, int expectedSize);

    @Override
     HashCharLongMap newImmutableMap(Map<Character, Long> map1,
            Map<Character, Long> map2, Map<Character, Long> map3,
            Map<Character, Long> map4, Map<Character, Long> map5, int expectedSize);

    

    
    @Override
     HashCharLongMap newImmutableMap(Map<Character, Long> map);

    @Override
     HashCharLongMap newImmutableMap(Map<Character, Long> map1,
            Map<Character, Long> map2);

    @Override
     HashCharLongMap newImmutableMap(Map<Character, Long> map1,
            Map<Character, Long> map2, Map<Character, Long> map3);

    @Override
     HashCharLongMap newImmutableMap(Map<Character, Long> map1,
            Map<Character, Long> map2, Map<Character, Long> map3,
            Map<Character, Long> map4);

    @Override
     HashCharLongMap newImmutableMap(Map<Character, Long> map1,
            Map<Character, Long> map2, Map<Character, Long> map3,
            Map<Character, Long> map4, Map<Character, Long> map5);


    @Override
     HashCharLongMap newImmutableMap(
            net.openhft.function.Consumer<CharLongConsumer> entriesSupplier);

    @Override
     HashCharLongMap newImmutableMap(
            net.openhft.function.Consumer<CharLongConsumer> entriesSupplier,
            int expectedSize);

    @Override
     HashCharLongMap newImmutableMap(char[] keys, long[] values);

    @Override
     HashCharLongMap newImmutableMap(char[] keys, long[] values,
            int expectedSize);

    @Override
     HashCharLongMap newImmutableMap(
            Character[] keys, Long[] values);

    @Override
     HashCharLongMap newImmutableMap(
            Character[] keys, Long[] values, int expectedSize);

    @Override
     HashCharLongMap newImmutableMap(Iterable<Character> keys,
            Iterable<Long> values);

    @Override
     HashCharLongMap newImmutableMap(Iterable<Character> keys,
            Iterable<Long> values, int expectedSize);


    @Override
     HashCharLongMap newImmutableMapOf(char k1, long v1);

    @Override
     HashCharLongMap newImmutableMapOf(char k1, long v1,
            char k2, long v2);

    @Override
     HashCharLongMap newImmutableMapOf(char k1, long v1,
            char k2, long v2, char k3, long v3);

    @Override
     HashCharLongMap newImmutableMapOf(char k1, long v1,
            char k2, long v2, char k3, long v3,
            char k4, long v4);

    @Override
     HashCharLongMap newImmutableMapOf(char k1, long v1,
            char k2, long v2, char k3, long v3,
            char k4, long v4, char k5, long v5);
}

