/*
 * Copyright 2014 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.openhft.collect.map.hash;

import net.openhft.function.CharIntConsumer;

import java.util.Map;
import java.util.ServiceLoader;


/**
 * This class consists only of static factory methods to construct {@code HashCharIntMap}s, and
 * the default {@link HashCharIntMapFactory} static provider ({@link #getDefaultFactory()}).
 *
 * @see HashCharIntMap
 */
public final class HashCharIntMaps {

    

    private static final ServiceLoader<HashCharIntMapFactory> LOADER =
            ServiceLoader.load(HashCharIntMapFactory.class);
    private static HashCharIntMapFactory defaultFactory = null;

    public static HashCharIntMapFactory getDefaultFactory() {
        if (defaultFactory != null) {
            return defaultFactory;
        } else {
            // synchronization?
            return defaultFactory = LOADER.iterator().next();
        }
    }

    

    

    

    public static  HashCharIntMap newMutableMap() {
        return getDefaultFactory().newMutableMap();
    }

    public static  HashCharIntMap newMutableMap(int expectedSize) {
        return getDefaultFactory().newMutableMap(expectedSize);
    }



    
    


    public static  HashCharIntMap newMutableMap(Map<Character, Integer> map1,
            Map<Character, Integer> map2, int expectedSize) {
        return getDefaultFactory().newMutableMap(map1, map2, expectedSize);
    }

    public static  HashCharIntMap newMutableMap(Map<Character, Integer> map1,
            Map<Character, Integer> map2, Map<Character, Integer> map3, int expectedSize) {
        return getDefaultFactory().newMutableMap(map1, map2, map3, expectedSize);
    }

    public static  HashCharIntMap newMutableMap(Map<Character, Integer> map1,
            Map<Character, Integer> map2, Map<Character, Integer> map3,
            Map<Character, Integer> map4, int expectedSize) {
        return getDefaultFactory().newMutableMap(map1, map2, map3, map4, expectedSize);
    }

    public static  HashCharIntMap newMutableMap(Map<Character, Integer> map1,
            Map<Character, Integer> map2, Map<Character, Integer> map3,
            Map<Character, Integer> map4, Map<Character, Integer> map5, int expectedSize) {
        return getDefaultFactory().newMutableMap(map1, map2, map3, map4, map5, expectedSize);
    }

    
    

    
    public static  HashCharIntMap newMutableMap(
            Map<Character, Integer> map) {
        return getDefaultFactory().newMutableMap(map);
    }

    public static  HashCharIntMap newMutableMap(Map<Character, Integer> map1,
            Map<Character, Integer> map2) {
        return getDefaultFactory().newMutableMap(map1, map2);
    }

    public static  HashCharIntMap newMutableMap(Map<Character, Integer> map1,
            Map<Character, Integer> map2, Map<Character, Integer> map3) {
        return getDefaultFactory().newMutableMap(map1, map2, map3);
    }

    public static  HashCharIntMap newMutableMap(Map<Character, Integer> map1,
            Map<Character, Integer> map2, Map<Character, Integer> map3,
            Map<Character, Integer> map4) {
        return getDefaultFactory().newMutableMap(map1, map2, map3, map4);
    }

    public static  HashCharIntMap newMutableMap(Map<Character, Integer> map1,
            Map<Character, Integer> map2, Map<Character, Integer> map3,
            Map<Character, Integer> map4, Map<Character, Integer> map5) {
        return getDefaultFactory().newMutableMap(map1, map2, map3, map4, map5);
    }


    public static  HashCharIntMap newMutableMap(
            net.openhft.function.Consumer<CharIntConsumer> entriesSupplier) {
        return getDefaultFactory().newMutableMap(entriesSupplier);
    }

    public static  HashCharIntMap newMutableMap(
            net.openhft.function.Consumer<CharIntConsumer> entriesSupplier,
            int expectedSize) {
        return getDefaultFactory().newMutableMap(entriesSupplier, expectedSize);
    }

    public static  HashCharIntMap newMutableMap(
            char[] keys, int[] values) {
        return getDefaultFactory().newMutableMap(keys, values);
    }

    public static  HashCharIntMap newMutableMap(
            char[] keys, int[] values, int expectedSize) {
        return getDefaultFactory().newMutableMap(keys, values, expectedSize);
    }

    public static  HashCharIntMap newMutableMap(
            Character[] keys, Integer[] values) {
        return getDefaultFactory().newMutableMap(keys, values);
    }

    public static  HashCharIntMap newMutableMap(
            Character[] keys, Integer[] values, int expectedSize) {
        return getDefaultFactory().newMutableMap(keys, values, expectedSize);
    }

    public static  HashCharIntMap newMutableMap(Iterable<Character> keys,
            Iterable<Integer> values) {
        return getDefaultFactory().newMutableMap(keys, values);
    }

    public static  HashCharIntMap newMutableMap(Iterable<Character> keys,
            Iterable<Integer> values, int expectedSize) {
        return getDefaultFactory().newMutableMap(keys, values, expectedSize);
    }


    public static  HashCharIntMap newMutableMapOf(
            char k1, int v1) {
        return getDefaultFactory().newMutableMapOf(k1, v1);
    }

    public static  HashCharIntMap newMutableMapOf(
            char k1, int v1, char k2, int v2) {
        return getDefaultFactory().newMutableMapOf(k1, v1, k2, v2);
    }

    public static  HashCharIntMap newMutableMapOf(
            char k1, int v1, char k2, int v2,
            char k3, int v3) {
        return getDefaultFactory().newMutableMapOf(k1, v1, k2, v2, k3, v3);
    }

    public static  HashCharIntMap newMutableMapOf(
            char k1, int v1, char k2, int v2,
            char k3, int v3, char k4, int v4) {
        return getDefaultFactory().newMutableMapOf(k1, v1, k2, v2, k3, v3, k4, v4);
    }

    public static  HashCharIntMap newMutableMapOf(
            char k1, int v1, char k2, int v2,
            char k3, int v3, char k4, int v4,
            char k5, int v5) {
        return getDefaultFactory().newMutableMapOf(k1, v1, k2, v2, k3, v3, k4, v4, k5, v5);
    }

    
    


    public static  HashCharIntMap newUpdatableMap(Map<Character, Integer> map1,
            Map<Character, Integer> map2, int expectedSize) {
        return getDefaultFactory().newUpdatableMap(map1, map2, expectedSize);
    }

    public static  HashCharIntMap newUpdatableMap(Map<Character, Integer> map1,
            Map<Character, Integer> map2, Map<Character, Integer> map3, int expectedSize) {
        return getDefaultFactory().newUpdatableMap(map1, map2, map3, expectedSize);
    }

    public static  HashCharIntMap newUpdatableMap(Map<Character, Integer> map1,
            Map<Character, Integer> map2, Map<Character, Integer> map3,
            Map<Character, Integer> map4, int expectedSize) {
        return getDefaultFactory().newUpdatableMap(map1, map2, map3, map4, expectedSize);
    }

    public static  HashCharIntMap newUpdatableMap(Map<Character, Integer> map1,
            Map<Character, Integer> map2, Map<Character, Integer> map3,
            Map<Character, Integer> map4, Map<Character, Integer> map5, int expectedSize) {
        return getDefaultFactory().newUpdatableMap(map1, map2, map3, map4, map5, expectedSize);
    }

    
    

    
    public static  HashCharIntMap newUpdatableMap(
            Map<Character, Integer> map) {
        return getDefaultFactory().newUpdatableMap(map);
    }

    public static  HashCharIntMap newUpdatableMap(Map<Character, Integer> map1,
            Map<Character, Integer> map2) {
        return getDefaultFactory().newUpdatableMap(map1, map2);
    }

    public static  HashCharIntMap newUpdatableMap(Map<Character, Integer> map1,
            Map<Character, Integer> map2, Map<Character, Integer> map3) {
        return getDefaultFactory().newUpdatableMap(map1, map2, map3);
    }

    public static  HashCharIntMap newUpdatableMap(Map<Character, Integer> map1,
            Map<Character, Integer> map2, Map<Character, Integer> map3,
            Map<Character, Integer> map4) {
        return getDefaultFactory().newUpdatableMap(map1, map2, map3, map4);
    }

    public static  HashCharIntMap newUpdatableMap(Map<Character, Integer> map1,
            Map<Character, Integer> map2, Map<Character, Integer> map3,
            Map<Character, Integer> map4, Map<Character, Integer> map5) {
        return getDefaultFactory().newUpdatableMap(map1, map2, map3, map4, map5);
    }


    public static  HashCharIntMap newUpdatableMap(
            net.openhft.function.Consumer<CharIntConsumer> entriesSupplier) {
        return getDefaultFactory().newUpdatableMap(entriesSupplier);
    }

    public static  HashCharIntMap newUpdatableMap(
            net.openhft.function.Consumer<CharIntConsumer> entriesSupplier,
            int expectedSize) {
        return getDefaultFactory().newUpdatableMap(entriesSupplier, expectedSize);
    }

    public static  HashCharIntMap newUpdatableMap(
            char[] keys, int[] values) {
        return getDefaultFactory().newUpdatableMap(keys, values);
    }

    public static  HashCharIntMap newUpdatableMap(
            char[] keys, int[] values, int expectedSize) {
        return getDefaultFactory().newUpdatableMap(keys, values, expectedSize);
    }

    public static  HashCharIntMap newUpdatableMap(
            Character[] keys, Integer[] values) {
        return getDefaultFactory().newUpdatableMap(keys, values);
    }

    public static  HashCharIntMap newUpdatableMap(
            Character[] keys, Integer[] values, int expectedSize) {
        return getDefaultFactory().newUpdatableMap(keys, values, expectedSize);
    }

    public static  HashCharIntMap newUpdatableMap(Iterable<Character> keys,
            Iterable<Integer> values) {
        return getDefaultFactory().newUpdatableMap(keys, values);
    }

    public static  HashCharIntMap newUpdatableMap(Iterable<Character> keys,
            Iterable<Integer> values, int expectedSize) {
        return getDefaultFactory().newUpdatableMap(keys, values, expectedSize);
    }


    public static  HashCharIntMap newUpdatableMapOf(
            char k1, int v1) {
        return getDefaultFactory().newUpdatableMapOf(k1, v1);
    }

    public static  HashCharIntMap newUpdatableMapOf(
            char k1, int v1, char k2, int v2) {
        return getDefaultFactory().newUpdatableMapOf(k1, v1, k2, v2);
    }

    public static  HashCharIntMap newUpdatableMapOf(
            char k1, int v1, char k2, int v2,
            char k3, int v3) {
        return getDefaultFactory().newUpdatableMapOf(k1, v1, k2, v2, k3, v3);
    }

    public static  HashCharIntMap newUpdatableMapOf(
            char k1, int v1, char k2, int v2,
            char k3, int v3, char k4, int v4) {
        return getDefaultFactory().newUpdatableMapOf(k1, v1, k2, v2, k3, v3, k4, v4);
    }

    public static  HashCharIntMap newUpdatableMapOf(
            char k1, int v1, char k2, int v2,
            char k3, int v3, char k4, int v4,
            char k5, int v5) {
        return getDefaultFactory().newUpdatableMapOf(k1, v1, k2, v2, k3, v3, k4, v4, k5, v5);
    }

    
    


    public static  HashCharIntMap newImmutableMap(Map<Character, Integer> map1,
            Map<Character, Integer> map2, int expectedSize) {
        return getDefaultFactory().newImmutableMap(map1, map2, expectedSize);
    }

    public static  HashCharIntMap newImmutableMap(Map<Character, Integer> map1,
            Map<Character, Integer> map2, Map<Character, Integer> map3, int expectedSize) {
        return getDefaultFactory().newImmutableMap(map1, map2, map3, expectedSize);
    }

    public static  HashCharIntMap newImmutableMap(Map<Character, Integer> map1,
            Map<Character, Integer> map2, Map<Character, Integer> map3,
            Map<Character, Integer> map4, int expectedSize) {
        return getDefaultFactory().newImmutableMap(map1, map2, map3, map4, expectedSize);
    }

    public static  HashCharIntMap newImmutableMap(Map<Character, Integer> map1,
            Map<Character, Integer> map2, Map<Character, Integer> map3,
            Map<Character, Integer> map4, Map<Character, Integer> map5, int expectedSize) {
        return getDefaultFactory().newImmutableMap(map1, map2, map3, map4, map5, expectedSize);
    }

    
    

    
    public static  HashCharIntMap newImmutableMap(
            Map<Character, Integer> map) {
        return getDefaultFactory().newImmutableMap(map);
    }

    public static  HashCharIntMap newImmutableMap(Map<Character, Integer> map1,
            Map<Character, Integer> map2) {
        return getDefaultFactory().newImmutableMap(map1, map2);
    }

    public static  HashCharIntMap newImmutableMap(Map<Character, Integer> map1,
            Map<Character, Integer> map2, Map<Character, Integer> map3) {
        return getDefaultFactory().newImmutableMap(map1, map2, map3);
    }

    public static  HashCharIntMap newImmutableMap(Map<Character, Integer> map1,
            Map<Character, Integer> map2, Map<Character, Integer> map3,
            Map<Character, Integer> map4) {
        return getDefaultFactory().newImmutableMap(map1, map2, map3, map4);
    }

    public static  HashCharIntMap newImmutableMap(Map<Character, Integer> map1,
            Map<Character, Integer> map2, Map<Character, Integer> map3,
            Map<Character, Integer> map4, Map<Character, Integer> map5) {
        return getDefaultFactory().newImmutableMap(map1, map2, map3, map4, map5);
    }


    public static  HashCharIntMap newImmutableMap(
            net.openhft.function.Consumer<CharIntConsumer> entriesSupplier) {
        return getDefaultFactory().newImmutableMap(entriesSupplier);
    }

    public static  HashCharIntMap newImmutableMap(
            net.openhft.function.Consumer<CharIntConsumer> entriesSupplier,
            int expectedSize) {
        return getDefaultFactory().newImmutableMap(entriesSupplier, expectedSize);
    }

    public static  HashCharIntMap newImmutableMap(
            char[] keys, int[] values) {
        return getDefaultFactory().newImmutableMap(keys, values);
    }

    public static  HashCharIntMap newImmutableMap(
            char[] keys, int[] values, int expectedSize) {
        return getDefaultFactory().newImmutableMap(keys, values, expectedSize);
    }

    public static  HashCharIntMap newImmutableMap(
            Character[] keys, Integer[] values) {
        return getDefaultFactory().newImmutableMap(keys, values);
    }

    public static  HashCharIntMap newImmutableMap(
            Character[] keys, Integer[] values, int expectedSize) {
        return getDefaultFactory().newImmutableMap(keys, values, expectedSize);
    }

    public static  HashCharIntMap newImmutableMap(Iterable<Character> keys,
            Iterable<Integer> values) {
        return getDefaultFactory().newImmutableMap(keys, values);
    }

    public static  HashCharIntMap newImmutableMap(Iterable<Character> keys,
            Iterable<Integer> values, int expectedSize) {
        return getDefaultFactory().newImmutableMap(keys, values, expectedSize);
    }


    public static  HashCharIntMap newImmutableMapOf(
            char k1, int v1) {
        return getDefaultFactory().newImmutableMapOf(k1, v1);
    }

    public static  HashCharIntMap newImmutableMapOf(
            char k1, int v1, char k2, int v2) {
        return getDefaultFactory().newImmutableMapOf(k1, v1, k2, v2);
    }

    public static  HashCharIntMap newImmutableMapOf(
            char k1, int v1, char k2, int v2,
            char k3, int v3) {
        return getDefaultFactory().newImmutableMapOf(k1, v1, k2, v2, k3, v3);
    }

    public static  HashCharIntMap newImmutableMapOf(
            char k1, int v1, char k2, int v2,
            char k3, int v3, char k4, int v4) {
        return getDefaultFactory().newImmutableMapOf(k1, v1, k2, v2, k3, v3, k4, v4);
    }

    public static  HashCharIntMap newImmutableMapOf(
            char k1, int v1, char k2, int v2,
            char k3, int v3, char k4, int v4,
            char k5, int v5) {
        return getDefaultFactory().newImmutableMapOf(k1, v1, k2, v2, k3, v3, k4, v4, k5, v5);
    }

    private HashCharIntMaps() {}
}

