/*
 * Copyright 2014 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.openhft.collect.map.hash;

import net.openhft.collect.*;
import net.openhft.collect.hash.*;
import net.openhft.function.CharIntConsumer;
import net.openhft.collect.map.*;
import javax.annotation.Nullable;

import java.util.Map;


/**
 * An immutable factory of {@code HashCharIntMaps}
 *
 * @see HashCharIntMap
 * @see HashCharIntMaps#getDefaultFactory()
 */
public interface HashCharIntMapFactory extends CharIntMapFactory
        , CharHashFactory<HashCharIntMapFactory>
         {

    

    

    

    

    

    
    

    
    


    @Override
    HashCharIntMapFactory withDefaultValue(int defaultValue);

    @Override
     HashCharIntMap newMutableMap();

    @Override
     HashCharIntMap newMutableMap(int expectedSize);

    


    @Override
     HashCharIntMap newMutableMap(Map<Character, Integer> map1,
            Map<Character, Integer> map2, int expectedSize);

    @Override
     HashCharIntMap newMutableMap(Map<Character, Integer> map1,
            Map<Character, Integer> map2, Map<Character, Integer> map3, int expectedSize);

    @Override
     HashCharIntMap newMutableMap(Map<Character, Integer> map1,
            Map<Character, Integer> map2, Map<Character, Integer> map3,
            Map<Character, Integer> map4, int expectedSize);

    @Override
     HashCharIntMap newMutableMap(Map<Character, Integer> map1,
            Map<Character, Integer> map2, Map<Character, Integer> map3,
            Map<Character, Integer> map4, Map<Character, Integer> map5, int expectedSize);

    

    
    @Override
     HashCharIntMap newMutableMap(Map<Character, Integer> map);

    @Override
     HashCharIntMap newMutableMap(Map<Character, Integer> map1,
            Map<Character, Integer> map2);

    @Override
     HashCharIntMap newMutableMap(Map<Character, Integer> map1,
            Map<Character, Integer> map2, Map<Character, Integer> map3);

    @Override
     HashCharIntMap newMutableMap(Map<Character, Integer> map1,
            Map<Character, Integer> map2, Map<Character, Integer> map3,
            Map<Character, Integer> map4);

    @Override
     HashCharIntMap newMutableMap(Map<Character, Integer> map1,
            Map<Character, Integer> map2, Map<Character, Integer> map3,
            Map<Character, Integer> map4, Map<Character, Integer> map5);


    @Override
     HashCharIntMap newMutableMap(
            net.openhft.function.Consumer<CharIntConsumer> entriesSupplier);

    @Override
     HashCharIntMap newMutableMap(
            net.openhft.function.Consumer<CharIntConsumer> entriesSupplier,
            int expectedSize);

    @Override
     HashCharIntMap newMutableMap(char[] keys, int[] values);

    @Override
     HashCharIntMap newMutableMap(char[] keys, int[] values,
            int expectedSize);

    @Override
     HashCharIntMap newMutableMap(
            Character[] keys, Integer[] values);

    @Override
     HashCharIntMap newMutableMap(
            Character[] keys, Integer[] values, int expectedSize);

    @Override
     HashCharIntMap newMutableMap(Iterable<Character> keys,
            Iterable<Integer> values);

    @Override
     HashCharIntMap newMutableMap(Iterable<Character> keys,
            Iterable<Integer> values, int expectedSize);


    @Override
     HashCharIntMap newMutableMapOf(char k1, int v1);

    @Override
     HashCharIntMap newMutableMapOf(char k1, int v1,
            char k2, int v2);

    @Override
     HashCharIntMap newMutableMapOf(char k1, int v1,
            char k2, int v2, char k3, int v3);

    @Override
     HashCharIntMap newMutableMapOf(char k1, int v1,
            char k2, int v2, char k3, int v3,
            char k4, int v4);

    @Override
     HashCharIntMap newMutableMapOf(char k1, int v1,
            char k2, int v2, char k3, int v3,
            char k4, int v4, char k5, int v5);
    @Override
     HashCharIntMap newUpdatableMap();

    @Override
     HashCharIntMap newUpdatableMap(int expectedSize);

    


    @Override
     HashCharIntMap newUpdatableMap(Map<Character, Integer> map1,
            Map<Character, Integer> map2, int expectedSize);

    @Override
     HashCharIntMap newUpdatableMap(Map<Character, Integer> map1,
            Map<Character, Integer> map2, Map<Character, Integer> map3, int expectedSize);

    @Override
     HashCharIntMap newUpdatableMap(Map<Character, Integer> map1,
            Map<Character, Integer> map2, Map<Character, Integer> map3,
            Map<Character, Integer> map4, int expectedSize);

    @Override
     HashCharIntMap newUpdatableMap(Map<Character, Integer> map1,
            Map<Character, Integer> map2, Map<Character, Integer> map3,
            Map<Character, Integer> map4, Map<Character, Integer> map5, int expectedSize);

    

    
    @Override
     HashCharIntMap newUpdatableMap(Map<Character, Integer> map);

    @Override
     HashCharIntMap newUpdatableMap(Map<Character, Integer> map1,
            Map<Character, Integer> map2);

    @Override
     HashCharIntMap newUpdatableMap(Map<Character, Integer> map1,
            Map<Character, Integer> map2, Map<Character, Integer> map3);

    @Override
     HashCharIntMap newUpdatableMap(Map<Character, Integer> map1,
            Map<Character, Integer> map2, Map<Character, Integer> map3,
            Map<Character, Integer> map4);

    @Override
     HashCharIntMap newUpdatableMap(Map<Character, Integer> map1,
            Map<Character, Integer> map2, Map<Character, Integer> map3,
            Map<Character, Integer> map4, Map<Character, Integer> map5);


    @Override
     HashCharIntMap newUpdatableMap(
            net.openhft.function.Consumer<CharIntConsumer> entriesSupplier);

    @Override
     HashCharIntMap newUpdatableMap(
            net.openhft.function.Consumer<CharIntConsumer> entriesSupplier,
            int expectedSize);

    @Override
     HashCharIntMap newUpdatableMap(char[] keys, int[] values);

    @Override
     HashCharIntMap newUpdatableMap(char[] keys, int[] values,
            int expectedSize);

    @Override
     HashCharIntMap newUpdatableMap(
            Character[] keys, Integer[] values);

    @Override
     HashCharIntMap newUpdatableMap(
            Character[] keys, Integer[] values, int expectedSize);

    @Override
     HashCharIntMap newUpdatableMap(Iterable<Character> keys,
            Iterable<Integer> values);

    @Override
     HashCharIntMap newUpdatableMap(Iterable<Character> keys,
            Iterable<Integer> values, int expectedSize);


    @Override
     HashCharIntMap newUpdatableMapOf(char k1, int v1);

    @Override
     HashCharIntMap newUpdatableMapOf(char k1, int v1,
            char k2, int v2);

    @Override
     HashCharIntMap newUpdatableMapOf(char k1, int v1,
            char k2, int v2, char k3, int v3);

    @Override
     HashCharIntMap newUpdatableMapOf(char k1, int v1,
            char k2, int v2, char k3, int v3,
            char k4, int v4);

    @Override
     HashCharIntMap newUpdatableMapOf(char k1, int v1,
            char k2, int v2, char k3, int v3,
            char k4, int v4, char k5, int v5);

    


    @Override
     HashCharIntMap newImmutableMap(Map<Character, Integer> map1,
            Map<Character, Integer> map2, int expectedSize);

    @Override
     HashCharIntMap newImmutableMap(Map<Character, Integer> map1,
            Map<Character, Integer> map2, Map<Character, Integer> map3, int expectedSize);

    @Override
     HashCharIntMap newImmutableMap(Map<Character, Integer> map1,
            Map<Character, Integer> map2, Map<Character, Integer> map3,
            Map<Character, Integer> map4, int expectedSize);

    @Override
     HashCharIntMap newImmutableMap(Map<Character, Integer> map1,
            Map<Character, Integer> map2, Map<Character, Integer> map3,
            Map<Character, Integer> map4, Map<Character, Integer> map5, int expectedSize);

    

    
    @Override
     HashCharIntMap newImmutableMap(Map<Character, Integer> map);

    @Override
     HashCharIntMap newImmutableMap(Map<Character, Integer> map1,
            Map<Character, Integer> map2);

    @Override
     HashCharIntMap newImmutableMap(Map<Character, Integer> map1,
            Map<Character, Integer> map2, Map<Character, Integer> map3);

    @Override
     HashCharIntMap newImmutableMap(Map<Character, Integer> map1,
            Map<Character, Integer> map2, Map<Character, Integer> map3,
            Map<Character, Integer> map4);

    @Override
     HashCharIntMap newImmutableMap(Map<Character, Integer> map1,
            Map<Character, Integer> map2, Map<Character, Integer> map3,
            Map<Character, Integer> map4, Map<Character, Integer> map5);


    @Override
     HashCharIntMap newImmutableMap(
            net.openhft.function.Consumer<CharIntConsumer> entriesSupplier);

    @Override
     HashCharIntMap newImmutableMap(
            net.openhft.function.Consumer<CharIntConsumer> entriesSupplier,
            int expectedSize);

    @Override
     HashCharIntMap newImmutableMap(char[] keys, int[] values);

    @Override
     HashCharIntMap newImmutableMap(char[] keys, int[] values,
            int expectedSize);

    @Override
     HashCharIntMap newImmutableMap(
            Character[] keys, Integer[] values);

    @Override
     HashCharIntMap newImmutableMap(
            Character[] keys, Integer[] values, int expectedSize);

    @Override
     HashCharIntMap newImmutableMap(Iterable<Character> keys,
            Iterable<Integer> values);

    @Override
     HashCharIntMap newImmutableMap(Iterable<Character> keys,
            Iterable<Integer> values, int expectedSize);


    @Override
     HashCharIntMap newImmutableMapOf(char k1, int v1);

    @Override
     HashCharIntMap newImmutableMapOf(char k1, int v1,
            char k2, int v2);

    @Override
     HashCharIntMap newImmutableMapOf(char k1, int v1,
            char k2, int v2, char k3, int v3);

    @Override
     HashCharIntMap newImmutableMapOf(char k1, int v1,
            char k2, int v2, char k3, int v3,
            char k4, int v4);

    @Override
     HashCharIntMap newImmutableMapOf(char k1, int v1,
            char k2, int v2, char k3, int v3,
            char k4, int v4, char k5, int v5);
}

