/*
 * Copyright 2014 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.openhft.collect.map.hash;

import net.openhft.collect.*;
import net.openhft.collect.hash.*;
import net.openhft.function.CharFloatConsumer;
import net.openhft.collect.map.*;
import javax.annotation.Nullable;

import java.util.Map;


/**
 * An immutable factory of {@code HashCharFloatMaps}
 *
 * @see HashCharFloatMap
 * @see HashCharFloatMaps#getDefaultFactory()
 */
public interface HashCharFloatMapFactory extends CharFloatMapFactory
        , CharHashFactory<HashCharFloatMapFactory>
         {

    

    

    

    

    

    
    

    
    


    @Override
    HashCharFloatMapFactory withDefaultValue(float defaultValue);

    @Override
     HashCharFloatMap newMutableMap();

    @Override
     HashCharFloatMap newMutableMap(int expectedSize);

    


    @Override
     HashCharFloatMap newMutableMap(Map<Character, Float> map1,
            Map<Character, Float> map2, int expectedSize);

    @Override
     HashCharFloatMap newMutableMap(Map<Character, Float> map1,
            Map<Character, Float> map2, Map<Character, Float> map3, int expectedSize);

    @Override
     HashCharFloatMap newMutableMap(Map<Character, Float> map1,
            Map<Character, Float> map2, Map<Character, Float> map3,
            Map<Character, Float> map4, int expectedSize);

    @Override
     HashCharFloatMap newMutableMap(Map<Character, Float> map1,
            Map<Character, Float> map2, Map<Character, Float> map3,
            Map<Character, Float> map4, Map<Character, Float> map5, int expectedSize);

    

    
    @Override
     HashCharFloatMap newMutableMap(Map<Character, Float> map);

    @Override
     HashCharFloatMap newMutableMap(Map<Character, Float> map1,
            Map<Character, Float> map2);

    @Override
     HashCharFloatMap newMutableMap(Map<Character, Float> map1,
            Map<Character, Float> map2, Map<Character, Float> map3);

    @Override
     HashCharFloatMap newMutableMap(Map<Character, Float> map1,
            Map<Character, Float> map2, Map<Character, Float> map3,
            Map<Character, Float> map4);

    @Override
     HashCharFloatMap newMutableMap(Map<Character, Float> map1,
            Map<Character, Float> map2, Map<Character, Float> map3,
            Map<Character, Float> map4, Map<Character, Float> map5);


    @Override
     HashCharFloatMap newMutableMap(
            net.openhft.function.Consumer<CharFloatConsumer> entriesSupplier);

    @Override
     HashCharFloatMap newMutableMap(
            net.openhft.function.Consumer<CharFloatConsumer> entriesSupplier,
            int expectedSize);

    @Override
     HashCharFloatMap newMutableMap(char[] keys, float[] values);

    @Override
     HashCharFloatMap newMutableMap(char[] keys, float[] values,
            int expectedSize);

    @Override
     HashCharFloatMap newMutableMap(
            Character[] keys, Float[] values);

    @Override
     HashCharFloatMap newMutableMap(
            Character[] keys, Float[] values, int expectedSize);

    @Override
     HashCharFloatMap newMutableMap(Iterable<Character> keys,
            Iterable<Float> values);

    @Override
     HashCharFloatMap newMutableMap(Iterable<Character> keys,
            Iterable<Float> values, int expectedSize);


    @Override
     HashCharFloatMap newMutableMapOf(char k1, float v1);

    @Override
     HashCharFloatMap newMutableMapOf(char k1, float v1,
            char k2, float v2);

    @Override
     HashCharFloatMap newMutableMapOf(char k1, float v1,
            char k2, float v2, char k3, float v3);

    @Override
     HashCharFloatMap newMutableMapOf(char k1, float v1,
            char k2, float v2, char k3, float v3,
            char k4, float v4);

    @Override
     HashCharFloatMap newMutableMapOf(char k1, float v1,
            char k2, float v2, char k3, float v3,
            char k4, float v4, char k5, float v5);
    @Override
     HashCharFloatMap newUpdatableMap();

    @Override
     HashCharFloatMap newUpdatableMap(int expectedSize);

    


    @Override
     HashCharFloatMap newUpdatableMap(Map<Character, Float> map1,
            Map<Character, Float> map2, int expectedSize);

    @Override
     HashCharFloatMap newUpdatableMap(Map<Character, Float> map1,
            Map<Character, Float> map2, Map<Character, Float> map3, int expectedSize);

    @Override
     HashCharFloatMap newUpdatableMap(Map<Character, Float> map1,
            Map<Character, Float> map2, Map<Character, Float> map3,
            Map<Character, Float> map4, int expectedSize);

    @Override
     HashCharFloatMap newUpdatableMap(Map<Character, Float> map1,
            Map<Character, Float> map2, Map<Character, Float> map3,
            Map<Character, Float> map4, Map<Character, Float> map5, int expectedSize);

    

    
    @Override
     HashCharFloatMap newUpdatableMap(Map<Character, Float> map);

    @Override
     HashCharFloatMap newUpdatableMap(Map<Character, Float> map1,
            Map<Character, Float> map2);

    @Override
     HashCharFloatMap newUpdatableMap(Map<Character, Float> map1,
            Map<Character, Float> map2, Map<Character, Float> map3);

    @Override
     HashCharFloatMap newUpdatableMap(Map<Character, Float> map1,
            Map<Character, Float> map2, Map<Character, Float> map3,
            Map<Character, Float> map4);

    @Override
     HashCharFloatMap newUpdatableMap(Map<Character, Float> map1,
            Map<Character, Float> map2, Map<Character, Float> map3,
            Map<Character, Float> map4, Map<Character, Float> map5);


    @Override
     HashCharFloatMap newUpdatableMap(
            net.openhft.function.Consumer<CharFloatConsumer> entriesSupplier);

    @Override
     HashCharFloatMap newUpdatableMap(
            net.openhft.function.Consumer<CharFloatConsumer> entriesSupplier,
            int expectedSize);

    @Override
     HashCharFloatMap newUpdatableMap(char[] keys, float[] values);

    @Override
     HashCharFloatMap newUpdatableMap(char[] keys, float[] values,
            int expectedSize);

    @Override
     HashCharFloatMap newUpdatableMap(
            Character[] keys, Float[] values);

    @Override
     HashCharFloatMap newUpdatableMap(
            Character[] keys, Float[] values, int expectedSize);

    @Override
     HashCharFloatMap newUpdatableMap(Iterable<Character> keys,
            Iterable<Float> values);

    @Override
     HashCharFloatMap newUpdatableMap(Iterable<Character> keys,
            Iterable<Float> values, int expectedSize);


    @Override
     HashCharFloatMap newUpdatableMapOf(char k1, float v1);

    @Override
     HashCharFloatMap newUpdatableMapOf(char k1, float v1,
            char k2, float v2);

    @Override
     HashCharFloatMap newUpdatableMapOf(char k1, float v1,
            char k2, float v2, char k3, float v3);

    @Override
     HashCharFloatMap newUpdatableMapOf(char k1, float v1,
            char k2, float v2, char k3, float v3,
            char k4, float v4);

    @Override
     HashCharFloatMap newUpdatableMapOf(char k1, float v1,
            char k2, float v2, char k3, float v3,
            char k4, float v4, char k5, float v5);

    


    @Override
     HashCharFloatMap newImmutableMap(Map<Character, Float> map1,
            Map<Character, Float> map2, int expectedSize);

    @Override
     HashCharFloatMap newImmutableMap(Map<Character, Float> map1,
            Map<Character, Float> map2, Map<Character, Float> map3, int expectedSize);

    @Override
     HashCharFloatMap newImmutableMap(Map<Character, Float> map1,
            Map<Character, Float> map2, Map<Character, Float> map3,
            Map<Character, Float> map4, int expectedSize);

    @Override
     HashCharFloatMap newImmutableMap(Map<Character, Float> map1,
            Map<Character, Float> map2, Map<Character, Float> map3,
            Map<Character, Float> map4, Map<Character, Float> map5, int expectedSize);

    

    
    @Override
     HashCharFloatMap newImmutableMap(Map<Character, Float> map);

    @Override
     HashCharFloatMap newImmutableMap(Map<Character, Float> map1,
            Map<Character, Float> map2);

    @Override
     HashCharFloatMap newImmutableMap(Map<Character, Float> map1,
            Map<Character, Float> map2, Map<Character, Float> map3);

    @Override
     HashCharFloatMap newImmutableMap(Map<Character, Float> map1,
            Map<Character, Float> map2, Map<Character, Float> map3,
            Map<Character, Float> map4);

    @Override
     HashCharFloatMap newImmutableMap(Map<Character, Float> map1,
            Map<Character, Float> map2, Map<Character, Float> map3,
            Map<Character, Float> map4, Map<Character, Float> map5);


    @Override
     HashCharFloatMap newImmutableMap(
            net.openhft.function.Consumer<CharFloatConsumer> entriesSupplier);

    @Override
     HashCharFloatMap newImmutableMap(
            net.openhft.function.Consumer<CharFloatConsumer> entriesSupplier,
            int expectedSize);

    @Override
     HashCharFloatMap newImmutableMap(char[] keys, float[] values);

    @Override
     HashCharFloatMap newImmutableMap(char[] keys, float[] values,
            int expectedSize);

    @Override
     HashCharFloatMap newImmutableMap(
            Character[] keys, Float[] values);

    @Override
     HashCharFloatMap newImmutableMap(
            Character[] keys, Float[] values, int expectedSize);

    @Override
     HashCharFloatMap newImmutableMap(Iterable<Character> keys,
            Iterable<Float> values);

    @Override
     HashCharFloatMap newImmutableMap(Iterable<Character> keys,
            Iterable<Float> values, int expectedSize);


    @Override
     HashCharFloatMap newImmutableMapOf(char k1, float v1);

    @Override
     HashCharFloatMap newImmutableMapOf(char k1, float v1,
            char k2, float v2);

    @Override
     HashCharFloatMap newImmutableMapOf(char k1, float v1,
            char k2, float v2, char k3, float v3);

    @Override
     HashCharFloatMap newImmutableMapOf(char k1, float v1,
            char k2, float v2, char k3, float v3,
            char k4, float v4);

    @Override
     HashCharFloatMap newImmutableMapOf(char k1, float v1,
            char k2, float v2, char k3, float v3,
            char k4, float v4, char k5, float v5);
}

