/*
 * Copyright 2014 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.openhft.collect.map.hash;

import net.openhft.function.CharDoubleConsumer;

import java.util.Map;
import java.util.ServiceLoader;


/**
 * This class consists only of static factory methods to construct {@code HashCharDoubleMap}s, and
 * the default {@link HashCharDoubleMapFactory} static provider ({@link #getDefaultFactory()}).
 *
 * @see HashCharDoubleMap
 */
public final class HashCharDoubleMaps {

    

    private static final ServiceLoader<HashCharDoubleMapFactory> LOADER =
            ServiceLoader.load(HashCharDoubleMapFactory.class);
    private static HashCharDoubleMapFactory defaultFactory = null;

    public static HashCharDoubleMapFactory getDefaultFactory() {
        if (defaultFactory != null) {
            return defaultFactory;
        } else {
            // synchronization?
            return defaultFactory = LOADER.iterator().next();
        }
    }

    

    

    

    public static  HashCharDoubleMap newMutableMap() {
        return getDefaultFactory().newMutableMap();
    }

    public static  HashCharDoubleMap newMutableMap(int expectedSize) {
        return getDefaultFactory().newMutableMap(expectedSize);
    }



    
    


    public static  HashCharDoubleMap newMutableMap(Map<Character, Double> map1,
            Map<Character, Double> map2, int expectedSize) {
        return getDefaultFactory().newMutableMap(map1, map2, expectedSize);
    }

    public static  HashCharDoubleMap newMutableMap(Map<Character, Double> map1,
            Map<Character, Double> map2, Map<Character, Double> map3, int expectedSize) {
        return getDefaultFactory().newMutableMap(map1, map2, map3, expectedSize);
    }

    public static  HashCharDoubleMap newMutableMap(Map<Character, Double> map1,
            Map<Character, Double> map2, Map<Character, Double> map3,
            Map<Character, Double> map4, int expectedSize) {
        return getDefaultFactory().newMutableMap(map1, map2, map3, map4, expectedSize);
    }

    public static  HashCharDoubleMap newMutableMap(Map<Character, Double> map1,
            Map<Character, Double> map2, Map<Character, Double> map3,
            Map<Character, Double> map4, Map<Character, Double> map5, int expectedSize) {
        return getDefaultFactory().newMutableMap(map1, map2, map3, map4, map5, expectedSize);
    }

    
    

    
    public static  HashCharDoubleMap newMutableMap(
            Map<Character, Double> map) {
        return getDefaultFactory().newMutableMap(map);
    }

    public static  HashCharDoubleMap newMutableMap(Map<Character, Double> map1,
            Map<Character, Double> map2) {
        return getDefaultFactory().newMutableMap(map1, map2);
    }

    public static  HashCharDoubleMap newMutableMap(Map<Character, Double> map1,
            Map<Character, Double> map2, Map<Character, Double> map3) {
        return getDefaultFactory().newMutableMap(map1, map2, map3);
    }

    public static  HashCharDoubleMap newMutableMap(Map<Character, Double> map1,
            Map<Character, Double> map2, Map<Character, Double> map3,
            Map<Character, Double> map4) {
        return getDefaultFactory().newMutableMap(map1, map2, map3, map4);
    }

    public static  HashCharDoubleMap newMutableMap(Map<Character, Double> map1,
            Map<Character, Double> map2, Map<Character, Double> map3,
            Map<Character, Double> map4, Map<Character, Double> map5) {
        return getDefaultFactory().newMutableMap(map1, map2, map3, map4, map5);
    }


    public static  HashCharDoubleMap newMutableMap(
            net.openhft.function.Consumer<CharDoubleConsumer> entriesSupplier) {
        return getDefaultFactory().newMutableMap(entriesSupplier);
    }

    public static  HashCharDoubleMap newMutableMap(
            net.openhft.function.Consumer<CharDoubleConsumer> entriesSupplier,
            int expectedSize) {
        return getDefaultFactory().newMutableMap(entriesSupplier, expectedSize);
    }

    public static  HashCharDoubleMap newMutableMap(
            char[] keys, double[] values) {
        return getDefaultFactory().newMutableMap(keys, values);
    }

    public static  HashCharDoubleMap newMutableMap(
            char[] keys, double[] values, int expectedSize) {
        return getDefaultFactory().newMutableMap(keys, values, expectedSize);
    }

    public static  HashCharDoubleMap newMutableMap(
            Character[] keys, Double[] values) {
        return getDefaultFactory().newMutableMap(keys, values);
    }

    public static  HashCharDoubleMap newMutableMap(
            Character[] keys, Double[] values, int expectedSize) {
        return getDefaultFactory().newMutableMap(keys, values, expectedSize);
    }

    public static  HashCharDoubleMap newMutableMap(Iterable<Character> keys,
            Iterable<Double> values) {
        return getDefaultFactory().newMutableMap(keys, values);
    }

    public static  HashCharDoubleMap newMutableMap(Iterable<Character> keys,
            Iterable<Double> values, int expectedSize) {
        return getDefaultFactory().newMutableMap(keys, values, expectedSize);
    }


    public static  HashCharDoubleMap newMutableMapOf(
            char k1, double v1) {
        return getDefaultFactory().newMutableMapOf(k1, v1);
    }

    public static  HashCharDoubleMap newMutableMapOf(
            char k1, double v1, char k2, double v2) {
        return getDefaultFactory().newMutableMapOf(k1, v1, k2, v2);
    }

    public static  HashCharDoubleMap newMutableMapOf(
            char k1, double v1, char k2, double v2,
            char k3, double v3) {
        return getDefaultFactory().newMutableMapOf(k1, v1, k2, v2, k3, v3);
    }

    public static  HashCharDoubleMap newMutableMapOf(
            char k1, double v1, char k2, double v2,
            char k3, double v3, char k4, double v4) {
        return getDefaultFactory().newMutableMapOf(k1, v1, k2, v2, k3, v3, k4, v4);
    }

    public static  HashCharDoubleMap newMutableMapOf(
            char k1, double v1, char k2, double v2,
            char k3, double v3, char k4, double v4,
            char k5, double v5) {
        return getDefaultFactory().newMutableMapOf(k1, v1, k2, v2, k3, v3, k4, v4, k5, v5);
    }

    
    


    public static  HashCharDoubleMap newUpdatableMap(Map<Character, Double> map1,
            Map<Character, Double> map2, int expectedSize) {
        return getDefaultFactory().newUpdatableMap(map1, map2, expectedSize);
    }

    public static  HashCharDoubleMap newUpdatableMap(Map<Character, Double> map1,
            Map<Character, Double> map2, Map<Character, Double> map3, int expectedSize) {
        return getDefaultFactory().newUpdatableMap(map1, map2, map3, expectedSize);
    }

    public static  HashCharDoubleMap newUpdatableMap(Map<Character, Double> map1,
            Map<Character, Double> map2, Map<Character, Double> map3,
            Map<Character, Double> map4, int expectedSize) {
        return getDefaultFactory().newUpdatableMap(map1, map2, map3, map4, expectedSize);
    }

    public static  HashCharDoubleMap newUpdatableMap(Map<Character, Double> map1,
            Map<Character, Double> map2, Map<Character, Double> map3,
            Map<Character, Double> map4, Map<Character, Double> map5, int expectedSize) {
        return getDefaultFactory().newUpdatableMap(map1, map2, map3, map4, map5, expectedSize);
    }

    
    

    
    public static  HashCharDoubleMap newUpdatableMap(
            Map<Character, Double> map) {
        return getDefaultFactory().newUpdatableMap(map);
    }

    public static  HashCharDoubleMap newUpdatableMap(Map<Character, Double> map1,
            Map<Character, Double> map2) {
        return getDefaultFactory().newUpdatableMap(map1, map2);
    }

    public static  HashCharDoubleMap newUpdatableMap(Map<Character, Double> map1,
            Map<Character, Double> map2, Map<Character, Double> map3) {
        return getDefaultFactory().newUpdatableMap(map1, map2, map3);
    }

    public static  HashCharDoubleMap newUpdatableMap(Map<Character, Double> map1,
            Map<Character, Double> map2, Map<Character, Double> map3,
            Map<Character, Double> map4) {
        return getDefaultFactory().newUpdatableMap(map1, map2, map3, map4);
    }

    public static  HashCharDoubleMap newUpdatableMap(Map<Character, Double> map1,
            Map<Character, Double> map2, Map<Character, Double> map3,
            Map<Character, Double> map4, Map<Character, Double> map5) {
        return getDefaultFactory().newUpdatableMap(map1, map2, map3, map4, map5);
    }


    public static  HashCharDoubleMap newUpdatableMap(
            net.openhft.function.Consumer<CharDoubleConsumer> entriesSupplier) {
        return getDefaultFactory().newUpdatableMap(entriesSupplier);
    }

    public static  HashCharDoubleMap newUpdatableMap(
            net.openhft.function.Consumer<CharDoubleConsumer> entriesSupplier,
            int expectedSize) {
        return getDefaultFactory().newUpdatableMap(entriesSupplier, expectedSize);
    }

    public static  HashCharDoubleMap newUpdatableMap(
            char[] keys, double[] values) {
        return getDefaultFactory().newUpdatableMap(keys, values);
    }

    public static  HashCharDoubleMap newUpdatableMap(
            char[] keys, double[] values, int expectedSize) {
        return getDefaultFactory().newUpdatableMap(keys, values, expectedSize);
    }

    public static  HashCharDoubleMap newUpdatableMap(
            Character[] keys, Double[] values) {
        return getDefaultFactory().newUpdatableMap(keys, values);
    }

    public static  HashCharDoubleMap newUpdatableMap(
            Character[] keys, Double[] values, int expectedSize) {
        return getDefaultFactory().newUpdatableMap(keys, values, expectedSize);
    }

    public static  HashCharDoubleMap newUpdatableMap(Iterable<Character> keys,
            Iterable<Double> values) {
        return getDefaultFactory().newUpdatableMap(keys, values);
    }

    public static  HashCharDoubleMap newUpdatableMap(Iterable<Character> keys,
            Iterable<Double> values, int expectedSize) {
        return getDefaultFactory().newUpdatableMap(keys, values, expectedSize);
    }


    public static  HashCharDoubleMap newUpdatableMapOf(
            char k1, double v1) {
        return getDefaultFactory().newUpdatableMapOf(k1, v1);
    }

    public static  HashCharDoubleMap newUpdatableMapOf(
            char k1, double v1, char k2, double v2) {
        return getDefaultFactory().newUpdatableMapOf(k1, v1, k2, v2);
    }

    public static  HashCharDoubleMap newUpdatableMapOf(
            char k1, double v1, char k2, double v2,
            char k3, double v3) {
        return getDefaultFactory().newUpdatableMapOf(k1, v1, k2, v2, k3, v3);
    }

    public static  HashCharDoubleMap newUpdatableMapOf(
            char k1, double v1, char k2, double v2,
            char k3, double v3, char k4, double v4) {
        return getDefaultFactory().newUpdatableMapOf(k1, v1, k2, v2, k3, v3, k4, v4);
    }

    public static  HashCharDoubleMap newUpdatableMapOf(
            char k1, double v1, char k2, double v2,
            char k3, double v3, char k4, double v4,
            char k5, double v5) {
        return getDefaultFactory().newUpdatableMapOf(k1, v1, k2, v2, k3, v3, k4, v4, k5, v5);
    }

    
    


    public static  HashCharDoubleMap newImmutableMap(Map<Character, Double> map1,
            Map<Character, Double> map2, int expectedSize) {
        return getDefaultFactory().newImmutableMap(map1, map2, expectedSize);
    }

    public static  HashCharDoubleMap newImmutableMap(Map<Character, Double> map1,
            Map<Character, Double> map2, Map<Character, Double> map3, int expectedSize) {
        return getDefaultFactory().newImmutableMap(map1, map2, map3, expectedSize);
    }

    public static  HashCharDoubleMap newImmutableMap(Map<Character, Double> map1,
            Map<Character, Double> map2, Map<Character, Double> map3,
            Map<Character, Double> map4, int expectedSize) {
        return getDefaultFactory().newImmutableMap(map1, map2, map3, map4, expectedSize);
    }

    public static  HashCharDoubleMap newImmutableMap(Map<Character, Double> map1,
            Map<Character, Double> map2, Map<Character, Double> map3,
            Map<Character, Double> map4, Map<Character, Double> map5, int expectedSize) {
        return getDefaultFactory().newImmutableMap(map1, map2, map3, map4, map5, expectedSize);
    }

    
    

    
    public static  HashCharDoubleMap newImmutableMap(
            Map<Character, Double> map) {
        return getDefaultFactory().newImmutableMap(map);
    }

    public static  HashCharDoubleMap newImmutableMap(Map<Character, Double> map1,
            Map<Character, Double> map2) {
        return getDefaultFactory().newImmutableMap(map1, map2);
    }

    public static  HashCharDoubleMap newImmutableMap(Map<Character, Double> map1,
            Map<Character, Double> map2, Map<Character, Double> map3) {
        return getDefaultFactory().newImmutableMap(map1, map2, map3);
    }

    public static  HashCharDoubleMap newImmutableMap(Map<Character, Double> map1,
            Map<Character, Double> map2, Map<Character, Double> map3,
            Map<Character, Double> map4) {
        return getDefaultFactory().newImmutableMap(map1, map2, map3, map4);
    }

    public static  HashCharDoubleMap newImmutableMap(Map<Character, Double> map1,
            Map<Character, Double> map2, Map<Character, Double> map3,
            Map<Character, Double> map4, Map<Character, Double> map5) {
        return getDefaultFactory().newImmutableMap(map1, map2, map3, map4, map5);
    }


    public static  HashCharDoubleMap newImmutableMap(
            net.openhft.function.Consumer<CharDoubleConsumer> entriesSupplier) {
        return getDefaultFactory().newImmutableMap(entriesSupplier);
    }

    public static  HashCharDoubleMap newImmutableMap(
            net.openhft.function.Consumer<CharDoubleConsumer> entriesSupplier,
            int expectedSize) {
        return getDefaultFactory().newImmutableMap(entriesSupplier, expectedSize);
    }

    public static  HashCharDoubleMap newImmutableMap(
            char[] keys, double[] values) {
        return getDefaultFactory().newImmutableMap(keys, values);
    }

    public static  HashCharDoubleMap newImmutableMap(
            char[] keys, double[] values, int expectedSize) {
        return getDefaultFactory().newImmutableMap(keys, values, expectedSize);
    }

    public static  HashCharDoubleMap newImmutableMap(
            Character[] keys, Double[] values) {
        return getDefaultFactory().newImmutableMap(keys, values);
    }

    public static  HashCharDoubleMap newImmutableMap(
            Character[] keys, Double[] values, int expectedSize) {
        return getDefaultFactory().newImmutableMap(keys, values, expectedSize);
    }

    public static  HashCharDoubleMap newImmutableMap(Iterable<Character> keys,
            Iterable<Double> values) {
        return getDefaultFactory().newImmutableMap(keys, values);
    }

    public static  HashCharDoubleMap newImmutableMap(Iterable<Character> keys,
            Iterable<Double> values, int expectedSize) {
        return getDefaultFactory().newImmutableMap(keys, values, expectedSize);
    }


    public static  HashCharDoubleMap newImmutableMapOf(
            char k1, double v1) {
        return getDefaultFactory().newImmutableMapOf(k1, v1);
    }

    public static  HashCharDoubleMap newImmutableMapOf(
            char k1, double v1, char k2, double v2) {
        return getDefaultFactory().newImmutableMapOf(k1, v1, k2, v2);
    }

    public static  HashCharDoubleMap newImmutableMapOf(
            char k1, double v1, char k2, double v2,
            char k3, double v3) {
        return getDefaultFactory().newImmutableMapOf(k1, v1, k2, v2, k3, v3);
    }

    public static  HashCharDoubleMap newImmutableMapOf(
            char k1, double v1, char k2, double v2,
            char k3, double v3, char k4, double v4) {
        return getDefaultFactory().newImmutableMapOf(k1, v1, k2, v2, k3, v3, k4, v4);
    }

    public static  HashCharDoubleMap newImmutableMapOf(
            char k1, double v1, char k2, double v2,
            char k3, double v3, char k4, double v4,
            char k5, double v5) {
        return getDefaultFactory().newImmutableMapOf(k1, v1, k2, v2, k3, v3, k4, v4, k5, v5);
    }

    private HashCharDoubleMaps() {}
}

