/*
 * Copyright 2014 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.openhft.collect.map.hash;

import net.openhft.collect.*;
import net.openhft.collect.hash.*;
import net.openhft.function.CharDoubleConsumer;
import net.openhft.collect.map.*;
import javax.annotation.Nullable;

import java.util.Map;


/**
 * An immutable factory of {@code HashCharDoubleMaps}
 *
 * @see HashCharDoubleMap
 * @see HashCharDoubleMaps#getDefaultFactory()
 */
public interface HashCharDoubleMapFactory extends CharDoubleMapFactory
        , CharHashFactory<HashCharDoubleMapFactory>
         {

    

    

    

    

    

    
    

    
    


    @Override
    HashCharDoubleMapFactory withDefaultValue(double defaultValue);

    @Override
     HashCharDoubleMap newMutableMap();

    @Override
     HashCharDoubleMap newMutableMap(int expectedSize);

    


    @Override
     HashCharDoubleMap newMutableMap(Map<Character, Double> map1,
            Map<Character, Double> map2, int expectedSize);

    @Override
     HashCharDoubleMap newMutableMap(Map<Character, Double> map1,
            Map<Character, Double> map2, Map<Character, Double> map3, int expectedSize);

    @Override
     HashCharDoubleMap newMutableMap(Map<Character, Double> map1,
            Map<Character, Double> map2, Map<Character, Double> map3,
            Map<Character, Double> map4, int expectedSize);

    @Override
     HashCharDoubleMap newMutableMap(Map<Character, Double> map1,
            Map<Character, Double> map2, Map<Character, Double> map3,
            Map<Character, Double> map4, Map<Character, Double> map5, int expectedSize);

    

    
    @Override
     HashCharDoubleMap newMutableMap(Map<Character, Double> map);

    @Override
     HashCharDoubleMap newMutableMap(Map<Character, Double> map1,
            Map<Character, Double> map2);

    @Override
     HashCharDoubleMap newMutableMap(Map<Character, Double> map1,
            Map<Character, Double> map2, Map<Character, Double> map3);

    @Override
     HashCharDoubleMap newMutableMap(Map<Character, Double> map1,
            Map<Character, Double> map2, Map<Character, Double> map3,
            Map<Character, Double> map4);

    @Override
     HashCharDoubleMap newMutableMap(Map<Character, Double> map1,
            Map<Character, Double> map2, Map<Character, Double> map3,
            Map<Character, Double> map4, Map<Character, Double> map5);


    @Override
     HashCharDoubleMap newMutableMap(
            net.openhft.function.Consumer<CharDoubleConsumer> entriesSupplier);

    @Override
     HashCharDoubleMap newMutableMap(
            net.openhft.function.Consumer<CharDoubleConsumer> entriesSupplier,
            int expectedSize);

    @Override
     HashCharDoubleMap newMutableMap(char[] keys, double[] values);

    @Override
     HashCharDoubleMap newMutableMap(char[] keys, double[] values,
            int expectedSize);

    @Override
     HashCharDoubleMap newMutableMap(
            Character[] keys, Double[] values);

    @Override
     HashCharDoubleMap newMutableMap(
            Character[] keys, Double[] values, int expectedSize);

    @Override
     HashCharDoubleMap newMutableMap(Iterable<Character> keys,
            Iterable<Double> values);

    @Override
     HashCharDoubleMap newMutableMap(Iterable<Character> keys,
            Iterable<Double> values, int expectedSize);


    @Override
     HashCharDoubleMap newMutableMapOf(char k1, double v1);

    @Override
     HashCharDoubleMap newMutableMapOf(char k1, double v1,
            char k2, double v2);

    @Override
     HashCharDoubleMap newMutableMapOf(char k1, double v1,
            char k2, double v2, char k3, double v3);

    @Override
     HashCharDoubleMap newMutableMapOf(char k1, double v1,
            char k2, double v2, char k3, double v3,
            char k4, double v4);

    @Override
     HashCharDoubleMap newMutableMapOf(char k1, double v1,
            char k2, double v2, char k3, double v3,
            char k4, double v4, char k5, double v5);
    @Override
     HashCharDoubleMap newUpdatableMap();

    @Override
     HashCharDoubleMap newUpdatableMap(int expectedSize);

    


    @Override
     HashCharDoubleMap newUpdatableMap(Map<Character, Double> map1,
            Map<Character, Double> map2, int expectedSize);

    @Override
     HashCharDoubleMap newUpdatableMap(Map<Character, Double> map1,
            Map<Character, Double> map2, Map<Character, Double> map3, int expectedSize);

    @Override
     HashCharDoubleMap newUpdatableMap(Map<Character, Double> map1,
            Map<Character, Double> map2, Map<Character, Double> map3,
            Map<Character, Double> map4, int expectedSize);

    @Override
     HashCharDoubleMap newUpdatableMap(Map<Character, Double> map1,
            Map<Character, Double> map2, Map<Character, Double> map3,
            Map<Character, Double> map4, Map<Character, Double> map5, int expectedSize);

    

    
    @Override
     HashCharDoubleMap newUpdatableMap(Map<Character, Double> map);

    @Override
     HashCharDoubleMap newUpdatableMap(Map<Character, Double> map1,
            Map<Character, Double> map2);

    @Override
     HashCharDoubleMap newUpdatableMap(Map<Character, Double> map1,
            Map<Character, Double> map2, Map<Character, Double> map3);

    @Override
     HashCharDoubleMap newUpdatableMap(Map<Character, Double> map1,
            Map<Character, Double> map2, Map<Character, Double> map3,
            Map<Character, Double> map4);

    @Override
     HashCharDoubleMap newUpdatableMap(Map<Character, Double> map1,
            Map<Character, Double> map2, Map<Character, Double> map3,
            Map<Character, Double> map4, Map<Character, Double> map5);


    @Override
     HashCharDoubleMap newUpdatableMap(
            net.openhft.function.Consumer<CharDoubleConsumer> entriesSupplier);

    @Override
     HashCharDoubleMap newUpdatableMap(
            net.openhft.function.Consumer<CharDoubleConsumer> entriesSupplier,
            int expectedSize);

    @Override
     HashCharDoubleMap newUpdatableMap(char[] keys, double[] values);

    @Override
     HashCharDoubleMap newUpdatableMap(char[] keys, double[] values,
            int expectedSize);

    @Override
     HashCharDoubleMap newUpdatableMap(
            Character[] keys, Double[] values);

    @Override
     HashCharDoubleMap newUpdatableMap(
            Character[] keys, Double[] values, int expectedSize);

    @Override
     HashCharDoubleMap newUpdatableMap(Iterable<Character> keys,
            Iterable<Double> values);

    @Override
     HashCharDoubleMap newUpdatableMap(Iterable<Character> keys,
            Iterable<Double> values, int expectedSize);


    @Override
     HashCharDoubleMap newUpdatableMapOf(char k1, double v1);

    @Override
     HashCharDoubleMap newUpdatableMapOf(char k1, double v1,
            char k2, double v2);

    @Override
     HashCharDoubleMap newUpdatableMapOf(char k1, double v1,
            char k2, double v2, char k3, double v3);

    @Override
     HashCharDoubleMap newUpdatableMapOf(char k1, double v1,
            char k2, double v2, char k3, double v3,
            char k4, double v4);

    @Override
     HashCharDoubleMap newUpdatableMapOf(char k1, double v1,
            char k2, double v2, char k3, double v3,
            char k4, double v4, char k5, double v5);

    


    @Override
     HashCharDoubleMap newImmutableMap(Map<Character, Double> map1,
            Map<Character, Double> map2, int expectedSize);

    @Override
     HashCharDoubleMap newImmutableMap(Map<Character, Double> map1,
            Map<Character, Double> map2, Map<Character, Double> map3, int expectedSize);

    @Override
     HashCharDoubleMap newImmutableMap(Map<Character, Double> map1,
            Map<Character, Double> map2, Map<Character, Double> map3,
            Map<Character, Double> map4, int expectedSize);

    @Override
     HashCharDoubleMap newImmutableMap(Map<Character, Double> map1,
            Map<Character, Double> map2, Map<Character, Double> map3,
            Map<Character, Double> map4, Map<Character, Double> map5, int expectedSize);

    

    
    @Override
     HashCharDoubleMap newImmutableMap(Map<Character, Double> map);

    @Override
     HashCharDoubleMap newImmutableMap(Map<Character, Double> map1,
            Map<Character, Double> map2);

    @Override
     HashCharDoubleMap newImmutableMap(Map<Character, Double> map1,
            Map<Character, Double> map2, Map<Character, Double> map3);

    @Override
     HashCharDoubleMap newImmutableMap(Map<Character, Double> map1,
            Map<Character, Double> map2, Map<Character, Double> map3,
            Map<Character, Double> map4);

    @Override
     HashCharDoubleMap newImmutableMap(Map<Character, Double> map1,
            Map<Character, Double> map2, Map<Character, Double> map3,
            Map<Character, Double> map4, Map<Character, Double> map5);


    @Override
     HashCharDoubleMap newImmutableMap(
            net.openhft.function.Consumer<CharDoubleConsumer> entriesSupplier);

    @Override
     HashCharDoubleMap newImmutableMap(
            net.openhft.function.Consumer<CharDoubleConsumer> entriesSupplier,
            int expectedSize);

    @Override
     HashCharDoubleMap newImmutableMap(char[] keys, double[] values);

    @Override
     HashCharDoubleMap newImmutableMap(char[] keys, double[] values,
            int expectedSize);

    @Override
     HashCharDoubleMap newImmutableMap(
            Character[] keys, Double[] values);

    @Override
     HashCharDoubleMap newImmutableMap(
            Character[] keys, Double[] values, int expectedSize);

    @Override
     HashCharDoubleMap newImmutableMap(Iterable<Character> keys,
            Iterable<Double> values);

    @Override
     HashCharDoubleMap newImmutableMap(Iterable<Character> keys,
            Iterable<Double> values, int expectedSize);


    @Override
     HashCharDoubleMap newImmutableMapOf(char k1, double v1);

    @Override
     HashCharDoubleMap newImmutableMapOf(char k1, double v1,
            char k2, double v2);

    @Override
     HashCharDoubleMap newImmutableMapOf(char k1, double v1,
            char k2, double v2, char k3, double v3);

    @Override
     HashCharDoubleMap newImmutableMapOf(char k1, double v1,
            char k2, double v2, char k3, double v3,
            char k4, double v4);

    @Override
     HashCharDoubleMap newImmutableMapOf(char k1, double v1,
            char k2, double v2, char k3, double v3,
            char k4, double v4, char k5, double v5);
}

