/*
 * Copyright 2014 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.openhft.collect.map.hash;

import net.openhft.function.CharCharConsumer;

import java.util.Map;
import java.util.ServiceLoader;


/**
 * This class consists only of static factory methods to construct {@code HashCharCharMap}s, and
 * the default {@link HashCharCharMapFactory} static provider ({@link #getDefaultFactory()}).
 *
 * @see HashCharCharMap
 */
public final class HashCharCharMaps {

    

    private static final ServiceLoader<HashCharCharMapFactory> LOADER =
            ServiceLoader.load(HashCharCharMapFactory.class);
    private static HashCharCharMapFactory defaultFactory = null;

    public static HashCharCharMapFactory getDefaultFactory() {
        if (defaultFactory != null) {
            return defaultFactory;
        } else {
            // synchronization?
            return defaultFactory = LOADER.iterator().next();
        }
    }

    

    

    

    public static  HashCharCharMap newMutableMap() {
        return getDefaultFactory().newMutableMap();
    }

    public static  HashCharCharMap newMutableMap(int expectedSize) {
        return getDefaultFactory().newMutableMap(expectedSize);
    }



    
    


    public static  HashCharCharMap newMutableMap(Map<Character, Character> map1,
            Map<Character, Character> map2, int expectedSize) {
        return getDefaultFactory().newMutableMap(map1, map2, expectedSize);
    }

    public static  HashCharCharMap newMutableMap(Map<Character, Character> map1,
            Map<Character, Character> map2, Map<Character, Character> map3, int expectedSize) {
        return getDefaultFactory().newMutableMap(map1, map2, map3, expectedSize);
    }

    public static  HashCharCharMap newMutableMap(Map<Character, Character> map1,
            Map<Character, Character> map2, Map<Character, Character> map3,
            Map<Character, Character> map4, int expectedSize) {
        return getDefaultFactory().newMutableMap(map1, map2, map3, map4, expectedSize);
    }

    public static  HashCharCharMap newMutableMap(Map<Character, Character> map1,
            Map<Character, Character> map2, Map<Character, Character> map3,
            Map<Character, Character> map4, Map<Character, Character> map5, int expectedSize) {
        return getDefaultFactory().newMutableMap(map1, map2, map3, map4, map5, expectedSize);
    }

    
    

    
    public static  HashCharCharMap newMutableMap(
            Map<Character, Character> map) {
        return getDefaultFactory().newMutableMap(map);
    }

    public static  HashCharCharMap newMutableMap(Map<Character, Character> map1,
            Map<Character, Character> map2) {
        return getDefaultFactory().newMutableMap(map1, map2);
    }

    public static  HashCharCharMap newMutableMap(Map<Character, Character> map1,
            Map<Character, Character> map2, Map<Character, Character> map3) {
        return getDefaultFactory().newMutableMap(map1, map2, map3);
    }

    public static  HashCharCharMap newMutableMap(Map<Character, Character> map1,
            Map<Character, Character> map2, Map<Character, Character> map3,
            Map<Character, Character> map4) {
        return getDefaultFactory().newMutableMap(map1, map2, map3, map4);
    }

    public static  HashCharCharMap newMutableMap(Map<Character, Character> map1,
            Map<Character, Character> map2, Map<Character, Character> map3,
            Map<Character, Character> map4, Map<Character, Character> map5) {
        return getDefaultFactory().newMutableMap(map1, map2, map3, map4, map5);
    }


    public static  HashCharCharMap newMutableMap(
            net.openhft.function.Consumer<CharCharConsumer> entriesSupplier) {
        return getDefaultFactory().newMutableMap(entriesSupplier);
    }

    public static  HashCharCharMap newMutableMap(
            net.openhft.function.Consumer<CharCharConsumer> entriesSupplier,
            int expectedSize) {
        return getDefaultFactory().newMutableMap(entriesSupplier, expectedSize);
    }

    public static  HashCharCharMap newMutableMap(
            char[] keys, char[] values) {
        return getDefaultFactory().newMutableMap(keys, values);
    }

    public static  HashCharCharMap newMutableMap(
            char[] keys, char[] values, int expectedSize) {
        return getDefaultFactory().newMutableMap(keys, values, expectedSize);
    }

    public static  HashCharCharMap newMutableMap(
            Character[] keys, Character[] values) {
        return getDefaultFactory().newMutableMap(keys, values);
    }

    public static  HashCharCharMap newMutableMap(
            Character[] keys, Character[] values, int expectedSize) {
        return getDefaultFactory().newMutableMap(keys, values, expectedSize);
    }

    public static  HashCharCharMap newMutableMap(Iterable<Character> keys,
            Iterable<Character> values) {
        return getDefaultFactory().newMutableMap(keys, values);
    }

    public static  HashCharCharMap newMutableMap(Iterable<Character> keys,
            Iterable<Character> values, int expectedSize) {
        return getDefaultFactory().newMutableMap(keys, values, expectedSize);
    }


    public static  HashCharCharMap newMutableMapOf(
            char k1, char v1) {
        return getDefaultFactory().newMutableMapOf(k1, v1);
    }

    public static  HashCharCharMap newMutableMapOf(
            char k1, char v1, char k2, char v2) {
        return getDefaultFactory().newMutableMapOf(k1, v1, k2, v2);
    }

    public static  HashCharCharMap newMutableMapOf(
            char k1, char v1, char k2, char v2,
            char k3, char v3) {
        return getDefaultFactory().newMutableMapOf(k1, v1, k2, v2, k3, v3);
    }

    public static  HashCharCharMap newMutableMapOf(
            char k1, char v1, char k2, char v2,
            char k3, char v3, char k4, char v4) {
        return getDefaultFactory().newMutableMapOf(k1, v1, k2, v2, k3, v3, k4, v4);
    }

    public static  HashCharCharMap newMutableMapOf(
            char k1, char v1, char k2, char v2,
            char k3, char v3, char k4, char v4,
            char k5, char v5) {
        return getDefaultFactory().newMutableMapOf(k1, v1, k2, v2, k3, v3, k4, v4, k5, v5);
    }

    
    


    public static  HashCharCharMap newUpdatableMap(Map<Character, Character> map1,
            Map<Character, Character> map2, int expectedSize) {
        return getDefaultFactory().newUpdatableMap(map1, map2, expectedSize);
    }

    public static  HashCharCharMap newUpdatableMap(Map<Character, Character> map1,
            Map<Character, Character> map2, Map<Character, Character> map3, int expectedSize) {
        return getDefaultFactory().newUpdatableMap(map1, map2, map3, expectedSize);
    }

    public static  HashCharCharMap newUpdatableMap(Map<Character, Character> map1,
            Map<Character, Character> map2, Map<Character, Character> map3,
            Map<Character, Character> map4, int expectedSize) {
        return getDefaultFactory().newUpdatableMap(map1, map2, map3, map4, expectedSize);
    }

    public static  HashCharCharMap newUpdatableMap(Map<Character, Character> map1,
            Map<Character, Character> map2, Map<Character, Character> map3,
            Map<Character, Character> map4, Map<Character, Character> map5, int expectedSize) {
        return getDefaultFactory().newUpdatableMap(map1, map2, map3, map4, map5, expectedSize);
    }

    
    

    
    public static  HashCharCharMap newUpdatableMap(
            Map<Character, Character> map) {
        return getDefaultFactory().newUpdatableMap(map);
    }

    public static  HashCharCharMap newUpdatableMap(Map<Character, Character> map1,
            Map<Character, Character> map2) {
        return getDefaultFactory().newUpdatableMap(map1, map2);
    }

    public static  HashCharCharMap newUpdatableMap(Map<Character, Character> map1,
            Map<Character, Character> map2, Map<Character, Character> map3) {
        return getDefaultFactory().newUpdatableMap(map1, map2, map3);
    }

    public static  HashCharCharMap newUpdatableMap(Map<Character, Character> map1,
            Map<Character, Character> map2, Map<Character, Character> map3,
            Map<Character, Character> map4) {
        return getDefaultFactory().newUpdatableMap(map1, map2, map3, map4);
    }

    public static  HashCharCharMap newUpdatableMap(Map<Character, Character> map1,
            Map<Character, Character> map2, Map<Character, Character> map3,
            Map<Character, Character> map4, Map<Character, Character> map5) {
        return getDefaultFactory().newUpdatableMap(map1, map2, map3, map4, map5);
    }


    public static  HashCharCharMap newUpdatableMap(
            net.openhft.function.Consumer<CharCharConsumer> entriesSupplier) {
        return getDefaultFactory().newUpdatableMap(entriesSupplier);
    }

    public static  HashCharCharMap newUpdatableMap(
            net.openhft.function.Consumer<CharCharConsumer> entriesSupplier,
            int expectedSize) {
        return getDefaultFactory().newUpdatableMap(entriesSupplier, expectedSize);
    }

    public static  HashCharCharMap newUpdatableMap(
            char[] keys, char[] values) {
        return getDefaultFactory().newUpdatableMap(keys, values);
    }

    public static  HashCharCharMap newUpdatableMap(
            char[] keys, char[] values, int expectedSize) {
        return getDefaultFactory().newUpdatableMap(keys, values, expectedSize);
    }

    public static  HashCharCharMap newUpdatableMap(
            Character[] keys, Character[] values) {
        return getDefaultFactory().newUpdatableMap(keys, values);
    }

    public static  HashCharCharMap newUpdatableMap(
            Character[] keys, Character[] values, int expectedSize) {
        return getDefaultFactory().newUpdatableMap(keys, values, expectedSize);
    }

    public static  HashCharCharMap newUpdatableMap(Iterable<Character> keys,
            Iterable<Character> values) {
        return getDefaultFactory().newUpdatableMap(keys, values);
    }

    public static  HashCharCharMap newUpdatableMap(Iterable<Character> keys,
            Iterable<Character> values, int expectedSize) {
        return getDefaultFactory().newUpdatableMap(keys, values, expectedSize);
    }


    public static  HashCharCharMap newUpdatableMapOf(
            char k1, char v1) {
        return getDefaultFactory().newUpdatableMapOf(k1, v1);
    }

    public static  HashCharCharMap newUpdatableMapOf(
            char k1, char v1, char k2, char v2) {
        return getDefaultFactory().newUpdatableMapOf(k1, v1, k2, v2);
    }

    public static  HashCharCharMap newUpdatableMapOf(
            char k1, char v1, char k2, char v2,
            char k3, char v3) {
        return getDefaultFactory().newUpdatableMapOf(k1, v1, k2, v2, k3, v3);
    }

    public static  HashCharCharMap newUpdatableMapOf(
            char k1, char v1, char k2, char v2,
            char k3, char v3, char k4, char v4) {
        return getDefaultFactory().newUpdatableMapOf(k1, v1, k2, v2, k3, v3, k4, v4);
    }

    public static  HashCharCharMap newUpdatableMapOf(
            char k1, char v1, char k2, char v2,
            char k3, char v3, char k4, char v4,
            char k5, char v5) {
        return getDefaultFactory().newUpdatableMapOf(k1, v1, k2, v2, k3, v3, k4, v4, k5, v5);
    }

    
    


    public static  HashCharCharMap newImmutableMap(Map<Character, Character> map1,
            Map<Character, Character> map2, int expectedSize) {
        return getDefaultFactory().newImmutableMap(map1, map2, expectedSize);
    }

    public static  HashCharCharMap newImmutableMap(Map<Character, Character> map1,
            Map<Character, Character> map2, Map<Character, Character> map3, int expectedSize) {
        return getDefaultFactory().newImmutableMap(map1, map2, map3, expectedSize);
    }

    public static  HashCharCharMap newImmutableMap(Map<Character, Character> map1,
            Map<Character, Character> map2, Map<Character, Character> map3,
            Map<Character, Character> map4, int expectedSize) {
        return getDefaultFactory().newImmutableMap(map1, map2, map3, map4, expectedSize);
    }

    public static  HashCharCharMap newImmutableMap(Map<Character, Character> map1,
            Map<Character, Character> map2, Map<Character, Character> map3,
            Map<Character, Character> map4, Map<Character, Character> map5, int expectedSize) {
        return getDefaultFactory().newImmutableMap(map1, map2, map3, map4, map5, expectedSize);
    }

    
    

    
    public static  HashCharCharMap newImmutableMap(
            Map<Character, Character> map) {
        return getDefaultFactory().newImmutableMap(map);
    }

    public static  HashCharCharMap newImmutableMap(Map<Character, Character> map1,
            Map<Character, Character> map2) {
        return getDefaultFactory().newImmutableMap(map1, map2);
    }

    public static  HashCharCharMap newImmutableMap(Map<Character, Character> map1,
            Map<Character, Character> map2, Map<Character, Character> map3) {
        return getDefaultFactory().newImmutableMap(map1, map2, map3);
    }

    public static  HashCharCharMap newImmutableMap(Map<Character, Character> map1,
            Map<Character, Character> map2, Map<Character, Character> map3,
            Map<Character, Character> map4) {
        return getDefaultFactory().newImmutableMap(map1, map2, map3, map4);
    }

    public static  HashCharCharMap newImmutableMap(Map<Character, Character> map1,
            Map<Character, Character> map2, Map<Character, Character> map3,
            Map<Character, Character> map4, Map<Character, Character> map5) {
        return getDefaultFactory().newImmutableMap(map1, map2, map3, map4, map5);
    }


    public static  HashCharCharMap newImmutableMap(
            net.openhft.function.Consumer<CharCharConsumer> entriesSupplier) {
        return getDefaultFactory().newImmutableMap(entriesSupplier);
    }

    public static  HashCharCharMap newImmutableMap(
            net.openhft.function.Consumer<CharCharConsumer> entriesSupplier,
            int expectedSize) {
        return getDefaultFactory().newImmutableMap(entriesSupplier, expectedSize);
    }

    public static  HashCharCharMap newImmutableMap(
            char[] keys, char[] values) {
        return getDefaultFactory().newImmutableMap(keys, values);
    }

    public static  HashCharCharMap newImmutableMap(
            char[] keys, char[] values, int expectedSize) {
        return getDefaultFactory().newImmutableMap(keys, values, expectedSize);
    }

    public static  HashCharCharMap newImmutableMap(
            Character[] keys, Character[] values) {
        return getDefaultFactory().newImmutableMap(keys, values);
    }

    public static  HashCharCharMap newImmutableMap(
            Character[] keys, Character[] values, int expectedSize) {
        return getDefaultFactory().newImmutableMap(keys, values, expectedSize);
    }

    public static  HashCharCharMap newImmutableMap(Iterable<Character> keys,
            Iterable<Character> values) {
        return getDefaultFactory().newImmutableMap(keys, values);
    }

    public static  HashCharCharMap newImmutableMap(Iterable<Character> keys,
            Iterable<Character> values, int expectedSize) {
        return getDefaultFactory().newImmutableMap(keys, values, expectedSize);
    }


    public static  HashCharCharMap newImmutableMapOf(
            char k1, char v1) {
        return getDefaultFactory().newImmutableMapOf(k1, v1);
    }

    public static  HashCharCharMap newImmutableMapOf(
            char k1, char v1, char k2, char v2) {
        return getDefaultFactory().newImmutableMapOf(k1, v1, k2, v2);
    }

    public static  HashCharCharMap newImmutableMapOf(
            char k1, char v1, char k2, char v2,
            char k3, char v3) {
        return getDefaultFactory().newImmutableMapOf(k1, v1, k2, v2, k3, v3);
    }

    public static  HashCharCharMap newImmutableMapOf(
            char k1, char v1, char k2, char v2,
            char k3, char v3, char k4, char v4) {
        return getDefaultFactory().newImmutableMapOf(k1, v1, k2, v2, k3, v3, k4, v4);
    }

    public static  HashCharCharMap newImmutableMapOf(
            char k1, char v1, char k2, char v2,
            char k3, char v3, char k4, char v4,
            char k5, char v5) {
        return getDefaultFactory().newImmutableMapOf(k1, v1, k2, v2, k3, v3, k4, v4, k5, v5);
    }

    private HashCharCharMaps() {}
}

