/*
 * Copyright 2014 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.openhft.collect.map.hash;

import net.openhft.collect.*;
import net.openhft.collect.hash.*;
import net.openhft.function.CharCharConsumer;
import net.openhft.collect.map.*;
import javax.annotation.Nullable;

import java.util.Map;


/**
 * An immutable factory of {@code HashCharCharMaps}
 *
 * @see HashCharCharMap
 * @see HashCharCharMaps#getDefaultFactory()
 */
public interface HashCharCharMapFactory extends CharCharMapFactory
        , CharHashFactory<HashCharCharMapFactory>
         {

    

    

    

    

    

    
    

    
    


    @Override
    HashCharCharMapFactory withDefaultValue(char defaultValue);

    @Override
     HashCharCharMap newMutableMap();

    @Override
     HashCharCharMap newMutableMap(int expectedSize);

    


    @Override
     HashCharCharMap newMutableMap(Map<Character, Character> map1,
            Map<Character, Character> map2, int expectedSize);

    @Override
     HashCharCharMap newMutableMap(Map<Character, Character> map1,
            Map<Character, Character> map2, Map<Character, Character> map3, int expectedSize);

    @Override
     HashCharCharMap newMutableMap(Map<Character, Character> map1,
            Map<Character, Character> map2, Map<Character, Character> map3,
            Map<Character, Character> map4, int expectedSize);

    @Override
     HashCharCharMap newMutableMap(Map<Character, Character> map1,
            Map<Character, Character> map2, Map<Character, Character> map3,
            Map<Character, Character> map4, Map<Character, Character> map5, int expectedSize);

    

    
    @Override
     HashCharCharMap newMutableMap(Map<Character, Character> map);

    @Override
     HashCharCharMap newMutableMap(Map<Character, Character> map1,
            Map<Character, Character> map2);

    @Override
     HashCharCharMap newMutableMap(Map<Character, Character> map1,
            Map<Character, Character> map2, Map<Character, Character> map3);

    @Override
     HashCharCharMap newMutableMap(Map<Character, Character> map1,
            Map<Character, Character> map2, Map<Character, Character> map3,
            Map<Character, Character> map4);

    @Override
     HashCharCharMap newMutableMap(Map<Character, Character> map1,
            Map<Character, Character> map2, Map<Character, Character> map3,
            Map<Character, Character> map4, Map<Character, Character> map5);


    @Override
     HashCharCharMap newMutableMap(
            net.openhft.function.Consumer<CharCharConsumer> entriesSupplier);

    @Override
     HashCharCharMap newMutableMap(
            net.openhft.function.Consumer<CharCharConsumer> entriesSupplier,
            int expectedSize);

    @Override
     HashCharCharMap newMutableMap(char[] keys, char[] values);

    @Override
     HashCharCharMap newMutableMap(char[] keys, char[] values,
            int expectedSize);

    @Override
     HashCharCharMap newMutableMap(
            Character[] keys, Character[] values);

    @Override
     HashCharCharMap newMutableMap(
            Character[] keys, Character[] values, int expectedSize);

    @Override
     HashCharCharMap newMutableMap(Iterable<Character> keys,
            Iterable<Character> values);

    @Override
     HashCharCharMap newMutableMap(Iterable<Character> keys,
            Iterable<Character> values, int expectedSize);


    @Override
     HashCharCharMap newMutableMapOf(char k1, char v1);

    @Override
     HashCharCharMap newMutableMapOf(char k1, char v1,
            char k2, char v2);

    @Override
     HashCharCharMap newMutableMapOf(char k1, char v1,
            char k2, char v2, char k3, char v3);

    @Override
     HashCharCharMap newMutableMapOf(char k1, char v1,
            char k2, char v2, char k3, char v3,
            char k4, char v4);

    @Override
     HashCharCharMap newMutableMapOf(char k1, char v1,
            char k2, char v2, char k3, char v3,
            char k4, char v4, char k5, char v5);
    @Override
     HashCharCharMap newUpdatableMap();

    @Override
     HashCharCharMap newUpdatableMap(int expectedSize);

    


    @Override
     HashCharCharMap newUpdatableMap(Map<Character, Character> map1,
            Map<Character, Character> map2, int expectedSize);

    @Override
     HashCharCharMap newUpdatableMap(Map<Character, Character> map1,
            Map<Character, Character> map2, Map<Character, Character> map3, int expectedSize);

    @Override
     HashCharCharMap newUpdatableMap(Map<Character, Character> map1,
            Map<Character, Character> map2, Map<Character, Character> map3,
            Map<Character, Character> map4, int expectedSize);

    @Override
     HashCharCharMap newUpdatableMap(Map<Character, Character> map1,
            Map<Character, Character> map2, Map<Character, Character> map3,
            Map<Character, Character> map4, Map<Character, Character> map5, int expectedSize);

    

    
    @Override
     HashCharCharMap newUpdatableMap(Map<Character, Character> map);

    @Override
     HashCharCharMap newUpdatableMap(Map<Character, Character> map1,
            Map<Character, Character> map2);

    @Override
     HashCharCharMap newUpdatableMap(Map<Character, Character> map1,
            Map<Character, Character> map2, Map<Character, Character> map3);

    @Override
     HashCharCharMap newUpdatableMap(Map<Character, Character> map1,
            Map<Character, Character> map2, Map<Character, Character> map3,
            Map<Character, Character> map4);

    @Override
     HashCharCharMap newUpdatableMap(Map<Character, Character> map1,
            Map<Character, Character> map2, Map<Character, Character> map3,
            Map<Character, Character> map4, Map<Character, Character> map5);


    @Override
     HashCharCharMap newUpdatableMap(
            net.openhft.function.Consumer<CharCharConsumer> entriesSupplier);

    @Override
     HashCharCharMap newUpdatableMap(
            net.openhft.function.Consumer<CharCharConsumer> entriesSupplier,
            int expectedSize);

    @Override
     HashCharCharMap newUpdatableMap(char[] keys, char[] values);

    @Override
     HashCharCharMap newUpdatableMap(char[] keys, char[] values,
            int expectedSize);

    @Override
     HashCharCharMap newUpdatableMap(
            Character[] keys, Character[] values);

    @Override
     HashCharCharMap newUpdatableMap(
            Character[] keys, Character[] values, int expectedSize);

    @Override
     HashCharCharMap newUpdatableMap(Iterable<Character> keys,
            Iterable<Character> values);

    @Override
     HashCharCharMap newUpdatableMap(Iterable<Character> keys,
            Iterable<Character> values, int expectedSize);


    @Override
     HashCharCharMap newUpdatableMapOf(char k1, char v1);

    @Override
     HashCharCharMap newUpdatableMapOf(char k1, char v1,
            char k2, char v2);

    @Override
     HashCharCharMap newUpdatableMapOf(char k1, char v1,
            char k2, char v2, char k3, char v3);

    @Override
     HashCharCharMap newUpdatableMapOf(char k1, char v1,
            char k2, char v2, char k3, char v3,
            char k4, char v4);

    @Override
     HashCharCharMap newUpdatableMapOf(char k1, char v1,
            char k2, char v2, char k3, char v3,
            char k4, char v4, char k5, char v5);

    


    @Override
     HashCharCharMap newImmutableMap(Map<Character, Character> map1,
            Map<Character, Character> map2, int expectedSize);

    @Override
     HashCharCharMap newImmutableMap(Map<Character, Character> map1,
            Map<Character, Character> map2, Map<Character, Character> map3, int expectedSize);

    @Override
     HashCharCharMap newImmutableMap(Map<Character, Character> map1,
            Map<Character, Character> map2, Map<Character, Character> map3,
            Map<Character, Character> map4, int expectedSize);

    @Override
     HashCharCharMap newImmutableMap(Map<Character, Character> map1,
            Map<Character, Character> map2, Map<Character, Character> map3,
            Map<Character, Character> map4, Map<Character, Character> map5, int expectedSize);

    

    
    @Override
     HashCharCharMap newImmutableMap(Map<Character, Character> map);

    @Override
     HashCharCharMap newImmutableMap(Map<Character, Character> map1,
            Map<Character, Character> map2);

    @Override
     HashCharCharMap newImmutableMap(Map<Character, Character> map1,
            Map<Character, Character> map2, Map<Character, Character> map3);

    @Override
     HashCharCharMap newImmutableMap(Map<Character, Character> map1,
            Map<Character, Character> map2, Map<Character, Character> map3,
            Map<Character, Character> map4);

    @Override
     HashCharCharMap newImmutableMap(Map<Character, Character> map1,
            Map<Character, Character> map2, Map<Character, Character> map3,
            Map<Character, Character> map4, Map<Character, Character> map5);


    @Override
     HashCharCharMap newImmutableMap(
            net.openhft.function.Consumer<CharCharConsumer> entriesSupplier);

    @Override
     HashCharCharMap newImmutableMap(
            net.openhft.function.Consumer<CharCharConsumer> entriesSupplier,
            int expectedSize);

    @Override
     HashCharCharMap newImmutableMap(char[] keys, char[] values);

    @Override
     HashCharCharMap newImmutableMap(char[] keys, char[] values,
            int expectedSize);

    @Override
     HashCharCharMap newImmutableMap(
            Character[] keys, Character[] values);

    @Override
     HashCharCharMap newImmutableMap(
            Character[] keys, Character[] values, int expectedSize);

    @Override
     HashCharCharMap newImmutableMap(Iterable<Character> keys,
            Iterable<Character> values);

    @Override
     HashCharCharMap newImmutableMap(Iterable<Character> keys,
            Iterable<Character> values, int expectedSize);


    @Override
     HashCharCharMap newImmutableMapOf(char k1, char v1);

    @Override
     HashCharCharMap newImmutableMapOf(char k1, char v1,
            char k2, char v2);

    @Override
     HashCharCharMap newImmutableMapOf(char k1, char v1,
            char k2, char v2, char k3, char v3);

    @Override
     HashCharCharMap newImmutableMapOf(char k1, char v1,
            char k2, char v2, char k3, char v3,
            char k4, char v4);

    @Override
     HashCharCharMap newImmutableMapOf(char k1, char v1,
            char k2, char v2, char k3, char v3,
            char k4, char v4, char k5, char v5);
}

