/*
 * Copyright 2014 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.openhft.collect.map.hash;

import net.openhft.function.CharByteConsumer;

import java.util.Map;
import java.util.ServiceLoader;


/**
 * This class consists only of static factory methods to construct {@code HashCharByteMap}s, and
 * the default {@link HashCharByteMapFactory} static provider ({@link #getDefaultFactory()}).
 *
 * @see HashCharByteMap
 */
public final class HashCharByteMaps {

    

    private static final ServiceLoader<HashCharByteMapFactory> LOADER =
            ServiceLoader.load(HashCharByteMapFactory.class);
    private static HashCharByteMapFactory defaultFactory = null;

    public static HashCharByteMapFactory getDefaultFactory() {
        if (defaultFactory != null) {
            return defaultFactory;
        } else {
            // synchronization?
            return defaultFactory = LOADER.iterator().next();
        }
    }

    

    

    

    public static  HashCharByteMap newMutableMap() {
        return getDefaultFactory().newMutableMap();
    }

    public static  HashCharByteMap newMutableMap(int expectedSize) {
        return getDefaultFactory().newMutableMap(expectedSize);
    }



    
    


    public static  HashCharByteMap newMutableMap(Map<Character, Byte> map1,
            Map<Character, Byte> map2, int expectedSize) {
        return getDefaultFactory().newMutableMap(map1, map2, expectedSize);
    }

    public static  HashCharByteMap newMutableMap(Map<Character, Byte> map1,
            Map<Character, Byte> map2, Map<Character, Byte> map3, int expectedSize) {
        return getDefaultFactory().newMutableMap(map1, map2, map3, expectedSize);
    }

    public static  HashCharByteMap newMutableMap(Map<Character, Byte> map1,
            Map<Character, Byte> map2, Map<Character, Byte> map3,
            Map<Character, Byte> map4, int expectedSize) {
        return getDefaultFactory().newMutableMap(map1, map2, map3, map4, expectedSize);
    }

    public static  HashCharByteMap newMutableMap(Map<Character, Byte> map1,
            Map<Character, Byte> map2, Map<Character, Byte> map3,
            Map<Character, Byte> map4, Map<Character, Byte> map5, int expectedSize) {
        return getDefaultFactory().newMutableMap(map1, map2, map3, map4, map5, expectedSize);
    }

    
    

    
    public static  HashCharByteMap newMutableMap(
            Map<Character, Byte> map) {
        return getDefaultFactory().newMutableMap(map);
    }

    public static  HashCharByteMap newMutableMap(Map<Character, Byte> map1,
            Map<Character, Byte> map2) {
        return getDefaultFactory().newMutableMap(map1, map2);
    }

    public static  HashCharByteMap newMutableMap(Map<Character, Byte> map1,
            Map<Character, Byte> map2, Map<Character, Byte> map3) {
        return getDefaultFactory().newMutableMap(map1, map2, map3);
    }

    public static  HashCharByteMap newMutableMap(Map<Character, Byte> map1,
            Map<Character, Byte> map2, Map<Character, Byte> map3,
            Map<Character, Byte> map4) {
        return getDefaultFactory().newMutableMap(map1, map2, map3, map4);
    }

    public static  HashCharByteMap newMutableMap(Map<Character, Byte> map1,
            Map<Character, Byte> map2, Map<Character, Byte> map3,
            Map<Character, Byte> map4, Map<Character, Byte> map5) {
        return getDefaultFactory().newMutableMap(map1, map2, map3, map4, map5);
    }


    public static  HashCharByteMap newMutableMap(
            net.openhft.function.Consumer<CharByteConsumer> entriesSupplier) {
        return getDefaultFactory().newMutableMap(entriesSupplier);
    }

    public static  HashCharByteMap newMutableMap(
            net.openhft.function.Consumer<CharByteConsumer> entriesSupplier,
            int expectedSize) {
        return getDefaultFactory().newMutableMap(entriesSupplier, expectedSize);
    }

    public static  HashCharByteMap newMutableMap(
            char[] keys, byte[] values) {
        return getDefaultFactory().newMutableMap(keys, values);
    }

    public static  HashCharByteMap newMutableMap(
            char[] keys, byte[] values, int expectedSize) {
        return getDefaultFactory().newMutableMap(keys, values, expectedSize);
    }

    public static  HashCharByteMap newMutableMap(
            Character[] keys, Byte[] values) {
        return getDefaultFactory().newMutableMap(keys, values);
    }

    public static  HashCharByteMap newMutableMap(
            Character[] keys, Byte[] values, int expectedSize) {
        return getDefaultFactory().newMutableMap(keys, values, expectedSize);
    }

    public static  HashCharByteMap newMutableMap(Iterable<Character> keys,
            Iterable<Byte> values) {
        return getDefaultFactory().newMutableMap(keys, values);
    }

    public static  HashCharByteMap newMutableMap(Iterable<Character> keys,
            Iterable<Byte> values, int expectedSize) {
        return getDefaultFactory().newMutableMap(keys, values, expectedSize);
    }


    public static  HashCharByteMap newMutableMapOf(
            char k1, byte v1) {
        return getDefaultFactory().newMutableMapOf(k1, v1);
    }

    public static  HashCharByteMap newMutableMapOf(
            char k1, byte v1, char k2, byte v2) {
        return getDefaultFactory().newMutableMapOf(k1, v1, k2, v2);
    }

    public static  HashCharByteMap newMutableMapOf(
            char k1, byte v1, char k2, byte v2,
            char k3, byte v3) {
        return getDefaultFactory().newMutableMapOf(k1, v1, k2, v2, k3, v3);
    }

    public static  HashCharByteMap newMutableMapOf(
            char k1, byte v1, char k2, byte v2,
            char k3, byte v3, char k4, byte v4) {
        return getDefaultFactory().newMutableMapOf(k1, v1, k2, v2, k3, v3, k4, v4);
    }

    public static  HashCharByteMap newMutableMapOf(
            char k1, byte v1, char k2, byte v2,
            char k3, byte v3, char k4, byte v4,
            char k5, byte v5) {
        return getDefaultFactory().newMutableMapOf(k1, v1, k2, v2, k3, v3, k4, v4, k5, v5);
    }

    
    


    public static  HashCharByteMap newUpdatableMap(Map<Character, Byte> map1,
            Map<Character, Byte> map2, int expectedSize) {
        return getDefaultFactory().newUpdatableMap(map1, map2, expectedSize);
    }

    public static  HashCharByteMap newUpdatableMap(Map<Character, Byte> map1,
            Map<Character, Byte> map2, Map<Character, Byte> map3, int expectedSize) {
        return getDefaultFactory().newUpdatableMap(map1, map2, map3, expectedSize);
    }

    public static  HashCharByteMap newUpdatableMap(Map<Character, Byte> map1,
            Map<Character, Byte> map2, Map<Character, Byte> map3,
            Map<Character, Byte> map4, int expectedSize) {
        return getDefaultFactory().newUpdatableMap(map1, map2, map3, map4, expectedSize);
    }

    public static  HashCharByteMap newUpdatableMap(Map<Character, Byte> map1,
            Map<Character, Byte> map2, Map<Character, Byte> map3,
            Map<Character, Byte> map4, Map<Character, Byte> map5, int expectedSize) {
        return getDefaultFactory().newUpdatableMap(map1, map2, map3, map4, map5, expectedSize);
    }

    
    

    
    public static  HashCharByteMap newUpdatableMap(
            Map<Character, Byte> map) {
        return getDefaultFactory().newUpdatableMap(map);
    }

    public static  HashCharByteMap newUpdatableMap(Map<Character, Byte> map1,
            Map<Character, Byte> map2) {
        return getDefaultFactory().newUpdatableMap(map1, map2);
    }

    public static  HashCharByteMap newUpdatableMap(Map<Character, Byte> map1,
            Map<Character, Byte> map2, Map<Character, Byte> map3) {
        return getDefaultFactory().newUpdatableMap(map1, map2, map3);
    }

    public static  HashCharByteMap newUpdatableMap(Map<Character, Byte> map1,
            Map<Character, Byte> map2, Map<Character, Byte> map3,
            Map<Character, Byte> map4) {
        return getDefaultFactory().newUpdatableMap(map1, map2, map3, map4);
    }

    public static  HashCharByteMap newUpdatableMap(Map<Character, Byte> map1,
            Map<Character, Byte> map2, Map<Character, Byte> map3,
            Map<Character, Byte> map4, Map<Character, Byte> map5) {
        return getDefaultFactory().newUpdatableMap(map1, map2, map3, map4, map5);
    }


    public static  HashCharByteMap newUpdatableMap(
            net.openhft.function.Consumer<CharByteConsumer> entriesSupplier) {
        return getDefaultFactory().newUpdatableMap(entriesSupplier);
    }

    public static  HashCharByteMap newUpdatableMap(
            net.openhft.function.Consumer<CharByteConsumer> entriesSupplier,
            int expectedSize) {
        return getDefaultFactory().newUpdatableMap(entriesSupplier, expectedSize);
    }

    public static  HashCharByteMap newUpdatableMap(
            char[] keys, byte[] values) {
        return getDefaultFactory().newUpdatableMap(keys, values);
    }

    public static  HashCharByteMap newUpdatableMap(
            char[] keys, byte[] values, int expectedSize) {
        return getDefaultFactory().newUpdatableMap(keys, values, expectedSize);
    }

    public static  HashCharByteMap newUpdatableMap(
            Character[] keys, Byte[] values) {
        return getDefaultFactory().newUpdatableMap(keys, values);
    }

    public static  HashCharByteMap newUpdatableMap(
            Character[] keys, Byte[] values, int expectedSize) {
        return getDefaultFactory().newUpdatableMap(keys, values, expectedSize);
    }

    public static  HashCharByteMap newUpdatableMap(Iterable<Character> keys,
            Iterable<Byte> values) {
        return getDefaultFactory().newUpdatableMap(keys, values);
    }

    public static  HashCharByteMap newUpdatableMap(Iterable<Character> keys,
            Iterable<Byte> values, int expectedSize) {
        return getDefaultFactory().newUpdatableMap(keys, values, expectedSize);
    }


    public static  HashCharByteMap newUpdatableMapOf(
            char k1, byte v1) {
        return getDefaultFactory().newUpdatableMapOf(k1, v1);
    }

    public static  HashCharByteMap newUpdatableMapOf(
            char k1, byte v1, char k2, byte v2) {
        return getDefaultFactory().newUpdatableMapOf(k1, v1, k2, v2);
    }

    public static  HashCharByteMap newUpdatableMapOf(
            char k1, byte v1, char k2, byte v2,
            char k3, byte v3) {
        return getDefaultFactory().newUpdatableMapOf(k1, v1, k2, v2, k3, v3);
    }

    public static  HashCharByteMap newUpdatableMapOf(
            char k1, byte v1, char k2, byte v2,
            char k3, byte v3, char k4, byte v4) {
        return getDefaultFactory().newUpdatableMapOf(k1, v1, k2, v2, k3, v3, k4, v4);
    }

    public static  HashCharByteMap newUpdatableMapOf(
            char k1, byte v1, char k2, byte v2,
            char k3, byte v3, char k4, byte v4,
            char k5, byte v5) {
        return getDefaultFactory().newUpdatableMapOf(k1, v1, k2, v2, k3, v3, k4, v4, k5, v5);
    }

    
    


    public static  HashCharByteMap newImmutableMap(Map<Character, Byte> map1,
            Map<Character, Byte> map2, int expectedSize) {
        return getDefaultFactory().newImmutableMap(map1, map2, expectedSize);
    }

    public static  HashCharByteMap newImmutableMap(Map<Character, Byte> map1,
            Map<Character, Byte> map2, Map<Character, Byte> map3, int expectedSize) {
        return getDefaultFactory().newImmutableMap(map1, map2, map3, expectedSize);
    }

    public static  HashCharByteMap newImmutableMap(Map<Character, Byte> map1,
            Map<Character, Byte> map2, Map<Character, Byte> map3,
            Map<Character, Byte> map4, int expectedSize) {
        return getDefaultFactory().newImmutableMap(map1, map2, map3, map4, expectedSize);
    }

    public static  HashCharByteMap newImmutableMap(Map<Character, Byte> map1,
            Map<Character, Byte> map2, Map<Character, Byte> map3,
            Map<Character, Byte> map4, Map<Character, Byte> map5, int expectedSize) {
        return getDefaultFactory().newImmutableMap(map1, map2, map3, map4, map5, expectedSize);
    }

    
    

    
    public static  HashCharByteMap newImmutableMap(
            Map<Character, Byte> map) {
        return getDefaultFactory().newImmutableMap(map);
    }

    public static  HashCharByteMap newImmutableMap(Map<Character, Byte> map1,
            Map<Character, Byte> map2) {
        return getDefaultFactory().newImmutableMap(map1, map2);
    }

    public static  HashCharByteMap newImmutableMap(Map<Character, Byte> map1,
            Map<Character, Byte> map2, Map<Character, Byte> map3) {
        return getDefaultFactory().newImmutableMap(map1, map2, map3);
    }

    public static  HashCharByteMap newImmutableMap(Map<Character, Byte> map1,
            Map<Character, Byte> map2, Map<Character, Byte> map3,
            Map<Character, Byte> map4) {
        return getDefaultFactory().newImmutableMap(map1, map2, map3, map4);
    }

    public static  HashCharByteMap newImmutableMap(Map<Character, Byte> map1,
            Map<Character, Byte> map2, Map<Character, Byte> map3,
            Map<Character, Byte> map4, Map<Character, Byte> map5) {
        return getDefaultFactory().newImmutableMap(map1, map2, map3, map4, map5);
    }


    public static  HashCharByteMap newImmutableMap(
            net.openhft.function.Consumer<CharByteConsumer> entriesSupplier) {
        return getDefaultFactory().newImmutableMap(entriesSupplier);
    }

    public static  HashCharByteMap newImmutableMap(
            net.openhft.function.Consumer<CharByteConsumer> entriesSupplier,
            int expectedSize) {
        return getDefaultFactory().newImmutableMap(entriesSupplier, expectedSize);
    }

    public static  HashCharByteMap newImmutableMap(
            char[] keys, byte[] values) {
        return getDefaultFactory().newImmutableMap(keys, values);
    }

    public static  HashCharByteMap newImmutableMap(
            char[] keys, byte[] values, int expectedSize) {
        return getDefaultFactory().newImmutableMap(keys, values, expectedSize);
    }

    public static  HashCharByteMap newImmutableMap(
            Character[] keys, Byte[] values) {
        return getDefaultFactory().newImmutableMap(keys, values);
    }

    public static  HashCharByteMap newImmutableMap(
            Character[] keys, Byte[] values, int expectedSize) {
        return getDefaultFactory().newImmutableMap(keys, values, expectedSize);
    }

    public static  HashCharByteMap newImmutableMap(Iterable<Character> keys,
            Iterable<Byte> values) {
        return getDefaultFactory().newImmutableMap(keys, values);
    }

    public static  HashCharByteMap newImmutableMap(Iterable<Character> keys,
            Iterable<Byte> values, int expectedSize) {
        return getDefaultFactory().newImmutableMap(keys, values, expectedSize);
    }


    public static  HashCharByteMap newImmutableMapOf(
            char k1, byte v1) {
        return getDefaultFactory().newImmutableMapOf(k1, v1);
    }

    public static  HashCharByteMap newImmutableMapOf(
            char k1, byte v1, char k2, byte v2) {
        return getDefaultFactory().newImmutableMapOf(k1, v1, k2, v2);
    }

    public static  HashCharByteMap newImmutableMapOf(
            char k1, byte v1, char k2, byte v2,
            char k3, byte v3) {
        return getDefaultFactory().newImmutableMapOf(k1, v1, k2, v2, k3, v3);
    }

    public static  HashCharByteMap newImmutableMapOf(
            char k1, byte v1, char k2, byte v2,
            char k3, byte v3, char k4, byte v4) {
        return getDefaultFactory().newImmutableMapOf(k1, v1, k2, v2, k3, v3, k4, v4);
    }

    public static  HashCharByteMap newImmutableMapOf(
            char k1, byte v1, char k2, byte v2,
            char k3, byte v3, char k4, byte v4,
            char k5, byte v5) {
        return getDefaultFactory().newImmutableMapOf(k1, v1, k2, v2, k3, v3, k4, v4, k5, v5);
    }

    private HashCharByteMaps() {}
}

