/*
 * Copyright 2014 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.openhft.collect.map.hash;

import net.openhft.collect.*;
import net.openhft.collect.hash.*;
import net.openhft.function.CharByteConsumer;
import net.openhft.collect.map.*;
import javax.annotation.Nullable;

import java.util.Map;


/**
 * An immutable factory of {@code HashCharByteMaps}
 *
 * @see HashCharByteMap
 * @see HashCharByteMaps#getDefaultFactory()
 */
public interface HashCharByteMapFactory extends CharByteMapFactory
        , CharHashFactory<HashCharByteMapFactory>
         {

    

    

    

    

    

    
    

    
    


    @Override
    HashCharByteMapFactory withDefaultValue(byte defaultValue);

    @Override
     HashCharByteMap newMutableMap();

    @Override
     HashCharByteMap newMutableMap(int expectedSize);

    


    @Override
     HashCharByteMap newMutableMap(Map<Character, Byte> map1,
            Map<Character, Byte> map2, int expectedSize);

    @Override
     HashCharByteMap newMutableMap(Map<Character, Byte> map1,
            Map<Character, Byte> map2, Map<Character, Byte> map3, int expectedSize);

    @Override
     HashCharByteMap newMutableMap(Map<Character, Byte> map1,
            Map<Character, Byte> map2, Map<Character, Byte> map3,
            Map<Character, Byte> map4, int expectedSize);

    @Override
     HashCharByteMap newMutableMap(Map<Character, Byte> map1,
            Map<Character, Byte> map2, Map<Character, Byte> map3,
            Map<Character, Byte> map4, Map<Character, Byte> map5, int expectedSize);

    

    
    @Override
     HashCharByteMap newMutableMap(Map<Character, Byte> map);

    @Override
     HashCharByteMap newMutableMap(Map<Character, Byte> map1,
            Map<Character, Byte> map2);

    @Override
     HashCharByteMap newMutableMap(Map<Character, Byte> map1,
            Map<Character, Byte> map2, Map<Character, Byte> map3);

    @Override
     HashCharByteMap newMutableMap(Map<Character, Byte> map1,
            Map<Character, Byte> map2, Map<Character, Byte> map3,
            Map<Character, Byte> map4);

    @Override
     HashCharByteMap newMutableMap(Map<Character, Byte> map1,
            Map<Character, Byte> map2, Map<Character, Byte> map3,
            Map<Character, Byte> map4, Map<Character, Byte> map5);


    @Override
     HashCharByteMap newMutableMap(
            net.openhft.function.Consumer<CharByteConsumer> entriesSupplier);

    @Override
     HashCharByteMap newMutableMap(
            net.openhft.function.Consumer<CharByteConsumer> entriesSupplier,
            int expectedSize);

    @Override
     HashCharByteMap newMutableMap(char[] keys, byte[] values);

    @Override
     HashCharByteMap newMutableMap(char[] keys, byte[] values,
            int expectedSize);

    @Override
     HashCharByteMap newMutableMap(
            Character[] keys, Byte[] values);

    @Override
     HashCharByteMap newMutableMap(
            Character[] keys, Byte[] values, int expectedSize);

    @Override
     HashCharByteMap newMutableMap(Iterable<Character> keys,
            Iterable<Byte> values);

    @Override
     HashCharByteMap newMutableMap(Iterable<Character> keys,
            Iterable<Byte> values, int expectedSize);


    @Override
     HashCharByteMap newMutableMapOf(char k1, byte v1);

    @Override
     HashCharByteMap newMutableMapOf(char k1, byte v1,
            char k2, byte v2);

    @Override
     HashCharByteMap newMutableMapOf(char k1, byte v1,
            char k2, byte v2, char k3, byte v3);

    @Override
     HashCharByteMap newMutableMapOf(char k1, byte v1,
            char k2, byte v2, char k3, byte v3,
            char k4, byte v4);

    @Override
     HashCharByteMap newMutableMapOf(char k1, byte v1,
            char k2, byte v2, char k3, byte v3,
            char k4, byte v4, char k5, byte v5);
    @Override
     HashCharByteMap newUpdatableMap();

    @Override
     HashCharByteMap newUpdatableMap(int expectedSize);

    


    @Override
     HashCharByteMap newUpdatableMap(Map<Character, Byte> map1,
            Map<Character, Byte> map2, int expectedSize);

    @Override
     HashCharByteMap newUpdatableMap(Map<Character, Byte> map1,
            Map<Character, Byte> map2, Map<Character, Byte> map3, int expectedSize);

    @Override
     HashCharByteMap newUpdatableMap(Map<Character, Byte> map1,
            Map<Character, Byte> map2, Map<Character, Byte> map3,
            Map<Character, Byte> map4, int expectedSize);

    @Override
     HashCharByteMap newUpdatableMap(Map<Character, Byte> map1,
            Map<Character, Byte> map2, Map<Character, Byte> map3,
            Map<Character, Byte> map4, Map<Character, Byte> map5, int expectedSize);

    

    
    @Override
     HashCharByteMap newUpdatableMap(Map<Character, Byte> map);

    @Override
     HashCharByteMap newUpdatableMap(Map<Character, Byte> map1,
            Map<Character, Byte> map2);

    @Override
     HashCharByteMap newUpdatableMap(Map<Character, Byte> map1,
            Map<Character, Byte> map2, Map<Character, Byte> map3);

    @Override
     HashCharByteMap newUpdatableMap(Map<Character, Byte> map1,
            Map<Character, Byte> map2, Map<Character, Byte> map3,
            Map<Character, Byte> map4);

    @Override
     HashCharByteMap newUpdatableMap(Map<Character, Byte> map1,
            Map<Character, Byte> map2, Map<Character, Byte> map3,
            Map<Character, Byte> map4, Map<Character, Byte> map5);


    @Override
     HashCharByteMap newUpdatableMap(
            net.openhft.function.Consumer<CharByteConsumer> entriesSupplier);

    @Override
     HashCharByteMap newUpdatableMap(
            net.openhft.function.Consumer<CharByteConsumer> entriesSupplier,
            int expectedSize);

    @Override
     HashCharByteMap newUpdatableMap(char[] keys, byte[] values);

    @Override
     HashCharByteMap newUpdatableMap(char[] keys, byte[] values,
            int expectedSize);

    @Override
     HashCharByteMap newUpdatableMap(
            Character[] keys, Byte[] values);

    @Override
     HashCharByteMap newUpdatableMap(
            Character[] keys, Byte[] values, int expectedSize);

    @Override
     HashCharByteMap newUpdatableMap(Iterable<Character> keys,
            Iterable<Byte> values);

    @Override
     HashCharByteMap newUpdatableMap(Iterable<Character> keys,
            Iterable<Byte> values, int expectedSize);


    @Override
     HashCharByteMap newUpdatableMapOf(char k1, byte v1);

    @Override
     HashCharByteMap newUpdatableMapOf(char k1, byte v1,
            char k2, byte v2);

    @Override
     HashCharByteMap newUpdatableMapOf(char k1, byte v1,
            char k2, byte v2, char k3, byte v3);

    @Override
     HashCharByteMap newUpdatableMapOf(char k1, byte v1,
            char k2, byte v2, char k3, byte v3,
            char k4, byte v4);

    @Override
     HashCharByteMap newUpdatableMapOf(char k1, byte v1,
            char k2, byte v2, char k3, byte v3,
            char k4, byte v4, char k5, byte v5);

    


    @Override
     HashCharByteMap newImmutableMap(Map<Character, Byte> map1,
            Map<Character, Byte> map2, int expectedSize);

    @Override
     HashCharByteMap newImmutableMap(Map<Character, Byte> map1,
            Map<Character, Byte> map2, Map<Character, Byte> map3, int expectedSize);

    @Override
     HashCharByteMap newImmutableMap(Map<Character, Byte> map1,
            Map<Character, Byte> map2, Map<Character, Byte> map3,
            Map<Character, Byte> map4, int expectedSize);

    @Override
     HashCharByteMap newImmutableMap(Map<Character, Byte> map1,
            Map<Character, Byte> map2, Map<Character, Byte> map3,
            Map<Character, Byte> map4, Map<Character, Byte> map5, int expectedSize);

    

    
    @Override
     HashCharByteMap newImmutableMap(Map<Character, Byte> map);

    @Override
     HashCharByteMap newImmutableMap(Map<Character, Byte> map1,
            Map<Character, Byte> map2);

    @Override
     HashCharByteMap newImmutableMap(Map<Character, Byte> map1,
            Map<Character, Byte> map2, Map<Character, Byte> map3);

    @Override
     HashCharByteMap newImmutableMap(Map<Character, Byte> map1,
            Map<Character, Byte> map2, Map<Character, Byte> map3,
            Map<Character, Byte> map4);

    @Override
     HashCharByteMap newImmutableMap(Map<Character, Byte> map1,
            Map<Character, Byte> map2, Map<Character, Byte> map3,
            Map<Character, Byte> map4, Map<Character, Byte> map5);


    @Override
     HashCharByteMap newImmutableMap(
            net.openhft.function.Consumer<CharByteConsumer> entriesSupplier);

    @Override
     HashCharByteMap newImmutableMap(
            net.openhft.function.Consumer<CharByteConsumer> entriesSupplier,
            int expectedSize);

    @Override
     HashCharByteMap newImmutableMap(char[] keys, byte[] values);

    @Override
     HashCharByteMap newImmutableMap(char[] keys, byte[] values,
            int expectedSize);

    @Override
     HashCharByteMap newImmutableMap(
            Character[] keys, Byte[] values);

    @Override
     HashCharByteMap newImmutableMap(
            Character[] keys, Byte[] values, int expectedSize);

    @Override
     HashCharByteMap newImmutableMap(Iterable<Character> keys,
            Iterable<Byte> values);

    @Override
     HashCharByteMap newImmutableMap(Iterable<Character> keys,
            Iterable<Byte> values, int expectedSize);


    @Override
     HashCharByteMap newImmutableMapOf(char k1, byte v1);

    @Override
     HashCharByteMap newImmutableMapOf(char k1, byte v1,
            char k2, byte v2);

    @Override
     HashCharByteMap newImmutableMapOf(char k1, byte v1,
            char k2, byte v2, char k3, byte v3);

    @Override
     HashCharByteMap newImmutableMapOf(char k1, byte v1,
            char k2, byte v2, char k3, byte v3,
            char k4, byte v4);

    @Override
     HashCharByteMap newImmutableMapOf(char k1, byte v1,
            char k2, byte v2, char k3, byte v3,
            char k4, byte v4, char k5, byte v5);
}

