/*
 * Copyright 2014 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.openhft.collect.map.hash;

import net.openhft.collect.*;
import net.openhft.collect.hash.*;
import net.openhft.function.ByteShortConsumer;
import net.openhft.collect.map.*;
import javax.annotation.Nullable;

import java.util.Map;


/**
 * An immutable factory of {@code HashByteShortMaps}
 *
 * @see HashByteShortMap
 * @see HashByteShortMaps#getDefaultFactory()
 */
public interface HashByteShortMapFactory extends ByteShortMapFactory
        , ByteHashFactory<HashByteShortMapFactory>
         {

    

    

    

    

    

    
    

    
    


    @Override
    HashByteShortMapFactory withDefaultValue(short defaultValue);

    @Override
     HashByteShortMap newMutableMap();

    @Override
     HashByteShortMap newMutableMap(int expectedSize);

    


    @Override
     HashByteShortMap newMutableMap(Map<Byte, Short> map1,
            Map<Byte, Short> map2, int expectedSize);

    @Override
     HashByteShortMap newMutableMap(Map<Byte, Short> map1,
            Map<Byte, Short> map2, Map<Byte, Short> map3, int expectedSize);

    @Override
     HashByteShortMap newMutableMap(Map<Byte, Short> map1,
            Map<Byte, Short> map2, Map<Byte, Short> map3,
            Map<Byte, Short> map4, int expectedSize);

    @Override
     HashByteShortMap newMutableMap(Map<Byte, Short> map1,
            Map<Byte, Short> map2, Map<Byte, Short> map3,
            Map<Byte, Short> map4, Map<Byte, Short> map5, int expectedSize);

    

    
    @Override
     HashByteShortMap newMutableMap(Map<Byte, Short> map);

    @Override
     HashByteShortMap newMutableMap(Map<Byte, Short> map1,
            Map<Byte, Short> map2);

    @Override
     HashByteShortMap newMutableMap(Map<Byte, Short> map1,
            Map<Byte, Short> map2, Map<Byte, Short> map3);

    @Override
     HashByteShortMap newMutableMap(Map<Byte, Short> map1,
            Map<Byte, Short> map2, Map<Byte, Short> map3,
            Map<Byte, Short> map4);

    @Override
     HashByteShortMap newMutableMap(Map<Byte, Short> map1,
            Map<Byte, Short> map2, Map<Byte, Short> map3,
            Map<Byte, Short> map4, Map<Byte, Short> map5);


    @Override
     HashByteShortMap newMutableMap(
            net.openhft.function.Consumer<ByteShortConsumer> entriesSupplier);

    @Override
     HashByteShortMap newMutableMap(
            net.openhft.function.Consumer<ByteShortConsumer> entriesSupplier,
            int expectedSize);

    @Override
     HashByteShortMap newMutableMap(byte[] keys, short[] values);

    @Override
     HashByteShortMap newMutableMap(byte[] keys, short[] values,
            int expectedSize);

    @Override
     HashByteShortMap newMutableMap(
            Byte[] keys, Short[] values);

    @Override
     HashByteShortMap newMutableMap(
            Byte[] keys, Short[] values, int expectedSize);

    @Override
     HashByteShortMap newMutableMap(Iterable<Byte> keys,
            Iterable<Short> values);

    @Override
     HashByteShortMap newMutableMap(Iterable<Byte> keys,
            Iterable<Short> values, int expectedSize);


    @Override
     HashByteShortMap newMutableMapOf(byte k1, short v1);

    @Override
     HashByteShortMap newMutableMapOf(byte k1, short v1,
            byte k2, short v2);

    @Override
     HashByteShortMap newMutableMapOf(byte k1, short v1,
            byte k2, short v2, byte k3, short v3);

    @Override
     HashByteShortMap newMutableMapOf(byte k1, short v1,
            byte k2, short v2, byte k3, short v3,
            byte k4, short v4);

    @Override
     HashByteShortMap newMutableMapOf(byte k1, short v1,
            byte k2, short v2, byte k3, short v3,
            byte k4, short v4, byte k5, short v5);
    @Override
     HashByteShortMap newUpdatableMap();

    @Override
     HashByteShortMap newUpdatableMap(int expectedSize);

    


    @Override
     HashByteShortMap newUpdatableMap(Map<Byte, Short> map1,
            Map<Byte, Short> map2, int expectedSize);

    @Override
     HashByteShortMap newUpdatableMap(Map<Byte, Short> map1,
            Map<Byte, Short> map2, Map<Byte, Short> map3, int expectedSize);

    @Override
     HashByteShortMap newUpdatableMap(Map<Byte, Short> map1,
            Map<Byte, Short> map2, Map<Byte, Short> map3,
            Map<Byte, Short> map4, int expectedSize);

    @Override
     HashByteShortMap newUpdatableMap(Map<Byte, Short> map1,
            Map<Byte, Short> map2, Map<Byte, Short> map3,
            Map<Byte, Short> map4, Map<Byte, Short> map5, int expectedSize);

    

    
    @Override
     HashByteShortMap newUpdatableMap(Map<Byte, Short> map);

    @Override
     HashByteShortMap newUpdatableMap(Map<Byte, Short> map1,
            Map<Byte, Short> map2);

    @Override
     HashByteShortMap newUpdatableMap(Map<Byte, Short> map1,
            Map<Byte, Short> map2, Map<Byte, Short> map3);

    @Override
     HashByteShortMap newUpdatableMap(Map<Byte, Short> map1,
            Map<Byte, Short> map2, Map<Byte, Short> map3,
            Map<Byte, Short> map4);

    @Override
     HashByteShortMap newUpdatableMap(Map<Byte, Short> map1,
            Map<Byte, Short> map2, Map<Byte, Short> map3,
            Map<Byte, Short> map4, Map<Byte, Short> map5);


    @Override
     HashByteShortMap newUpdatableMap(
            net.openhft.function.Consumer<ByteShortConsumer> entriesSupplier);

    @Override
     HashByteShortMap newUpdatableMap(
            net.openhft.function.Consumer<ByteShortConsumer> entriesSupplier,
            int expectedSize);

    @Override
     HashByteShortMap newUpdatableMap(byte[] keys, short[] values);

    @Override
     HashByteShortMap newUpdatableMap(byte[] keys, short[] values,
            int expectedSize);

    @Override
     HashByteShortMap newUpdatableMap(
            Byte[] keys, Short[] values);

    @Override
     HashByteShortMap newUpdatableMap(
            Byte[] keys, Short[] values, int expectedSize);

    @Override
     HashByteShortMap newUpdatableMap(Iterable<Byte> keys,
            Iterable<Short> values);

    @Override
     HashByteShortMap newUpdatableMap(Iterable<Byte> keys,
            Iterable<Short> values, int expectedSize);


    @Override
     HashByteShortMap newUpdatableMapOf(byte k1, short v1);

    @Override
     HashByteShortMap newUpdatableMapOf(byte k1, short v1,
            byte k2, short v2);

    @Override
     HashByteShortMap newUpdatableMapOf(byte k1, short v1,
            byte k2, short v2, byte k3, short v3);

    @Override
     HashByteShortMap newUpdatableMapOf(byte k1, short v1,
            byte k2, short v2, byte k3, short v3,
            byte k4, short v4);

    @Override
     HashByteShortMap newUpdatableMapOf(byte k1, short v1,
            byte k2, short v2, byte k3, short v3,
            byte k4, short v4, byte k5, short v5);

    


    @Override
     HashByteShortMap newImmutableMap(Map<Byte, Short> map1,
            Map<Byte, Short> map2, int expectedSize);

    @Override
     HashByteShortMap newImmutableMap(Map<Byte, Short> map1,
            Map<Byte, Short> map2, Map<Byte, Short> map3, int expectedSize);

    @Override
     HashByteShortMap newImmutableMap(Map<Byte, Short> map1,
            Map<Byte, Short> map2, Map<Byte, Short> map3,
            Map<Byte, Short> map4, int expectedSize);

    @Override
     HashByteShortMap newImmutableMap(Map<Byte, Short> map1,
            Map<Byte, Short> map2, Map<Byte, Short> map3,
            Map<Byte, Short> map4, Map<Byte, Short> map5, int expectedSize);

    

    
    @Override
     HashByteShortMap newImmutableMap(Map<Byte, Short> map);

    @Override
     HashByteShortMap newImmutableMap(Map<Byte, Short> map1,
            Map<Byte, Short> map2);

    @Override
     HashByteShortMap newImmutableMap(Map<Byte, Short> map1,
            Map<Byte, Short> map2, Map<Byte, Short> map3);

    @Override
     HashByteShortMap newImmutableMap(Map<Byte, Short> map1,
            Map<Byte, Short> map2, Map<Byte, Short> map3,
            Map<Byte, Short> map4);

    @Override
     HashByteShortMap newImmutableMap(Map<Byte, Short> map1,
            Map<Byte, Short> map2, Map<Byte, Short> map3,
            Map<Byte, Short> map4, Map<Byte, Short> map5);


    @Override
     HashByteShortMap newImmutableMap(
            net.openhft.function.Consumer<ByteShortConsumer> entriesSupplier);

    @Override
     HashByteShortMap newImmutableMap(
            net.openhft.function.Consumer<ByteShortConsumer> entriesSupplier,
            int expectedSize);

    @Override
     HashByteShortMap newImmutableMap(byte[] keys, short[] values);

    @Override
     HashByteShortMap newImmutableMap(byte[] keys, short[] values,
            int expectedSize);

    @Override
     HashByteShortMap newImmutableMap(
            Byte[] keys, Short[] values);

    @Override
     HashByteShortMap newImmutableMap(
            Byte[] keys, Short[] values, int expectedSize);

    @Override
     HashByteShortMap newImmutableMap(Iterable<Byte> keys,
            Iterable<Short> values);

    @Override
     HashByteShortMap newImmutableMap(Iterable<Byte> keys,
            Iterable<Short> values, int expectedSize);


    @Override
     HashByteShortMap newImmutableMapOf(byte k1, short v1);

    @Override
     HashByteShortMap newImmutableMapOf(byte k1, short v1,
            byte k2, short v2);

    @Override
     HashByteShortMap newImmutableMapOf(byte k1, short v1,
            byte k2, short v2, byte k3, short v3);

    @Override
     HashByteShortMap newImmutableMapOf(byte k1, short v1,
            byte k2, short v2, byte k3, short v3,
            byte k4, short v4);

    @Override
     HashByteShortMap newImmutableMapOf(byte k1, short v1,
            byte k2, short v2, byte k3, short v3,
            byte k4, short v4, byte k5, short v5);
}

