/*
 * Copyright 2014 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.openhft.collect.map.hash;

import net.openhft.function.ByteObjConsumer;

import java.util.Map;
import java.util.ServiceLoader;


/**
 * This class consists only of static factory methods to construct {@code HashByteObjMap}s, and
 * the default {@link HashByteObjMapFactory} static provider ({@link #getDefaultFactory()}).
 *
 * @see HashByteObjMap
 */
public final class HashByteObjMaps {

    

    private static final ServiceLoader<HashByteObjMapFactory> LOADER =
            ServiceLoader.load(HashByteObjMapFactory.class);
    private static HashByteObjMapFactory<Object> defaultFactory = null;

    public static HashByteObjMapFactory<Object> getDefaultFactory() {
        if (defaultFactory != null) {
            return defaultFactory;
        } else {
            // synchronization?
            return defaultFactory = LOADER.iterator().next();
        }
    }

    

    

    

    public static <V> HashByteObjMap<V> newMutableMap() {
        return getDefaultFactory().newMutableMap();
    }

    public static <V> HashByteObjMap<V> newMutableMap(int expectedSize) {
        return getDefaultFactory().newMutableMap(expectedSize);
    }



    
    


    public static <V> HashByteObjMap<V> newMutableMap(Map<Byte, ? extends V> map1,
            Map<Byte, ? extends V> map2, int expectedSize) {
        return getDefaultFactory().newMutableMap(map1, map2, expectedSize);
    }

    public static <V> HashByteObjMap<V> newMutableMap(Map<Byte, ? extends V> map1,
            Map<Byte, ? extends V> map2, Map<Byte, ? extends V> map3, int expectedSize) {
        return getDefaultFactory().newMutableMap(map1, map2, map3, expectedSize);
    }

    public static <V> HashByteObjMap<V> newMutableMap(Map<Byte, ? extends V> map1,
            Map<Byte, ? extends V> map2, Map<Byte, ? extends V> map3,
            Map<Byte, ? extends V> map4, int expectedSize) {
        return getDefaultFactory().newMutableMap(map1, map2, map3, map4, expectedSize);
    }

    public static <V> HashByteObjMap<V> newMutableMap(Map<Byte, ? extends V> map1,
            Map<Byte, ? extends V> map2, Map<Byte, ? extends V> map3,
            Map<Byte, ? extends V> map4, Map<Byte, ? extends V> map5, int expectedSize) {
        return getDefaultFactory().newMutableMap(map1, map2, map3, map4, map5, expectedSize);
    }

    
    

    
    public static <V> HashByteObjMap<V> newMutableMap(
            Map<Byte, ? extends V> map) {
        return getDefaultFactory().newMutableMap(map);
    }

    public static <V> HashByteObjMap<V> newMutableMap(Map<Byte, ? extends V> map1,
            Map<Byte, ? extends V> map2) {
        return getDefaultFactory().newMutableMap(map1, map2);
    }

    public static <V> HashByteObjMap<V> newMutableMap(Map<Byte, ? extends V> map1,
            Map<Byte, ? extends V> map2, Map<Byte, ? extends V> map3) {
        return getDefaultFactory().newMutableMap(map1, map2, map3);
    }

    public static <V> HashByteObjMap<V> newMutableMap(Map<Byte, ? extends V> map1,
            Map<Byte, ? extends V> map2, Map<Byte, ? extends V> map3,
            Map<Byte, ? extends V> map4) {
        return getDefaultFactory().newMutableMap(map1, map2, map3, map4);
    }

    public static <V> HashByteObjMap<V> newMutableMap(Map<Byte, ? extends V> map1,
            Map<Byte, ? extends V> map2, Map<Byte, ? extends V> map3,
            Map<Byte, ? extends V> map4, Map<Byte, ? extends V> map5) {
        return getDefaultFactory().newMutableMap(map1, map2, map3, map4, map5);
    }


    public static <V> HashByteObjMap<V> newMutableMap(
            net.openhft.function.Consumer<ByteObjConsumer<V>> entriesSupplier) {
        return getDefaultFactory().newMutableMap(entriesSupplier);
    }

    public static <V> HashByteObjMap<V> newMutableMap(
            net.openhft.function.Consumer<ByteObjConsumer<V>> entriesSupplier,
            int expectedSize) {
        return getDefaultFactory().newMutableMap(entriesSupplier, expectedSize);
    }

    public static <V> HashByteObjMap<V> newMutableMap(
            byte[] keys, V[] values) {
        return getDefaultFactory().newMutableMap(keys, values);
    }

    public static <V> HashByteObjMap<V> newMutableMap(
            byte[] keys, V[] values, int expectedSize) {
        return getDefaultFactory().newMutableMap(keys, values, expectedSize);
    }

    public static <V> HashByteObjMap<V> newMutableMap(
            Byte[] keys, V[] values) {
        return getDefaultFactory().newMutableMap(keys, values);
    }

    public static <V> HashByteObjMap<V> newMutableMap(
            Byte[] keys, V[] values, int expectedSize) {
        return getDefaultFactory().newMutableMap(keys, values, expectedSize);
    }

    public static <V> HashByteObjMap<V> newMutableMap(Iterable<Byte> keys,
            Iterable<? extends V> values) {
        return getDefaultFactory().newMutableMap(keys, values);
    }

    public static <V> HashByteObjMap<V> newMutableMap(Iterable<Byte> keys,
            Iterable<? extends V> values, int expectedSize) {
        return getDefaultFactory().newMutableMap(keys, values, expectedSize);
    }


    public static <V> HashByteObjMap<V> newMutableMapOf(
            byte k1, V v1) {
        return getDefaultFactory().newMutableMapOf(k1, v1);
    }

    public static <V> HashByteObjMap<V> newMutableMapOf(
            byte k1, V v1, byte k2, V v2) {
        return getDefaultFactory().newMutableMapOf(k1, v1, k2, v2);
    }

    public static <V> HashByteObjMap<V> newMutableMapOf(
            byte k1, V v1, byte k2, V v2,
            byte k3, V v3) {
        return getDefaultFactory().newMutableMapOf(k1, v1, k2, v2, k3, v3);
    }

    public static <V> HashByteObjMap<V> newMutableMapOf(
            byte k1, V v1, byte k2, V v2,
            byte k3, V v3, byte k4, V v4) {
        return getDefaultFactory().newMutableMapOf(k1, v1, k2, v2, k3, v3, k4, v4);
    }

    public static <V> HashByteObjMap<V> newMutableMapOf(
            byte k1, V v1, byte k2, V v2,
            byte k3, V v3, byte k4, V v4,
            byte k5, V v5) {
        return getDefaultFactory().newMutableMapOf(k1, v1, k2, v2, k3, v3, k4, v4, k5, v5);
    }

    
    


    public static <V> HashByteObjMap<V> newUpdatableMap(Map<Byte, ? extends V> map1,
            Map<Byte, ? extends V> map2, int expectedSize) {
        return getDefaultFactory().newUpdatableMap(map1, map2, expectedSize);
    }

    public static <V> HashByteObjMap<V> newUpdatableMap(Map<Byte, ? extends V> map1,
            Map<Byte, ? extends V> map2, Map<Byte, ? extends V> map3, int expectedSize) {
        return getDefaultFactory().newUpdatableMap(map1, map2, map3, expectedSize);
    }

    public static <V> HashByteObjMap<V> newUpdatableMap(Map<Byte, ? extends V> map1,
            Map<Byte, ? extends V> map2, Map<Byte, ? extends V> map3,
            Map<Byte, ? extends V> map4, int expectedSize) {
        return getDefaultFactory().newUpdatableMap(map1, map2, map3, map4, expectedSize);
    }

    public static <V> HashByteObjMap<V> newUpdatableMap(Map<Byte, ? extends V> map1,
            Map<Byte, ? extends V> map2, Map<Byte, ? extends V> map3,
            Map<Byte, ? extends V> map4, Map<Byte, ? extends V> map5, int expectedSize) {
        return getDefaultFactory().newUpdatableMap(map1, map2, map3, map4, map5, expectedSize);
    }

    
    

    
    public static <V> HashByteObjMap<V> newUpdatableMap(
            Map<Byte, ? extends V> map) {
        return getDefaultFactory().newUpdatableMap(map);
    }

    public static <V> HashByteObjMap<V> newUpdatableMap(Map<Byte, ? extends V> map1,
            Map<Byte, ? extends V> map2) {
        return getDefaultFactory().newUpdatableMap(map1, map2);
    }

    public static <V> HashByteObjMap<V> newUpdatableMap(Map<Byte, ? extends V> map1,
            Map<Byte, ? extends V> map2, Map<Byte, ? extends V> map3) {
        return getDefaultFactory().newUpdatableMap(map1, map2, map3);
    }

    public static <V> HashByteObjMap<V> newUpdatableMap(Map<Byte, ? extends V> map1,
            Map<Byte, ? extends V> map2, Map<Byte, ? extends V> map3,
            Map<Byte, ? extends V> map4) {
        return getDefaultFactory().newUpdatableMap(map1, map2, map3, map4);
    }

    public static <V> HashByteObjMap<V> newUpdatableMap(Map<Byte, ? extends V> map1,
            Map<Byte, ? extends V> map2, Map<Byte, ? extends V> map3,
            Map<Byte, ? extends V> map4, Map<Byte, ? extends V> map5) {
        return getDefaultFactory().newUpdatableMap(map1, map2, map3, map4, map5);
    }


    public static <V> HashByteObjMap<V> newUpdatableMap(
            net.openhft.function.Consumer<ByteObjConsumer<V>> entriesSupplier) {
        return getDefaultFactory().newUpdatableMap(entriesSupplier);
    }

    public static <V> HashByteObjMap<V> newUpdatableMap(
            net.openhft.function.Consumer<ByteObjConsumer<V>> entriesSupplier,
            int expectedSize) {
        return getDefaultFactory().newUpdatableMap(entriesSupplier, expectedSize);
    }

    public static <V> HashByteObjMap<V> newUpdatableMap(
            byte[] keys, V[] values) {
        return getDefaultFactory().newUpdatableMap(keys, values);
    }

    public static <V> HashByteObjMap<V> newUpdatableMap(
            byte[] keys, V[] values, int expectedSize) {
        return getDefaultFactory().newUpdatableMap(keys, values, expectedSize);
    }

    public static <V> HashByteObjMap<V> newUpdatableMap(
            Byte[] keys, V[] values) {
        return getDefaultFactory().newUpdatableMap(keys, values);
    }

    public static <V> HashByteObjMap<V> newUpdatableMap(
            Byte[] keys, V[] values, int expectedSize) {
        return getDefaultFactory().newUpdatableMap(keys, values, expectedSize);
    }

    public static <V> HashByteObjMap<V> newUpdatableMap(Iterable<Byte> keys,
            Iterable<? extends V> values) {
        return getDefaultFactory().newUpdatableMap(keys, values);
    }

    public static <V> HashByteObjMap<V> newUpdatableMap(Iterable<Byte> keys,
            Iterable<? extends V> values, int expectedSize) {
        return getDefaultFactory().newUpdatableMap(keys, values, expectedSize);
    }


    public static <V> HashByteObjMap<V> newUpdatableMapOf(
            byte k1, V v1) {
        return getDefaultFactory().newUpdatableMapOf(k1, v1);
    }

    public static <V> HashByteObjMap<V> newUpdatableMapOf(
            byte k1, V v1, byte k2, V v2) {
        return getDefaultFactory().newUpdatableMapOf(k1, v1, k2, v2);
    }

    public static <V> HashByteObjMap<V> newUpdatableMapOf(
            byte k1, V v1, byte k2, V v2,
            byte k3, V v3) {
        return getDefaultFactory().newUpdatableMapOf(k1, v1, k2, v2, k3, v3);
    }

    public static <V> HashByteObjMap<V> newUpdatableMapOf(
            byte k1, V v1, byte k2, V v2,
            byte k3, V v3, byte k4, V v4) {
        return getDefaultFactory().newUpdatableMapOf(k1, v1, k2, v2, k3, v3, k4, v4);
    }

    public static <V> HashByteObjMap<V> newUpdatableMapOf(
            byte k1, V v1, byte k2, V v2,
            byte k3, V v3, byte k4, V v4,
            byte k5, V v5) {
        return getDefaultFactory().newUpdatableMapOf(k1, v1, k2, v2, k3, v3, k4, v4, k5, v5);
    }

    
    


    public static <V> HashByteObjMap<V> newImmutableMap(Map<Byte, ? extends V> map1,
            Map<Byte, ? extends V> map2, int expectedSize) {
        return getDefaultFactory().newImmutableMap(map1, map2, expectedSize);
    }

    public static <V> HashByteObjMap<V> newImmutableMap(Map<Byte, ? extends V> map1,
            Map<Byte, ? extends V> map2, Map<Byte, ? extends V> map3, int expectedSize) {
        return getDefaultFactory().newImmutableMap(map1, map2, map3, expectedSize);
    }

    public static <V> HashByteObjMap<V> newImmutableMap(Map<Byte, ? extends V> map1,
            Map<Byte, ? extends V> map2, Map<Byte, ? extends V> map3,
            Map<Byte, ? extends V> map4, int expectedSize) {
        return getDefaultFactory().newImmutableMap(map1, map2, map3, map4, expectedSize);
    }

    public static <V> HashByteObjMap<V> newImmutableMap(Map<Byte, ? extends V> map1,
            Map<Byte, ? extends V> map2, Map<Byte, ? extends V> map3,
            Map<Byte, ? extends V> map4, Map<Byte, ? extends V> map5, int expectedSize) {
        return getDefaultFactory().newImmutableMap(map1, map2, map3, map4, map5, expectedSize);
    }

    
    

    
    public static <V> HashByteObjMap<V> newImmutableMap(
            Map<Byte, ? extends V> map) {
        return getDefaultFactory().newImmutableMap(map);
    }

    public static <V> HashByteObjMap<V> newImmutableMap(Map<Byte, ? extends V> map1,
            Map<Byte, ? extends V> map2) {
        return getDefaultFactory().newImmutableMap(map1, map2);
    }

    public static <V> HashByteObjMap<V> newImmutableMap(Map<Byte, ? extends V> map1,
            Map<Byte, ? extends V> map2, Map<Byte, ? extends V> map3) {
        return getDefaultFactory().newImmutableMap(map1, map2, map3);
    }

    public static <V> HashByteObjMap<V> newImmutableMap(Map<Byte, ? extends V> map1,
            Map<Byte, ? extends V> map2, Map<Byte, ? extends V> map3,
            Map<Byte, ? extends V> map4) {
        return getDefaultFactory().newImmutableMap(map1, map2, map3, map4);
    }

    public static <V> HashByteObjMap<V> newImmutableMap(Map<Byte, ? extends V> map1,
            Map<Byte, ? extends V> map2, Map<Byte, ? extends V> map3,
            Map<Byte, ? extends V> map4, Map<Byte, ? extends V> map5) {
        return getDefaultFactory().newImmutableMap(map1, map2, map3, map4, map5);
    }


    public static <V> HashByteObjMap<V> newImmutableMap(
            net.openhft.function.Consumer<ByteObjConsumer<V>> entriesSupplier) {
        return getDefaultFactory().newImmutableMap(entriesSupplier);
    }

    public static <V> HashByteObjMap<V> newImmutableMap(
            net.openhft.function.Consumer<ByteObjConsumer<V>> entriesSupplier,
            int expectedSize) {
        return getDefaultFactory().newImmutableMap(entriesSupplier, expectedSize);
    }

    public static <V> HashByteObjMap<V> newImmutableMap(
            byte[] keys, V[] values) {
        return getDefaultFactory().newImmutableMap(keys, values);
    }

    public static <V> HashByteObjMap<V> newImmutableMap(
            byte[] keys, V[] values, int expectedSize) {
        return getDefaultFactory().newImmutableMap(keys, values, expectedSize);
    }

    public static <V> HashByteObjMap<V> newImmutableMap(
            Byte[] keys, V[] values) {
        return getDefaultFactory().newImmutableMap(keys, values);
    }

    public static <V> HashByteObjMap<V> newImmutableMap(
            Byte[] keys, V[] values, int expectedSize) {
        return getDefaultFactory().newImmutableMap(keys, values, expectedSize);
    }

    public static <V> HashByteObjMap<V> newImmutableMap(Iterable<Byte> keys,
            Iterable<? extends V> values) {
        return getDefaultFactory().newImmutableMap(keys, values);
    }

    public static <V> HashByteObjMap<V> newImmutableMap(Iterable<Byte> keys,
            Iterable<? extends V> values, int expectedSize) {
        return getDefaultFactory().newImmutableMap(keys, values, expectedSize);
    }


    public static <V> HashByteObjMap<V> newImmutableMapOf(
            byte k1, V v1) {
        return getDefaultFactory().newImmutableMapOf(k1, v1);
    }

    public static <V> HashByteObjMap<V> newImmutableMapOf(
            byte k1, V v1, byte k2, V v2) {
        return getDefaultFactory().newImmutableMapOf(k1, v1, k2, v2);
    }

    public static <V> HashByteObjMap<V> newImmutableMapOf(
            byte k1, V v1, byte k2, V v2,
            byte k3, V v3) {
        return getDefaultFactory().newImmutableMapOf(k1, v1, k2, v2, k3, v3);
    }

    public static <V> HashByteObjMap<V> newImmutableMapOf(
            byte k1, V v1, byte k2, V v2,
            byte k3, V v3, byte k4, V v4) {
        return getDefaultFactory().newImmutableMapOf(k1, v1, k2, v2, k3, v3, k4, v4);
    }

    public static <V> HashByteObjMap<V> newImmutableMapOf(
            byte k1, V v1, byte k2, V v2,
            byte k3, V v3, byte k4, V v4,
            byte k5, V v5) {
        return getDefaultFactory().newImmutableMapOf(k1, v1, k2, v2, k3, v3, k4, v4, k5, v5);
    }

    private HashByteObjMaps() {}
}

