/*
 * Copyright 2014 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.openhft.collect.map.hash;

import net.openhft.collect.*;
import net.openhft.collect.hash.*;
import net.openhft.function.ByteObjConsumer;
import net.openhft.collect.map.*;
import javax.annotation.Nullable;

import java.util.Map;


/**
 * An immutable factory of {@code HashByteObjMaps}
 *
 * @see HashByteObjMap
 * @see HashByteObjMaps#getDefaultFactory()
 */
public interface HashByteObjMapFactory<V> extends ByteObjMapFactory<V>
        , ByteHashFactory<HashByteObjMapFactory<V>>
         {

    

    

    

    

    

    
    

    
    


    @Override
    <VE> HashByteObjMapFactory<VE>
    withValueEquivalence(@Nullable Equivalence<VE> valueEquivalence);


    @Override
    <V2 extends V> HashByteObjMap<V2> newMutableMap();

    @Override
    <V2 extends V> HashByteObjMap<V2> newMutableMap(int expectedSize);

    


    @Override
    <V2 extends V> HashByteObjMap<V2> newMutableMap(Map<Byte, ? extends V2> map1,
            Map<Byte, ? extends V2> map2, int expectedSize);

    @Override
    <V2 extends V> HashByteObjMap<V2> newMutableMap(Map<Byte, ? extends V2> map1,
            Map<Byte, ? extends V2> map2, Map<Byte, ? extends V2> map3, int expectedSize);

    @Override
    <V2 extends V> HashByteObjMap<V2> newMutableMap(Map<Byte, ? extends V2> map1,
            Map<Byte, ? extends V2> map2, Map<Byte, ? extends V2> map3,
            Map<Byte, ? extends V2> map4, int expectedSize);

    @Override
    <V2 extends V> HashByteObjMap<V2> newMutableMap(Map<Byte, ? extends V2> map1,
            Map<Byte, ? extends V2> map2, Map<Byte, ? extends V2> map3,
            Map<Byte, ? extends V2> map4, Map<Byte, ? extends V2> map5, int expectedSize);

    

    
    @Override
    <V2 extends V> HashByteObjMap<V2> newMutableMap(Map<Byte, ? extends V2> map);

    @Override
    <V2 extends V> HashByteObjMap<V2> newMutableMap(Map<Byte, ? extends V2> map1,
            Map<Byte, ? extends V2> map2);

    @Override
    <V2 extends V> HashByteObjMap<V2> newMutableMap(Map<Byte, ? extends V2> map1,
            Map<Byte, ? extends V2> map2, Map<Byte, ? extends V2> map3);

    @Override
    <V2 extends V> HashByteObjMap<V2> newMutableMap(Map<Byte, ? extends V2> map1,
            Map<Byte, ? extends V2> map2, Map<Byte, ? extends V2> map3,
            Map<Byte, ? extends V2> map4);

    @Override
    <V2 extends V> HashByteObjMap<V2> newMutableMap(Map<Byte, ? extends V2> map1,
            Map<Byte, ? extends V2> map2, Map<Byte, ? extends V2> map3,
            Map<Byte, ? extends V2> map4, Map<Byte, ? extends V2> map5);


    @Override
    <V2 extends V> HashByteObjMap<V2> newMutableMap(
            net.openhft.function.Consumer<ByteObjConsumer<V2>> entriesSupplier);

    @Override
    <V2 extends V> HashByteObjMap<V2> newMutableMap(
            net.openhft.function.Consumer<ByteObjConsumer<V2>> entriesSupplier,
            int expectedSize);

    @Override
    <V2 extends V> HashByteObjMap<V2> newMutableMap(byte[] keys, V2[] values);

    @Override
    <V2 extends V> HashByteObjMap<V2> newMutableMap(byte[] keys, V2[] values,
            int expectedSize);

    @Override
    <V2 extends V> HashByteObjMap<V2> newMutableMap(
            Byte[] keys, V2[] values);

    @Override
    <V2 extends V> HashByteObjMap<V2> newMutableMap(
            Byte[] keys, V2[] values, int expectedSize);

    @Override
    <V2 extends V> HashByteObjMap<V2> newMutableMap(Iterable<Byte> keys,
            Iterable<? extends V2> values);

    @Override
    <V2 extends V> HashByteObjMap<V2> newMutableMap(Iterable<Byte> keys,
            Iterable<? extends V2> values, int expectedSize);


    @Override
    <V2 extends V> HashByteObjMap<V2> newMutableMapOf(byte k1, V2 v1);

    @Override
    <V2 extends V> HashByteObjMap<V2> newMutableMapOf(byte k1, V2 v1,
            byte k2, V2 v2);

    @Override
    <V2 extends V> HashByteObjMap<V2> newMutableMapOf(byte k1, V2 v1,
            byte k2, V2 v2, byte k3, V2 v3);

    @Override
    <V2 extends V> HashByteObjMap<V2> newMutableMapOf(byte k1, V2 v1,
            byte k2, V2 v2, byte k3, V2 v3,
            byte k4, V2 v4);

    @Override
    <V2 extends V> HashByteObjMap<V2> newMutableMapOf(byte k1, V2 v1,
            byte k2, V2 v2, byte k3, V2 v3,
            byte k4, V2 v4, byte k5, V2 v5);
    @Override
    <V2 extends V> HashByteObjMap<V2> newUpdatableMap();

    @Override
    <V2 extends V> HashByteObjMap<V2> newUpdatableMap(int expectedSize);

    


    @Override
    <V2 extends V> HashByteObjMap<V2> newUpdatableMap(Map<Byte, ? extends V2> map1,
            Map<Byte, ? extends V2> map2, int expectedSize);

    @Override
    <V2 extends V> HashByteObjMap<V2> newUpdatableMap(Map<Byte, ? extends V2> map1,
            Map<Byte, ? extends V2> map2, Map<Byte, ? extends V2> map3, int expectedSize);

    @Override
    <V2 extends V> HashByteObjMap<V2> newUpdatableMap(Map<Byte, ? extends V2> map1,
            Map<Byte, ? extends V2> map2, Map<Byte, ? extends V2> map3,
            Map<Byte, ? extends V2> map4, int expectedSize);

    @Override
    <V2 extends V> HashByteObjMap<V2> newUpdatableMap(Map<Byte, ? extends V2> map1,
            Map<Byte, ? extends V2> map2, Map<Byte, ? extends V2> map3,
            Map<Byte, ? extends V2> map4, Map<Byte, ? extends V2> map5, int expectedSize);

    

    
    @Override
    <V2 extends V> HashByteObjMap<V2> newUpdatableMap(Map<Byte, ? extends V2> map);

    @Override
    <V2 extends V> HashByteObjMap<V2> newUpdatableMap(Map<Byte, ? extends V2> map1,
            Map<Byte, ? extends V2> map2);

    @Override
    <V2 extends V> HashByteObjMap<V2> newUpdatableMap(Map<Byte, ? extends V2> map1,
            Map<Byte, ? extends V2> map2, Map<Byte, ? extends V2> map3);

    @Override
    <V2 extends V> HashByteObjMap<V2> newUpdatableMap(Map<Byte, ? extends V2> map1,
            Map<Byte, ? extends V2> map2, Map<Byte, ? extends V2> map3,
            Map<Byte, ? extends V2> map4);

    @Override
    <V2 extends V> HashByteObjMap<V2> newUpdatableMap(Map<Byte, ? extends V2> map1,
            Map<Byte, ? extends V2> map2, Map<Byte, ? extends V2> map3,
            Map<Byte, ? extends V2> map4, Map<Byte, ? extends V2> map5);


    @Override
    <V2 extends V> HashByteObjMap<V2> newUpdatableMap(
            net.openhft.function.Consumer<ByteObjConsumer<V2>> entriesSupplier);

    @Override
    <V2 extends V> HashByteObjMap<V2> newUpdatableMap(
            net.openhft.function.Consumer<ByteObjConsumer<V2>> entriesSupplier,
            int expectedSize);

    @Override
    <V2 extends V> HashByteObjMap<V2> newUpdatableMap(byte[] keys, V2[] values);

    @Override
    <V2 extends V> HashByteObjMap<V2> newUpdatableMap(byte[] keys, V2[] values,
            int expectedSize);

    @Override
    <V2 extends V> HashByteObjMap<V2> newUpdatableMap(
            Byte[] keys, V2[] values);

    @Override
    <V2 extends V> HashByteObjMap<V2> newUpdatableMap(
            Byte[] keys, V2[] values, int expectedSize);

    @Override
    <V2 extends V> HashByteObjMap<V2> newUpdatableMap(Iterable<Byte> keys,
            Iterable<? extends V2> values);

    @Override
    <V2 extends V> HashByteObjMap<V2> newUpdatableMap(Iterable<Byte> keys,
            Iterable<? extends V2> values, int expectedSize);


    @Override
    <V2 extends V> HashByteObjMap<V2> newUpdatableMapOf(byte k1, V2 v1);

    @Override
    <V2 extends V> HashByteObjMap<V2> newUpdatableMapOf(byte k1, V2 v1,
            byte k2, V2 v2);

    @Override
    <V2 extends V> HashByteObjMap<V2> newUpdatableMapOf(byte k1, V2 v1,
            byte k2, V2 v2, byte k3, V2 v3);

    @Override
    <V2 extends V> HashByteObjMap<V2> newUpdatableMapOf(byte k1, V2 v1,
            byte k2, V2 v2, byte k3, V2 v3,
            byte k4, V2 v4);

    @Override
    <V2 extends V> HashByteObjMap<V2> newUpdatableMapOf(byte k1, V2 v1,
            byte k2, V2 v2, byte k3, V2 v3,
            byte k4, V2 v4, byte k5, V2 v5);

    


    @Override
    <V2 extends V> HashByteObjMap<V2> newImmutableMap(Map<Byte, ? extends V2> map1,
            Map<Byte, ? extends V2> map2, int expectedSize);

    @Override
    <V2 extends V> HashByteObjMap<V2> newImmutableMap(Map<Byte, ? extends V2> map1,
            Map<Byte, ? extends V2> map2, Map<Byte, ? extends V2> map3, int expectedSize);

    @Override
    <V2 extends V> HashByteObjMap<V2> newImmutableMap(Map<Byte, ? extends V2> map1,
            Map<Byte, ? extends V2> map2, Map<Byte, ? extends V2> map3,
            Map<Byte, ? extends V2> map4, int expectedSize);

    @Override
    <V2 extends V> HashByteObjMap<V2> newImmutableMap(Map<Byte, ? extends V2> map1,
            Map<Byte, ? extends V2> map2, Map<Byte, ? extends V2> map3,
            Map<Byte, ? extends V2> map4, Map<Byte, ? extends V2> map5, int expectedSize);

    

    
    @Override
    <V2 extends V> HashByteObjMap<V2> newImmutableMap(Map<Byte, ? extends V2> map);

    @Override
    <V2 extends V> HashByteObjMap<V2> newImmutableMap(Map<Byte, ? extends V2> map1,
            Map<Byte, ? extends V2> map2);

    @Override
    <V2 extends V> HashByteObjMap<V2> newImmutableMap(Map<Byte, ? extends V2> map1,
            Map<Byte, ? extends V2> map2, Map<Byte, ? extends V2> map3);

    @Override
    <V2 extends V> HashByteObjMap<V2> newImmutableMap(Map<Byte, ? extends V2> map1,
            Map<Byte, ? extends V2> map2, Map<Byte, ? extends V2> map3,
            Map<Byte, ? extends V2> map4);

    @Override
    <V2 extends V> HashByteObjMap<V2> newImmutableMap(Map<Byte, ? extends V2> map1,
            Map<Byte, ? extends V2> map2, Map<Byte, ? extends V2> map3,
            Map<Byte, ? extends V2> map4, Map<Byte, ? extends V2> map5);


    @Override
    <V2 extends V> HashByteObjMap<V2> newImmutableMap(
            net.openhft.function.Consumer<ByteObjConsumer<V2>> entriesSupplier);

    @Override
    <V2 extends V> HashByteObjMap<V2> newImmutableMap(
            net.openhft.function.Consumer<ByteObjConsumer<V2>> entriesSupplier,
            int expectedSize);

    @Override
    <V2 extends V> HashByteObjMap<V2> newImmutableMap(byte[] keys, V2[] values);

    @Override
    <V2 extends V> HashByteObjMap<V2> newImmutableMap(byte[] keys, V2[] values,
            int expectedSize);

    @Override
    <V2 extends V> HashByteObjMap<V2> newImmutableMap(
            Byte[] keys, V2[] values);

    @Override
    <V2 extends V> HashByteObjMap<V2> newImmutableMap(
            Byte[] keys, V2[] values, int expectedSize);

    @Override
    <V2 extends V> HashByteObjMap<V2> newImmutableMap(Iterable<Byte> keys,
            Iterable<? extends V2> values);

    @Override
    <V2 extends V> HashByteObjMap<V2> newImmutableMap(Iterable<Byte> keys,
            Iterable<? extends V2> values, int expectedSize);


    @Override
    <V2 extends V> HashByteObjMap<V2> newImmutableMapOf(byte k1, V2 v1);

    @Override
    <V2 extends V> HashByteObjMap<V2> newImmutableMapOf(byte k1, V2 v1,
            byte k2, V2 v2);

    @Override
    <V2 extends V> HashByteObjMap<V2> newImmutableMapOf(byte k1, V2 v1,
            byte k2, V2 v2, byte k3, V2 v3);

    @Override
    <V2 extends V> HashByteObjMap<V2> newImmutableMapOf(byte k1, V2 v1,
            byte k2, V2 v2, byte k3, V2 v3,
            byte k4, V2 v4);

    @Override
    <V2 extends V> HashByteObjMap<V2> newImmutableMapOf(byte k1, V2 v1,
            byte k2, V2 v2, byte k3, V2 v3,
            byte k4, V2 v4, byte k5, V2 v5);
}

