/*
 * Copyright 2014 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.openhft.collect.map.hash;

import net.openhft.function.ByteLongConsumer;

import java.util.Map;
import java.util.ServiceLoader;


/**
 * This class consists only of static factory methods to construct {@code HashByteLongMap}s, and
 * the default {@link HashByteLongMapFactory} static provider ({@link #getDefaultFactory()}).
 *
 * @see HashByteLongMap
 */
public final class HashByteLongMaps {

    

    private static final ServiceLoader<HashByteLongMapFactory> LOADER =
            ServiceLoader.load(HashByteLongMapFactory.class);
    private static HashByteLongMapFactory defaultFactory = null;

    public static HashByteLongMapFactory getDefaultFactory() {
        if (defaultFactory != null) {
            return defaultFactory;
        } else {
            // synchronization?
            return defaultFactory = LOADER.iterator().next();
        }
    }

    

    

    

    public static  HashByteLongMap newMutableMap() {
        return getDefaultFactory().newMutableMap();
    }

    public static  HashByteLongMap newMutableMap(int expectedSize) {
        return getDefaultFactory().newMutableMap(expectedSize);
    }



    
    


    public static  HashByteLongMap newMutableMap(Map<Byte, Long> map1,
            Map<Byte, Long> map2, int expectedSize) {
        return getDefaultFactory().newMutableMap(map1, map2, expectedSize);
    }

    public static  HashByteLongMap newMutableMap(Map<Byte, Long> map1,
            Map<Byte, Long> map2, Map<Byte, Long> map3, int expectedSize) {
        return getDefaultFactory().newMutableMap(map1, map2, map3, expectedSize);
    }

    public static  HashByteLongMap newMutableMap(Map<Byte, Long> map1,
            Map<Byte, Long> map2, Map<Byte, Long> map3,
            Map<Byte, Long> map4, int expectedSize) {
        return getDefaultFactory().newMutableMap(map1, map2, map3, map4, expectedSize);
    }

    public static  HashByteLongMap newMutableMap(Map<Byte, Long> map1,
            Map<Byte, Long> map2, Map<Byte, Long> map3,
            Map<Byte, Long> map4, Map<Byte, Long> map5, int expectedSize) {
        return getDefaultFactory().newMutableMap(map1, map2, map3, map4, map5, expectedSize);
    }

    
    

    
    public static  HashByteLongMap newMutableMap(
            Map<Byte, Long> map) {
        return getDefaultFactory().newMutableMap(map);
    }

    public static  HashByteLongMap newMutableMap(Map<Byte, Long> map1,
            Map<Byte, Long> map2) {
        return getDefaultFactory().newMutableMap(map1, map2);
    }

    public static  HashByteLongMap newMutableMap(Map<Byte, Long> map1,
            Map<Byte, Long> map2, Map<Byte, Long> map3) {
        return getDefaultFactory().newMutableMap(map1, map2, map3);
    }

    public static  HashByteLongMap newMutableMap(Map<Byte, Long> map1,
            Map<Byte, Long> map2, Map<Byte, Long> map3,
            Map<Byte, Long> map4) {
        return getDefaultFactory().newMutableMap(map1, map2, map3, map4);
    }

    public static  HashByteLongMap newMutableMap(Map<Byte, Long> map1,
            Map<Byte, Long> map2, Map<Byte, Long> map3,
            Map<Byte, Long> map4, Map<Byte, Long> map5) {
        return getDefaultFactory().newMutableMap(map1, map2, map3, map4, map5);
    }


    public static  HashByteLongMap newMutableMap(
            net.openhft.function.Consumer<ByteLongConsumer> entriesSupplier) {
        return getDefaultFactory().newMutableMap(entriesSupplier);
    }

    public static  HashByteLongMap newMutableMap(
            net.openhft.function.Consumer<ByteLongConsumer> entriesSupplier,
            int expectedSize) {
        return getDefaultFactory().newMutableMap(entriesSupplier, expectedSize);
    }

    public static  HashByteLongMap newMutableMap(
            byte[] keys, long[] values) {
        return getDefaultFactory().newMutableMap(keys, values);
    }

    public static  HashByteLongMap newMutableMap(
            byte[] keys, long[] values, int expectedSize) {
        return getDefaultFactory().newMutableMap(keys, values, expectedSize);
    }

    public static  HashByteLongMap newMutableMap(
            Byte[] keys, Long[] values) {
        return getDefaultFactory().newMutableMap(keys, values);
    }

    public static  HashByteLongMap newMutableMap(
            Byte[] keys, Long[] values, int expectedSize) {
        return getDefaultFactory().newMutableMap(keys, values, expectedSize);
    }

    public static  HashByteLongMap newMutableMap(Iterable<Byte> keys,
            Iterable<Long> values) {
        return getDefaultFactory().newMutableMap(keys, values);
    }

    public static  HashByteLongMap newMutableMap(Iterable<Byte> keys,
            Iterable<Long> values, int expectedSize) {
        return getDefaultFactory().newMutableMap(keys, values, expectedSize);
    }


    public static  HashByteLongMap newMutableMapOf(
            byte k1, long v1) {
        return getDefaultFactory().newMutableMapOf(k1, v1);
    }

    public static  HashByteLongMap newMutableMapOf(
            byte k1, long v1, byte k2, long v2) {
        return getDefaultFactory().newMutableMapOf(k1, v1, k2, v2);
    }

    public static  HashByteLongMap newMutableMapOf(
            byte k1, long v1, byte k2, long v2,
            byte k3, long v3) {
        return getDefaultFactory().newMutableMapOf(k1, v1, k2, v2, k3, v3);
    }

    public static  HashByteLongMap newMutableMapOf(
            byte k1, long v1, byte k2, long v2,
            byte k3, long v3, byte k4, long v4) {
        return getDefaultFactory().newMutableMapOf(k1, v1, k2, v2, k3, v3, k4, v4);
    }

    public static  HashByteLongMap newMutableMapOf(
            byte k1, long v1, byte k2, long v2,
            byte k3, long v3, byte k4, long v4,
            byte k5, long v5) {
        return getDefaultFactory().newMutableMapOf(k1, v1, k2, v2, k3, v3, k4, v4, k5, v5);
    }

    
    


    public static  HashByteLongMap newUpdatableMap(Map<Byte, Long> map1,
            Map<Byte, Long> map2, int expectedSize) {
        return getDefaultFactory().newUpdatableMap(map1, map2, expectedSize);
    }

    public static  HashByteLongMap newUpdatableMap(Map<Byte, Long> map1,
            Map<Byte, Long> map2, Map<Byte, Long> map3, int expectedSize) {
        return getDefaultFactory().newUpdatableMap(map1, map2, map3, expectedSize);
    }

    public static  HashByteLongMap newUpdatableMap(Map<Byte, Long> map1,
            Map<Byte, Long> map2, Map<Byte, Long> map3,
            Map<Byte, Long> map4, int expectedSize) {
        return getDefaultFactory().newUpdatableMap(map1, map2, map3, map4, expectedSize);
    }

    public static  HashByteLongMap newUpdatableMap(Map<Byte, Long> map1,
            Map<Byte, Long> map2, Map<Byte, Long> map3,
            Map<Byte, Long> map4, Map<Byte, Long> map5, int expectedSize) {
        return getDefaultFactory().newUpdatableMap(map1, map2, map3, map4, map5, expectedSize);
    }

    
    

    
    public static  HashByteLongMap newUpdatableMap(
            Map<Byte, Long> map) {
        return getDefaultFactory().newUpdatableMap(map);
    }

    public static  HashByteLongMap newUpdatableMap(Map<Byte, Long> map1,
            Map<Byte, Long> map2) {
        return getDefaultFactory().newUpdatableMap(map1, map2);
    }

    public static  HashByteLongMap newUpdatableMap(Map<Byte, Long> map1,
            Map<Byte, Long> map2, Map<Byte, Long> map3) {
        return getDefaultFactory().newUpdatableMap(map1, map2, map3);
    }

    public static  HashByteLongMap newUpdatableMap(Map<Byte, Long> map1,
            Map<Byte, Long> map2, Map<Byte, Long> map3,
            Map<Byte, Long> map4) {
        return getDefaultFactory().newUpdatableMap(map1, map2, map3, map4);
    }

    public static  HashByteLongMap newUpdatableMap(Map<Byte, Long> map1,
            Map<Byte, Long> map2, Map<Byte, Long> map3,
            Map<Byte, Long> map4, Map<Byte, Long> map5) {
        return getDefaultFactory().newUpdatableMap(map1, map2, map3, map4, map5);
    }


    public static  HashByteLongMap newUpdatableMap(
            net.openhft.function.Consumer<ByteLongConsumer> entriesSupplier) {
        return getDefaultFactory().newUpdatableMap(entriesSupplier);
    }

    public static  HashByteLongMap newUpdatableMap(
            net.openhft.function.Consumer<ByteLongConsumer> entriesSupplier,
            int expectedSize) {
        return getDefaultFactory().newUpdatableMap(entriesSupplier, expectedSize);
    }

    public static  HashByteLongMap newUpdatableMap(
            byte[] keys, long[] values) {
        return getDefaultFactory().newUpdatableMap(keys, values);
    }

    public static  HashByteLongMap newUpdatableMap(
            byte[] keys, long[] values, int expectedSize) {
        return getDefaultFactory().newUpdatableMap(keys, values, expectedSize);
    }

    public static  HashByteLongMap newUpdatableMap(
            Byte[] keys, Long[] values) {
        return getDefaultFactory().newUpdatableMap(keys, values);
    }

    public static  HashByteLongMap newUpdatableMap(
            Byte[] keys, Long[] values, int expectedSize) {
        return getDefaultFactory().newUpdatableMap(keys, values, expectedSize);
    }

    public static  HashByteLongMap newUpdatableMap(Iterable<Byte> keys,
            Iterable<Long> values) {
        return getDefaultFactory().newUpdatableMap(keys, values);
    }

    public static  HashByteLongMap newUpdatableMap(Iterable<Byte> keys,
            Iterable<Long> values, int expectedSize) {
        return getDefaultFactory().newUpdatableMap(keys, values, expectedSize);
    }


    public static  HashByteLongMap newUpdatableMapOf(
            byte k1, long v1) {
        return getDefaultFactory().newUpdatableMapOf(k1, v1);
    }

    public static  HashByteLongMap newUpdatableMapOf(
            byte k1, long v1, byte k2, long v2) {
        return getDefaultFactory().newUpdatableMapOf(k1, v1, k2, v2);
    }

    public static  HashByteLongMap newUpdatableMapOf(
            byte k1, long v1, byte k2, long v2,
            byte k3, long v3) {
        return getDefaultFactory().newUpdatableMapOf(k1, v1, k2, v2, k3, v3);
    }

    public static  HashByteLongMap newUpdatableMapOf(
            byte k1, long v1, byte k2, long v2,
            byte k3, long v3, byte k4, long v4) {
        return getDefaultFactory().newUpdatableMapOf(k1, v1, k2, v2, k3, v3, k4, v4);
    }

    public static  HashByteLongMap newUpdatableMapOf(
            byte k1, long v1, byte k2, long v2,
            byte k3, long v3, byte k4, long v4,
            byte k5, long v5) {
        return getDefaultFactory().newUpdatableMapOf(k1, v1, k2, v2, k3, v3, k4, v4, k5, v5);
    }

    
    


    public static  HashByteLongMap newImmutableMap(Map<Byte, Long> map1,
            Map<Byte, Long> map2, int expectedSize) {
        return getDefaultFactory().newImmutableMap(map1, map2, expectedSize);
    }

    public static  HashByteLongMap newImmutableMap(Map<Byte, Long> map1,
            Map<Byte, Long> map2, Map<Byte, Long> map3, int expectedSize) {
        return getDefaultFactory().newImmutableMap(map1, map2, map3, expectedSize);
    }

    public static  HashByteLongMap newImmutableMap(Map<Byte, Long> map1,
            Map<Byte, Long> map2, Map<Byte, Long> map3,
            Map<Byte, Long> map4, int expectedSize) {
        return getDefaultFactory().newImmutableMap(map1, map2, map3, map4, expectedSize);
    }

    public static  HashByteLongMap newImmutableMap(Map<Byte, Long> map1,
            Map<Byte, Long> map2, Map<Byte, Long> map3,
            Map<Byte, Long> map4, Map<Byte, Long> map5, int expectedSize) {
        return getDefaultFactory().newImmutableMap(map1, map2, map3, map4, map5, expectedSize);
    }

    
    

    
    public static  HashByteLongMap newImmutableMap(
            Map<Byte, Long> map) {
        return getDefaultFactory().newImmutableMap(map);
    }

    public static  HashByteLongMap newImmutableMap(Map<Byte, Long> map1,
            Map<Byte, Long> map2) {
        return getDefaultFactory().newImmutableMap(map1, map2);
    }

    public static  HashByteLongMap newImmutableMap(Map<Byte, Long> map1,
            Map<Byte, Long> map2, Map<Byte, Long> map3) {
        return getDefaultFactory().newImmutableMap(map1, map2, map3);
    }

    public static  HashByteLongMap newImmutableMap(Map<Byte, Long> map1,
            Map<Byte, Long> map2, Map<Byte, Long> map3,
            Map<Byte, Long> map4) {
        return getDefaultFactory().newImmutableMap(map1, map2, map3, map4);
    }

    public static  HashByteLongMap newImmutableMap(Map<Byte, Long> map1,
            Map<Byte, Long> map2, Map<Byte, Long> map3,
            Map<Byte, Long> map4, Map<Byte, Long> map5) {
        return getDefaultFactory().newImmutableMap(map1, map2, map3, map4, map5);
    }


    public static  HashByteLongMap newImmutableMap(
            net.openhft.function.Consumer<ByteLongConsumer> entriesSupplier) {
        return getDefaultFactory().newImmutableMap(entriesSupplier);
    }

    public static  HashByteLongMap newImmutableMap(
            net.openhft.function.Consumer<ByteLongConsumer> entriesSupplier,
            int expectedSize) {
        return getDefaultFactory().newImmutableMap(entriesSupplier, expectedSize);
    }

    public static  HashByteLongMap newImmutableMap(
            byte[] keys, long[] values) {
        return getDefaultFactory().newImmutableMap(keys, values);
    }

    public static  HashByteLongMap newImmutableMap(
            byte[] keys, long[] values, int expectedSize) {
        return getDefaultFactory().newImmutableMap(keys, values, expectedSize);
    }

    public static  HashByteLongMap newImmutableMap(
            Byte[] keys, Long[] values) {
        return getDefaultFactory().newImmutableMap(keys, values);
    }

    public static  HashByteLongMap newImmutableMap(
            Byte[] keys, Long[] values, int expectedSize) {
        return getDefaultFactory().newImmutableMap(keys, values, expectedSize);
    }

    public static  HashByteLongMap newImmutableMap(Iterable<Byte> keys,
            Iterable<Long> values) {
        return getDefaultFactory().newImmutableMap(keys, values);
    }

    public static  HashByteLongMap newImmutableMap(Iterable<Byte> keys,
            Iterable<Long> values, int expectedSize) {
        return getDefaultFactory().newImmutableMap(keys, values, expectedSize);
    }


    public static  HashByteLongMap newImmutableMapOf(
            byte k1, long v1) {
        return getDefaultFactory().newImmutableMapOf(k1, v1);
    }

    public static  HashByteLongMap newImmutableMapOf(
            byte k1, long v1, byte k2, long v2) {
        return getDefaultFactory().newImmutableMapOf(k1, v1, k2, v2);
    }

    public static  HashByteLongMap newImmutableMapOf(
            byte k1, long v1, byte k2, long v2,
            byte k3, long v3) {
        return getDefaultFactory().newImmutableMapOf(k1, v1, k2, v2, k3, v3);
    }

    public static  HashByteLongMap newImmutableMapOf(
            byte k1, long v1, byte k2, long v2,
            byte k3, long v3, byte k4, long v4) {
        return getDefaultFactory().newImmutableMapOf(k1, v1, k2, v2, k3, v3, k4, v4);
    }

    public static  HashByteLongMap newImmutableMapOf(
            byte k1, long v1, byte k2, long v2,
            byte k3, long v3, byte k4, long v4,
            byte k5, long v5) {
        return getDefaultFactory().newImmutableMapOf(k1, v1, k2, v2, k3, v3, k4, v4, k5, v5);
    }

    private HashByteLongMaps() {}
}

