/*
 * Copyright 2014 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.openhft.collect.map.hash;

import net.openhft.collect.*;
import net.openhft.collect.hash.*;
import net.openhft.function.ByteLongConsumer;
import net.openhft.collect.map.*;
import javax.annotation.Nullable;

import java.util.Map;


/**
 * An immutable factory of {@code HashByteLongMaps}
 *
 * @see HashByteLongMap
 * @see HashByteLongMaps#getDefaultFactory()
 */
public interface HashByteLongMapFactory extends ByteLongMapFactory
        , ByteHashFactory<HashByteLongMapFactory>
         {

    

    

    

    

    

    
    

    
    


    @Override
    HashByteLongMapFactory withDefaultValue(long defaultValue);

    @Override
     HashByteLongMap newMutableMap();

    @Override
     HashByteLongMap newMutableMap(int expectedSize);

    


    @Override
     HashByteLongMap newMutableMap(Map<Byte, Long> map1,
            Map<Byte, Long> map2, int expectedSize);

    @Override
     HashByteLongMap newMutableMap(Map<Byte, Long> map1,
            Map<Byte, Long> map2, Map<Byte, Long> map3, int expectedSize);

    @Override
     HashByteLongMap newMutableMap(Map<Byte, Long> map1,
            Map<Byte, Long> map2, Map<Byte, Long> map3,
            Map<Byte, Long> map4, int expectedSize);

    @Override
     HashByteLongMap newMutableMap(Map<Byte, Long> map1,
            Map<Byte, Long> map2, Map<Byte, Long> map3,
            Map<Byte, Long> map4, Map<Byte, Long> map5, int expectedSize);

    

    
    @Override
     HashByteLongMap newMutableMap(Map<Byte, Long> map);

    @Override
     HashByteLongMap newMutableMap(Map<Byte, Long> map1,
            Map<Byte, Long> map2);

    @Override
     HashByteLongMap newMutableMap(Map<Byte, Long> map1,
            Map<Byte, Long> map2, Map<Byte, Long> map3);

    @Override
     HashByteLongMap newMutableMap(Map<Byte, Long> map1,
            Map<Byte, Long> map2, Map<Byte, Long> map3,
            Map<Byte, Long> map4);

    @Override
     HashByteLongMap newMutableMap(Map<Byte, Long> map1,
            Map<Byte, Long> map2, Map<Byte, Long> map3,
            Map<Byte, Long> map4, Map<Byte, Long> map5);


    @Override
     HashByteLongMap newMutableMap(
            net.openhft.function.Consumer<ByteLongConsumer> entriesSupplier);

    @Override
     HashByteLongMap newMutableMap(
            net.openhft.function.Consumer<ByteLongConsumer> entriesSupplier,
            int expectedSize);

    @Override
     HashByteLongMap newMutableMap(byte[] keys, long[] values);

    @Override
     HashByteLongMap newMutableMap(byte[] keys, long[] values,
            int expectedSize);

    @Override
     HashByteLongMap newMutableMap(
            Byte[] keys, Long[] values);

    @Override
     HashByteLongMap newMutableMap(
            Byte[] keys, Long[] values, int expectedSize);

    @Override
     HashByteLongMap newMutableMap(Iterable<Byte> keys,
            Iterable<Long> values);

    @Override
     HashByteLongMap newMutableMap(Iterable<Byte> keys,
            Iterable<Long> values, int expectedSize);


    @Override
     HashByteLongMap newMutableMapOf(byte k1, long v1);

    @Override
     HashByteLongMap newMutableMapOf(byte k1, long v1,
            byte k2, long v2);

    @Override
     HashByteLongMap newMutableMapOf(byte k1, long v1,
            byte k2, long v2, byte k3, long v3);

    @Override
     HashByteLongMap newMutableMapOf(byte k1, long v1,
            byte k2, long v2, byte k3, long v3,
            byte k4, long v4);

    @Override
     HashByteLongMap newMutableMapOf(byte k1, long v1,
            byte k2, long v2, byte k3, long v3,
            byte k4, long v4, byte k5, long v5);
    @Override
     HashByteLongMap newUpdatableMap();

    @Override
     HashByteLongMap newUpdatableMap(int expectedSize);

    


    @Override
     HashByteLongMap newUpdatableMap(Map<Byte, Long> map1,
            Map<Byte, Long> map2, int expectedSize);

    @Override
     HashByteLongMap newUpdatableMap(Map<Byte, Long> map1,
            Map<Byte, Long> map2, Map<Byte, Long> map3, int expectedSize);

    @Override
     HashByteLongMap newUpdatableMap(Map<Byte, Long> map1,
            Map<Byte, Long> map2, Map<Byte, Long> map3,
            Map<Byte, Long> map4, int expectedSize);

    @Override
     HashByteLongMap newUpdatableMap(Map<Byte, Long> map1,
            Map<Byte, Long> map2, Map<Byte, Long> map3,
            Map<Byte, Long> map4, Map<Byte, Long> map5, int expectedSize);

    

    
    @Override
     HashByteLongMap newUpdatableMap(Map<Byte, Long> map);

    @Override
     HashByteLongMap newUpdatableMap(Map<Byte, Long> map1,
            Map<Byte, Long> map2);

    @Override
     HashByteLongMap newUpdatableMap(Map<Byte, Long> map1,
            Map<Byte, Long> map2, Map<Byte, Long> map3);

    @Override
     HashByteLongMap newUpdatableMap(Map<Byte, Long> map1,
            Map<Byte, Long> map2, Map<Byte, Long> map3,
            Map<Byte, Long> map4);

    @Override
     HashByteLongMap newUpdatableMap(Map<Byte, Long> map1,
            Map<Byte, Long> map2, Map<Byte, Long> map3,
            Map<Byte, Long> map4, Map<Byte, Long> map5);


    @Override
     HashByteLongMap newUpdatableMap(
            net.openhft.function.Consumer<ByteLongConsumer> entriesSupplier);

    @Override
     HashByteLongMap newUpdatableMap(
            net.openhft.function.Consumer<ByteLongConsumer> entriesSupplier,
            int expectedSize);

    @Override
     HashByteLongMap newUpdatableMap(byte[] keys, long[] values);

    @Override
     HashByteLongMap newUpdatableMap(byte[] keys, long[] values,
            int expectedSize);

    @Override
     HashByteLongMap newUpdatableMap(
            Byte[] keys, Long[] values);

    @Override
     HashByteLongMap newUpdatableMap(
            Byte[] keys, Long[] values, int expectedSize);

    @Override
     HashByteLongMap newUpdatableMap(Iterable<Byte> keys,
            Iterable<Long> values);

    @Override
     HashByteLongMap newUpdatableMap(Iterable<Byte> keys,
            Iterable<Long> values, int expectedSize);


    @Override
     HashByteLongMap newUpdatableMapOf(byte k1, long v1);

    @Override
     HashByteLongMap newUpdatableMapOf(byte k1, long v1,
            byte k2, long v2);

    @Override
     HashByteLongMap newUpdatableMapOf(byte k1, long v1,
            byte k2, long v2, byte k3, long v3);

    @Override
     HashByteLongMap newUpdatableMapOf(byte k1, long v1,
            byte k2, long v2, byte k3, long v3,
            byte k4, long v4);

    @Override
     HashByteLongMap newUpdatableMapOf(byte k1, long v1,
            byte k2, long v2, byte k3, long v3,
            byte k4, long v4, byte k5, long v5);

    


    @Override
     HashByteLongMap newImmutableMap(Map<Byte, Long> map1,
            Map<Byte, Long> map2, int expectedSize);

    @Override
     HashByteLongMap newImmutableMap(Map<Byte, Long> map1,
            Map<Byte, Long> map2, Map<Byte, Long> map3, int expectedSize);

    @Override
     HashByteLongMap newImmutableMap(Map<Byte, Long> map1,
            Map<Byte, Long> map2, Map<Byte, Long> map3,
            Map<Byte, Long> map4, int expectedSize);

    @Override
     HashByteLongMap newImmutableMap(Map<Byte, Long> map1,
            Map<Byte, Long> map2, Map<Byte, Long> map3,
            Map<Byte, Long> map4, Map<Byte, Long> map5, int expectedSize);

    

    
    @Override
     HashByteLongMap newImmutableMap(Map<Byte, Long> map);

    @Override
     HashByteLongMap newImmutableMap(Map<Byte, Long> map1,
            Map<Byte, Long> map2);

    @Override
     HashByteLongMap newImmutableMap(Map<Byte, Long> map1,
            Map<Byte, Long> map2, Map<Byte, Long> map3);

    @Override
     HashByteLongMap newImmutableMap(Map<Byte, Long> map1,
            Map<Byte, Long> map2, Map<Byte, Long> map3,
            Map<Byte, Long> map4);

    @Override
     HashByteLongMap newImmutableMap(Map<Byte, Long> map1,
            Map<Byte, Long> map2, Map<Byte, Long> map3,
            Map<Byte, Long> map4, Map<Byte, Long> map5);


    @Override
     HashByteLongMap newImmutableMap(
            net.openhft.function.Consumer<ByteLongConsumer> entriesSupplier);

    @Override
     HashByteLongMap newImmutableMap(
            net.openhft.function.Consumer<ByteLongConsumer> entriesSupplier,
            int expectedSize);

    @Override
     HashByteLongMap newImmutableMap(byte[] keys, long[] values);

    @Override
     HashByteLongMap newImmutableMap(byte[] keys, long[] values,
            int expectedSize);

    @Override
     HashByteLongMap newImmutableMap(
            Byte[] keys, Long[] values);

    @Override
     HashByteLongMap newImmutableMap(
            Byte[] keys, Long[] values, int expectedSize);

    @Override
     HashByteLongMap newImmutableMap(Iterable<Byte> keys,
            Iterable<Long> values);

    @Override
     HashByteLongMap newImmutableMap(Iterable<Byte> keys,
            Iterable<Long> values, int expectedSize);


    @Override
     HashByteLongMap newImmutableMapOf(byte k1, long v1);

    @Override
     HashByteLongMap newImmutableMapOf(byte k1, long v1,
            byte k2, long v2);

    @Override
     HashByteLongMap newImmutableMapOf(byte k1, long v1,
            byte k2, long v2, byte k3, long v3);

    @Override
     HashByteLongMap newImmutableMapOf(byte k1, long v1,
            byte k2, long v2, byte k3, long v3,
            byte k4, long v4);

    @Override
     HashByteLongMap newImmutableMapOf(byte k1, long v1,
            byte k2, long v2, byte k3, long v3,
            byte k4, long v4, byte k5, long v5);
}

