/*
 * Copyright 2014 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.openhft.collect.map.hash;

import net.openhft.function.ByteIntConsumer;

import java.util.Map;
import java.util.ServiceLoader;


/**
 * This class consists only of static factory methods to construct {@code HashByteIntMap}s, and
 * the default {@link HashByteIntMapFactory} static provider ({@link #getDefaultFactory()}).
 *
 * @see HashByteIntMap
 */
public final class HashByteIntMaps {

    

    private static final ServiceLoader<HashByteIntMapFactory> LOADER =
            ServiceLoader.load(HashByteIntMapFactory.class);
    private static HashByteIntMapFactory defaultFactory = null;

    public static HashByteIntMapFactory getDefaultFactory() {
        if (defaultFactory != null) {
            return defaultFactory;
        } else {
            // synchronization?
            return defaultFactory = LOADER.iterator().next();
        }
    }

    

    

    

    public static  HashByteIntMap newMutableMap() {
        return getDefaultFactory().newMutableMap();
    }

    public static  HashByteIntMap newMutableMap(int expectedSize) {
        return getDefaultFactory().newMutableMap(expectedSize);
    }



    
    


    public static  HashByteIntMap newMutableMap(Map<Byte, Integer> map1,
            Map<Byte, Integer> map2, int expectedSize) {
        return getDefaultFactory().newMutableMap(map1, map2, expectedSize);
    }

    public static  HashByteIntMap newMutableMap(Map<Byte, Integer> map1,
            Map<Byte, Integer> map2, Map<Byte, Integer> map3, int expectedSize) {
        return getDefaultFactory().newMutableMap(map1, map2, map3, expectedSize);
    }

    public static  HashByteIntMap newMutableMap(Map<Byte, Integer> map1,
            Map<Byte, Integer> map2, Map<Byte, Integer> map3,
            Map<Byte, Integer> map4, int expectedSize) {
        return getDefaultFactory().newMutableMap(map1, map2, map3, map4, expectedSize);
    }

    public static  HashByteIntMap newMutableMap(Map<Byte, Integer> map1,
            Map<Byte, Integer> map2, Map<Byte, Integer> map3,
            Map<Byte, Integer> map4, Map<Byte, Integer> map5, int expectedSize) {
        return getDefaultFactory().newMutableMap(map1, map2, map3, map4, map5, expectedSize);
    }

    
    

    
    public static  HashByteIntMap newMutableMap(
            Map<Byte, Integer> map) {
        return getDefaultFactory().newMutableMap(map);
    }

    public static  HashByteIntMap newMutableMap(Map<Byte, Integer> map1,
            Map<Byte, Integer> map2) {
        return getDefaultFactory().newMutableMap(map1, map2);
    }

    public static  HashByteIntMap newMutableMap(Map<Byte, Integer> map1,
            Map<Byte, Integer> map2, Map<Byte, Integer> map3) {
        return getDefaultFactory().newMutableMap(map1, map2, map3);
    }

    public static  HashByteIntMap newMutableMap(Map<Byte, Integer> map1,
            Map<Byte, Integer> map2, Map<Byte, Integer> map3,
            Map<Byte, Integer> map4) {
        return getDefaultFactory().newMutableMap(map1, map2, map3, map4);
    }

    public static  HashByteIntMap newMutableMap(Map<Byte, Integer> map1,
            Map<Byte, Integer> map2, Map<Byte, Integer> map3,
            Map<Byte, Integer> map4, Map<Byte, Integer> map5) {
        return getDefaultFactory().newMutableMap(map1, map2, map3, map4, map5);
    }


    public static  HashByteIntMap newMutableMap(
            net.openhft.function.Consumer<ByteIntConsumer> entriesSupplier) {
        return getDefaultFactory().newMutableMap(entriesSupplier);
    }

    public static  HashByteIntMap newMutableMap(
            net.openhft.function.Consumer<ByteIntConsumer> entriesSupplier,
            int expectedSize) {
        return getDefaultFactory().newMutableMap(entriesSupplier, expectedSize);
    }

    public static  HashByteIntMap newMutableMap(
            byte[] keys, int[] values) {
        return getDefaultFactory().newMutableMap(keys, values);
    }

    public static  HashByteIntMap newMutableMap(
            byte[] keys, int[] values, int expectedSize) {
        return getDefaultFactory().newMutableMap(keys, values, expectedSize);
    }

    public static  HashByteIntMap newMutableMap(
            Byte[] keys, Integer[] values) {
        return getDefaultFactory().newMutableMap(keys, values);
    }

    public static  HashByteIntMap newMutableMap(
            Byte[] keys, Integer[] values, int expectedSize) {
        return getDefaultFactory().newMutableMap(keys, values, expectedSize);
    }

    public static  HashByteIntMap newMutableMap(Iterable<Byte> keys,
            Iterable<Integer> values) {
        return getDefaultFactory().newMutableMap(keys, values);
    }

    public static  HashByteIntMap newMutableMap(Iterable<Byte> keys,
            Iterable<Integer> values, int expectedSize) {
        return getDefaultFactory().newMutableMap(keys, values, expectedSize);
    }


    public static  HashByteIntMap newMutableMapOf(
            byte k1, int v1) {
        return getDefaultFactory().newMutableMapOf(k1, v1);
    }

    public static  HashByteIntMap newMutableMapOf(
            byte k1, int v1, byte k2, int v2) {
        return getDefaultFactory().newMutableMapOf(k1, v1, k2, v2);
    }

    public static  HashByteIntMap newMutableMapOf(
            byte k1, int v1, byte k2, int v2,
            byte k3, int v3) {
        return getDefaultFactory().newMutableMapOf(k1, v1, k2, v2, k3, v3);
    }

    public static  HashByteIntMap newMutableMapOf(
            byte k1, int v1, byte k2, int v2,
            byte k3, int v3, byte k4, int v4) {
        return getDefaultFactory().newMutableMapOf(k1, v1, k2, v2, k3, v3, k4, v4);
    }

    public static  HashByteIntMap newMutableMapOf(
            byte k1, int v1, byte k2, int v2,
            byte k3, int v3, byte k4, int v4,
            byte k5, int v5) {
        return getDefaultFactory().newMutableMapOf(k1, v1, k2, v2, k3, v3, k4, v4, k5, v5);
    }

    
    


    public static  HashByteIntMap newUpdatableMap(Map<Byte, Integer> map1,
            Map<Byte, Integer> map2, int expectedSize) {
        return getDefaultFactory().newUpdatableMap(map1, map2, expectedSize);
    }

    public static  HashByteIntMap newUpdatableMap(Map<Byte, Integer> map1,
            Map<Byte, Integer> map2, Map<Byte, Integer> map3, int expectedSize) {
        return getDefaultFactory().newUpdatableMap(map1, map2, map3, expectedSize);
    }

    public static  HashByteIntMap newUpdatableMap(Map<Byte, Integer> map1,
            Map<Byte, Integer> map2, Map<Byte, Integer> map3,
            Map<Byte, Integer> map4, int expectedSize) {
        return getDefaultFactory().newUpdatableMap(map1, map2, map3, map4, expectedSize);
    }

    public static  HashByteIntMap newUpdatableMap(Map<Byte, Integer> map1,
            Map<Byte, Integer> map2, Map<Byte, Integer> map3,
            Map<Byte, Integer> map4, Map<Byte, Integer> map5, int expectedSize) {
        return getDefaultFactory().newUpdatableMap(map1, map2, map3, map4, map5, expectedSize);
    }

    
    

    
    public static  HashByteIntMap newUpdatableMap(
            Map<Byte, Integer> map) {
        return getDefaultFactory().newUpdatableMap(map);
    }

    public static  HashByteIntMap newUpdatableMap(Map<Byte, Integer> map1,
            Map<Byte, Integer> map2) {
        return getDefaultFactory().newUpdatableMap(map1, map2);
    }

    public static  HashByteIntMap newUpdatableMap(Map<Byte, Integer> map1,
            Map<Byte, Integer> map2, Map<Byte, Integer> map3) {
        return getDefaultFactory().newUpdatableMap(map1, map2, map3);
    }

    public static  HashByteIntMap newUpdatableMap(Map<Byte, Integer> map1,
            Map<Byte, Integer> map2, Map<Byte, Integer> map3,
            Map<Byte, Integer> map4) {
        return getDefaultFactory().newUpdatableMap(map1, map2, map3, map4);
    }

    public static  HashByteIntMap newUpdatableMap(Map<Byte, Integer> map1,
            Map<Byte, Integer> map2, Map<Byte, Integer> map3,
            Map<Byte, Integer> map4, Map<Byte, Integer> map5) {
        return getDefaultFactory().newUpdatableMap(map1, map2, map3, map4, map5);
    }


    public static  HashByteIntMap newUpdatableMap(
            net.openhft.function.Consumer<ByteIntConsumer> entriesSupplier) {
        return getDefaultFactory().newUpdatableMap(entriesSupplier);
    }

    public static  HashByteIntMap newUpdatableMap(
            net.openhft.function.Consumer<ByteIntConsumer> entriesSupplier,
            int expectedSize) {
        return getDefaultFactory().newUpdatableMap(entriesSupplier, expectedSize);
    }

    public static  HashByteIntMap newUpdatableMap(
            byte[] keys, int[] values) {
        return getDefaultFactory().newUpdatableMap(keys, values);
    }

    public static  HashByteIntMap newUpdatableMap(
            byte[] keys, int[] values, int expectedSize) {
        return getDefaultFactory().newUpdatableMap(keys, values, expectedSize);
    }

    public static  HashByteIntMap newUpdatableMap(
            Byte[] keys, Integer[] values) {
        return getDefaultFactory().newUpdatableMap(keys, values);
    }

    public static  HashByteIntMap newUpdatableMap(
            Byte[] keys, Integer[] values, int expectedSize) {
        return getDefaultFactory().newUpdatableMap(keys, values, expectedSize);
    }

    public static  HashByteIntMap newUpdatableMap(Iterable<Byte> keys,
            Iterable<Integer> values) {
        return getDefaultFactory().newUpdatableMap(keys, values);
    }

    public static  HashByteIntMap newUpdatableMap(Iterable<Byte> keys,
            Iterable<Integer> values, int expectedSize) {
        return getDefaultFactory().newUpdatableMap(keys, values, expectedSize);
    }


    public static  HashByteIntMap newUpdatableMapOf(
            byte k1, int v1) {
        return getDefaultFactory().newUpdatableMapOf(k1, v1);
    }

    public static  HashByteIntMap newUpdatableMapOf(
            byte k1, int v1, byte k2, int v2) {
        return getDefaultFactory().newUpdatableMapOf(k1, v1, k2, v2);
    }

    public static  HashByteIntMap newUpdatableMapOf(
            byte k1, int v1, byte k2, int v2,
            byte k3, int v3) {
        return getDefaultFactory().newUpdatableMapOf(k1, v1, k2, v2, k3, v3);
    }

    public static  HashByteIntMap newUpdatableMapOf(
            byte k1, int v1, byte k2, int v2,
            byte k3, int v3, byte k4, int v4) {
        return getDefaultFactory().newUpdatableMapOf(k1, v1, k2, v2, k3, v3, k4, v4);
    }

    public static  HashByteIntMap newUpdatableMapOf(
            byte k1, int v1, byte k2, int v2,
            byte k3, int v3, byte k4, int v4,
            byte k5, int v5) {
        return getDefaultFactory().newUpdatableMapOf(k1, v1, k2, v2, k3, v3, k4, v4, k5, v5);
    }

    
    


    public static  HashByteIntMap newImmutableMap(Map<Byte, Integer> map1,
            Map<Byte, Integer> map2, int expectedSize) {
        return getDefaultFactory().newImmutableMap(map1, map2, expectedSize);
    }

    public static  HashByteIntMap newImmutableMap(Map<Byte, Integer> map1,
            Map<Byte, Integer> map2, Map<Byte, Integer> map3, int expectedSize) {
        return getDefaultFactory().newImmutableMap(map1, map2, map3, expectedSize);
    }

    public static  HashByteIntMap newImmutableMap(Map<Byte, Integer> map1,
            Map<Byte, Integer> map2, Map<Byte, Integer> map3,
            Map<Byte, Integer> map4, int expectedSize) {
        return getDefaultFactory().newImmutableMap(map1, map2, map3, map4, expectedSize);
    }

    public static  HashByteIntMap newImmutableMap(Map<Byte, Integer> map1,
            Map<Byte, Integer> map2, Map<Byte, Integer> map3,
            Map<Byte, Integer> map4, Map<Byte, Integer> map5, int expectedSize) {
        return getDefaultFactory().newImmutableMap(map1, map2, map3, map4, map5, expectedSize);
    }

    
    

    
    public static  HashByteIntMap newImmutableMap(
            Map<Byte, Integer> map) {
        return getDefaultFactory().newImmutableMap(map);
    }

    public static  HashByteIntMap newImmutableMap(Map<Byte, Integer> map1,
            Map<Byte, Integer> map2) {
        return getDefaultFactory().newImmutableMap(map1, map2);
    }

    public static  HashByteIntMap newImmutableMap(Map<Byte, Integer> map1,
            Map<Byte, Integer> map2, Map<Byte, Integer> map3) {
        return getDefaultFactory().newImmutableMap(map1, map2, map3);
    }

    public static  HashByteIntMap newImmutableMap(Map<Byte, Integer> map1,
            Map<Byte, Integer> map2, Map<Byte, Integer> map3,
            Map<Byte, Integer> map4) {
        return getDefaultFactory().newImmutableMap(map1, map2, map3, map4);
    }

    public static  HashByteIntMap newImmutableMap(Map<Byte, Integer> map1,
            Map<Byte, Integer> map2, Map<Byte, Integer> map3,
            Map<Byte, Integer> map4, Map<Byte, Integer> map5) {
        return getDefaultFactory().newImmutableMap(map1, map2, map3, map4, map5);
    }


    public static  HashByteIntMap newImmutableMap(
            net.openhft.function.Consumer<ByteIntConsumer> entriesSupplier) {
        return getDefaultFactory().newImmutableMap(entriesSupplier);
    }

    public static  HashByteIntMap newImmutableMap(
            net.openhft.function.Consumer<ByteIntConsumer> entriesSupplier,
            int expectedSize) {
        return getDefaultFactory().newImmutableMap(entriesSupplier, expectedSize);
    }

    public static  HashByteIntMap newImmutableMap(
            byte[] keys, int[] values) {
        return getDefaultFactory().newImmutableMap(keys, values);
    }

    public static  HashByteIntMap newImmutableMap(
            byte[] keys, int[] values, int expectedSize) {
        return getDefaultFactory().newImmutableMap(keys, values, expectedSize);
    }

    public static  HashByteIntMap newImmutableMap(
            Byte[] keys, Integer[] values) {
        return getDefaultFactory().newImmutableMap(keys, values);
    }

    public static  HashByteIntMap newImmutableMap(
            Byte[] keys, Integer[] values, int expectedSize) {
        return getDefaultFactory().newImmutableMap(keys, values, expectedSize);
    }

    public static  HashByteIntMap newImmutableMap(Iterable<Byte> keys,
            Iterable<Integer> values) {
        return getDefaultFactory().newImmutableMap(keys, values);
    }

    public static  HashByteIntMap newImmutableMap(Iterable<Byte> keys,
            Iterable<Integer> values, int expectedSize) {
        return getDefaultFactory().newImmutableMap(keys, values, expectedSize);
    }


    public static  HashByteIntMap newImmutableMapOf(
            byte k1, int v1) {
        return getDefaultFactory().newImmutableMapOf(k1, v1);
    }

    public static  HashByteIntMap newImmutableMapOf(
            byte k1, int v1, byte k2, int v2) {
        return getDefaultFactory().newImmutableMapOf(k1, v1, k2, v2);
    }

    public static  HashByteIntMap newImmutableMapOf(
            byte k1, int v1, byte k2, int v2,
            byte k3, int v3) {
        return getDefaultFactory().newImmutableMapOf(k1, v1, k2, v2, k3, v3);
    }

    public static  HashByteIntMap newImmutableMapOf(
            byte k1, int v1, byte k2, int v2,
            byte k3, int v3, byte k4, int v4) {
        return getDefaultFactory().newImmutableMapOf(k1, v1, k2, v2, k3, v3, k4, v4);
    }

    public static  HashByteIntMap newImmutableMapOf(
            byte k1, int v1, byte k2, int v2,
            byte k3, int v3, byte k4, int v4,
            byte k5, int v5) {
        return getDefaultFactory().newImmutableMapOf(k1, v1, k2, v2, k3, v3, k4, v4, k5, v5);
    }

    private HashByteIntMaps() {}
}

