/*
 * Copyright 2014 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.openhft.collect.map.hash;

import net.openhft.collect.*;
import net.openhft.collect.hash.*;
import net.openhft.function.ByteIntConsumer;
import net.openhft.collect.map.*;
import javax.annotation.Nullable;

import java.util.Map;


/**
 * An immutable factory of {@code HashByteIntMaps}
 *
 * @see HashByteIntMap
 * @see HashByteIntMaps#getDefaultFactory()
 */
public interface HashByteIntMapFactory extends ByteIntMapFactory
        , ByteHashFactory<HashByteIntMapFactory>
         {

    

    

    

    

    

    
    

    
    


    @Override
    HashByteIntMapFactory withDefaultValue(int defaultValue);

    @Override
     HashByteIntMap newMutableMap();

    @Override
     HashByteIntMap newMutableMap(int expectedSize);

    


    @Override
     HashByteIntMap newMutableMap(Map<Byte, Integer> map1,
            Map<Byte, Integer> map2, int expectedSize);

    @Override
     HashByteIntMap newMutableMap(Map<Byte, Integer> map1,
            Map<Byte, Integer> map2, Map<Byte, Integer> map3, int expectedSize);

    @Override
     HashByteIntMap newMutableMap(Map<Byte, Integer> map1,
            Map<Byte, Integer> map2, Map<Byte, Integer> map3,
            Map<Byte, Integer> map4, int expectedSize);

    @Override
     HashByteIntMap newMutableMap(Map<Byte, Integer> map1,
            Map<Byte, Integer> map2, Map<Byte, Integer> map3,
            Map<Byte, Integer> map4, Map<Byte, Integer> map5, int expectedSize);

    

    
    @Override
     HashByteIntMap newMutableMap(Map<Byte, Integer> map);

    @Override
     HashByteIntMap newMutableMap(Map<Byte, Integer> map1,
            Map<Byte, Integer> map2);

    @Override
     HashByteIntMap newMutableMap(Map<Byte, Integer> map1,
            Map<Byte, Integer> map2, Map<Byte, Integer> map3);

    @Override
     HashByteIntMap newMutableMap(Map<Byte, Integer> map1,
            Map<Byte, Integer> map2, Map<Byte, Integer> map3,
            Map<Byte, Integer> map4);

    @Override
     HashByteIntMap newMutableMap(Map<Byte, Integer> map1,
            Map<Byte, Integer> map2, Map<Byte, Integer> map3,
            Map<Byte, Integer> map4, Map<Byte, Integer> map5);


    @Override
     HashByteIntMap newMutableMap(
            net.openhft.function.Consumer<ByteIntConsumer> entriesSupplier);

    @Override
     HashByteIntMap newMutableMap(
            net.openhft.function.Consumer<ByteIntConsumer> entriesSupplier,
            int expectedSize);

    @Override
     HashByteIntMap newMutableMap(byte[] keys, int[] values);

    @Override
     HashByteIntMap newMutableMap(byte[] keys, int[] values,
            int expectedSize);

    @Override
     HashByteIntMap newMutableMap(
            Byte[] keys, Integer[] values);

    @Override
     HashByteIntMap newMutableMap(
            Byte[] keys, Integer[] values, int expectedSize);

    @Override
     HashByteIntMap newMutableMap(Iterable<Byte> keys,
            Iterable<Integer> values);

    @Override
     HashByteIntMap newMutableMap(Iterable<Byte> keys,
            Iterable<Integer> values, int expectedSize);


    @Override
     HashByteIntMap newMutableMapOf(byte k1, int v1);

    @Override
     HashByteIntMap newMutableMapOf(byte k1, int v1,
            byte k2, int v2);

    @Override
     HashByteIntMap newMutableMapOf(byte k1, int v1,
            byte k2, int v2, byte k3, int v3);

    @Override
     HashByteIntMap newMutableMapOf(byte k1, int v1,
            byte k2, int v2, byte k3, int v3,
            byte k4, int v4);

    @Override
     HashByteIntMap newMutableMapOf(byte k1, int v1,
            byte k2, int v2, byte k3, int v3,
            byte k4, int v4, byte k5, int v5);
    @Override
     HashByteIntMap newUpdatableMap();

    @Override
     HashByteIntMap newUpdatableMap(int expectedSize);

    


    @Override
     HashByteIntMap newUpdatableMap(Map<Byte, Integer> map1,
            Map<Byte, Integer> map2, int expectedSize);

    @Override
     HashByteIntMap newUpdatableMap(Map<Byte, Integer> map1,
            Map<Byte, Integer> map2, Map<Byte, Integer> map3, int expectedSize);

    @Override
     HashByteIntMap newUpdatableMap(Map<Byte, Integer> map1,
            Map<Byte, Integer> map2, Map<Byte, Integer> map3,
            Map<Byte, Integer> map4, int expectedSize);

    @Override
     HashByteIntMap newUpdatableMap(Map<Byte, Integer> map1,
            Map<Byte, Integer> map2, Map<Byte, Integer> map3,
            Map<Byte, Integer> map4, Map<Byte, Integer> map5, int expectedSize);

    

    
    @Override
     HashByteIntMap newUpdatableMap(Map<Byte, Integer> map);

    @Override
     HashByteIntMap newUpdatableMap(Map<Byte, Integer> map1,
            Map<Byte, Integer> map2);

    @Override
     HashByteIntMap newUpdatableMap(Map<Byte, Integer> map1,
            Map<Byte, Integer> map2, Map<Byte, Integer> map3);

    @Override
     HashByteIntMap newUpdatableMap(Map<Byte, Integer> map1,
            Map<Byte, Integer> map2, Map<Byte, Integer> map3,
            Map<Byte, Integer> map4);

    @Override
     HashByteIntMap newUpdatableMap(Map<Byte, Integer> map1,
            Map<Byte, Integer> map2, Map<Byte, Integer> map3,
            Map<Byte, Integer> map4, Map<Byte, Integer> map5);


    @Override
     HashByteIntMap newUpdatableMap(
            net.openhft.function.Consumer<ByteIntConsumer> entriesSupplier);

    @Override
     HashByteIntMap newUpdatableMap(
            net.openhft.function.Consumer<ByteIntConsumer> entriesSupplier,
            int expectedSize);

    @Override
     HashByteIntMap newUpdatableMap(byte[] keys, int[] values);

    @Override
     HashByteIntMap newUpdatableMap(byte[] keys, int[] values,
            int expectedSize);

    @Override
     HashByteIntMap newUpdatableMap(
            Byte[] keys, Integer[] values);

    @Override
     HashByteIntMap newUpdatableMap(
            Byte[] keys, Integer[] values, int expectedSize);

    @Override
     HashByteIntMap newUpdatableMap(Iterable<Byte> keys,
            Iterable<Integer> values);

    @Override
     HashByteIntMap newUpdatableMap(Iterable<Byte> keys,
            Iterable<Integer> values, int expectedSize);


    @Override
     HashByteIntMap newUpdatableMapOf(byte k1, int v1);

    @Override
     HashByteIntMap newUpdatableMapOf(byte k1, int v1,
            byte k2, int v2);

    @Override
     HashByteIntMap newUpdatableMapOf(byte k1, int v1,
            byte k2, int v2, byte k3, int v3);

    @Override
     HashByteIntMap newUpdatableMapOf(byte k1, int v1,
            byte k2, int v2, byte k3, int v3,
            byte k4, int v4);

    @Override
     HashByteIntMap newUpdatableMapOf(byte k1, int v1,
            byte k2, int v2, byte k3, int v3,
            byte k4, int v4, byte k5, int v5);

    


    @Override
     HashByteIntMap newImmutableMap(Map<Byte, Integer> map1,
            Map<Byte, Integer> map2, int expectedSize);

    @Override
     HashByteIntMap newImmutableMap(Map<Byte, Integer> map1,
            Map<Byte, Integer> map2, Map<Byte, Integer> map3, int expectedSize);

    @Override
     HashByteIntMap newImmutableMap(Map<Byte, Integer> map1,
            Map<Byte, Integer> map2, Map<Byte, Integer> map3,
            Map<Byte, Integer> map4, int expectedSize);

    @Override
     HashByteIntMap newImmutableMap(Map<Byte, Integer> map1,
            Map<Byte, Integer> map2, Map<Byte, Integer> map3,
            Map<Byte, Integer> map4, Map<Byte, Integer> map5, int expectedSize);

    

    
    @Override
     HashByteIntMap newImmutableMap(Map<Byte, Integer> map);

    @Override
     HashByteIntMap newImmutableMap(Map<Byte, Integer> map1,
            Map<Byte, Integer> map2);

    @Override
     HashByteIntMap newImmutableMap(Map<Byte, Integer> map1,
            Map<Byte, Integer> map2, Map<Byte, Integer> map3);

    @Override
     HashByteIntMap newImmutableMap(Map<Byte, Integer> map1,
            Map<Byte, Integer> map2, Map<Byte, Integer> map3,
            Map<Byte, Integer> map4);

    @Override
     HashByteIntMap newImmutableMap(Map<Byte, Integer> map1,
            Map<Byte, Integer> map2, Map<Byte, Integer> map3,
            Map<Byte, Integer> map4, Map<Byte, Integer> map5);


    @Override
     HashByteIntMap newImmutableMap(
            net.openhft.function.Consumer<ByteIntConsumer> entriesSupplier);

    @Override
     HashByteIntMap newImmutableMap(
            net.openhft.function.Consumer<ByteIntConsumer> entriesSupplier,
            int expectedSize);

    @Override
     HashByteIntMap newImmutableMap(byte[] keys, int[] values);

    @Override
     HashByteIntMap newImmutableMap(byte[] keys, int[] values,
            int expectedSize);

    @Override
     HashByteIntMap newImmutableMap(
            Byte[] keys, Integer[] values);

    @Override
     HashByteIntMap newImmutableMap(
            Byte[] keys, Integer[] values, int expectedSize);

    @Override
     HashByteIntMap newImmutableMap(Iterable<Byte> keys,
            Iterable<Integer> values);

    @Override
     HashByteIntMap newImmutableMap(Iterable<Byte> keys,
            Iterable<Integer> values, int expectedSize);


    @Override
     HashByteIntMap newImmutableMapOf(byte k1, int v1);

    @Override
     HashByteIntMap newImmutableMapOf(byte k1, int v1,
            byte k2, int v2);

    @Override
     HashByteIntMap newImmutableMapOf(byte k1, int v1,
            byte k2, int v2, byte k3, int v3);

    @Override
     HashByteIntMap newImmutableMapOf(byte k1, int v1,
            byte k2, int v2, byte k3, int v3,
            byte k4, int v4);

    @Override
     HashByteIntMap newImmutableMapOf(byte k1, int v1,
            byte k2, int v2, byte k3, int v3,
            byte k4, int v4, byte k5, int v5);
}

