/*
 * Copyright 2014 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.openhft.collect.map.hash;

import net.openhft.function.ByteFloatConsumer;

import java.util.Map;
import java.util.ServiceLoader;


/**
 * This class consists only of static factory methods to construct {@code HashByteFloatMap}s, and
 * the default {@link HashByteFloatMapFactory} static provider ({@link #getDefaultFactory()}).
 *
 * @see HashByteFloatMap
 */
public final class HashByteFloatMaps {

    

    private static final ServiceLoader<HashByteFloatMapFactory> LOADER =
            ServiceLoader.load(HashByteFloatMapFactory.class);
    private static HashByteFloatMapFactory defaultFactory = null;

    public static HashByteFloatMapFactory getDefaultFactory() {
        if (defaultFactory != null) {
            return defaultFactory;
        } else {
            // synchronization?
            return defaultFactory = LOADER.iterator().next();
        }
    }

    

    

    

    public static  HashByteFloatMap newMutableMap() {
        return getDefaultFactory().newMutableMap();
    }

    public static  HashByteFloatMap newMutableMap(int expectedSize) {
        return getDefaultFactory().newMutableMap(expectedSize);
    }



    
    


    public static  HashByteFloatMap newMutableMap(Map<Byte, Float> map1,
            Map<Byte, Float> map2, int expectedSize) {
        return getDefaultFactory().newMutableMap(map1, map2, expectedSize);
    }

    public static  HashByteFloatMap newMutableMap(Map<Byte, Float> map1,
            Map<Byte, Float> map2, Map<Byte, Float> map3, int expectedSize) {
        return getDefaultFactory().newMutableMap(map1, map2, map3, expectedSize);
    }

    public static  HashByteFloatMap newMutableMap(Map<Byte, Float> map1,
            Map<Byte, Float> map2, Map<Byte, Float> map3,
            Map<Byte, Float> map4, int expectedSize) {
        return getDefaultFactory().newMutableMap(map1, map2, map3, map4, expectedSize);
    }

    public static  HashByteFloatMap newMutableMap(Map<Byte, Float> map1,
            Map<Byte, Float> map2, Map<Byte, Float> map3,
            Map<Byte, Float> map4, Map<Byte, Float> map5, int expectedSize) {
        return getDefaultFactory().newMutableMap(map1, map2, map3, map4, map5, expectedSize);
    }

    
    

    
    public static  HashByteFloatMap newMutableMap(
            Map<Byte, Float> map) {
        return getDefaultFactory().newMutableMap(map);
    }

    public static  HashByteFloatMap newMutableMap(Map<Byte, Float> map1,
            Map<Byte, Float> map2) {
        return getDefaultFactory().newMutableMap(map1, map2);
    }

    public static  HashByteFloatMap newMutableMap(Map<Byte, Float> map1,
            Map<Byte, Float> map2, Map<Byte, Float> map3) {
        return getDefaultFactory().newMutableMap(map1, map2, map3);
    }

    public static  HashByteFloatMap newMutableMap(Map<Byte, Float> map1,
            Map<Byte, Float> map2, Map<Byte, Float> map3,
            Map<Byte, Float> map4) {
        return getDefaultFactory().newMutableMap(map1, map2, map3, map4);
    }

    public static  HashByteFloatMap newMutableMap(Map<Byte, Float> map1,
            Map<Byte, Float> map2, Map<Byte, Float> map3,
            Map<Byte, Float> map4, Map<Byte, Float> map5) {
        return getDefaultFactory().newMutableMap(map1, map2, map3, map4, map5);
    }


    public static  HashByteFloatMap newMutableMap(
            net.openhft.function.Consumer<ByteFloatConsumer> entriesSupplier) {
        return getDefaultFactory().newMutableMap(entriesSupplier);
    }

    public static  HashByteFloatMap newMutableMap(
            net.openhft.function.Consumer<ByteFloatConsumer> entriesSupplier,
            int expectedSize) {
        return getDefaultFactory().newMutableMap(entriesSupplier, expectedSize);
    }

    public static  HashByteFloatMap newMutableMap(
            byte[] keys, float[] values) {
        return getDefaultFactory().newMutableMap(keys, values);
    }

    public static  HashByteFloatMap newMutableMap(
            byte[] keys, float[] values, int expectedSize) {
        return getDefaultFactory().newMutableMap(keys, values, expectedSize);
    }

    public static  HashByteFloatMap newMutableMap(
            Byte[] keys, Float[] values) {
        return getDefaultFactory().newMutableMap(keys, values);
    }

    public static  HashByteFloatMap newMutableMap(
            Byte[] keys, Float[] values, int expectedSize) {
        return getDefaultFactory().newMutableMap(keys, values, expectedSize);
    }

    public static  HashByteFloatMap newMutableMap(Iterable<Byte> keys,
            Iterable<Float> values) {
        return getDefaultFactory().newMutableMap(keys, values);
    }

    public static  HashByteFloatMap newMutableMap(Iterable<Byte> keys,
            Iterable<Float> values, int expectedSize) {
        return getDefaultFactory().newMutableMap(keys, values, expectedSize);
    }


    public static  HashByteFloatMap newMutableMapOf(
            byte k1, float v1) {
        return getDefaultFactory().newMutableMapOf(k1, v1);
    }

    public static  HashByteFloatMap newMutableMapOf(
            byte k1, float v1, byte k2, float v2) {
        return getDefaultFactory().newMutableMapOf(k1, v1, k2, v2);
    }

    public static  HashByteFloatMap newMutableMapOf(
            byte k1, float v1, byte k2, float v2,
            byte k3, float v3) {
        return getDefaultFactory().newMutableMapOf(k1, v1, k2, v2, k3, v3);
    }

    public static  HashByteFloatMap newMutableMapOf(
            byte k1, float v1, byte k2, float v2,
            byte k3, float v3, byte k4, float v4) {
        return getDefaultFactory().newMutableMapOf(k1, v1, k2, v2, k3, v3, k4, v4);
    }

    public static  HashByteFloatMap newMutableMapOf(
            byte k1, float v1, byte k2, float v2,
            byte k3, float v3, byte k4, float v4,
            byte k5, float v5) {
        return getDefaultFactory().newMutableMapOf(k1, v1, k2, v2, k3, v3, k4, v4, k5, v5);
    }

    
    


    public static  HashByteFloatMap newUpdatableMap(Map<Byte, Float> map1,
            Map<Byte, Float> map2, int expectedSize) {
        return getDefaultFactory().newUpdatableMap(map1, map2, expectedSize);
    }

    public static  HashByteFloatMap newUpdatableMap(Map<Byte, Float> map1,
            Map<Byte, Float> map2, Map<Byte, Float> map3, int expectedSize) {
        return getDefaultFactory().newUpdatableMap(map1, map2, map3, expectedSize);
    }

    public static  HashByteFloatMap newUpdatableMap(Map<Byte, Float> map1,
            Map<Byte, Float> map2, Map<Byte, Float> map3,
            Map<Byte, Float> map4, int expectedSize) {
        return getDefaultFactory().newUpdatableMap(map1, map2, map3, map4, expectedSize);
    }

    public static  HashByteFloatMap newUpdatableMap(Map<Byte, Float> map1,
            Map<Byte, Float> map2, Map<Byte, Float> map3,
            Map<Byte, Float> map4, Map<Byte, Float> map5, int expectedSize) {
        return getDefaultFactory().newUpdatableMap(map1, map2, map3, map4, map5, expectedSize);
    }

    
    

    
    public static  HashByteFloatMap newUpdatableMap(
            Map<Byte, Float> map) {
        return getDefaultFactory().newUpdatableMap(map);
    }

    public static  HashByteFloatMap newUpdatableMap(Map<Byte, Float> map1,
            Map<Byte, Float> map2) {
        return getDefaultFactory().newUpdatableMap(map1, map2);
    }

    public static  HashByteFloatMap newUpdatableMap(Map<Byte, Float> map1,
            Map<Byte, Float> map2, Map<Byte, Float> map3) {
        return getDefaultFactory().newUpdatableMap(map1, map2, map3);
    }

    public static  HashByteFloatMap newUpdatableMap(Map<Byte, Float> map1,
            Map<Byte, Float> map2, Map<Byte, Float> map3,
            Map<Byte, Float> map4) {
        return getDefaultFactory().newUpdatableMap(map1, map2, map3, map4);
    }

    public static  HashByteFloatMap newUpdatableMap(Map<Byte, Float> map1,
            Map<Byte, Float> map2, Map<Byte, Float> map3,
            Map<Byte, Float> map4, Map<Byte, Float> map5) {
        return getDefaultFactory().newUpdatableMap(map1, map2, map3, map4, map5);
    }


    public static  HashByteFloatMap newUpdatableMap(
            net.openhft.function.Consumer<ByteFloatConsumer> entriesSupplier) {
        return getDefaultFactory().newUpdatableMap(entriesSupplier);
    }

    public static  HashByteFloatMap newUpdatableMap(
            net.openhft.function.Consumer<ByteFloatConsumer> entriesSupplier,
            int expectedSize) {
        return getDefaultFactory().newUpdatableMap(entriesSupplier, expectedSize);
    }

    public static  HashByteFloatMap newUpdatableMap(
            byte[] keys, float[] values) {
        return getDefaultFactory().newUpdatableMap(keys, values);
    }

    public static  HashByteFloatMap newUpdatableMap(
            byte[] keys, float[] values, int expectedSize) {
        return getDefaultFactory().newUpdatableMap(keys, values, expectedSize);
    }

    public static  HashByteFloatMap newUpdatableMap(
            Byte[] keys, Float[] values) {
        return getDefaultFactory().newUpdatableMap(keys, values);
    }

    public static  HashByteFloatMap newUpdatableMap(
            Byte[] keys, Float[] values, int expectedSize) {
        return getDefaultFactory().newUpdatableMap(keys, values, expectedSize);
    }

    public static  HashByteFloatMap newUpdatableMap(Iterable<Byte> keys,
            Iterable<Float> values) {
        return getDefaultFactory().newUpdatableMap(keys, values);
    }

    public static  HashByteFloatMap newUpdatableMap(Iterable<Byte> keys,
            Iterable<Float> values, int expectedSize) {
        return getDefaultFactory().newUpdatableMap(keys, values, expectedSize);
    }


    public static  HashByteFloatMap newUpdatableMapOf(
            byte k1, float v1) {
        return getDefaultFactory().newUpdatableMapOf(k1, v1);
    }

    public static  HashByteFloatMap newUpdatableMapOf(
            byte k1, float v1, byte k2, float v2) {
        return getDefaultFactory().newUpdatableMapOf(k1, v1, k2, v2);
    }

    public static  HashByteFloatMap newUpdatableMapOf(
            byte k1, float v1, byte k2, float v2,
            byte k3, float v3) {
        return getDefaultFactory().newUpdatableMapOf(k1, v1, k2, v2, k3, v3);
    }

    public static  HashByteFloatMap newUpdatableMapOf(
            byte k1, float v1, byte k2, float v2,
            byte k3, float v3, byte k4, float v4) {
        return getDefaultFactory().newUpdatableMapOf(k1, v1, k2, v2, k3, v3, k4, v4);
    }

    public static  HashByteFloatMap newUpdatableMapOf(
            byte k1, float v1, byte k2, float v2,
            byte k3, float v3, byte k4, float v4,
            byte k5, float v5) {
        return getDefaultFactory().newUpdatableMapOf(k1, v1, k2, v2, k3, v3, k4, v4, k5, v5);
    }

    
    


    public static  HashByteFloatMap newImmutableMap(Map<Byte, Float> map1,
            Map<Byte, Float> map2, int expectedSize) {
        return getDefaultFactory().newImmutableMap(map1, map2, expectedSize);
    }

    public static  HashByteFloatMap newImmutableMap(Map<Byte, Float> map1,
            Map<Byte, Float> map2, Map<Byte, Float> map3, int expectedSize) {
        return getDefaultFactory().newImmutableMap(map1, map2, map3, expectedSize);
    }

    public static  HashByteFloatMap newImmutableMap(Map<Byte, Float> map1,
            Map<Byte, Float> map2, Map<Byte, Float> map3,
            Map<Byte, Float> map4, int expectedSize) {
        return getDefaultFactory().newImmutableMap(map1, map2, map3, map4, expectedSize);
    }

    public static  HashByteFloatMap newImmutableMap(Map<Byte, Float> map1,
            Map<Byte, Float> map2, Map<Byte, Float> map3,
            Map<Byte, Float> map4, Map<Byte, Float> map5, int expectedSize) {
        return getDefaultFactory().newImmutableMap(map1, map2, map3, map4, map5, expectedSize);
    }

    
    

    
    public static  HashByteFloatMap newImmutableMap(
            Map<Byte, Float> map) {
        return getDefaultFactory().newImmutableMap(map);
    }

    public static  HashByteFloatMap newImmutableMap(Map<Byte, Float> map1,
            Map<Byte, Float> map2) {
        return getDefaultFactory().newImmutableMap(map1, map2);
    }

    public static  HashByteFloatMap newImmutableMap(Map<Byte, Float> map1,
            Map<Byte, Float> map2, Map<Byte, Float> map3) {
        return getDefaultFactory().newImmutableMap(map1, map2, map3);
    }

    public static  HashByteFloatMap newImmutableMap(Map<Byte, Float> map1,
            Map<Byte, Float> map2, Map<Byte, Float> map3,
            Map<Byte, Float> map4) {
        return getDefaultFactory().newImmutableMap(map1, map2, map3, map4);
    }

    public static  HashByteFloatMap newImmutableMap(Map<Byte, Float> map1,
            Map<Byte, Float> map2, Map<Byte, Float> map3,
            Map<Byte, Float> map4, Map<Byte, Float> map5) {
        return getDefaultFactory().newImmutableMap(map1, map2, map3, map4, map5);
    }


    public static  HashByteFloatMap newImmutableMap(
            net.openhft.function.Consumer<ByteFloatConsumer> entriesSupplier) {
        return getDefaultFactory().newImmutableMap(entriesSupplier);
    }

    public static  HashByteFloatMap newImmutableMap(
            net.openhft.function.Consumer<ByteFloatConsumer> entriesSupplier,
            int expectedSize) {
        return getDefaultFactory().newImmutableMap(entriesSupplier, expectedSize);
    }

    public static  HashByteFloatMap newImmutableMap(
            byte[] keys, float[] values) {
        return getDefaultFactory().newImmutableMap(keys, values);
    }

    public static  HashByteFloatMap newImmutableMap(
            byte[] keys, float[] values, int expectedSize) {
        return getDefaultFactory().newImmutableMap(keys, values, expectedSize);
    }

    public static  HashByteFloatMap newImmutableMap(
            Byte[] keys, Float[] values) {
        return getDefaultFactory().newImmutableMap(keys, values);
    }

    public static  HashByteFloatMap newImmutableMap(
            Byte[] keys, Float[] values, int expectedSize) {
        return getDefaultFactory().newImmutableMap(keys, values, expectedSize);
    }

    public static  HashByteFloatMap newImmutableMap(Iterable<Byte> keys,
            Iterable<Float> values) {
        return getDefaultFactory().newImmutableMap(keys, values);
    }

    public static  HashByteFloatMap newImmutableMap(Iterable<Byte> keys,
            Iterable<Float> values, int expectedSize) {
        return getDefaultFactory().newImmutableMap(keys, values, expectedSize);
    }


    public static  HashByteFloatMap newImmutableMapOf(
            byte k1, float v1) {
        return getDefaultFactory().newImmutableMapOf(k1, v1);
    }

    public static  HashByteFloatMap newImmutableMapOf(
            byte k1, float v1, byte k2, float v2) {
        return getDefaultFactory().newImmutableMapOf(k1, v1, k2, v2);
    }

    public static  HashByteFloatMap newImmutableMapOf(
            byte k1, float v1, byte k2, float v2,
            byte k3, float v3) {
        return getDefaultFactory().newImmutableMapOf(k1, v1, k2, v2, k3, v3);
    }

    public static  HashByteFloatMap newImmutableMapOf(
            byte k1, float v1, byte k2, float v2,
            byte k3, float v3, byte k4, float v4) {
        return getDefaultFactory().newImmutableMapOf(k1, v1, k2, v2, k3, v3, k4, v4);
    }

    public static  HashByteFloatMap newImmutableMapOf(
            byte k1, float v1, byte k2, float v2,
            byte k3, float v3, byte k4, float v4,
            byte k5, float v5) {
        return getDefaultFactory().newImmutableMapOf(k1, v1, k2, v2, k3, v3, k4, v4, k5, v5);
    }

    private HashByteFloatMaps() {}
}

