/*
 * Copyright 2014 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.openhft.collect.map.hash;

import net.openhft.collect.*;
import net.openhft.collect.hash.*;
import net.openhft.function.ByteFloatConsumer;
import net.openhft.collect.map.*;
import javax.annotation.Nullable;

import java.util.Map;


/**
 * An immutable factory of {@code HashByteFloatMaps}
 *
 * @see HashByteFloatMap
 * @see HashByteFloatMaps#getDefaultFactory()
 */
public interface HashByteFloatMapFactory extends ByteFloatMapFactory
        , ByteHashFactory<HashByteFloatMapFactory>
         {

    

    

    

    

    

    
    

    
    


    @Override
    HashByteFloatMapFactory withDefaultValue(float defaultValue);

    @Override
     HashByteFloatMap newMutableMap();

    @Override
     HashByteFloatMap newMutableMap(int expectedSize);

    


    @Override
     HashByteFloatMap newMutableMap(Map<Byte, Float> map1,
            Map<Byte, Float> map2, int expectedSize);

    @Override
     HashByteFloatMap newMutableMap(Map<Byte, Float> map1,
            Map<Byte, Float> map2, Map<Byte, Float> map3, int expectedSize);

    @Override
     HashByteFloatMap newMutableMap(Map<Byte, Float> map1,
            Map<Byte, Float> map2, Map<Byte, Float> map3,
            Map<Byte, Float> map4, int expectedSize);

    @Override
     HashByteFloatMap newMutableMap(Map<Byte, Float> map1,
            Map<Byte, Float> map2, Map<Byte, Float> map3,
            Map<Byte, Float> map4, Map<Byte, Float> map5, int expectedSize);

    

    
    @Override
     HashByteFloatMap newMutableMap(Map<Byte, Float> map);

    @Override
     HashByteFloatMap newMutableMap(Map<Byte, Float> map1,
            Map<Byte, Float> map2);

    @Override
     HashByteFloatMap newMutableMap(Map<Byte, Float> map1,
            Map<Byte, Float> map2, Map<Byte, Float> map3);

    @Override
     HashByteFloatMap newMutableMap(Map<Byte, Float> map1,
            Map<Byte, Float> map2, Map<Byte, Float> map3,
            Map<Byte, Float> map4);

    @Override
     HashByteFloatMap newMutableMap(Map<Byte, Float> map1,
            Map<Byte, Float> map2, Map<Byte, Float> map3,
            Map<Byte, Float> map4, Map<Byte, Float> map5);


    @Override
     HashByteFloatMap newMutableMap(
            net.openhft.function.Consumer<ByteFloatConsumer> entriesSupplier);

    @Override
     HashByteFloatMap newMutableMap(
            net.openhft.function.Consumer<ByteFloatConsumer> entriesSupplier,
            int expectedSize);

    @Override
     HashByteFloatMap newMutableMap(byte[] keys, float[] values);

    @Override
     HashByteFloatMap newMutableMap(byte[] keys, float[] values,
            int expectedSize);

    @Override
     HashByteFloatMap newMutableMap(
            Byte[] keys, Float[] values);

    @Override
     HashByteFloatMap newMutableMap(
            Byte[] keys, Float[] values, int expectedSize);

    @Override
     HashByteFloatMap newMutableMap(Iterable<Byte> keys,
            Iterable<Float> values);

    @Override
     HashByteFloatMap newMutableMap(Iterable<Byte> keys,
            Iterable<Float> values, int expectedSize);


    @Override
     HashByteFloatMap newMutableMapOf(byte k1, float v1);

    @Override
     HashByteFloatMap newMutableMapOf(byte k1, float v1,
            byte k2, float v2);

    @Override
     HashByteFloatMap newMutableMapOf(byte k1, float v1,
            byte k2, float v2, byte k3, float v3);

    @Override
     HashByteFloatMap newMutableMapOf(byte k1, float v1,
            byte k2, float v2, byte k3, float v3,
            byte k4, float v4);

    @Override
     HashByteFloatMap newMutableMapOf(byte k1, float v1,
            byte k2, float v2, byte k3, float v3,
            byte k4, float v4, byte k5, float v5);
    @Override
     HashByteFloatMap newUpdatableMap();

    @Override
     HashByteFloatMap newUpdatableMap(int expectedSize);

    


    @Override
     HashByteFloatMap newUpdatableMap(Map<Byte, Float> map1,
            Map<Byte, Float> map2, int expectedSize);

    @Override
     HashByteFloatMap newUpdatableMap(Map<Byte, Float> map1,
            Map<Byte, Float> map2, Map<Byte, Float> map3, int expectedSize);

    @Override
     HashByteFloatMap newUpdatableMap(Map<Byte, Float> map1,
            Map<Byte, Float> map2, Map<Byte, Float> map3,
            Map<Byte, Float> map4, int expectedSize);

    @Override
     HashByteFloatMap newUpdatableMap(Map<Byte, Float> map1,
            Map<Byte, Float> map2, Map<Byte, Float> map3,
            Map<Byte, Float> map4, Map<Byte, Float> map5, int expectedSize);

    

    
    @Override
     HashByteFloatMap newUpdatableMap(Map<Byte, Float> map);

    @Override
     HashByteFloatMap newUpdatableMap(Map<Byte, Float> map1,
            Map<Byte, Float> map2);

    @Override
     HashByteFloatMap newUpdatableMap(Map<Byte, Float> map1,
            Map<Byte, Float> map2, Map<Byte, Float> map3);

    @Override
     HashByteFloatMap newUpdatableMap(Map<Byte, Float> map1,
            Map<Byte, Float> map2, Map<Byte, Float> map3,
            Map<Byte, Float> map4);

    @Override
     HashByteFloatMap newUpdatableMap(Map<Byte, Float> map1,
            Map<Byte, Float> map2, Map<Byte, Float> map3,
            Map<Byte, Float> map4, Map<Byte, Float> map5);


    @Override
     HashByteFloatMap newUpdatableMap(
            net.openhft.function.Consumer<ByteFloatConsumer> entriesSupplier);

    @Override
     HashByteFloatMap newUpdatableMap(
            net.openhft.function.Consumer<ByteFloatConsumer> entriesSupplier,
            int expectedSize);

    @Override
     HashByteFloatMap newUpdatableMap(byte[] keys, float[] values);

    @Override
     HashByteFloatMap newUpdatableMap(byte[] keys, float[] values,
            int expectedSize);

    @Override
     HashByteFloatMap newUpdatableMap(
            Byte[] keys, Float[] values);

    @Override
     HashByteFloatMap newUpdatableMap(
            Byte[] keys, Float[] values, int expectedSize);

    @Override
     HashByteFloatMap newUpdatableMap(Iterable<Byte> keys,
            Iterable<Float> values);

    @Override
     HashByteFloatMap newUpdatableMap(Iterable<Byte> keys,
            Iterable<Float> values, int expectedSize);


    @Override
     HashByteFloatMap newUpdatableMapOf(byte k1, float v1);

    @Override
     HashByteFloatMap newUpdatableMapOf(byte k1, float v1,
            byte k2, float v2);

    @Override
     HashByteFloatMap newUpdatableMapOf(byte k1, float v1,
            byte k2, float v2, byte k3, float v3);

    @Override
     HashByteFloatMap newUpdatableMapOf(byte k1, float v1,
            byte k2, float v2, byte k3, float v3,
            byte k4, float v4);

    @Override
     HashByteFloatMap newUpdatableMapOf(byte k1, float v1,
            byte k2, float v2, byte k3, float v3,
            byte k4, float v4, byte k5, float v5);

    


    @Override
     HashByteFloatMap newImmutableMap(Map<Byte, Float> map1,
            Map<Byte, Float> map2, int expectedSize);

    @Override
     HashByteFloatMap newImmutableMap(Map<Byte, Float> map1,
            Map<Byte, Float> map2, Map<Byte, Float> map3, int expectedSize);

    @Override
     HashByteFloatMap newImmutableMap(Map<Byte, Float> map1,
            Map<Byte, Float> map2, Map<Byte, Float> map3,
            Map<Byte, Float> map4, int expectedSize);

    @Override
     HashByteFloatMap newImmutableMap(Map<Byte, Float> map1,
            Map<Byte, Float> map2, Map<Byte, Float> map3,
            Map<Byte, Float> map4, Map<Byte, Float> map5, int expectedSize);

    

    
    @Override
     HashByteFloatMap newImmutableMap(Map<Byte, Float> map);

    @Override
     HashByteFloatMap newImmutableMap(Map<Byte, Float> map1,
            Map<Byte, Float> map2);

    @Override
     HashByteFloatMap newImmutableMap(Map<Byte, Float> map1,
            Map<Byte, Float> map2, Map<Byte, Float> map3);

    @Override
     HashByteFloatMap newImmutableMap(Map<Byte, Float> map1,
            Map<Byte, Float> map2, Map<Byte, Float> map3,
            Map<Byte, Float> map4);

    @Override
     HashByteFloatMap newImmutableMap(Map<Byte, Float> map1,
            Map<Byte, Float> map2, Map<Byte, Float> map3,
            Map<Byte, Float> map4, Map<Byte, Float> map5);


    @Override
     HashByteFloatMap newImmutableMap(
            net.openhft.function.Consumer<ByteFloatConsumer> entriesSupplier);

    @Override
     HashByteFloatMap newImmutableMap(
            net.openhft.function.Consumer<ByteFloatConsumer> entriesSupplier,
            int expectedSize);

    @Override
     HashByteFloatMap newImmutableMap(byte[] keys, float[] values);

    @Override
     HashByteFloatMap newImmutableMap(byte[] keys, float[] values,
            int expectedSize);

    @Override
     HashByteFloatMap newImmutableMap(
            Byte[] keys, Float[] values);

    @Override
     HashByteFloatMap newImmutableMap(
            Byte[] keys, Float[] values, int expectedSize);

    @Override
     HashByteFloatMap newImmutableMap(Iterable<Byte> keys,
            Iterable<Float> values);

    @Override
     HashByteFloatMap newImmutableMap(Iterable<Byte> keys,
            Iterable<Float> values, int expectedSize);


    @Override
     HashByteFloatMap newImmutableMapOf(byte k1, float v1);

    @Override
     HashByteFloatMap newImmutableMapOf(byte k1, float v1,
            byte k2, float v2);

    @Override
     HashByteFloatMap newImmutableMapOf(byte k1, float v1,
            byte k2, float v2, byte k3, float v3);

    @Override
     HashByteFloatMap newImmutableMapOf(byte k1, float v1,
            byte k2, float v2, byte k3, float v3,
            byte k4, float v4);

    @Override
     HashByteFloatMap newImmutableMapOf(byte k1, float v1,
            byte k2, float v2, byte k3, float v3,
            byte k4, float v4, byte k5, float v5);
}

