/*
 * Copyright 2014 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.openhft.collect.map.hash;

import net.openhft.function.ByteDoubleConsumer;

import java.util.Map;
import java.util.ServiceLoader;


/**
 * This class consists only of static factory methods to construct {@code HashByteDoubleMap}s, and
 * the default {@link HashByteDoubleMapFactory} static provider ({@link #getDefaultFactory()}).
 *
 * @see HashByteDoubleMap
 */
public final class HashByteDoubleMaps {

    

    private static final ServiceLoader<HashByteDoubleMapFactory> LOADER =
            ServiceLoader.load(HashByteDoubleMapFactory.class);
    private static HashByteDoubleMapFactory defaultFactory = null;

    public static HashByteDoubleMapFactory getDefaultFactory() {
        if (defaultFactory != null) {
            return defaultFactory;
        } else {
            // synchronization?
            return defaultFactory = LOADER.iterator().next();
        }
    }

    

    

    

    public static  HashByteDoubleMap newMutableMap() {
        return getDefaultFactory().newMutableMap();
    }

    public static  HashByteDoubleMap newMutableMap(int expectedSize) {
        return getDefaultFactory().newMutableMap(expectedSize);
    }



    
    


    public static  HashByteDoubleMap newMutableMap(Map<Byte, Double> map1,
            Map<Byte, Double> map2, int expectedSize) {
        return getDefaultFactory().newMutableMap(map1, map2, expectedSize);
    }

    public static  HashByteDoubleMap newMutableMap(Map<Byte, Double> map1,
            Map<Byte, Double> map2, Map<Byte, Double> map3, int expectedSize) {
        return getDefaultFactory().newMutableMap(map1, map2, map3, expectedSize);
    }

    public static  HashByteDoubleMap newMutableMap(Map<Byte, Double> map1,
            Map<Byte, Double> map2, Map<Byte, Double> map3,
            Map<Byte, Double> map4, int expectedSize) {
        return getDefaultFactory().newMutableMap(map1, map2, map3, map4, expectedSize);
    }

    public static  HashByteDoubleMap newMutableMap(Map<Byte, Double> map1,
            Map<Byte, Double> map2, Map<Byte, Double> map3,
            Map<Byte, Double> map4, Map<Byte, Double> map5, int expectedSize) {
        return getDefaultFactory().newMutableMap(map1, map2, map3, map4, map5, expectedSize);
    }

    
    

    
    public static  HashByteDoubleMap newMutableMap(
            Map<Byte, Double> map) {
        return getDefaultFactory().newMutableMap(map);
    }

    public static  HashByteDoubleMap newMutableMap(Map<Byte, Double> map1,
            Map<Byte, Double> map2) {
        return getDefaultFactory().newMutableMap(map1, map2);
    }

    public static  HashByteDoubleMap newMutableMap(Map<Byte, Double> map1,
            Map<Byte, Double> map2, Map<Byte, Double> map3) {
        return getDefaultFactory().newMutableMap(map1, map2, map3);
    }

    public static  HashByteDoubleMap newMutableMap(Map<Byte, Double> map1,
            Map<Byte, Double> map2, Map<Byte, Double> map3,
            Map<Byte, Double> map4) {
        return getDefaultFactory().newMutableMap(map1, map2, map3, map4);
    }

    public static  HashByteDoubleMap newMutableMap(Map<Byte, Double> map1,
            Map<Byte, Double> map2, Map<Byte, Double> map3,
            Map<Byte, Double> map4, Map<Byte, Double> map5) {
        return getDefaultFactory().newMutableMap(map1, map2, map3, map4, map5);
    }


    public static  HashByteDoubleMap newMutableMap(
            net.openhft.function.Consumer<ByteDoubleConsumer> entriesSupplier) {
        return getDefaultFactory().newMutableMap(entriesSupplier);
    }

    public static  HashByteDoubleMap newMutableMap(
            net.openhft.function.Consumer<ByteDoubleConsumer> entriesSupplier,
            int expectedSize) {
        return getDefaultFactory().newMutableMap(entriesSupplier, expectedSize);
    }

    public static  HashByteDoubleMap newMutableMap(
            byte[] keys, double[] values) {
        return getDefaultFactory().newMutableMap(keys, values);
    }

    public static  HashByteDoubleMap newMutableMap(
            byte[] keys, double[] values, int expectedSize) {
        return getDefaultFactory().newMutableMap(keys, values, expectedSize);
    }

    public static  HashByteDoubleMap newMutableMap(
            Byte[] keys, Double[] values) {
        return getDefaultFactory().newMutableMap(keys, values);
    }

    public static  HashByteDoubleMap newMutableMap(
            Byte[] keys, Double[] values, int expectedSize) {
        return getDefaultFactory().newMutableMap(keys, values, expectedSize);
    }

    public static  HashByteDoubleMap newMutableMap(Iterable<Byte> keys,
            Iterable<Double> values) {
        return getDefaultFactory().newMutableMap(keys, values);
    }

    public static  HashByteDoubleMap newMutableMap(Iterable<Byte> keys,
            Iterable<Double> values, int expectedSize) {
        return getDefaultFactory().newMutableMap(keys, values, expectedSize);
    }


    public static  HashByteDoubleMap newMutableMapOf(
            byte k1, double v1) {
        return getDefaultFactory().newMutableMapOf(k1, v1);
    }

    public static  HashByteDoubleMap newMutableMapOf(
            byte k1, double v1, byte k2, double v2) {
        return getDefaultFactory().newMutableMapOf(k1, v1, k2, v2);
    }

    public static  HashByteDoubleMap newMutableMapOf(
            byte k1, double v1, byte k2, double v2,
            byte k3, double v3) {
        return getDefaultFactory().newMutableMapOf(k1, v1, k2, v2, k3, v3);
    }

    public static  HashByteDoubleMap newMutableMapOf(
            byte k1, double v1, byte k2, double v2,
            byte k3, double v3, byte k4, double v4) {
        return getDefaultFactory().newMutableMapOf(k1, v1, k2, v2, k3, v3, k4, v4);
    }

    public static  HashByteDoubleMap newMutableMapOf(
            byte k1, double v1, byte k2, double v2,
            byte k3, double v3, byte k4, double v4,
            byte k5, double v5) {
        return getDefaultFactory().newMutableMapOf(k1, v1, k2, v2, k3, v3, k4, v4, k5, v5);
    }

    
    


    public static  HashByteDoubleMap newUpdatableMap(Map<Byte, Double> map1,
            Map<Byte, Double> map2, int expectedSize) {
        return getDefaultFactory().newUpdatableMap(map1, map2, expectedSize);
    }

    public static  HashByteDoubleMap newUpdatableMap(Map<Byte, Double> map1,
            Map<Byte, Double> map2, Map<Byte, Double> map3, int expectedSize) {
        return getDefaultFactory().newUpdatableMap(map1, map2, map3, expectedSize);
    }

    public static  HashByteDoubleMap newUpdatableMap(Map<Byte, Double> map1,
            Map<Byte, Double> map2, Map<Byte, Double> map3,
            Map<Byte, Double> map4, int expectedSize) {
        return getDefaultFactory().newUpdatableMap(map1, map2, map3, map4, expectedSize);
    }

    public static  HashByteDoubleMap newUpdatableMap(Map<Byte, Double> map1,
            Map<Byte, Double> map2, Map<Byte, Double> map3,
            Map<Byte, Double> map4, Map<Byte, Double> map5, int expectedSize) {
        return getDefaultFactory().newUpdatableMap(map1, map2, map3, map4, map5, expectedSize);
    }

    
    

    
    public static  HashByteDoubleMap newUpdatableMap(
            Map<Byte, Double> map) {
        return getDefaultFactory().newUpdatableMap(map);
    }

    public static  HashByteDoubleMap newUpdatableMap(Map<Byte, Double> map1,
            Map<Byte, Double> map2) {
        return getDefaultFactory().newUpdatableMap(map1, map2);
    }

    public static  HashByteDoubleMap newUpdatableMap(Map<Byte, Double> map1,
            Map<Byte, Double> map2, Map<Byte, Double> map3) {
        return getDefaultFactory().newUpdatableMap(map1, map2, map3);
    }

    public static  HashByteDoubleMap newUpdatableMap(Map<Byte, Double> map1,
            Map<Byte, Double> map2, Map<Byte, Double> map3,
            Map<Byte, Double> map4) {
        return getDefaultFactory().newUpdatableMap(map1, map2, map3, map4);
    }

    public static  HashByteDoubleMap newUpdatableMap(Map<Byte, Double> map1,
            Map<Byte, Double> map2, Map<Byte, Double> map3,
            Map<Byte, Double> map4, Map<Byte, Double> map5) {
        return getDefaultFactory().newUpdatableMap(map1, map2, map3, map4, map5);
    }


    public static  HashByteDoubleMap newUpdatableMap(
            net.openhft.function.Consumer<ByteDoubleConsumer> entriesSupplier) {
        return getDefaultFactory().newUpdatableMap(entriesSupplier);
    }

    public static  HashByteDoubleMap newUpdatableMap(
            net.openhft.function.Consumer<ByteDoubleConsumer> entriesSupplier,
            int expectedSize) {
        return getDefaultFactory().newUpdatableMap(entriesSupplier, expectedSize);
    }

    public static  HashByteDoubleMap newUpdatableMap(
            byte[] keys, double[] values) {
        return getDefaultFactory().newUpdatableMap(keys, values);
    }

    public static  HashByteDoubleMap newUpdatableMap(
            byte[] keys, double[] values, int expectedSize) {
        return getDefaultFactory().newUpdatableMap(keys, values, expectedSize);
    }

    public static  HashByteDoubleMap newUpdatableMap(
            Byte[] keys, Double[] values) {
        return getDefaultFactory().newUpdatableMap(keys, values);
    }

    public static  HashByteDoubleMap newUpdatableMap(
            Byte[] keys, Double[] values, int expectedSize) {
        return getDefaultFactory().newUpdatableMap(keys, values, expectedSize);
    }

    public static  HashByteDoubleMap newUpdatableMap(Iterable<Byte> keys,
            Iterable<Double> values) {
        return getDefaultFactory().newUpdatableMap(keys, values);
    }

    public static  HashByteDoubleMap newUpdatableMap(Iterable<Byte> keys,
            Iterable<Double> values, int expectedSize) {
        return getDefaultFactory().newUpdatableMap(keys, values, expectedSize);
    }


    public static  HashByteDoubleMap newUpdatableMapOf(
            byte k1, double v1) {
        return getDefaultFactory().newUpdatableMapOf(k1, v1);
    }

    public static  HashByteDoubleMap newUpdatableMapOf(
            byte k1, double v1, byte k2, double v2) {
        return getDefaultFactory().newUpdatableMapOf(k1, v1, k2, v2);
    }

    public static  HashByteDoubleMap newUpdatableMapOf(
            byte k1, double v1, byte k2, double v2,
            byte k3, double v3) {
        return getDefaultFactory().newUpdatableMapOf(k1, v1, k2, v2, k3, v3);
    }

    public static  HashByteDoubleMap newUpdatableMapOf(
            byte k1, double v1, byte k2, double v2,
            byte k3, double v3, byte k4, double v4) {
        return getDefaultFactory().newUpdatableMapOf(k1, v1, k2, v2, k3, v3, k4, v4);
    }

    public static  HashByteDoubleMap newUpdatableMapOf(
            byte k1, double v1, byte k2, double v2,
            byte k3, double v3, byte k4, double v4,
            byte k5, double v5) {
        return getDefaultFactory().newUpdatableMapOf(k1, v1, k2, v2, k3, v3, k4, v4, k5, v5);
    }

    
    


    public static  HashByteDoubleMap newImmutableMap(Map<Byte, Double> map1,
            Map<Byte, Double> map2, int expectedSize) {
        return getDefaultFactory().newImmutableMap(map1, map2, expectedSize);
    }

    public static  HashByteDoubleMap newImmutableMap(Map<Byte, Double> map1,
            Map<Byte, Double> map2, Map<Byte, Double> map3, int expectedSize) {
        return getDefaultFactory().newImmutableMap(map1, map2, map3, expectedSize);
    }

    public static  HashByteDoubleMap newImmutableMap(Map<Byte, Double> map1,
            Map<Byte, Double> map2, Map<Byte, Double> map3,
            Map<Byte, Double> map4, int expectedSize) {
        return getDefaultFactory().newImmutableMap(map1, map2, map3, map4, expectedSize);
    }

    public static  HashByteDoubleMap newImmutableMap(Map<Byte, Double> map1,
            Map<Byte, Double> map2, Map<Byte, Double> map3,
            Map<Byte, Double> map4, Map<Byte, Double> map5, int expectedSize) {
        return getDefaultFactory().newImmutableMap(map1, map2, map3, map4, map5, expectedSize);
    }

    
    

    
    public static  HashByteDoubleMap newImmutableMap(
            Map<Byte, Double> map) {
        return getDefaultFactory().newImmutableMap(map);
    }

    public static  HashByteDoubleMap newImmutableMap(Map<Byte, Double> map1,
            Map<Byte, Double> map2) {
        return getDefaultFactory().newImmutableMap(map1, map2);
    }

    public static  HashByteDoubleMap newImmutableMap(Map<Byte, Double> map1,
            Map<Byte, Double> map2, Map<Byte, Double> map3) {
        return getDefaultFactory().newImmutableMap(map1, map2, map3);
    }

    public static  HashByteDoubleMap newImmutableMap(Map<Byte, Double> map1,
            Map<Byte, Double> map2, Map<Byte, Double> map3,
            Map<Byte, Double> map4) {
        return getDefaultFactory().newImmutableMap(map1, map2, map3, map4);
    }

    public static  HashByteDoubleMap newImmutableMap(Map<Byte, Double> map1,
            Map<Byte, Double> map2, Map<Byte, Double> map3,
            Map<Byte, Double> map4, Map<Byte, Double> map5) {
        return getDefaultFactory().newImmutableMap(map1, map2, map3, map4, map5);
    }


    public static  HashByteDoubleMap newImmutableMap(
            net.openhft.function.Consumer<ByteDoubleConsumer> entriesSupplier) {
        return getDefaultFactory().newImmutableMap(entriesSupplier);
    }

    public static  HashByteDoubleMap newImmutableMap(
            net.openhft.function.Consumer<ByteDoubleConsumer> entriesSupplier,
            int expectedSize) {
        return getDefaultFactory().newImmutableMap(entriesSupplier, expectedSize);
    }

    public static  HashByteDoubleMap newImmutableMap(
            byte[] keys, double[] values) {
        return getDefaultFactory().newImmutableMap(keys, values);
    }

    public static  HashByteDoubleMap newImmutableMap(
            byte[] keys, double[] values, int expectedSize) {
        return getDefaultFactory().newImmutableMap(keys, values, expectedSize);
    }

    public static  HashByteDoubleMap newImmutableMap(
            Byte[] keys, Double[] values) {
        return getDefaultFactory().newImmutableMap(keys, values);
    }

    public static  HashByteDoubleMap newImmutableMap(
            Byte[] keys, Double[] values, int expectedSize) {
        return getDefaultFactory().newImmutableMap(keys, values, expectedSize);
    }

    public static  HashByteDoubleMap newImmutableMap(Iterable<Byte> keys,
            Iterable<Double> values) {
        return getDefaultFactory().newImmutableMap(keys, values);
    }

    public static  HashByteDoubleMap newImmutableMap(Iterable<Byte> keys,
            Iterable<Double> values, int expectedSize) {
        return getDefaultFactory().newImmutableMap(keys, values, expectedSize);
    }


    public static  HashByteDoubleMap newImmutableMapOf(
            byte k1, double v1) {
        return getDefaultFactory().newImmutableMapOf(k1, v1);
    }

    public static  HashByteDoubleMap newImmutableMapOf(
            byte k1, double v1, byte k2, double v2) {
        return getDefaultFactory().newImmutableMapOf(k1, v1, k2, v2);
    }

    public static  HashByteDoubleMap newImmutableMapOf(
            byte k1, double v1, byte k2, double v2,
            byte k3, double v3) {
        return getDefaultFactory().newImmutableMapOf(k1, v1, k2, v2, k3, v3);
    }

    public static  HashByteDoubleMap newImmutableMapOf(
            byte k1, double v1, byte k2, double v2,
            byte k3, double v3, byte k4, double v4) {
        return getDefaultFactory().newImmutableMapOf(k1, v1, k2, v2, k3, v3, k4, v4);
    }

    public static  HashByteDoubleMap newImmutableMapOf(
            byte k1, double v1, byte k2, double v2,
            byte k3, double v3, byte k4, double v4,
            byte k5, double v5) {
        return getDefaultFactory().newImmutableMapOf(k1, v1, k2, v2, k3, v3, k4, v4, k5, v5);
    }

    private HashByteDoubleMaps() {}
}

