/*
 * Copyright 2014 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.openhft.collect.map.hash;

import net.openhft.collect.*;
import net.openhft.collect.hash.*;
import net.openhft.function.ByteDoubleConsumer;
import net.openhft.collect.map.*;
import javax.annotation.Nullable;

import java.util.Map;


/**
 * An immutable factory of {@code HashByteDoubleMaps}
 *
 * @see HashByteDoubleMap
 * @see HashByteDoubleMaps#getDefaultFactory()
 */
public interface HashByteDoubleMapFactory extends ByteDoubleMapFactory
        , ByteHashFactory<HashByteDoubleMapFactory>
         {

    

    

    

    

    

    
    

    
    


    @Override
    HashByteDoubleMapFactory withDefaultValue(double defaultValue);

    @Override
     HashByteDoubleMap newMutableMap();

    @Override
     HashByteDoubleMap newMutableMap(int expectedSize);

    


    @Override
     HashByteDoubleMap newMutableMap(Map<Byte, Double> map1,
            Map<Byte, Double> map2, int expectedSize);

    @Override
     HashByteDoubleMap newMutableMap(Map<Byte, Double> map1,
            Map<Byte, Double> map2, Map<Byte, Double> map3, int expectedSize);

    @Override
     HashByteDoubleMap newMutableMap(Map<Byte, Double> map1,
            Map<Byte, Double> map2, Map<Byte, Double> map3,
            Map<Byte, Double> map4, int expectedSize);

    @Override
     HashByteDoubleMap newMutableMap(Map<Byte, Double> map1,
            Map<Byte, Double> map2, Map<Byte, Double> map3,
            Map<Byte, Double> map4, Map<Byte, Double> map5, int expectedSize);

    

    
    @Override
     HashByteDoubleMap newMutableMap(Map<Byte, Double> map);

    @Override
     HashByteDoubleMap newMutableMap(Map<Byte, Double> map1,
            Map<Byte, Double> map2);

    @Override
     HashByteDoubleMap newMutableMap(Map<Byte, Double> map1,
            Map<Byte, Double> map2, Map<Byte, Double> map3);

    @Override
     HashByteDoubleMap newMutableMap(Map<Byte, Double> map1,
            Map<Byte, Double> map2, Map<Byte, Double> map3,
            Map<Byte, Double> map4);

    @Override
     HashByteDoubleMap newMutableMap(Map<Byte, Double> map1,
            Map<Byte, Double> map2, Map<Byte, Double> map3,
            Map<Byte, Double> map4, Map<Byte, Double> map5);


    @Override
     HashByteDoubleMap newMutableMap(
            net.openhft.function.Consumer<ByteDoubleConsumer> entriesSupplier);

    @Override
     HashByteDoubleMap newMutableMap(
            net.openhft.function.Consumer<ByteDoubleConsumer> entriesSupplier,
            int expectedSize);

    @Override
     HashByteDoubleMap newMutableMap(byte[] keys, double[] values);

    @Override
     HashByteDoubleMap newMutableMap(byte[] keys, double[] values,
            int expectedSize);

    @Override
     HashByteDoubleMap newMutableMap(
            Byte[] keys, Double[] values);

    @Override
     HashByteDoubleMap newMutableMap(
            Byte[] keys, Double[] values, int expectedSize);

    @Override
     HashByteDoubleMap newMutableMap(Iterable<Byte> keys,
            Iterable<Double> values);

    @Override
     HashByteDoubleMap newMutableMap(Iterable<Byte> keys,
            Iterable<Double> values, int expectedSize);


    @Override
     HashByteDoubleMap newMutableMapOf(byte k1, double v1);

    @Override
     HashByteDoubleMap newMutableMapOf(byte k1, double v1,
            byte k2, double v2);

    @Override
     HashByteDoubleMap newMutableMapOf(byte k1, double v1,
            byte k2, double v2, byte k3, double v3);

    @Override
     HashByteDoubleMap newMutableMapOf(byte k1, double v1,
            byte k2, double v2, byte k3, double v3,
            byte k4, double v4);

    @Override
     HashByteDoubleMap newMutableMapOf(byte k1, double v1,
            byte k2, double v2, byte k3, double v3,
            byte k4, double v4, byte k5, double v5);
    @Override
     HashByteDoubleMap newUpdatableMap();

    @Override
     HashByteDoubleMap newUpdatableMap(int expectedSize);

    


    @Override
     HashByteDoubleMap newUpdatableMap(Map<Byte, Double> map1,
            Map<Byte, Double> map2, int expectedSize);

    @Override
     HashByteDoubleMap newUpdatableMap(Map<Byte, Double> map1,
            Map<Byte, Double> map2, Map<Byte, Double> map3, int expectedSize);

    @Override
     HashByteDoubleMap newUpdatableMap(Map<Byte, Double> map1,
            Map<Byte, Double> map2, Map<Byte, Double> map3,
            Map<Byte, Double> map4, int expectedSize);

    @Override
     HashByteDoubleMap newUpdatableMap(Map<Byte, Double> map1,
            Map<Byte, Double> map2, Map<Byte, Double> map3,
            Map<Byte, Double> map4, Map<Byte, Double> map5, int expectedSize);

    

    
    @Override
     HashByteDoubleMap newUpdatableMap(Map<Byte, Double> map);

    @Override
     HashByteDoubleMap newUpdatableMap(Map<Byte, Double> map1,
            Map<Byte, Double> map2);

    @Override
     HashByteDoubleMap newUpdatableMap(Map<Byte, Double> map1,
            Map<Byte, Double> map2, Map<Byte, Double> map3);

    @Override
     HashByteDoubleMap newUpdatableMap(Map<Byte, Double> map1,
            Map<Byte, Double> map2, Map<Byte, Double> map3,
            Map<Byte, Double> map4);

    @Override
     HashByteDoubleMap newUpdatableMap(Map<Byte, Double> map1,
            Map<Byte, Double> map2, Map<Byte, Double> map3,
            Map<Byte, Double> map4, Map<Byte, Double> map5);


    @Override
     HashByteDoubleMap newUpdatableMap(
            net.openhft.function.Consumer<ByteDoubleConsumer> entriesSupplier);

    @Override
     HashByteDoubleMap newUpdatableMap(
            net.openhft.function.Consumer<ByteDoubleConsumer> entriesSupplier,
            int expectedSize);

    @Override
     HashByteDoubleMap newUpdatableMap(byte[] keys, double[] values);

    @Override
     HashByteDoubleMap newUpdatableMap(byte[] keys, double[] values,
            int expectedSize);

    @Override
     HashByteDoubleMap newUpdatableMap(
            Byte[] keys, Double[] values);

    @Override
     HashByteDoubleMap newUpdatableMap(
            Byte[] keys, Double[] values, int expectedSize);

    @Override
     HashByteDoubleMap newUpdatableMap(Iterable<Byte> keys,
            Iterable<Double> values);

    @Override
     HashByteDoubleMap newUpdatableMap(Iterable<Byte> keys,
            Iterable<Double> values, int expectedSize);


    @Override
     HashByteDoubleMap newUpdatableMapOf(byte k1, double v1);

    @Override
     HashByteDoubleMap newUpdatableMapOf(byte k1, double v1,
            byte k2, double v2);

    @Override
     HashByteDoubleMap newUpdatableMapOf(byte k1, double v1,
            byte k2, double v2, byte k3, double v3);

    @Override
     HashByteDoubleMap newUpdatableMapOf(byte k1, double v1,
            byte k2, double v2, byte k3, double v3,
            byte k4, double v4);

    @Override
     HashByteDoubleMap newUpdatableMapOf(byte k1, double v1,
            byte k2, double v2, byte k3, double v3,
            byte k4, double v4, byte k5, double v5);

    


    @Override
     HashByteDoubleMap newImmutableMap(Map<Byte, Double> map1,
            Map<Byte, Double> map2, int expectedSize);

    @Override
     HashByteDoubleMap newImmutableMap(Map<Byte, Double> map1,
            Map<Byte, Double> map2, Map<Byte, Double> map3, int expectedSize);

    @Override
     HashByteDoubleMap newImmutableMap(Map<Byte, Double> map1,
            Map<Byte, Double> map2, Map<Byte, Double> map3,
            Map<Byte, Double> map4, int expectedSize);

    @Override
     HashByteDoubleMap newImmutableMap(Map<Byte, Double> map1,
            Map<Byte, Double> map2, Map<Byte, Double> map3,
            Map<Byte, Double> map4, Map<Byte, Double> map5, int expectedSize);

    

    
    @Override
     HashByteDoubleMap newImmutableMap(Map<Byte, Double> map);

    @Override
     HashByteDoubleMap newImmutableMap(Map<Byte, Double> map1,
            Map<Byte, Double> map2);

    @Override
     HashByteDoubleMap newImmutableMap(Map<Byte, Double> map1,
            Map<Byte, Double> map2, Map<Byte, Double> map3);

    @Override
     HashByteDoubleMap newImmutableMap(Map<Byte, Double> map1,
            Map<Byte, Double> map2, Map<Byte, Double> map3,
            Map<Byte, Double> map4);

    @Override
     HashByteDoubleMap newImmutableMap(Map<Byte, Double> map1,
            Map<Byte, Double> map2, Map<Byte, Double> map3,
            Map<Byte, Double> map4, Map<Byte, Double> map5);


    @Override
     HashByteDoubleMap newImmutableMap(
            net.openhft.function.Consumer<ByteDoubleConsumer> entriesSupplier);

    @Override
     HashByteDoubleMap newImmutableMap(
            net.openhft.function.Consumer<ByteDoubleConsumer> entriesSupplier,
            int expectedSize);

    @Override
     HashByteDoubleMap newImmutableMap(byte[] keys, double[] values);

    @Override
     HashByteDoubleMap newImmutableMap(byte[] keys, double[] values,
            int expectedSize);

    @Override
     HashByteDoubleMap newImmutableMap(
            Byte[] keys, Double[] values);

    @Override
     HashByteDoubleMap newImmutableMap(
            Byte[] keys, Double[] values, int expectedSize);

    @Override
     HashByteDoubleMap newImmutableMap(Iterable<Byte> keys,
            Iterable<Double> values);

    @Override
     HashByteDoubleMap newImmutableMap(Iterable<Byte> keys,
            Iterable<Double> values, int expectedSize);


    @Override
     HashByteDoubleMap newImmutableMapOf(byte k1, double v1);

    @Override
     HashByteDoubleMap newImmutableMapOf(byte k1, double v1,
            byte k2, double v2);

    @Override
     HashByteDoubleMap newImmutableMapOf(byte k1, double v1,
            byte k2, double v2, byte k3, double v3);

    @Override
     HashByteDoubleMap newImmutableMapOf(byte k1, double v1,
            byte k2, double v2, byte k3, double v3,
            byte k4, double v4);

    @Override
     HashByteDoubleMap newImmutableMapOf(byte k1, double v1,
            byte k2, double v2, byte k3, double v3,
            byte k4, double v4, byte k5, double v5);
}

