/*
 * Copyright 2014 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.openhft.collect.map.hash;

import net.openhft.function.ByteCharConsumer;

import java.util.Map;
import java.util.ServiceLoader;


/**
 * This class consists only of static factory methods to construct {@code HashByteCharMap}s, and
 * the default {@link HashByteCharMapFactory} static provider ({@link #getDefaultFactory()}).
 *
 * @see HashByteCharMap
 */
public final class HashByteCharMaps {

    

    private static final ServiceLoader<HashByteCharMapFactory> LOADER =
            ServiceLoader.load(HashByteCharMapFactory.class);
    private static HashByteCharMapFactory defaultFactory = null;

    public static HashByteCharMapFactory getDefaultFactory() {
        if (defaultFactory != null) {
            return defaultFactory;
        } else {
            // synchronization?
            return defaultFactory = LOADER.iterator().next();
        }
    }

    

    

    

    public static  HashByteCharMap newMutableMap() {
        return getDefaultFactory().newMutableMap();
    }

    public static  HashByteCharMap newMutableMap(int expectedSize) {
        return getDefaultFactory().newMutableMap(expectedSize);
    }



    
    


    public static  HashByteCharMap newMutableMap(Map<Byte, Character> map1,
            Map<Byte, Character> map2, int expectedSize) {
        return getDefaultFactory().newMutableMap(map1, map2, expectedSize);
    }

    public static  HashByteCharMap newMutableMap(Map<Byte, Character> map1,
            Map<Byte, Character> map2, Map<Byte, Character> map3, int expectedSize) {
        return getDefaultFactory().newMutableMap(map1, map2, map3, expectedSize);
    }

    public static  HashByteCharMap newMutableMap(Map<Byte, Character> map1,
            Map<Byte, Character> map2, Map<Byte, Character> map3,
            Map<Byte, Character> map4, int expectedSize) {
        return getDefaultFactory().newMutableMap(map1, map2, map3, map4, expectedSize);
    }

    public static  HashByteCharMap newMutableMap(Map<Byte, Character> map1,
            Map<Byte, Character> map2, Map<Byte, Character> map3,
            Map<Byte, Character> map4, Map<Byte, Character> map5, int expectedSize) {
        return getDefaultFactory().newMutableMap(map1, map2, map3, map4, map5, expectedSize);
    }

    
    

    
    public static  HashByteCharMap newMutableMap(
            Map<Byte, Character> map) {
        return getDefaultFactory().newMutableMap(map);
    }

    public static  HashByteCharMap newMutableMap(Map<Byte, Character> map1,
            Map<Byte, Character> map2) {
        return getDefaultFactory().newMutableMap(map1, map2);
    }

    public static  HashByteCharMap newMutableMap(Map<Byte, Character> map1,
            Map<Byte, Character> map2, Map<Byte, Character> map3) {
        return getDefaultFactory().newMutableMap(map1, map2, map3);
    }

    public static  HashByteCharMap newMutableMap(Map<Byte, Character> map1,
            Map<Byte, Character> map2, Map<Byte, Character> map3,
            Map<Byte, Character> map4) {
        return getDefaultFactory().newMutableMap(map1, map2, map3, map4);
    }

    public static  HashByteCharMap newMutableMap(Map<Byte, Character> map1,
            Map<Byte, Character> map2, Map<Byte, Character> map3,
            Map<Byte, Character> map4, Map<Byte, Character> map5) {
        return getDefaultFactory().newMutableMap(map1, map2, map3, map4, map5);
    }


    public static  HashByteCharMap newMutableMap(
            net.openhft.function.Consumer<ByteCharConsumer> entriesSupplier) {
        return getDefaultFactory().newMutableMap(entriesSupplier);
    }

    public static  HashByteCharMap newMutableMap(
            net.openhft.function.Consumer<ByteCharConsumer> entriesSupplier,
            int expectedSize) {
        return getDefaultFactory().newMutableMap(entriesSupplier, expectedSize);
    }

    public static  HashByteCharMap newMutableMap(
            byte[] keys, char[] values) {
        return getDefaultFactory().newMutableMap(keys, values);
    }

    public static  HashByteCharMap newMutableMap(
            byte[] keys, char[] values, int expectedSize) {
        return getDefaultFactory().newMutableMap(keys, values, expectedSize);
    }

    public static  HashByteCharMap newMutableMap(
            Byte[] keys, Character[] values) {
        return getDefaultFactory().newMutableMap(keys, values);
    }

    public static  HashByteCharMap newMutableMap(
            Byte[] keys, Character[] values, int expectedSize) {
        return getDefaultFactory().newMutableMap(keys, values, expectedSize);
    }

    public static  HashByteCharMap newMutableMap(Iterable<Byte> keys,
            Iterable<Character> values) {
        return getDefaultFactory().newMutableMap(keys, values);
    }

    public static  HashByteCharMap newMutableMap(Iterable<Byte> keys,
            Iterable<Character> values, int expectedSize) {
        return getDefaultFactory().newMutableMap(keys, values, expectedSize);
    }


    public static  HashByteCharMap newMutableMapOf(
            byte k1, char v1) {
        return getDefaultFactory().newMutableMapOf(k1, v1);
    }

    public static  HashByteCharMap newMutableMapOf(
            byte k1, char v1, byte k2, char v2) {
        return getDefaultFactory().newMutableMapOf(k1, v1, k2, v2);
    }

    public static  HashByteCharMap newMutableMapOf(
            byte k1, char v1, byte k2, char v2,
            byte k3, char v3) {
        return getDefaultFactory().newMutableMapOf(k1, v1, k2, v2, k3, v3);
    }

    public static  HashByteCharMap newMutableMapOf(
            byte k1, char v1, byte k2, char v2,
            byte k3, char v3, byte k4, char v4) {
        return getDefaultFactory().newMutableMapOf(k1, v1, k2, v2, k3, v3, k4, v4);
    }

    public static  HashByteCharMap newMutableMapOf(
            byte k1, char v1, byte k2, char v2,
            byte k3, char v3, byte k4, char v4,
            byte k5, char v5) {
        return getDefaultFactory().newMutableMapOf(k1, v1, k2, v2, k3, v3, k4, v4, k5, v5);
    }

    
    


    public static  HashByteCharMap newUpdatableMap(Map<Byte, Character> map1,
            Map<Byte, Character> map2, int expectedSize) {
        return getDefaultFactory().newUpdatableMap(map1, map2, expectedSize);
    }

    public static  HashByteCharMap newUpdatableMap(Map<Byte, Character> map1,
            Map<Byte, Character> map2, Map<Byte, Character> map3, int expectedSize) {
        return getDefaultFactory().newUpdatableMap(map1, map2, map3, expectedSize);
    }

    public static  HashByteCharMap newUpdatableMap(Map<Byte, Character> map1,
            Map<Byte, Character> map2, Map<Byte, Character> map3,
            Map<Byte, Character> map4, int expectedSize) {
        return getDefaultFactory().newUpdatableMap(map1, map2, map3, map4, expectedSize);
    }

    public static  HashByteCharMap newUpdatableMap(Map<Byte, Character> map1,
            Map<Byte, Character> map2, Map<Byte, Character> map3,
            Map<Byte, Character> map4, Map<Byte, Character> map5, int expectedSize) {
        return getDefaultFactory().newUpdatableMap(map1, map2, map3, map4, map5, expectedSize);
    }

    
    

    
    public static  HashByteCharMap newUpdatableMap(
            Map<Byte, Character> map) {
        return getDefaultFactory().newUpdatableMap(map);
    }

    public static  HashByteCharMap newUpdatableMap(Map<Byte, Character> map1,
            Map<Byte, Character> map2) {
        return getDefaultFactory().newUpdatableMap(map1, map2);
    }

    public static  HashByteCharMap newUpdatableMap(Map<Byte, Character> map1,
            Map<Byte, Character> map2, Map<Byte, Character> map3) {
        return getDefaultFactory().newUpdatableMap(map1, map2, map3);
    }

    public static  HashByteCharMap newUpdatableMap(Map<Byte, Character> map1,
            Map<Byte, Character> map2, Map<Byte, Character> map3,
            Map<Byte, Character> map4) {
        return getDefaultFactory().newUpdatableMap(map1, map2, map3, map4);
    }

    public static  HashByteCharMap newUpdatableMap(Map<Byte, Character> map1,
            Map<Byte, Character> map2, Map<Byte, Character> map3,
            Map<Byte, Character> map4, Map<Byte, Character> map5) {
        return getDefaultFactory().newUpdatableMap(map1, map2, map3, map4, map5);
    }


    public static  HashByteCharMap newUpdatableMap(
            net.openhft.function.Consumer<ByteCharConsumer> entriesSupplier) {
        return getDefaultFactory().newUpdatableMap(entriesSupplier);
    }

    public static  HashByteCharMap newUpdatableMap(
            net.openhft.function.Consumer<ByteCharConsumer> entriesSupplier,
            int expectedSize) {
        return getDefaultFactory().newUpdatableMap(entriesSupplier, expectedSize);
    }

    public static  HashByteCharMap newUpdatableMap(
            byte[] keys, char[] values) {
        return getDefaultFactory().newUpdatableMap(keys, values);
    }

    public static  HashByteCharMap newUpdatableMap(
            byte[] keys, char[] values, int expectedSize) {
        return getDefaultFactory().newUpdatableMap(keys, values, expectedSize);
    }

    public static  HashByteCharMap newUpdatableMap(
            Byte[] keys, Character[] values) {
        return getDefaultFactory().newUpdatableMap(keys, values);
    }

    public static  HashByteCharMap newUpdatableMap(
            Byte[] keys, Character[] values, int expectedSize) {
        return getDefaultFactory().newUpdatableMap(keys, values, expectedSize);
    }

    public static  HashByteCharMap newUpdatableMap(Iterable<Byte> keys,
            Iterable<Character> values) {
        return getDefaultFactory().newUpdatableMap(keys, values);
    }

    public static  HashByteCharMap newUpdatableMap(Iterable<Byte> keys,
            Iterable<Character> values, int expectedSize) {
        return getDefaultFactory().newUpdatableMap(keys, values, expectedSize);
    }


    public static  HashByteCharMap newUpdatableMapOf(
            byte k1, char v1) {
        return getDefaultFactory().newUpdatableMapOf(k1, v1);
    }

    public static  HashByteCharMap newUpdatableMapOf(
            byte k1, char v1, byte k2, char v2) {
        return getDefaultFactory().newUpdatableMapOf(k1, v1, k2, v2);
    }

    public static  HashByteCharMap newUpdatableMapOf(
            byte k1, char v1, byte k2, char v2,
            byte k3, char v3) {
        return getDefaultFactory().newUpdatableMapOf(k1, v1, k2, v2, k3, v3);
    }

    public static  HashByteCharMap newUpdatableMapOf(
            byte k1, char v1, byte k2, char v2,
            byte k3, char v3, byte k4, char v4) {
        return getDefaultFactory().newUpdatableMapOf(k1, v1, k2, v2, k3, v3, k4, v4);
    }

    public static  HashByteCharMap newUpdatableMapOf(
            byte k1, char v1, byte k2, char v2,
            byte k3, char v3, byte k4, char v4,
            byte k5, char v5) {
        return getDefaultFactory().newUpdatableMapOf(k1, v1, k2, v2, k3, v3, k4, v4, k5, v5);
    }

    
    


    public static  HashByteCharMap newImmutableMap(Map<Byte, Character> map1,
            Map<Byte, Character> map2, int expectedSize) {
        return getDefaultFactory().newImmutableMap(map1, map2, expectedSize);
    }

    public static  HashByteCharMap newImmutableMap(Map<Byte, Character> map1,
            Map<Byte, Character> map2, Map<Byte, Character> map3, int expectedSize) {
        return getDefaultFactory().newImmutableMap(map1, map2, map3, expectedSize);
    }

    public static  HashByteCharMap newImmutableMap(Map<Byte, Character> map1,
            Map<Byte, Character> map2, Map<Byte, Character> map3,
            Map<Byte, Character> map4, int expectedSize) {
        return getDefaultFactory().newImmutableMap(map1, map2, map3, map4, expectedSize);
    }

    public static  HashByteCharMap newImmutableMap(Map<Byte, Character> map1,
            Map<Byte, Character> map2, Map<Byte, Character> map3,
            Map<Byte, Character> map4, Map<Byte, Character> map5, int expectedSize) {
        return getDefaultFactory().newImmutableMap(map1, map2, map3, map4, map5, expectedSize);
    }

    
    

    
    public static  HashByteCharMap newImmutableMap(
            Map<Byte, Character> map) {
        return getDefaultFactory().newImmutableMap(map);
    }

    public static  HashByteCharMap newImmutableMap(Map<Byte, Character> map1,
            Map<Byte, Character> map2) {
        return getDefaultFactory().newImmutableMap(map1, map2);
    }

    public static  HashByteCharMap newImmutableMap(Map<Byte, Character> map1,
            Map<Byte, Character> map2, Map<Byte, Character> map3) {
        return getDefaultFactory().newImmutableMap(map1, map2, map3);
    }

    public static  HashByteCharMap newImmutableMap(Map<Byte, Character> map1,
            Map<Byte, Character> map2, Map<Byte, Character> map3,
            Map<Byte, Character> map4) {
        return getDefaultFactory().newImmutableMap(map1, map2, map3, map4);
    }

    public static  HashByteCharMap newImmutableMap(Map<Byte, Character> map1,
            Map<Byte, Character> map2, Map<Byte, Character> map3,
            Map<Byte, Character> map4, Map<Byte, Character> map5) {
        return getDefaultFactory().newImmutableMap(map1, map2, map3, map4, map5);
    }


    public static  HashByteCharMap newImmutableMap(
            net.openhft.function.Consumer<ByteCharConsumer> entriesSupplier) {
        return getDefaultFactory().newImmutableMap(entriesSupplier);
    }

    public static  HashByteCharMap newImmutableMap(
            net.openhft.function.Consumer<ByteCharConsumer> entriesSupplier,
            int expectedSize) {
        return getDefaultFactory().newImmutableMap(entriesSupplier, expectedSize);
    }

    public static  HashByteCharMap newImmutableMap(
            byte[] keys, char[] values) {
        return getDefaultFactory().newImmutableMap(keys, values);
    }

    public static  HashByteCharMap newImmutableMap(
            byte[] keys, char[] values, int expectedSize) {
        return getDefaultFactory().newImmutableMap(keys, values, expectedSize);
    }

    public static  HashByteCharMap newImmutableMap(
            Byte[] keys, Character[] values) {
        return getDefaultFactory().newImmutableMap(keys, values);
    }

    public static  HashByteCharMap newImmutableMap(
            Byte[] keys, Character[] values, int expectedSize) {
        return getDefaultFactory().newImmutableMap(keys, values, expectedSize);
    }

    public static  HashByteCharMap newImmutableMap(Iterable<Byte> keys,
            Iterable<Character> values) {
        return getDefaultFactory().newImmutableMap(keys, values);
    }

    public static  HashByteCharMap newImmutableMap(Iterable<Byte> keys,
            Iterable<Character> values, int expectedSize) {
        return getDefaultFactory().newImmutableMap(keys, values, expectedSize);
    }


    public static  HashByteCharMap newImmutableMapOf(
            byte k1, char v1) {
        return getDefaultFactory().newImmutableMapOf(k1, v1);
    }

    public static  HashByteCharMap newImmutableMapOf(
            byte k1, char v1, byte k2, char v2) {
        return getDefaultFactory().newImmutableMapOf(k1, v1, k2, v2);
    }

    public static  HashByteCharMap newImmutableMapOf(
            byte k1, char v1, byte k2, char v2,
            byte k3, char v3) {
        return getDefaultFactory().newImmutableMapOf(k1, v1, k2, v2, k3, v3);
    }

    public static  HashByteCharMap newImmutableMapOf(
            byte k1, char v1, byte k2, char v2,
            byte k3, char v3, byte k4, char v4) {
        return getDefaultFactory().newImmutableMapOf(k1, v1, k2, v2, k3, v3, k4, v4);
    }

    public static  HashByteCharMap newImmutableMapOf(
            byte k1, char v1, byte k2, char v2,
            byte k3, char v3, byte k4, char v4,
            byte k5, char v5) {
        return getDefaultFactory().newImmutableMapOf(k1, v1, k2, v2, k3, v3, k4, v4, k5, v5);
    }

    private HashByteCharMaps() {}
}

