/*
 * Copyright 2014 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.openhft.collect.map.hash;

import net.openhft.collect.*;
import net.openhft.collect.hash.*;
import net.openhft.function.ByteCharConsumer;
import net.openhft.collect.map.*;
import javax.annotation.Nullable;

import java.util.Map;


/**
 * An immutable factory of {@code HashByteCharMaps}
 *
 * @see HashByteCharMap
 * @see HashByteCharMaps#getDefaultFactory()
 */
public interface HashByteCharMapFactory extends ByteCharMapFactory
        , ByteHashFactory<HashByteCharMapFactory>
         {

    

    

    

    

    

    
    

    
    


    @Override
    HashByteCharMapFactory withDefaultValue(char defaultValue);

    @Override
     HashByteCharMap newMutableMap();

    @Override
     HashByteCharMap newMutableMap(int expectedSize);

    


    @Override
     HashByteCharMap newMutableMap(Map<Byte, Character> map1,
            Map<Byte, Character> map2, int expectedSize);

    @Override
     HashByteCharMap newMutableMap(Map<Byte, Character> map1,
            Map<Byte, Character> map2, Map<Byte, Character> map3, int expectedSize);

    @Override
     HashByteCharMap newMutableMap(Map<Byte, Character> map1,
            Map<Byte, Character> map2, Map<Byte, Character> map3,
            Map<Byte, Character> map4, int expectedSize);

    @Override
     HashByteCharMap newMutableMap(Map<Byte, Character> map1,
            Map<Byte, Character> map2, Map<Byte, Character> map3,
            Map<Byte, Character> map4, Map<Byte, Character> map5, int expectedSize);

    

    
    @Override
     HashByteCharMap newMutableMap(Map<Byte, Character> map);

    @Override
     HashByteCharMap newMutableMap(Map<Byte, Character> map1,
            Map<Byte, Character> map2);

    @Override
     HashByteCharMap newMutableMap(Map<Byte, Character> map1,
            Map<Byte, Character> map2, Map<Byte, Character> map3);

    @Override
     HashByteCharMap newMutableMap(Map<Byte, Character> map1,
            Map<Byte, Character> map2, Map<Byte, Character> map3,
            Map<Byte, Character> map4);

    @Override
     HashByteCharMap newMutableMap(Map<Byte, Character> map1,
            Map<Byte, Character> map2, Map<Byte, Character> map3,
            Map<Byte, Character> map4, Map<Byte, Character> map5);


    @Override
     HashByteCharMap newMutableMap(
            net.openhft.function.Consumer<ByteCharConsumer> entriesSupplier);

    @Override
     HashByteCharMap newMutableMap(
            net.openhft.function.Consumer<ByteCharConsumer> entriesSupplier,
            int expectedSize);

    @Override
     HashByteCharMap newMutableMap(byte[] keys, char[] values);

    @Override
     HashByteCharMap newMutableMap(byte[] keys, char[] values,
            int expectedSize);

    @Override
     HashByteCharMap newMutableMap(
            Byte[] keys, Character[] values);

    @Override
     HashByteCharMap newMutableMap(
            Byte[] keys, Character[] values, int expectedSize);

    @Override
     HashByteCharMap newMutableMap(Iterable<Byte> keys,
            Iterable<Character> values);

    @Override
     HashByteCharMap newMutableMap(Iterable<Byte> keys,
            Iterable<Character> values, int expectedSize);


    @Override
     HashByteCharMap newMutableMapOf(byte k1, char v1);

    @Override
     HashByteCharMap newMutableMapOf(byte k1, char v1,
            byte k2, char v2);

    @Override
     HashByteCharMap newMutableMapOf(byte k1, char v1,
            byte k2, char v2, byte k3, char v3);

    @Override
     HashByteCharMap newMutableMapOf(byte k1, char v1,
            byte k2, char v2, byte k3, char v3,
            byte k4, char v4);

    @Override
     HashByteCharMap newMutableMapOf(byte k1, char v1,
            byte k2, char v2, byte k3, char v3,
            byte k4, char v4, byte k5, char v5);
    @Override
     HashByteCharMap newUpdatableMap();

    @Override
     HashByteCharMap newUpdatableMap(int expectedSize);

    


    @Override
     HashByteCharMap newUpdatableMap(Map<Byte, Character> map1,
            Map<Byte, Character> map2, int expectedSize);

    @Override
     HashByteCharMap newUpdatableMap(Map<Byte, Character> map1,
            Map<Byte, Character> map2, Map<Byte, Character> map3, int expectedSize);

    @Override
     HashByteCharMap newUpdatableMap(Map<Byte, Character> map1,
            Map<Byte, Character> map2, Map<Byte, Character> map3,
            Map<Byte, Character> map4, int expectedSize);

    @Override
     HashByteCharMap newUpdatableMap(Map<Byte, Character> map1,
            Map<Byte, Character> map2, Map<Byte, Character> map3,
            Map<Byte, Character> map4, Map<Byte, Character> map5, int expectedSize);

    

    
    @Override
     HashByteCharMap newUpdatableMap(Map<Byte, Character> map);

    @Override
     HashByteCharMap newUpdatableMap(Map<Byte, Character> map1,
            Map<Byte, Character> map2);

    @Override
     HashByteCharMap newUpdatableMap(Map<Byte, Character> map1,
            Map<Byte, Character> map2, Map<Byte, Character> map3);

    @Override
     HashByteCharMap newUpdatableMap(Map<Byte, Character> map1,
            Map<Byte, Character> map2, Map<Byte, Character> map3,
            Map<Byte, Character> map4);

    @Override
     HashByteCharMap newUpdatableMap(Map<Byte, Character> map1,
            Map<Byte, Character> map2, Map<Byte, Character> map3,
            Map<Byte, Character> map4, Map<Byte, Character> map5);


    @Override
     HashByteCharMap newUpdatableMap(
            net.openhft.function.Consumer<ByteCharConsumer> entriesSupplier);

    @Override
     HashByteCharMap newUpdatableMap(
            net.openhft.function.Consumer<ByteCharConsumer> entriesSupplier,
            int expectedSize);

    @Override
     HashByteCharMap newUpdatableMap(byte[] keys, char[] values);

    @Override
     HashByteCharMap newUpdatableMap(byte[] keys, char[] values,
            int expectedSize);

    @Override
     HashByteCharMap newUpdatableMap(
            Byte[] keys, Character[] values);

    @Override
     HashByteCharMap newUpdatableMap(
            Byte[] keys, Character[] values, int expectedSize);

    @Override
     HashByteCharMap newUpdatableMap(Iterable<Byte> keys,
            Iterable<Character> values);

    @Override
     HashByteCharMap newUpdatableMap(Iterable<Byte> keys,
            Iterable<Character> values, int expectedSize);


    @Override
     HashByteCharMap newUpdatableMapOf(byte k1, char v1);

    @Override
     HashByteCharMap newUpdatableMapOf(byte k1, char v1,
            byte k2, char v2);

    @Override
     HashByteCharMap newUpdatableMapOf(byte k1, char v1,
            byte k2, char v2, byte k3, char v3);

    @Override
     HashByteCharMap newUpdatableMapOf(byte k1, char v1,
            byte k2, char v2, byte k3, char v3,
            byte k4, char v4);

    @Override
     HashByteCharMap newUpdatableMapOf(byte k1, char v1,
            byte k2, char v2, byte k3, char v3,
            byte k4, char v4, byte k5, char v5);

    


    @Override
     HashByteCharMap newImmutableMap(Map<Byte, Character> map1,
            Map<Byte, Character> map2, int expectedSize);

    @Override
     HashByteCharMap newImmutableMap(Map<Byte, Character> map1,
            Map<Byte, Character> map2, Map<Byte, Character> map3, int expectedSize);

    @Override
     HashByteCharMap newImmutableMap(Map<Byte, Character> map1,
            Map<Byte, Character> map2, Map<Byte, Character> map3,
            Map<Byte, Character> map4, int expectedSize);

    @Override
     HashByteCharMap newImmutableMap(Map<Byte, Character> map1,
            Map<Byte, Character> map2, Map<Byte, Character> map3,
            Map<Byte, Character> map4, Map<Byte, Character> map5, int expectedSize);

    

    
    @Override
     HashByteCharMap newImmutableMap(Map<Byte, Character> map);

    @Override
     HashByteCharMap newImmutableMap(Map<Byte, Character> map1,
            Map<Byte, Character> map2);

    @Override
     HashByteCharMap newImmutableMap(Map<Byte, Character> map1,
            Map<Byte, Character> map2, Map<Byte, Character> map3);

    @Override
     HashByteCharMap newImmutableMap(Map<Byte, Character> map1,
            Map<Byte, Character> map2, Map<Byte, Character> map3,
            Map<Byte, Character> map4);

    @Override
     HashByteCharMap newImmutableMap(Map<Byte, Character> map1,
            Map<Byte, Character> map2, Map<Byte, Character> map3,
            Map<Byte, Character> map4, Map<Byte, Character> map5);


    @Override
     HashByteCharMap newImmutableMap(
            net.openhft.function.Consumer<ByteCharConsumer> entriesSupplier);

    @Override
     HashByteCharMap newImmutableMap(
            net.openhft.function.Consumer<ByteCharConsumer> entriesSupplier,
            int expectedSize);

    @Override
     HashByteCharMap newImmutableMap(byte[] keys, char[] values);

    @Override
     HashByteCharMap newImmutableMap(byte[] keys, char[] values,
            int expectedSize);

    @Override
     HashByteCharMap newImmutableMap(
            Byte[] keys, Character[] values);

    @Override
     HashByteCharMap newImmutableMap(
            Byte[] keys, Character[] values, int expectedSize);

    @Override
     HashByteCharMap newImmutableMap(Iterable<Byte> keys,
            Iterable<Character> values);

    @Override
     HashByteCharMap newImmutableMap(Iterable<Byte> keys,
            Iterable<Character> values, int expectedSize);


    @Override
     HashByteCharMap newImmutableMapOf(byte k1, char v1);

    @Override
     HashByteCharMap newImmutableMapOf(byte k1, char v1,
            byte k2, char v2);

    @Override
     HashByteCharMap newImmutableMapOf(byte k1, char v1,
            byte k2, char v2, byte k3, char v3);

    @Override
     HashByteCharMap newImmutableMapOf(byte k1, char v1,
            byte k2, char v2, byte k3, char v3,
            byte k4, char v4);

    @Override
     HashByteCharMap newImmutableMapOf(byte k1, char v1,
            byte k2, char v2, byte k3, char v3,
            byte k4, char v4, byte k5, char v5);
}

