/*
 * Copyright 2014 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.openhft.collect.map.hash;

import net.openhft.function.ByteByteConsumer;

import java.util.Map;
import java.util.ServiceLoader;


/**
 * This class consists only of static factory methods to construct {@code HashByteByteMap}s, and
 * the default {@link HashByteByteMapFactory} static provider ({@link #getDefaultFactory()}).
 *
 * @see HashByteByteMap
 */
public final class HashByteByteMaps {

    

    private static final ServiceLoader<HashByteByteMapFactory> LOADER =
            ServiceLoader.load(HashByteByteMapFactory.class);
    private static HashByteByteMapFactory defaultFactory = null;

    public static HashByteByteMapFactory getDefaultFactory() {
        if (defaultFactory != null) {
            return defaultFactory;
        } else {
            // synchronization?
            return defaultFactory = LOADER.iterator().next();
        }
    }

    

    

    

    public static  HashByteByteMap newMutableMap() {
        return getDefaultFactory().newMutableMap();
    }

    public static  HashByteByteMap newMutableMap(int expectedSize) {
        return getDefaultFactory().newMutableMap(expectedSize);
    }



    
    


    public static  HashByteByteMap newMutableMap(Map<Byte, Byte> map1,
            Map<Byte, Byte> map2, int expectedSize) {
        return getDefaultFactory().newMutableMap(map1, map2, expectedSize);
    }

    public static  HashByteByteMap newMutableMap(Map<Byte, Byte> map1,
            Map<Byte, Byte> map2, Map<Byte, Byte> map3, int expectedSize) {
        return getDefaultFactory().newMutableMap(map1, map2, map3, expectedSize);
    }

    public static  HashByteByteMap newMutableMap(Map<Byte, Byte> map1,
            Map<Byte, Byte> map2, Map<Byte, Byte> map3,
            Map<Byte, Byte> map4, int expectedSize) {
        return getDefaultFactory().newMutableMap(map1, map2, map3, map4, expectedSize);
    }

    public static  HashByteByteMap newMutableMap(Map<Byte, Byte> map1,
            Map<Byte, Byte> map2, Map<Byte, Byte> map3,
            Map<Byte, Byte> map4, Map<Byte, Byte> map5, int expectedSize) {
        return getDefaultFactory().newMutableMap(map1, map2, map3, map4, map5, expectedSize);
    }

    
    

    
    public static  HashByteByteMap newMutableMap(
            Map<Byte, Byte> map) {
        return getDefaultFactory().newMutableMap(map);
    }

    public static  HashByteByteMap newMutableMap(Map<Byte, Byte> map1,
            Map<Byte, Byte> map2) {
        return getDefaultFactory().newMutableMap(map1, map2);
    }

    public static  HashByteByteMap newMutableMap(Map<Byte, Byte> map1,
            Map<Byte, Byte> map2, Map<Byte, Byte> map3) {
        return getDefaultFactory().newMutableMap(map1, map2, map3);
    }

    public static  HashByteByteMap newMutableMap(Map<Byte, Byte> map1,
            Map<Byte, Byte> map2, Map<Byte, Byte> map3,
            Map<Byte, Byte> map4) {
        return getDefaultFactory().newMutableMap(map1, map2, map3, map4);
    }

    public static  HashByteByteMap newMutableMap(Map<Byte, Byte> map1,
            Map<Byte, Byte> map2, Map<Byte, Byte> map3,
            Map<Byte, Byte> map4, Map<Byte, Byte> map5) {
        return getDefaultFactory().newMutableMap(map1, map2, map3, map4, map5);
    }


    public static  HashByteByteMap newMutableMap(
            net.openhft.function.Consumer<ByteByteConsumer> entriesSupplier) {
        return getDefaultFactory().newMutableMap(entriesSupplier);
    }

    public static  HashByteByteMap newMutableMap(
            net.openhft.function.Consumer<ByteByteConsumer> entriesSupplier,
            int expectedSize) {
        return getDefaultFactory().newMutableMap(entriesSupplier, expectedSize);
    }

    public static  HashByteByteMap newMutableMap(
            byte[] keys, byte[] values) {
        return getDefaultFactory().newMutableMap(keys, values);
    }

    public static  HashByteByteMap newMutableMap(
            byte[] keys, byte[] values, int expectedSize) {
        return getDefaultFactory().newMutableMap(keys, values, expectedSize);
    }

    public static  HashByteByteMap newMutableMap(
            Byte[] keys, Byte[] values) {
        return getDefaultFactory().newMutableMap(keys, values);
    }

    public static  HashByteByteMap newMutableMap(
            Byte[] keys, Byte[] values, int expectedSize) {
        return getDefaultFactory().newMutableMap(keys, values, expectedSize);
    }

    public static  HashByteByteMap newMutableMap(Iterable<Byte> keys,
            Iterable<Byte> values) {
        return getDefaultFactory().newMutableMap(keys, values);
    }

    public static  HashByteByteMap newMutableMap(Iterable<Byte> keys,
            Iterable<Byte> values, int expectedSize) {
        return getDefaultFactory().newMutableMap(keys, values, expectedSize);
    }


    public static  HashByteByteMap newMutableMapOf(
            byte k1, byte v1) {
        return getDefaultFactory().newMutableMapOf(k1, v1);
    }

    public static  HashByteByteMap newMutableMapOf(
            byte k1, byte v1, byte k2, byte v2) {
        return getDefaultFactory().newMutableMapOf(k1, v1, k2, v2);
    }

    public static  HashByteByteMap newMutableMapOf(
            byte k1, byte v1, byte k2, byte v2,
            byte k3, byte v3) {
        return getDefaultFactory().newMutableMapOf(k1, v1, k2, v2, k3, v3);
    }

    public static  HashByteByteMap newMutableMapOf(
            byte k1, byte v1, byte k2, byte v2,
            byte k3, byte v3, byte k4, byte v4) {
        return getDefaultFactory().newMutableMapOf(k1, v1, k2, v2, k3, v3, k4, v4);
    }

    public static  HashByteByteMap newMutableMapOf(
            byte k1, byte v1, byte k2, byte v2,
            byte k3, byte v3, byte k4, byte v4,
            byte k5, byte v5) {
        return getDefaultFactory().newMutableMapOf(k1, v1, k2, v2, k3, v3, k4, v4, k5, v5);
    }

    
    


    public static  HashByteByteMap newUpdatableMap(Map<Byte, Byte> map1,
            Map<Byte, Byte> map2, int expectedSize) {
        return getDefaultFactory().newUpdatableMap(map1, map2, expectedSize);
    }

    public static  HashByteByteMap newUpdatableMap(Map<Byte, Byte> map1,
            Map<Byte, Byte> map2, Map<Byte, Byte> map3, int expectedSize) {
        return getDefaultFactory().newUpdatableMap(map1, map2, map3, expectedSize);
    }

    public static  HashByteByteMap newUpdatableMap(Map<Byte, Byte> map1,
            Map<Byte, Byte> map2, Map<Byte, Byte> map3,
            Map<Byte, Byte> map4, int expectedSize) {
        return getDefaultFactory().newUpdatableMap(map1, map2, map3, map4, expectedSize);
    }

    public static  HashByteByteMap newUpdatableMap(Map<Byte, Byte> map1,
            Map<Byte, Byte> map2, Map<Byte, Byte> map3,
            Map<Byte, Byte> map4, Map<Byte, Byte> map5, int expectedSize) {
        return getDefaultFactory().newUpdatableMap(map1, map2, map3, map4, map5, expectedSize);
    }

    
    

    
    public static  HashByteByteMap newUpdatableMap(
            Map<Byte, Byte> map) {
        return getDefaultFactory().newUpdatableMap(map);
    }

    public static  HashByteByteMap newUpdatableMap(Map<Byte, Byte> map1,
            Map<Byte, Byte> map2) {
        return getDefaultFactory().newUpdatableMap(map1, map2);
    }

    public static  HashByteByteMap newUpdatableMap(Map<Byte, Byte> map1,
            Map<Byte, Byte> map2, Map<Byte, Byte> map3) {
        return getDefaultFactory().newUpdatableMap(map1, map2, map3);
    }

    public static  HashByteByteMap newUpdatableMap(Map<Byte, Byte> map1,
            Map<Byte, Byte> map2, Map<Byte, Byte> map3,
            Map<Byte, Byte> map4) {
        return getDefaultFactory().newUpdatableMap(map1, map2, map3, map4);
    }

    public static  HashByteByteMap newUpdatableMap(Map<Byte, Byte> map1,
            Map<Byte, Byte> map2, Map<Byte, Byte> map3,
            Map<Byte, Byte> map4, Map<Byte, Byte> map5) {
        return getDefaultFactory().newUpdatableMap(map1, map2, map3, map4, map5);
    }


    public static  HashByteByteMap newUpdatableMap(
            net.openhft.function.Consumer<ByteByteConsumer> entriesSupplier) {
        return getDefaultFactory().newUpdatableMap(entriesSupplier);
    }

    public static  HashByteByteMap newUpdatableMap(
            net.openhft.function.Consumer<ByteByteConsumer> entriesSupplier,
            int expectedSize) {
        return getDefaultFactory().newUpdatableMap(entriesSupplier, expectedSize);
    }

    public static  HashByteByteMap newUpdatableMap(
            byte[] keys, byte[] values) {
        return getDefaultFactory().newUpdatableMap(keys, values);
    }

    public static  HashByteByteMap newUpdatableMap(
            byte[] keys, byte[] values, int expectedSize) {
        return getDefaultFactory().newUpdatableMap(keys, values, expectedSize);
    }

    public static  HashByteByteMap newUpdatableMap(
            Byte[] keys, Byte[] values) {
        return getDefaultFactory().newUpdatableMap(keys, values);
    }

    public static  HashByteByteMap newUpdatableMap(
            Byte[] keys, Byte[] values, int expectedSize) {
        return getDefaultFactory().newUpdatableMap(keys, values, expectedSize);
    }

    public static  HashByteByteMap newUpdatableMap(Iterable<Byte> keys,
            Iterable<Byte> values) {
        return getDefaultFactory().newUpdatableMap(keys, values);
    }

    public static  HashByteByteMap newUpdatableMap(Iterable<Byte> keys,
            Iterable<Byte> values, int expectedSize) {
        return getDefaultFactory().newUpdatableMap(keys, values, expectedSize);
    }


    public static  HashByteByteMap newUpdatableMapOf(
            byte k1, byte v1) {
        return getDefaultFactory().newUpdatableMapOf(k1, v1);
    }

    public static  HashByteByteMap newUpdatableMapOf(
            byte k1, byte v1, byte k2, byte v2) {
        return getDefaultFactory().newUpdatableMapOf(k1, v1, k2, v2);
    }

    public static  HashByteByteMap newUpdatableMapOf(
            byte k1, byte v1, byte k2, byte v2,
            byte k3, byte v3) {
        return getDefaultFactory().newUpdatableMapOf(k1, v1, k2, v2, k3, v3);
    }

    public static  HashByteByteMap newUpdatableMapOf(
            byte k1, byte v1, byte k2, byte v2,
            byte k3, byte v3, byte k4, byte v4) {
        return getDefaultFactory().newUpdatableMapOf(k1, v1, k2, v2, k3, v3, k4, v4);
    }

    public static  HashByteByteMap newUpdatableMapOf(
            byte k1, byte v1, byte k2, byte v2,
            byte k3, byte v3, byte k4, byte v4,
            byte k5, byte v5) {
        return getDefaultFactory().newUpdatableMapOf(k1, v1, k2, v2, k3, v3, k4, v4, k5, v5);
    }

    
    


    public static  HashByteByteMap newImmutableMap(Map<Byte, Byte> map1,
            Map<Byte, Byte> map2, int expectedSize) {
        return getDefaultFactory().newImmutableMap(map1, map2, expectedSize);
    }

    public static  HashByteByteMap newImmutableMap(Map<Byte, Byte> map1,
            Map<Byte, Byte> map2, Map<Byte, Byte> map3, int expectedSize) {
        return getDefaultFactory().newImmutableMap(map1, map2, map3, expectedSize);
    }

    public static  HashByteByteMap newImmutableMap(Map<Byte, Byte> map1,
            Map<Byte, Byte> map2, Map<Byte, Byte> map3,
            Map<Byte, Byte> map4, int expectedSize) {
        return getDefaultFactory().newImmutableMap(map1, map2, map3, map4, expectedSize);
    }

    public static  HashByteByteMap newImmutableMap(Map<Byte, Byte> map1,
            Map<Byte, Byte> map2, Map<Byte, Byte> map3,
            Map<Byte, Byte> map4, Map<Byte, Byte> map5, int expectedSize) {
        return getDefaultFactory().newImmutableMap(map1, map2, map3, map4, map5, expectedSize);
    }

    
    

    
    public static  HashByteByteMap newImmutableMap(
            Map<Byte, Byte> map) {
        return getDefaultFactory().newImmutableMap(map);
    }

    public static  HashByteByteMap newImmutableMap(Map<Byte, Byte> map1,
            Map<Byte, Byte> map2) {
        return getDefaultFactory().newImmutableMap(map1, map2);
    }

    public static  HashByteByteMap newImmutableMap(Map<Byte, Byte> map1,
            Map<Byte, Byte> map2, Map<Byte, Byte> map3) {
        return getDefaultFactory().newImmutableMap(map1, map2, map3);
    }

    public static  HashByteByteMap newImmutableMap(Map<Byte, Byte> map1,
            Map<Byte, Byte> map2, Map<Byte, Byte> map3,
            Map<Byte, Byte> map4) {
        return getDefaultFactory().newImmutableMap(map1, map2, map3, map4);
    }

    public static  HashByteByteMap newImmutableMap(Map<Byte, Byte> map1,
            Map<Byte, Byte> map2, Map<Byte, Byte> map3,
            Map<Byte, Byte> map4, Map<Byte, Byte> map5) {
        return getDefaultFactory().newImmutableMap(map1, map2, map3, map4, map5);
    }


    public static  HashByteByteMap newImmutableMap(
            net.openhft.function.Consumer<ByteByteConsumer> entriesSupplier) {
        return getDefaultFactory().newImmutableMap(entriesSupplier);
    }

    public static  HashByteByteMap newImmutableMap(
            net.openhft.function.Consumer<ByteByteConsumer> entriesSupplier,
            int expectedSize) {
        return getDefaultFactory().newImmutableMap(entriesSupplier, expectedSize);
    }

    public static  HashByteByteMap newImmutableMap(
            byte[] keys, byte[] values) {
        return getDefaultFactory().newImmutableMap(keys, values);
    }

    public static  HashByteByteMap newImmutableMap(
            byte[] keys, byte[] values, int expectedSize) {
        return getDefaultFactory().newImmutableMap(keys, values, expectedSize);
    }

    public static  HashByteByteMap newImmutableMap(
            Byte[] keys, Byte[] values) {
        return getDefaultFactory().newImmutableMap(keys, values);
    }

    public static  HashByteByteMap newImmutableMap(
            Byte[] keys, Byte[] values, int expectedSize) {
        return getDefaultFactory().newImmutableMap(keys, values, expectedSize);
    }

    public static  HashByteByteMap newImmutableMap(Iterable<Byte> keys,
            Iterable<Byte> values) {
        return getDefaultFactory().newImmutableMap(keys, values);
    }

    public static  HashByteByteMap newImmutableMap(Iterable<Byte> keys,
            Iterable<Byte> values, int expectedSize) {
        return getDefaultFactory().newImmutableMap(keys, values, expectedSize);
    }


    public static  HashByteByteMap newImmutableMapOf(
            byte k1, byte v1) {
        return getDefaultFactory().newImmutableMapOf(k1, v1);
    }

    public static  HashByteByteMap newImmutableMapOf(
            byte k1, byte v1, byte k2, byte v2) {
        return getDefaultFactory().newImmutableMapOf(k1, v1, k2, v2);
    }

    public static  HashByteByteMap newImmutableMapOf(
            byte k1, byte v1, byte k2, byte v2,
            byte k3, byte v3) {
        return getDefaultFactory().newImmutableMapOf(k1, v1, k2, v2, k3, v3);
    }

    public static  HashByteByteMap newImmutableMapOf(
            byte k1, byte v1, byte k2, byte v2,
            byte k3, byte v3, byte k4, byte v4) {
        return getDefaultFactory().newImmutableMapOf(k1, v1, k2, v2, k3, v3, k4, v4);
    }

    public static  HashByteByteMap newImmutableMapOf(
            byte k1, byte v1, byte k2, byte v2,
            byte k3, byte v3, byte k4, byte v4,
            byte k5, byte v5) {
        return getDefaultFactory().newImmutableMapOf(k1, v1, k2, v2, k3, v3, k4, v4, k5, v5);
    }

    private HashByteByteMaps() {}
}

