/*
 * Copyright 2014 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.openhft.collect.map.hash;

import net.openhft.collect.*;
import net.openhft.collect.hash.*;
import net.openhft.function.ByteByteConsumer;
import net.openhft.collect.map.*;
import javax.annotation.Nullable;

import java.util.Map;


/**
 * An immutable factory of {@code HashByteByteMaps}
 *
 * @see HashByteByteMap
 * @see HashByteByteMaps#getDefaultFactory()
 */
public interface HashByteByteMapFactory extends ByteByteMapFactory
        , ByteHashFactory<HashByteByteMapFactory>
         {

    

    

    

    

    

    
    

    
    


    @Override
    HashByteByteMapFactory withDefaultValue(byte defaultValue);

    @Override
     HashByteByteMap newMutableMap();

    @Override
     HashByteByteMap newMutableMap(int expectedSize);

    


    @Override
     HashByteByteMap newMutableMap(Map<Byte, Byte> map1,
            Map<Byte, Byte> map2, int expectedSize);

    @Override
     HashByteByteMap newMutableMap(Map<Byte, Byte> map1,
            Map<Byte, Byte> map2, Map<Byte, Byte> map3, int expectedSize);

    @Override
     HashByteByteMap newMutableMap(Map<Byte, Byte> map1,
            Map<Byte, Byte> map2, Map<Byte, Byte> map3,
            Map<Byte, Byte> map4, int expectedSize);

    @Override
     HashByteByteMap newMutableMap(Map<Byte, Byte> map1,
            Map<Byte, Byte> map2, Map<Byte, Byte> map3,
            Map<Byte, Byte> map4, Map<Byte, Byte> map5, int expectedSize);

    

    
    @Override
     HashByteByteMap newMutableMap(Map<Byte, Byte> map);

    @Override
     HashByteByteMap newMutableMap(Map<Byte, Byte> map1,
            Map<Byte, Byte> map2);

    @Override
     HashByteByteMap newMutableMap(Map<Byte, Byte> map1,
            Map<Byte, Byte> map2, Map<Byte, Byte> map3);

    @Override
     HashByteByteMap newMutableMap(Map<Byte, Byte> map1,
            Map<Byte, Byte> map2, Map<Byte, Byte> map3,
            Map<Byte, Byte> map4);

    @Override
     HashByteByteMap newMutableMap(Map<Byte, Byte> map1,
            Map<Byte, Byte> map2, Map<Byte, Byte> map3,
            Map<Byte, Byte> map4, Map<Byte, Byte> map5);


    @Override
     HashByteByteMap newMutableMap(
            net.openhft.function.Consumer<ByteByteConsumer> entriesSupplier);

    @Override
     HashByteByteMap newMutableMap(
            net.openhft.function.Consumer<ByteByteConsumer> entriesSupplier,
            int expectedSize);

    @Override
     HashByteByteMap newMutableMap(byte[] keys, byte[] values);

    @Override
     HashByteByteMap newMutableMap(byte[] keys, byte[] values,
            int expectedSize);

    @Override
     HashByteByteMap newMutableMap(
            Byte[] keys, Byte[] values);

    @Override
     HashByteByteMap newMutableMap(
            Byte[] keys, Byte[] values, int expectedSize);

    @Override
     HashByteByteMap newMutableMap(Iterable<Byte> keys,
            Iterable<Byte> values);

    @Override
     HashByteByteMap newMutableMap(Iterable<Byte> keys,
            Iterable<Byte> values, int expectedSize);


    @Override
     HashByteByteMap newMutableMapOf(byte k1, byte v1);

    @Override
     HashByteByteMap newMutableMapOf(byte k1, byte v1,
            byte k2, byte v2);

    @Override
     HashByteByteMap newMutableMapOf(byte k1, byte v1,
            byte k2, byte v2, byte k3, byte v3);

    @Override
     HashByteByteMap newMutableMapOf(byte k1, byte v1,
            byte k2, byte v2, byte k3, byte v3,
            byte k4, byte v4);

    @Override
     HashByteByteMap newMutableMapOf(byte k1, byte v1,
            byte k2, byte v2, byte k3, byte v3,
            byte k4, byte v4, byte k5, byte v5);
    @Override
     HashByteByteMap newUpdatableMap();

    @Override
     HashByteByteMap newUpdatableMap(int expectedSize);

    


    @Override
     HashByteByteMap newUpdatableMap(Map<Byte, Byte> map1,
            Map<Byte, Byte> map2, int expectedSize);

    @Override
     HashByteByteMap newUpdatableMap(Map<Byte, Byte> map1,
            Map<Byte, Byte> map2, Map<Byte, Byte> map3, int expectedSize);

    @Override
     HashByteByteMap newUpdatableMap(Map<Byte, Byte> map1,
            Map<Byte, Byte> map2, Map<Byte, Byte> map3,
            Map<Byte, Byte> map4, int expectedSize);

    @Override
     HashByteByteMap newUpdatableMap(Map<Byte, Byte> map1,
            Map<Byte, Byte> map2, Map<Byte, Byte> map3,
            Map<Byte, Byte> map4, Map<Byte, Byte> map5, int expectedSize);

    

    
    @Override
     HashByteByteMap newUpdatableMap(Map<Byte, Byte> map);

    @Override
     HashByteByteMap newUpdatableMap(Map<Byte, Byte> map1,
            Map<Byte, Byte> map2);

    @Override
     HashByteByteMap newUpdatableMap(Map<Byte, Byte> map1,
            Map<Byte, Byte> map2, Map<Byte, Byte> map3);

    @Override
     HashByteByteMap newUpdatableMap(Map<Byte, Byte> map1,
            Map<Byte, Byte> map2, Map<Byte, Byte> map3,
            Map<Byte, Byte> map4);

    @Override
     HashByteByteMap newUpdatableMap(Map<Byte, Byte> map1,
            Map<Byte, Byte> map2, Map<Byte, Byte> map3,
            Map<Byte, Byte> map4, Map<Byte, Byte> map5);


    @Override
     HashByteByteMap newUpdatableMap(
            net.openhft.function.Consumer<ByteByteConsumer> entriesSupplier);

    @Override
     HashByteByteMap newUpdatableMap(
            net.openhft.function.Consumer<ByteByteConsumer> entriesSupplier,
            int expectedSize);

    @Override
     HashByteByteMap newUpdatableMap(byte[] keys, byte[] values);

    @Override
     HashByteByteMap newUpdatableMap(byte[] keys, byte[] values,
            int expectedSize);

    @Override
     HashByteByteMap newUpdatableMap(
            Byte[] keys, Byte[] values);

    @Override
     HashByteByteMap newUpdatableMap(
            Byte[] keys, Byte[] values, int expectedSize);

    @Override
     HashByteByteMap newUpdatableMap(Iterable<Byte> keys,
            Iterable<Byte> values);

    @Override
     HashByteByteMap newUpdatableMap(Iterable<Byte> keys,
            Iterable<Byte> values, int expectedSize);


    @Override
     HashByteByteMap newUpdatableMapOf(byte k1, byte v1);

    @Override
     HashByteByteMap newUpdatableMapOf(byte k1, byte v1,
            byte k2, byte v2);

    @Override
     HashByteByteMap newUpdatableMapOf(byte k1, byte v1,
            byte k2, byte v2, byte k3, byte v3);

    @Override
     HashByteByteMap newUpdatableMapOf(byte k1, byte v1,
            byte k2, byte v2, byte k3, byte v3,
            byte k4, byte v4);

    @Override
     HashByteByteMap newUpdatableMapOf(byte k1, byte v1,
            byte k2, byte v2, byte k3, byte v3,
            byte k4, byte v4, byte k5, byte v5);

    


    @Override
     HashByteByteMap newImmutableMap(Map<Byte, Byte> map1,
            Map<Byte, Byte> map2, int expectedSize);

    @Override
     HashByteByteMap newImmutableMap(Map<Byte, Byte> map1,
            Map<Byte, Byte> map2, Map<Byte, Byte> map3, int expectedSize);

    @Override
     HashByteByteMap newImmutableMap(Map<Byte, Byte> map1,
            Map<Byte, Byte> map2, Map<Byte, Byte> map3,
            Map<Byte, Byte> map4, int expectedSize);

    @Override
     HashByteByteMap newImmutableMap(Map<Byte, Byte> map1,
            Map<Byte, Byte> map2, Map<Byte, Byte> map3,
            Map<Byte, Byte> map4, Map<Byte, Byte> map5, int expectedSize);

    

    
    @Override
     HashByteByteMap newImmutableMap(Map<Byte, Byte> map);

    @Override
     HashByteByteMap newImmutableMap(Map<Byte, Byte> map1,
            Map<Byte, Byte> map2);

    @Override
     HashByteByteMap newImmutableMap(Map<Byte, Byte> map1,
            Map<Byte, Byte> map2, Map<Byte, Byte> map3);

    @Override
     HashByteByteMap newImmutableMap(Map<Byte, Byte> map1,
            Map<Byte, Byte> map2, Map<Byte, Byte> map3,
            Map<Byte, Byte> map4);

    @Override
     HashByteByteMap newImmutableMap(Map<Byte, Byte> map1,
            Map<Byte, Byte> map2, Map<Byte, Byte> map3,
            Map<Byte, Byte> map4, Map<Byte, Byte> map5);


    @Override
     HashByteByteMap newImmutableMap(
            net.openhft.function.Consumer<ByteByteConsumer> entriesSupplier);

    @Override
     HashByteByteMap newImmutableMap(
            net.openhft.function.Consumer<ByteByteConsumer> entriesSupplier,
            int expectedSize);

    @Override
     HashByteByteMap newImmutableMap(byte[] keys, byte[] values);

    @Override
     HashByteByteMap newImmutableMap(byte[] keys, byte[] values,
            int expectedSize);

    @Override
     HashByteByteMap newImmutableMap(
            Byte[] keys, Byte[] values);

    @Override
     HashByteByteMap newImmutableMap(
            Byte[] keys, Byte[] values, int expectedSize);

    @Override
     HashByteByteMap newImmutableMap(Iterable<Byte> keys,
            Iterable<Byte> values);

    @Override
     HashByteByteMap newImmutableMap(Iterable<Byte> keys,
            Iterable<Byte> values, int expectedSize);


    @Override
     HashByteByteMap newImmutableMapOf(byte k1, byte v1);

    @Override
     HashByteByteMap newImmutableMapOf(byte k1, byte v1,
            byte k2, byte v2);

    @Override
     HashByteByteMap newImmutableMapOf(byte k1, byte v1,
            byte k2, byte v2, byte k3, byte v3);

    @Override
     HashByteByteMap newImmutableMapOf(byte k1, byte v1,
            byte k2, byte v2, byte k3, byte v3,
            byte k4, byte v4);

    @Override
     HashByteByteMap newImmutableMapOf(byte k1, byte v1,
            byte k2, byte v2, byte k3, byte v3,
            byte k4, byte v4, byte k5, byte v5);
}

