/*
 * Copyright 2014 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.openhft.collect.map;

import net.openhft.collect.*;
import net.openhft.function.ShortShortConsumer;
import javax.annotation.Nullable;

import java.util.Map;


/**
 * An immutable factory of {@code ShortShortMap}s.
 *
 * @see ShortShortMap
 */
public interface ShortShortMapFactory {

    

    

    

    

    

    
    

    
    



    short getDefaultValue();

    /**
     * @see ShortShortMap#defaultValue()
     */
    ShortShortMapFactory withDefaultValue(short defaultValue);

     ShortShortMap newMutableMap();

     ShortShortMap newMutableMap(int expectedSize);

    


     ShortShortMap newMutableMap(Map<Short, Short> map1,
            Map<Short, Short> map2, int expectedSize);

     ShortShortMap newMutableMap(Map<Short, Short> map1,
            Map<Short, Short> map2, Map<Short, Short> map3, int expectedSize);

     ShortShortMap newMutableMap(Map<Short, Short> map1,
            Map<Short, Short> map2, Map<Short, Short> map3,
            Map<Short, Short> map4, int expectedSize);

     ShortShortMap newMutableMap(Map<Short, Short> map1,
            Map<Short, Short> map2, Map<Short, Short> map3,
            Map<Short, Short> map4, Map<Short, Short> map5, int expectedSize);

    

    
     ShortShortMap newMutableMap(Map<Short, Short> map);

     ShortShortMap newMutableMap(Map<Short, Short> map1,
            Map<Short, Short> map2);

     ShortShortMap newMutableMap(Map<Short, Short> map1,
            Map<Short, Short> map2, Map<Short, Short> map3);

     ShortShortMap newMutableMap(Map<Short, Short> map1,
            Map<Short, Short> map2, Map<Short, Short> map3,
            Map<Short, Short> map4);

     ShortShortMap newMutableMap(Map<Short, Short> map1,
            Map<Short, Short> map2, Map<Short, Short> map3,
            Map<Short, Short> map4, Map<Short, Short> map5);


     ShortShortMap newMutableMap(
            net.openhft.function.Consumer<ShortShortConsumer> entriesSupplier);

     ShortShortMap newMutableMap(
            net.openhft.function.Consumer<ShortShortConsumer> entriesSupplier,
            int expectedSize);

     ShortShortMap newMutableMap(short[] keys, short[] values);

     ShortShortMap newMutableMap(short[] keys, short[] values,
            int expectedSize);

     ShortShortMap newMutableMap(Short[] keys, Short[] values);

     ShortShortMap newMutableMap(Short[] keys, Short[] values,
            int expectedSize);

     ShortShortMap newMutableMap(Iterable<Short> keys,
            Iterable<Short> values);

     ShortShortMap newMutableMap(Iterable<Short> keys,
            Iterable<Short> values, int expectedSize);


     ShortShortMap newMutableMapOf(short k1, short v1);

     ShortShortMap newMutableMapOf(short k1, short v1,
            short k2, short v2);

     ShortShortMap newMutableMapOf(short k1, short v1,
            short k2, short v2, short k3, short v3);

     ShortShortMap newMutableMapOf(short k1, short v1,
            short k2, short v2, short k3, short v3,
            short k4, short v4);

     ShortShortMap newMutableMapOf(short k1, short v1,
            short k2, short v2, short k3, short v3,
            short k4, short v4, short k5, short v5);
     ShortShortMap newUpdatableMap();

     ShortShortMap newUpdatableMap(int expectedSize);

    


     ShortShortMap newUpdatableMap(Map<Short, Short> map1,
            Map<Short, Short> map2, int expectedSize);

     ShortShortMap newUpdatableMap(Map<Short, Short> map1,
            Map<Short, Short> map2, Map<Short, Short> map3, int expectedSize);

     ShortShortMap newUpdatableMap(Map<Short, Short> map1,
            Map<Short, Short> map2, Map<Short, Short> map3,
            Map<Short, Short> map4, int expectedSize);

     ShortShortMap newUpdatableMap(Map<Short, Short> map1,
            Map<Short, Short> map2, Map<Short, Short> map3,
            Map<Short, Short> map4, Map<Short, Short> map5, int expectedSize);

    

    
     ShortShortMap newUpdatableMap(Map<Short, Short> map);

     ShortShortMap newUpdatableMap(Map<Short, Short> map1,
            Map<Short, Short> map2);

     ShortShortMap newUpdatableMap(Map<Short, Short> map1,
            Map<Short, Short> map2, Map<Short, Short> map3);

     ShortShortMap newUpdatableMap(Map<Short, Short> map1,
            Map<Short, Short> map2, Map<Short, Short> map3,
            Map<Short, Short> map4);

     ShortShortMap newUpdatableMap(Map<Short, Short> map1,
            Map<Short, Short> map2, Map<Short, Short> map3,
            Map<Short, Short> map4, Map<Short, Short> map5);


     ShortShortMap newUpdatableMap(
            net.openhft.function.Consumer<ShortShortConsumer> entriesSupplier);

     ShortShortMap newUpdatableMap(
            net.openhft.function.Consumer<ShortShortConsumer> entriesSupplier,
            int expectedSize);

     ShortShortMap newUpdatableMap(short[] keys, short[] values);

     ShortShortMap newUpdatableMap(short[] keys, short[] values,
            int expectedSize);

     ShortShortMap newUpdatableMap(Short[] keys, Short[] values);

     ShortShortMap newUpdatableMap(Short[] keys, Short[] values,
            int expectedSize);

     ShortShortMap newUpdatableMap(Iterable<Short> keys,
            Iterable<Short> values);

     ShortShortMap newUpdatableMap(Iterable<Short> keys,
            Iterable<Short> values, int expectedSize);


     ShortShortMap newUpdatableMapOf(short k1, short v1);

     ShortShortMap newUpdatableMapOf(short k1, short v1,
            short k2, short v2);

     ShortShortMap newUpdatableMapOf(short k1, short v1,
            short k2, short v2, short k3, short v3);

     ShortShortMap newUpdatableMapOf(short k1, short v1,
            short k2, short v2, short k3, short v3,
            short k4, short v4);

     ShortShortMap newUpdatableMapOf(short k1, short v1,
            short k2, short v2, short k3, short v3,
            short k4, short v4, short k5, short v5);

    


     ShortShortMap newImmutableMap(Map<Short, Short> map1,
            Map<Short, Short> map2, int expectedSize);

     ShortShortMap newImmutableMap(Map<Short, Short> map1,
            Map<Short, Short> map2, Map<Short, Short> map3, int expectedSize);

     ShortShortMap newImmutableMap(Map<Short, Short> map1,
            Map<Short, Short> map2, Map<Short, Short> map3,
            Map<Short, Short> map4, int expectedSize);

     ShortShortMap newImmutableMap(Map<Short, Short> map1,
            Map<Short, Short> map2, Map<Short, Short> map3,
            Map<Short, Short> map4, Map<Short, Short> map5, int expectedSize);

    

    
     ShortShortMap newImmutableMap(Map<Short, Short> map);

     ShortShortMap newImmutableMap(Map<Short, Short> map1,
            Map<Short, Short> map2);

     ShortShortMap newImmutableMap(Map<Short, Short> map1,
            Map<Short, Short> map2, Map<Short, Short> map3);

     ShortShortMap newImmutableMap(Map<Short, Short> map1,
            Map<Short, Short> map2, Map<Short, Short> map3,
            Map<Short, Short> map4);

     ShortShortMap newImmutableMap(Map<Short, Short> map1,
            Map<Short, Short> map2, Map<Short, Short> map3,
            Map<Short, Short> map4, Map<Short, Short> map5);


     ShortShortMap newImmutableMap(
            net.openhft.function.Consumer<ShortShortConsumer> entriesSupplier);

     ShortShortMap newImmutableMap(
            net.openhft.function.Consumer<ShortShortConsumer> entriesSupplier,
            int expectedSize);

     ShortShortMap newImmutableMap(short[] keys, short[] values);

     ShortShortMap newImmutableMap(short[] keys, short[] values,
            int expectedSize);

     ShortShortMap newImmutableMap(Short[] keys, Short[] values);

     ShortShortMap newImmutableMap(Short[] keys, Short[] values,
            int expectedSize);

     ShortShortMap newImmutableMap(Iterable<Short> keys,
            Iterable<Short> values);

     ShortShortMap newImmutableMap(Iterable<Short> keys,
            Iterable<Short> values, int expectedSize);


     ShortShortMap newImmutableMapOf(short k1, short v1);

     ShortShortMap newImmutableMapOf(short k1, short v1,
            short k2, short v2);

     ShortShortMap newImmutableMapOf(short k1, short v1,
            short k2, short v2, short k3, short v3);

     ShortShortMap newImmutableMapOf(short k1, short v1,
            short k2, short v2, short k3, short v3,
            short k4, short v4);

     ShortShortMap newImmutableMapOf(short k1, short v1,
            short k2, short v2, short k3, short v3,
            short k4, short v4, short k5, short v5);
}

