/*
 * Copyright 2014 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.openhft.collect.map;

import net.openhft.collect.*;
import net.openhft.function.ShortObjConsumer;
import javax.annotation.Nullable;

import java.util.Map;


/**
 * An immutable factory of {@code ShortObjMap}s.
 *
 * @see ShortObjMap
 */
public interface ShortObjMapFactory<V> {

    

    

    

    

    

    
    

    
    



    @Nullable Equivalence<V> getValueEquivalence();

    <VE> ShortObjMapFactory<VE>
    withValueEquivalence(@Nullable Equivalence<VE> valueEquivalence);


    <V2 extends V> ShortObjMap<V2> newMutableMap();

    <V2 extends V> ShortObjMap<V2> newMutableMap(int expectedSize);

    


    <V2 extends V> ShortObjMap<V2> newMutableMap(Map<Short, ? extends V2> map1,
            Map<Short, ? extends V2> map2, int expectedSize);

    <V2 extends V> ShortObjMap<V2> newMutableMap(Map<Short, ? extends V2> map1,
            Map<Short, ? extends V2> map2, Map<Short, ? extends V2> map3, int expectedSize);

    <V2 extends V> ShortObjMap<V2> newMutableMap(Map<Short, ? extends V2> map1,
            Map<Short, ? extends V2> map2, Map<Short, ? extends V2> map3,
            Map<Short, ? extends V2> map4, int expectedSize);

    <V2 extends V> ShortObjMap<V2> newMutableMap(Map<Short, ? extends V2> map1,
            Map<Short, ? extends V2> map2, Map<Short, ? extends V2> map3,
            Map<Short, ? extends V2> map4, Map<Short, ? extends V2> map5, int expectedSize);

    

    
    <V2 extends V> ShortObjMap<V2> newMutableMap(Map<Short, ? extends V2> map);

    <V2 extends V> ShortObjMap<V2> newMutableMap(Map<Short, ? extends V2> map1,
            Map<Short, ? extends V2> map2);

    <V2 extends V> ShortObjMap<V2> newMutableMap(Map<Short, ? extends V2> map1,
            Map<Short, ? extends V2> map2, Map<Short, ? extends V2> map3);

    <V2 extends V> ShortObjMap<V2> newMutableMap(Map<Short, ? extends V2> map1,
            Map<Short, ? extends V2> map2, Map<Short, ? extends V2> map3,
            Map<Short, ? extends V2> map4);

    <V2 extends V> ShortObjMap<V2> newMutableMap(Map<Short, ? extends V2> map1,
            Map<Short, ? extends V2> map2, Map<Short, ? extends V2> map3,
            Map<Short, ? extends V2> map4, Map<Short, ? extends V2> map5);


    <V2 extends V> ShortObjMap<V2> newMutableMap(
            net.openhft.function.Consumer<ShortObjConsumer<V2>> entriesSupplier);

    <V2 extends V> ShortObjMap<V2> newMutableMap(
            net.openhft.function.Consumer<ShortObjConsumer<V2>> entriesSupplier,
            int expectedSize);

    <V2 extends V> ShortObjMap<V2> newMutableMap(short[] keys, V2[] values);

    <V2 extends V> ShortObjMap<V2> newMutableMap(short[] keys, V2[] values,
            int expectedSize);

    <V2 extends V> ShortObjMap<V2> newMutableMap(Short[] keys, V2[] values);

    <V2 extends V> ShortObjMap<V2> newMutableMap(Short[] keys, V2[] values,
            int expectedSize);

    <V2 extends V> ShortObjMap<V2> newMutableMap(Iterable<Short> keys,
            Iterable<? extends V2> values);

    <V2 extends V> ShortObjMap<V2> newMutableMap(Iterable<Short> keys,
            Iterable<? extends V2> values, int expectedSize);


    <V2 extends V> ShortObjMap<V2> newMutableMapOf(short k1, V2 v1);

    <V2 extends V> ShortObjMap<V2> newMutableMapOf(short k1, V2 v1,
            short k2, V2 v2);

    <V2 extends V> ShortObjMap<V2> newMutableMapOf(short k1, V2 v1,
            short k2, V2 v2, short k3, V2 v3);

    <V2 extends V> ShortObjMap<V2> newMutableMapOf(short k1, V2 v1,
            short k2, V2 v2, short k3, V2 v3,
            short k4, V2 v4);

    <V2 extends V> ShortObjMap<V2> newMutableMapOf(short k1, V2 v1,
            short k2, V2 v2, short k3, V2 v3,
            short k4, V2 v4, short k5, V2 v5);
    <V2 extends V> ShortObjMap<V2> newUpdatableMap();

    <V2 extends V> ShortObjMap<V2> newUpdatableMap(int expectedSize);

    


    <V2 extends V> ShortObjMap<V2> newUpdatableMap(Map<Short, ? extends V2> map1,
            Map<Short, ? extends V2> map2, int expectedSize);

    <V2 extends V> ShortObjMap<V2> newUpdatableMap(Map<Short, ? extends V2> map1,
            Map<Short, ? extends V2> map2, Map<Short, ? extends V2> map3, int expectedSize);

    <V2 extends V> ShortObjMap<V2> newUpdatableMap(Map<Short, ? extends V2> map1,
            Map<Short, ? extends V2> map2, Map<Short, ? extends V2> map3,
            Map<Short, ? extends V2> map4, int expectedSize);

    <V2 extends V> ShortObjMap<V2> newUpdatableMap(Map<Short, ? extends V2> map1,
            Map<Short, ? extends V2> map2, Map<Short, ? extends V2> map3,
            Map<Short, ? extends V2> map4, Map<Short, ? extends V2> map5, int expectedSize);

    

    
    <V2 extends V> ShortObjMap<V2> newUpdatableMap(Map<Short, ? extends V2> map);

    <V2 extends V> ShortObjMap<V2> newUpdatableMap(Map<Short, ? extends V2> map1,
            Map<Short, ? extends V2> map2);

    <V2 extends V> ShortObjMap<V2> newUpdatableMap(Map<Short, ? extends V2> map1,
            Map<Short, ? extends V2> map2, Map<Short, ? extends V2> map3);

    <V2 extends V> ShortObjMap<V2> newUpdatableMap(Map<Short, ? extends V2> map1,
            Map<Short, ? extends V2> map2, Map<Short, ? extends V2> map3,
            Map<Short, ? extends V2> map4);

    <V2 extends V> ShortObjMap<V2> newUpdatableMap(Map<Short, ? extends V2> map1,
            Map<Short, ? extends V2> map2, Map<Short, ? extends V2> map3,
            Map<Short, ? extends V2> map4, Map<Short, ? extends V2> map5);


    <V2 extends V> ShortObjMap<V2> newUpdatableMap(
            net.openhft.function.Consumer<ShortObjConsumer<V2>> entriesSupplier);

    <V2 extends V> ShortObjMap<V2> newUpdatableMap(
            net.openhft.function.Consumer<ShortObjConsumer<V2>> entriesSupplier,
            int expectedSize);

    <V2 extends V> ShortObjMap<V2> newUpdatableMap(short[] keys, V2[] values);

    <V2 extends V> ShortObjMap<V2> newUpdatableMap(short[] keys, V2[] values,
            int expectedSize);

    <V2 extends V> ShortObjMap<V2> newUpdatableMap(Short[] keys, V2[] values);

    <V2 extends V> ShortObjMap<V2> newUpdatableMap(Short[] keys, V2[] values,
            int expectedSize);

    <V2 extends V> ShortObjMap<V2> newUpdatableMap(Iterable<Short> keys,
            Iterable<? extends V2> values);

    <V2 extends V> ShortObjMap<V2> newUpdatableMap(Iterable<Short> keys,
            Iterable<? extends V2> values, int expectedSize);


    <V2 extends V> ShortObjMap<V2> newUpdatableMapOf(short k1, V2 v1);

    <V2 extends V> ShortObjMap<V2> newUpdatableMapOf(short k1, V2 v1,
            short k2, V2 v2);

    <V2 extends V> ShortObjMap<V2> newUpdatableMapOf(short k1, V2 v1,
            short k2, V2 v2, short k3, V2 v3);

    <V2 extends V> ShortObjMap<V2> newUpdatableMapOf(short k1, V2 v1,
            short k2, V2 v2, short k3, V2 v3,
            short k4, V2 v4);

    <V2 extends V> ShortObjMap<V2> newUpdatableMapOf(short k1, V2 v1,
            short k2, V2 v2, short k3, V2 v3,
            short k4, V2 v4, short k5, V2 v5);

    


    <V2 extends V> ShortObjMap<V2> newImmutableMap(Map<Short, ? extends V2> map1,
            Map<Short, ? extends V2> map2, int expectedSize);

    <V2 extends V> ShortObjMap<V2> newImmutableMap(Map<Short, ? extends V2> map1,
            Map<Short, ? extends V2> map2, Map<Short, ? extends V2> map3, int expectedSize);

    <V2 extends V> ShortObjMap<V2> newImmutableMap(Map<Short, ? extends V2> map1,
            Map<Short, ? extends V2> map2, Map<Short, ? extends V2> map3,
            Map<Short, ? extends V2> map4, int expectedSize);

    <V2 extends V> ShortObjMap<V2> newImmutableMap(Map<Short, ? extends V2> map1,
            Map<Short, ? extends V2> map2, Map<Short, ? extends V2> map3,
            Map<Short, ? extends V2> map4, Map<Short, ? extends V2> map5, int expectedSize);

    

    
    <V2 extends V> ShortObjMap<V2> newImmutableMap(Map<Short, ? extends V2> map);

    <V2 extends V> ShortObjMap<V2> newImmutableMap(Map<Short, ? extends V2> map1,
            Map<Short, ? extends V2> map2);

    <V2 extends V> ShortObjMap<V2> newImmutableMap(Map<Short, ? extends V2> map1,
            Map<Short, ? extends V2> map2, Map<Short, ? extends V2> map3);

    <V2 extends V> ShortObjMap<V2> newImmutableMap(Map<Short, ? extends V2> map1,
            Map<Short, ? extends V2> map2, Map<Short, ? extends V2> map3,
            Map<Short, ? extends V2> map4);

    <V2 extends V> ShortObjMap<V2> newImmutableMap(Map<Short, ? extends V2> map1,
            Map<Short, ? extends V2> map2, Map<Short, ? extends V2> map3,
            Map<Short, ? extends V2> map4, Map<Short, ? extends V2> map5);


    <V2 extends V> ShortObjMap<V2> newImmutableMap(
            net.openhft.function.Consumer<ShortObjConsumer<V2>> entriesSupplier);

    <V2 extends V> ShortObjMap<V2> newImmutableMap(
            net.openhft.function.Consumer<ShortObjConsumer<V2>> entriesSupplier,
            int expectedSize);

    <V2 extends V> ShortObjMap<V2> newImmutableMap(short[] keys, V2[] values);

    <V2 extends V> ShortObjMap<V2> newImmutableMap(short[] keys, V2[] values,
            int expectedSize);

    <V2 extends V> ShortObjMap<V2> newImmutableMap(Short[] keys, V2[] values);

    <V2 extends V> ShortObjMap<V2> newImmutableMap(Short[] keys, V2[] values,
            int expectedSize);

    <V2 extends V> ShortObjMap<V2> newImmutableMap(Iterable<Short> keys,
            Iterable<? extends V2> values);

    <V2 extends V> ShortObjMap<V2> newImmutableMap(Iterable<Short> keys,
            Iterable<? extends V2> values, int expectedSize);


    <V2 extends V> ShortObjMap<V2> newImmutableMapOf(short k1, V2 v1);

    <V2 extends V> ShortObjMap<V2> newImmutableMapOf(short k1, V2 v1,
            short k2, V2 v2);

    <V2 extends V> ShortObjMap<V2> newImmutableMapOf(short k1, V2 v1,
            short k2, V2 v2, short k3, V2 v3);

    <V2 extends V> ShortObjMap<V2> newImmutableMapOf(short k1, V2 v1,
            short k2, V2 v2, short k3, V2 v3,
            short k4, V2 v4);

    <V2 extends V> ShortObjMap<V2> newImmutableMapOf(short k1, V2 v1,
            short k2, V2 v2, short k3, V2 v3,
            short k4, V2 v4, short k5, V2 v5);
}

