/*
 * Copyright 2014 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.openhft.collect.map;

import net.openhft.collect.*;
import net.openhft.function.ShortLongConsumer;
import javax.annotation.Nullable;

import java.util.Map;


/**
 * An immutable factory of {@code ShortLongMap}s.
 *
 * @see ShortLongMap
 */
public interface ShortLongMapFactory {

    

    

    

    

    

    
    

    
    



    long getDefaultValue();

    /**
     * @see ShortLongMap#defaultValue()
     */
    ShortLongMapFactory withDefaultValue(long defaultValue);

     ShortLongMap newMutableMap();

     ShortLongMap newMutableMap(int expectedSize);

    


     ShortLongMap newMutableMap(Map<Short, Long> map1,
            Map<Short, Long> map2, int expectedSize);

     ShortLongMap newMutableMap(Map<Short, Long> map1,
            Map<Short, Long> map2, Map<Short, Long> map3, int expectedSize);

     ShortLongMap newMutableMap(Map<Short, Long> map1,
            Map<Short, Long> map2, Map<Short, Long> map3,
            Map<Short, Long> map4, int expectedSize);

     ShortLongMap newMutableMap(Map<Short, Long> map1,
            Map<Short, Long> map2, Map<Short, Long> map3,
            Map<Short, Long> map4, Map<Short, Long> map5, int expectedSize);

    

    
     ShortLongMap newMutableMap(Map<Short, Long> map);

     ShortLongMap newMutableMap(Map<Short, Long> map1,
            Map<Short, Long> map2);

     ShortLongMap newMutableMap(Map<Short, Long> map1,
            Map<Short, Long> map2, Map<Short, Long> map3);

     ShortLongMap newMutableMap(Map<Short, Long> map1,
            Map<Short, Long> map2, Map<Short, Long> map3,
            Map<Short, Long> map4);

     ShortLongMap newMutableMap(Map<Short, Long> map1,
            Map<Short, Long> map2, Map<Short, Long> map3,
            Map<Short, Long> map4, Map<Short, Long> map5);


     ShortLongMap newMutableMap(
            net.openhft.function.Consumer<ShortLongConsumer> entriesSupplier);

     ShortLongMap newMutableMap(
            net.openhft.function.Consumer<ShortLongConsumer> entriesSupplier,
            int expectedSize);

     ShortLongMap newMutableMap(short[] keys, long[] values);

     ShortLongMap newMutableMap(short[] keys, long[] values,
            int expectedSize);

     ShortLongMap newMutableMap(Short[] keys, Long[] values);

     ShortLongMap newMutableMap(Short[] keys, Long[] values,
            int expectedSize);

     ShortLongMap newMutableMap(Iterable<Short> keys,
            Iterable<Long> values);

     ShortLongMap newMutableMap(Iterable<Short> keys,
            Iterable<Long> values, int expectedSize);


     ShortLongMap newMutableMapOf(short k1, long v1);

     ShortLongMap newMutableMapOf(short k1, long v1,
            short k2, long v2);

     ShortLongMap newMutableMapOf(short k1, long v1,
            short k2, long v2, short k3, long v3);

     ShortLongMap newMutableMapOf(short k1, long v1,
            short k2, long v2, short k3, long v3,
            short k4, long v4);

     ShortLongMap newMutableMapOf(short k1, long v1,
            short k2, long v2, short k3, long v3,
            short k4, long v4, short k5, long v5);
     ShortLongMap newUpdatableMap();

     ShortLongMap newUpdatableMap(int expectedSize);

    


     ShortLongMap newUpdatableMap(Map<Short, Long> map1,
            Map<Short, Long> map2, int expectedSize);

     ShortLongMap newUpdatableMap(Map<Short, Long> map1,
            Map<Short, Long> map2, Map<Short, Long> map3, int expectedSize);

     ShortLongMap newUpdatableMap(Map<Short, Long> map1,
            Map<Short, Long> map2, Map<Short, Long> map3,
            Map<Short, Long> map4, int expectedSize);

     ShortLongMap newUpdatableMap(Map<Short, Long> map1,
            Map<Short, Long> map2, Map<Short, Long> map3,
            Map<Short, Long> map4, Map<Short, Long> map5, int expectedSize);

    

    
     ShortLongMap newUpdatableMap(Map<Short, Long> map);

     ShortLongMap newUpdatableMap(Map<Short, Long> map1,
            Map<Short, Long> map2);

     ShortLongMap newUpdatableMap(Map<Short, Long> map1,
            Map<Short, Long> map2, Map<Short, Long> map3);

     ShortLongMap newUpdatableMap(Map<Short, Long> map1,
            Map<Short, Long> map2, Map<Short, Long> map3,
            Map<Short, Long> map4);

     ShortLongMap newUpdatableMap(Map<Short, Long> map1,
            Map<Short, Long> map2, Map<Short, Long> map3,
            Map<Short, Long> map4, Map<Short, Long> map5);


     ShortLongMap newUpdatableMap(
            net.openhft.function.Consumer<ShortLongConsumer> entriesSupplier);

     ShortLongMap newUpdatableMap(
            net.openhft.function.Consumer<ShortLongConsumer> entriesSupplier,
            int expectedSize);

     ShortLongMap newUpdatableMap(short[] keys, long[] values);

     ShortLongMap newUpdatableMap(short[] keys, long[] values,
            int expectedSize);

     ShortLongMap newUpdatableMap(Short[] keys, Long[] values);

     ShortLongMap newUpdatableMap(Short[] keys, Long[] values,
            int expectedSize);

     ShortLongMap newUpdatableMap(Iterable<Short> keys,
            Iterable<Long> values);

     ShortLongMap newUpdatableMap(Iterable<Short> keys,
            Iterable<Long> values, int expectedSize);


     ShortLongMap newUpdatableMapOf(short k1, long v1);

     ShortLongMap newUpdatableMapOf(short k1, long v1,
            short k2, long v2);

     ShortLongMap newUpdatableMapOf(short k1, long v1,
            short k2, long v2, short k3, long v3);

     ShortLongMap newUpdatableMapOf(short k1, long v1,
            short k2, long v2, short k3, long v3,
            short k4, long v4);

     ShortLongMap newUpdatableMapOf(short k1, long v1,
            short k2, long v2, short k3, long v3,
            short k4, long v4, short k5, long v5);

    


     ShortLongMap newImmutableMap(Map<Short, Long> map1,
            Map<Short, Long> map2, int expectedSize);

     ShortLongMap newImmutableMap(Map<Short, Long> map1,
            Map<Short, Long> map2, Map<Short, Long> map3, int expectedSize);

     ShortLongMap newImmutableMap(Map<Short, Long> map1,
            Map<Short, Long> map2, Map<Short, Long> map3,
            Map<Short, Long> map4, int expectedSize);

     ShortLongMap newImmutableMap(Map<Short, Long> map1,
            Map<Short, Long> map2, Map<Short, Long> map3,
            Map<Short, Long> map4, Map<Short, Long> map5, int expectedSize);

    

    
     ShortLongMap newImmutableMap(Map<Short, Long> map);

     ShortLongMap newImmutableMap(Map<Short, Long> map1,
            Map<Short, Long> map2);

     ShortLongMap newImmutableMap(Map<Short, Long> map1,
            Map<Short, Long> map2, Map<Short, Long> map3);

     ShortLongMap newImmutableMap(Map<Short, Long> map1,
            Map<Short, Long> map2, Map<Short, Long> map3,
            Map<Short, Long> map4);

     ShortLongMap newImmutableMap(Map<Short, Long> map1,
            Map<Short, Long> map2, Map<Short, Long> map3,
            Map<Short, Long> map4, Map<Short, Long> map5);


     ShortLongMap newImmutableMap(
            net.openhft.function.Consumer<ShortLongConsumer> entriesSupplier);

     ShortLongMap newImmutableMap(
            net.openhft.function.Consumer<ShortLongConsumer> entriesSupplier,
            int expectedSize);

     ShortLongMap newImmutableMap(short[] keys, long[] values);

     ShortLongMap newImmutableMap(short[] keys, long[] values,
            int expectedSize);

     ShortLongMap newImmutableMap(Short[] keys, Long[] values);

     ShortLongMap newImmutableMap(Short[] keys, Long[] values,
            int expectedSize);

     ShortLongMap newImmutableMap(Iterable<Short> keys,
            Iterable<Long> values);

     ShortLongMap newImmutableMap(Iterable<Short> keys,
            Iterable<Long> values, int expectedSize);


     ShortLongMap newImmutableMapOf(short k1, long v1);

     ShortLongMap newImmutableMapOf(short k1, long v1,
            short k2, long v2);

     ShortLongMap newImmutableMapOf(short k1, long v1,
            short k2, long v2, short k3, long v3);

     ShortLongMap newImmutableMapOf(short k1, long v1,
            short k2, long v2, short k3, long v3,
            short k4, long v4);

     ShortLongMap newImmutableMapOf(short k1, long v1,
            short k2, long v2, short k3, long v3,
            short k4, long v4, short k5, long v5);
}

