/*
 * Copyright 2014 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.openhft.collect.map;

import net.openhft.collect.*;
import net.openhft.function.ShortIntConsumer;
import javax.annotation.Nullable;

import java.util.Map;


/**
 * An immutable factory of {@code ShortIntMap}s.
 *
 * @see ShortIntMap
 */
public interface ShortIntMapFactory {

    

    

    

    

    

    
    

    
    



    int getDefaultValue();

    /**
     * @see ShortIntMap#defaultValue()
     */
    ShortIntMapFactory withDefaultValue(int defaultValue);

     ShortIntMap newMutableMap();

     ShortIntMap newMutableMap(int expectedSize);

    


     ShortIntMap newMutableMap(Map<Short, Integer> map1,
            Map<Short, Integer> map2, int expectedSize);

     ShortIntMap newMutableMap(Map<Short, Integer> map1,
            Map<Short, Integer> map2, Map<Short, Integer> map3, int expectedSize);

     ShortIntMap newMutableMap(Map<Short, Integer> map1,
            Map<Short, Integer> map2, Map<Short, Integer> map3,
            Map<Short, Integer> map4, int expectedSize);

     ShortIntMap newMutableMap(Map<Short, Integer> map1,
            Map<Short, Integer> map2, Map<Short, Integer> map3,
            Map<Short, Integer> map4, Map<Short, Integer> map5, int expectedSize);

    

    
     ShortIntMap newMutableMap(Map<Short, Integer> map);

     ShortIntMap newMutableMap(Map<Short, Integer> map1,
            Map<Short, Integer> map2);

     ShortIntMap newMutableMap(Map<Short, Integer> map1,
            Map<Short, Integer> map2, Map<Short, Integer> map3);

     ShortIntMap newMutableMap(Map<Short, Integer> map1,
            Map<Short, Integer> map2, Map<Short, Integer> map3,
            Map<Short, Integer> map4);

     ShortIntMap newMutableMap(Map<Short, Integer> map1,
            Map<Short, Integer> map2, Map<Short, Integer> map3,
            Map<Short, Integer> map4, Map<Short, Integer> map5);


     ShortIntMap newMutableMap(
            net.openhft.function.Consumer<ShortIntConsumer> entriesSupplier);

     ShortIntMap newMutableMap(
            net.openhft.function.Consumer<ShortIntConsumer> entriesSupplier,
            int expectedSize);

     ShortIntMap newMutableMap(short[] keys, int[] values);

     ShortIntMap newMutableMap(short[] keys, int[] values,
            int expectedSize);

     ShortIntMap newMutableMap(Short[] keys, Integer[] values);

     ShortIntMap newMutableMap(Short[] keys, Integer[] values,
            int expectedSize);

     ShortIntMap newMutableMap(Iterable<Short> keys,
            Iterable<Integer> values);

     ShortIntMap newMutableMap(Iterable<Short> keys,
            Iterable<Integer> values, int expectedSize);


     ShortIntMap newMutableMapOf(short k1, int v1);

     ShortIntMap newMutableMapOf(short k1, int v1,
            short k2, int v2);

     ShortIntMap newMutableMapOf(short k1, int v1,
            short k2, int v2, short k3, int v3);

     ShortIntMap newMutableMapOf(short k1, int v1,
            short k2, int v2, short k3, int v3,
            short k4, int v4);

     ShortIntMap newMutableMapOf(short k1, int v1,
            short k2, int v2, short k3, int v3,
            short k4, int v4, short k5, int v5);
     ShortIntMap newUpdatableMap();

     ShortIntMap newUpdatableMap(int expectedSize);

    


     ShortIntMap newUpdatableMap(Map<Short, Integer> map1,
            Map<Short, Integer> map2, int expectedSize);

     ShortIntMap newUpdatableMap(Map<Short, Integer> map1,
            Map<Short, Integer> map2, Map<Short, Integer> map3, int expectedSize);

     ShortIntMap newUpdatableMap(Map<Short, Integer> map1,
            Map<Short, Integer> map2, Map<Short, Integer> map3,
            Map<Short, Integer> map4, int expectedSize);

     ShortIntMap newUpdatableMap(Map<Short, Integer> map1,
            Map<Short, Integer> map2, Map<Short, Integer> map3,
            Map<Short, Integer> map4, Map<Short, Integer> map5, int expectedSize);

    

    
     ShortIntMap newUpdatableMap(Map<Short, Integer> map);

     ShortIntMap newUpdatableMap(Map<Short, Integer> map1,
            Map<Short, Integer> map2);

     ShortIntMap newUpdatableMap(Map<Short, Integer> map1,
            Map<Short, Integer> map2, Map<Short, Integer> map3);

     ShortIntMap newUpdatableMap(Map<Short, Integer> map1,
            Map<Short, Integer> map2, Map<Short, Integer> map3,
            Map<Short, Integer> map4);

     ShortIntMap newUpdatableMap(Map<Short, Integer> map1,
            Map<Short, Integer> map2, Map<Short, Integer> map3,
            Map<Short, Integer> map4, Map<Short, Integer> map5);


     ShortIntMap newUpdatableMap(
            net.openhft.function.Consumer<ShortIntConsumer> entriesSupplier);

     ShortIntMap newUpdatableMap(
            net.openhft.function.Consumer<ShortIntConsumer> entriesSupplier,
            int expectedSize);

     ShortIntMap newUpdatableMap(short[] keys, int[] values);

     ShortIntMap newUpdatableMap(short[] keys, int[] values,
            int expectedSize);

     ShortIntMap newUpdatableMap(Short[] keys, Integer[] values);

     ShortIntMap newUpdatableMap(Short[] keys, Integer[] values,
            int expectedSize);

     ShortIntMap newUpdatableMap(Iterable<Short> keys,
            Iterable<Integer> values);

     ShortIntMap newUpdatableMap(Iterable<Short> keys,
            Iterable<Integer> values, int expectedSize);


     ShortIntMap newUpdatableMapOf(short k1, int v1);

     ShortIntMap newUpdatableMapOf(short k1, int v1,
            short k2, int v2);

     ShortIntMap newUpdatableMapOf(short k1, int v1,
            short k2, int v2, short k3, int v3);

     ShortIntMap newUpdatableMapOf(short k1, int v1,
            short k2, int v2, short k3, int v3,
            short k4, int v4);

     ShortIntMap newUpdatableMapOf(short k1, int v1,
            short k2, int v2, short k3, int v3,
            short k4, int v4, short k5, int v5);

    


     ShortIntMap newImmutableMap(Map<Short, Integer> map1,
            Map<Short, Integer> map2, int expectedSize);

     ShortIntMap newImmutableMap(Map<Short, Integer> map1,
            Map<Short, Integer> map2, Map<Short, Integer> map3, int expectedSize);

     ShortIntMap newImmutableMap(Map<Short, Integer> map1,
            Map<Short, Integer> map2, Map<Short, Integer> map3,
            Map<Short, Integer> map4, int expectedSize);

     ShortIntMap newImmutableMap(Map<Short, Integer> map1,
            Map<Short, Integer> map2, Map<Short, Integer> map3,
            Map<Short, Integer> map4, Map<Short, Integer> map5, int expectedSize);

    

    
     ShortIntMap newImmutableMap(Map<Short, Integer> map);

     ShortIntMap newImmutableMap(Map<Short, Integer> map1,
            Map<Short, Integer> map2);

     ShortIntMap newImmutableMap(Map<Short, Integer> map1,
            Map<Short, Integer> map2, Map<Short, Integer> map3);

     ShortIntMap newImmutableMap(Map<Short, Integer> map1,
            Map<Short, Integer> map2, Map<Short, Integer> map3,
            Map<Short, Integer> map4);

     ShortIntMap newImmutableMap(Map<Short, Integer> map1,
            Map<Short, Integer> map2, Map<Short, Integer> map3,
            Map<Short, Integer> map4, Map<Short, Integer> map5);


     ShortIntMap newImmutableMap(
            net.openhft.function.Consumer<ShortIntConsumer> entriesSupplier);

     ShortIntMap newImmutableMap(
            net.openhft.function.Consumer<ShortIntConsumer> entriesSupplier,
            int expectedSize);

     ShortIntMap newImmutableMap(short[] keys, int[] values);

     ShortIntMap newImmutableMap(short[] keys, int[] values,
            int expectedSize);

     ShortIntMap newImmutableMap(Short[] keys, Integer[] values);

     ShortIntMap newImmutableMap(Short[] keys, Integer[] values,
            int expectedSize);

     ShortIntMap newImmutableMap(Iterable<Short> keys,
            Iterable<Integer> values);

     ShortIntMap newImmutableMap(Iterable<Short> keys,
            Iterable<Integer> values, int expectedSize);


     ShortIntMap newImmutableMapOf(short k1, int v1);

     ShortIntMap newImmutableMapOf(short k1, int v1,
            short k2, int v2);

     ShortIntMap newImmutableMapOf(short k1, int v1,
            short k2, int v2, short k3, int v3);

     ShortIntMap newImmutableMapOf(short k1, int v1,
            short k2, int v2, short k3, int v3,
            short k4, int v4);

     ShortIntMap newImmutableMapOf(short k1, int v1,
            short k2, int v2, short k3, int v3,
            short k4, int v4, short k5, int v5);
}

