/*
 * Copyright 2014 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.openhft.collect.map;

import net.openhft.collect.*;
import net.openhft.function.ShortFloatConsumer;
import javax.annotation.Nullable;

import java.util.Map;


/**
 * An immutable factory of {@code ShortFloatMap}s.
 *
 * @see ShortFloatMap
 */
public interface ShortFloatMapFactory {

    

    

    

    

    

    
    

    
    



    float getDefaultValue();

    /**
     * @see ShortFloatMap#defaultValue()
     */
    ShortFloatMapFactory withDefaultValue(float defaultValue);

     ShortFloatMap newMutableMap();

     ShortFloatMap newMutableMap(int expectedSize);

    


     ShortFloatMap newMutableMap(Map<Short, Float> map1,
            Map<Short, Float> map2, int expectedSize);

     ShortFloatMap newMutableMap(Map<Short, Float> map1,
            Map<Short, Float> map2, Map<Short, Float> map3, int expectedSize);

     ShortFloatMap newMutableMap(Map<Short, Float> map1,
            Map<Short, Float> map2, Map<Short, Float> map3,
            Map<Short, Float> map4, int expectedSize);

     ShortFloatMap newMutableMap(Map<Short, Float> map1,
            Map<Short, Float> map2, Map<Short, Float> map3,
            Map<Short, Float> map4, Map<Short, Float> map5, int expectedSize);

    

    
     ShortFloatMap newMutableMap(Map<Short, Float> map);

     ShortFloatMap newMutableMap(Map<Short, Float> map1,
            Map<Short, Float> map2);

     ShortFloatMap newMutableMap(Map<Short, Float> map1,
            Map<Short, Float> map2, Map<Short, Float> map3);

     ShortFloatMap newMutableMap(Map<Short, Float> map1,
            Map<Short, Float> map2, Map<Short, Float> map3,
            Map<Short, Float> map4);

     ShortFloatMap newMutableMap(Map<Short, Float> map1,
            Map<Short, Float> map2, Map<Short, Float> map3,
            Map<Short, Float> map4, Map<Short, Float> map5);


     ShortFloatMap newMutableMap(
            net.openhft.function.Consumer<ShortFloatConsumer> entriesSupplier);

     ShortFloatMap newMutableMap(
            net.openhft.function.Consumer<ShortFloatConsumer> entriesSupplier,
            int expectedSize);

     ShortFloatMap newMutableMap(short[] keys, float[] values);

     ShortFloatMap newMutableMap(short[] keys, float[] values,
            int expectedSize);

     ShortFloatMap newMutableMap(Short[] keys, Float[] values);

     ShortFloatMap newMutableMap(Short[] keys, Float[] values,
            int expectedSize);

     ShortFloatMap newMutableMap(Iterable<Short> keys,
            Iterable<Float> values);

     ShortFloatMap newMutableMap(Iterable<Short> keys,
            Iterable<Float> values, int expectedSize);


     ShortFloatMap newMutableMapOf(short k1, float v1);

     ShortFloatMap newMutableMapOf(short k1, float v1,
            short k2, float v2);

     ShortFloatMap newMutableMapOf(short k1, float v1,
            short k2, float v2, short k3, float v3);

     ShortFloatMap newMutableMapOf(short k1, float v1,
            short k2, float v2, short k3, float v3,
            short k4, float v4);

     ShortFloatMap newMutableMapOf(short k1, float v1,
            short k2, float v2, short k3, float v3,
            short k4, float v4, short k5, float v5);
     ShortFloatMap newUpdatableMap();

     ShortFloatMap newUpdatableMap(int expectedSize);

    


     ShortFloatMap newUpdatableMap(Map<Short, Float> map1,
            Map<Short, Float> map2, int expectedSize);

     ShortFloatMap newUpdatableMap(Map<Short, Float> map1,
            Map<Short, Float> map2, Map<Short, Float> map3, int expectedSize);

     ShortFloatMap newUpdatableMap(Map<Short, Float> map1,
            Map<Short, Float> map2, Map<Short, Float> map3,
            Map<Short, Float> map4, int expectedSize);

     ShortFloatMap newUpdatableMap(Map<Short, Float> map1,
            Map<Short, Float> map2, Map<Short, Float> map3,
            Map<Short, Float> map4, Map<Short, Float> map5, int expectedSize);

    

    
     ShortFloatMap newUpdatableMap(Map<Short, Float> map);

     ShortFloatMap newUpdatableMap(Map<Short, Float> map1,
            Map<Short, Float> map2);

     ShortFloatMap newUpdatableMap(Map<Short, Float> map1,
            Map<Short, Float> map2, Map<Short, Float> map3);

     ShortFloatMap newUpdatableMap(Map<Short, Float> map1,
            Map<Short, Float> map2, Map<Short, Float> map3,
            Map<Short, Float> map4);

     ShortFloatMap newUpdatableMap(Map<Short, Float> map1,
            Map<Short, Float> map2, Map<Short, Float> map3,
            Map<Short, Float> map4, Map<Short, Float> map5);


     ShortFloatMap newUpdatableMap(
            net.openhft.function.Consumer<ShortFloatConsumer> entriesSupplier);

     ShortFloatMap newUpdatableMap(
            net.openhft.function.Consumer<ShortFloatConsumer> entriesSupplier,
            int expectedSize);

     ShortFloatMap newUpdatableMap(short[] keys, float[] values);

     ShortFloatMap newUpdatableMap(short[] keys, float[] values,
            int expectedSize);

     ShortFloatMap newUpdatableMap(Short[] keys, Float[] values);

     ShortFloatMap newUpdatableMap(Short[] keys, Float[] values,
            int expectedSize);

     ShortFloatMap newUpdatableMap(Iterable<Short> keys,
            Iterable<Float> values);

     ShortFloatMap newUpdatableMap(Iterable<Short> keys,
            Iterable<Float> values, int expectedSize);


     ShortFloatMap newUpdatableMapOf(short k1, float v1);

     ShortFloatMap newUpdatableMapOf(short k1, float v1,
            short k2, float v2);

     ShortFloatMap newUpdatableMapOf(short k1, float v1,
            short k2, float v2, short k3, float v3);

     ShortFloatMap newUpdatableMapOf(short k1, float v1,
            short k2, float v2, short k3, float v3,
            short k4, float v4);

     ShortFloatMap newUpdatableMapOf(short k1, float v1,
            short k2, float v2, short k3, float v3,
            short k4, float v4, short k5, float v5);

    


     ShortFloatMap newImmutableMap(Map<Short, Float> map1,
            Map<Short, Float> map2, int expectedSize);

     ShortFloatMap newImmutableMap(Map<Short, Float> map1,
            Map<Short, Float> map2, Map<Short, Float> map3, int expectedSize);

     ShortFloatMap newImmutableMap(Map<Short, Float> map1,
            Map<Short, Float> map2, Map<Short, Float> map3,
            Map<Short, Float> map4, int expectedSize);

     ShortFloatMap newImmutableMap(Map<Short, Float> map1,
            Map<Short, Float> map2, Map<Short, Float> map3,
            Map<Short, Float> map4, Map<Short, Float> map5, int expectedSize);

    

    
     ShortFloatMap newImmutableMap(Map<Short, Float> map);

     ShortFloatMap newImmutableMap(Map<Short, Float> map1,
            Map<Short, Float> map2);

     ShortFloatMap newImmutableMap(Map<Short, Float> map1,
            Map<Short, Float> map2, Map<Short, Float> map3);

     ShortFloatMap newImmutableMap(Map<Short, Float> map1,
            Map<Short, Float> map2, Map<Short, Float> map3,
            Map<Short, Float> map4);

     ShortFloatMap newImmutableMap(Map<Short, Float> map1,
            Map<Short, Float> map2, Map<Short, Float> map3,
            Map<Short, Float> map4, Map<Short, Float> map5);


     ShortFloatMap newImmutableMap(
            net.openhft.function.Consumer<ShortFloatConsumer> entriesSupplier);

     ShortFloatMap newImmutableMap(
            net.openhft.function.Consumer<ShortFloatConsumer> entriesSupplier,
            int expectedSize);

     ShortFloatMap newImmutableMap(short[] keys, float[] values);

     ShortFloatMap newImmutableMap(short[] keys, float[] values,
            int expectedSize);

     ShortFloatMap newImmutableMap(Short[] keys, Float[] values);

     ShortFloatMap newImmutableMap(Short[] keys, Float[] values,
            int expectedSize);

     ShortFloatMap newImmutableMap(Iterable<Short> keys,
            Iterable<Float> values);

     ShortFloatMap newImmutableMap(Iterable<Short> keys,
            Iterable<Float> values, int expectedSize);


     ShortFloatMap newImmutableMapOf(short k1, float v1);

     ShortFloatMap newImmutableMapOf(short k1, float v1,
            short k2, float v2);

     ShortFloatMap newImmutableMapOf(short k1, float v1,
            short k2, float v2, short k3, float v3);

     ShortFloatMap newImmutableMapOf(short k1, float v1,
            short k2, float v2, short k3, float v3,
            short k4, float v4);

     ShortFloatMap newImmutableMapOf(short k1, float v1,
            short k2, float v2, short k3, float v3,
            short k4, float v4, short k5, float v5);
}

