/*
 * Copyright 2014 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.openhft.collect.map;

import net.openhft.collect.*;
import net.openhft.function.ShortDoubleConsumer;
import javax.annotation.Nullable;

import java.util.Map;


/**
 * An immutable factory of {@code ShortDoubleMap}s.
 *
 * @see ShortDoubleMap
 */
public interface ShortDoubleMapFactory {

    

    

    

    

    

    
    

    
    



    double getDefaultValue();

    /**
     * @see ShortDoubleMap#defaultValue()
     */
    ShortDoubleMapFactory withDefaultValue(double defaultValue);

     ShortDoubleMap newMutableMap();

     ShortDoubleMap newMutableMap(int expectedSize);

    


     ShortDoubleMap newMutableMap(Map<Short, Double> map1,
            Map<Short, Double> map2, int expectedSize);

     ShortDoubleMap newMutableMap(Map<Short, Double> map1,
            Map<Short, Double> map2, Map<Short, Double> map3, int expectedSize);

     ShortDoubleMap newMutableMap(Map<Short, Double> map1,
            Map<Short, Double> map2, Map<Short, Double> map3,
            Map<Short, Double> map4, int expectedSize);

     ShortDoubleMap newMutableMap(Map<Short, Double> map1,
            Map<Short, Double> map2, Map<Short, Double> map3,
            Map<Short, Double> map4, Map<Short, Double> map5, int expectedSize);

    

    
     ShortDoubleMap newMutableMap(Map<Short, Double> map);

     ShortDoubleMap newMutableMap(Map<Short, Double> map1,
            Map<Short, Double> map2);

     ShortDoubleMap newMutableMap(Map<Short, Double> map1,
            Map<Short, Double> map2, Map<Short, Double> map3);

     ShortDoubleMap newMutableMap(Map<Short, Double> map1,
            Map<Short, Double> map2, Map<Short, Double> map3,
            Map<Short, Double> map4);

     ShortDoubleMap newMutableMap(Map<Short, Double> map1,
            Map<Short, Double> map2, Map<Short, Double> map3,
            Map<Short, Double> map4, Map<Short, Double> map5);


     ShortDoubleMap newMutableMap(
            net.openhft.function.Consumer<ShortDoubleConsumer> entriesSupplier);

     ShortDoubleMap newMutableMap(
            net.openhft.function.Consumer<ShortDoubleConsumer> entriesSupplier,
            int expectedSize);

     ShortDoubleMap newMutableMap(short[] keys, double[] values);

     ShortDoubleMap newMutableMap(short[] keys, double[] values,
            int expectedSize);

     ShortDoubleMap newMutableMap(Short[] keys, Double[] values);

     ShortDoubleMap newMutableMap(Short[] keys, Double[] values,
            int expectedSize);

     ShortDoubleMap newMutableMap(Iterable<Short> keys,
            Iterable<Double> values);

     ShortDoubleMap newMutableMap(Iterable<Short> keys,
            Iterable<Double> values, int expectedSize);


     ShortDoubleMap newMutableMapOf(short k1, double v1);

     ShortDoubleMap newMutableMapOf(short k1, double v1,
            short k2, double v2);

     ShortDoubleMap newMutableMapOf(short k1, double v1,
            short k2, double v2, short k3, double v3);

     ShortDoubleMap newMutableMapOf(short k1, double v1,
            short k2, double v2, short k3, double v3,
            short k4, double v4);

     ShortDoubleMap newMutableMapOf(short k1, double v1,
            short k2, double v2, short k3, double v3,
            short k4, double v4, short k5, double v5);
     ShortDoubleMap newUpdatableMap();

     ShortDoubleMap newUpdatableMap(int expectedSize);

    


     ShortDoubleMap newUpdatableMap(Map<Short, Double> map1,
            Map<Short, Double> map2, int expectedSize);

     ShortDoubleMap newUpdatableMap(Map<Short, Double> map1,
            Map<Short, Double> map2, Map<Short, Double> map3, int expectedSize);

     ShortDoubleMap newUpdatableMap(Map<Short, Double> map1,
            Map<Short, Double> map2, Map<Short, Double> map3,
            Map<Short, Double> map4, int expectedSize);

     ShortDoubleMap newUpdatableMap(Map<Short, Double> map1,
            Map<Short, Double> map2, Map<Short, Double> map3,
            Map<Short, Double> map4, Map<Short, Double> map5, int expectedSize);

    

    
     ShortDoubleMap newUpdatableMap(Map<Short, Double> map);

     ShortDoubleMap newUpdatableMap(Map<Short, Double> map1,
            Map<Short, Double> map2);

     ShortDoubleMap newUpdatableMap(Map<Short, Double> map1,
            Map<Short, Double> map2, Map<Short, Double> map3);

     ShortDoubleMap newUpdatableMap(Map<Short, Double> map1,
            Map<Short, Double> map2, Map<Short, Double> map3,
            Map<Short, Double> map4);

     ShortDoubleMap newUpdatableMap(Map<Short, Double> map1,
            Map<Short, Double> map2, Map<Short, Double> map3,
            Map<Short, Double> map4, Map<Short, Double> map5);


     ShortDoubleMap newUpdatableMap(
            net.openhft.function.Consumer<ShortDoubleConsumer> entriesSupplier);

     ShortDoubleMap newUpdatableMap(
            net.openhft.function.Consumer<ShortDoubleConsumer> entriesSupplier,
            int expectedSize);

     ShortDoubleMap newUpdatableMap(short[] keys, double[] values);

     ShortDoubleMap newUpdatableMap(short[] keys, double[] values,
            int expectedSize);

     ShortDoubleMap newUpdatableMap(Short[] keys, Double[] values);

     ShortDoubleMap newUpdatableMap(Short[] keys, Double[] values,
            int expectedSize);

     ShortDoubleMap newUpdatableMap(Iterable<Short> keys,
            Iterable<Double> values);

     ShortDoubleMap newUpdatableMap(Iterable<Short> keys,
            Iterable<Double> values, int expectedSize);


     ShortDoubleMap newUpdatableMapOf(short k1, double v1);

     ShortDoubleMap newUpdatableMapOf(short k1, double v1,
            short k2, double v2);

     ShortDoubleMap newUpdatableMapOf(short k1, double v1,
            short k2, double v2, short k3, double v3);

     ShortDoubleMap newUpdatableMapOf(short k1, double v1,
            short k2, double v2, short k3, double v3,
            short k4, double v4);

     ShortDoubleMap newUpdatableMapOf(short k1, double v1,
            short k2, double v2, short k3, double v3,
            short k4, double v4, short k5, double v5);

    


     ShortDoubleMap newImmutableMap(Map<Short, Double> map1,
            Map<Short, Double> map2, int expectedSize);

     ShortDoubleMap newImmutableMap(Map<Short, Double> map1,
            Map<Short, Double> map2, Map<Short, Double> map3, int expectedSize);

     ShortDoubleMap newImmutableMap(Map<Short, Double> map1,
            Map<Short, Double> map2, Map<Short, Double> map3,
            Map<Short, Double> map4, int expectedSize);

     ShortDoubleMap newImmutableMap(Map<Short, Double> map1,
            Map<Short, Double> map2, Map<Short, Double> map3,
            Map<Short, Double> map4, Map<Short, Double> map5, int expectedSize);

    

    
     ShortDoubleMap newImmutableMap(Map<Short, Double> map);

     ShortDoubleMap newImmutableMap(Map<Short, Double> map1,
            Map<Short, Double> map2);

     ShortDoubleMap newImmutableMap(Map<Short, Double> map1,
            Map<Short, Double> map2, Map<Short, Double> map3);

     ShortDoubleMap newImmutableMap(Map<Short, Double> map1,
            Map<Short, Double> map2, Map<Short, Double> map3,
            Map<Short, Double> map4);

     ShortDoubleMap newImmutableMap(Map<Short, Double> map1,
            Map<Short, Double> map2, Map<Short, Double> map3,
            Map<Short, Double> map4, Map<Short, Double> map5);


     ShortDoubleMap newImmutableMap(
            net.openhft.function.Consumer<ShortDoubleConsumer> entriesSupplier);

     ShortDoubleMap newImmutableMap(
            net.openhft.function.Consumer<ShortDoubleConsumer> entriesSupplier,
            int expectedSize);

     ShortDoubleMap newImmutableMap(short[] keys, double[] values);

     ShortDoubleMap newImmutableMap(short[] keys, double[] values,
            int expectedSize);

     ShortDoubleMap newImmutableMap(Short[] keys, Double[] values);

     ShortDoubleMap newImmutableMap(Short[] keys, Double[] values,
            int expectedSize);

     ShortDoubleMap newImmutableMap(Iterable<Short> keys,
            Iterable<Double> values);

     ShortDoubleMap newImmutableMap(Iterable<Short> keys,
            Iterable<Double> values, int expectedSize);


     ShortDoubleMap newImmutableMapOf(short k1, double v1);

     ShortDoubleMap newImmutableMapOf(short k1, double v1,
            short k2, double v2);

     ShortDoubleMap newImmutableMapOf(short k1, double v1,
            short k2, double v2, short k3, double v3);

     ShortDoubleMap newImmutableMapOf(short k1, double v1,
            short k2, double v2, short k3, double v3,
            short k4, double v4);

     ShortDoubleMap newImmutableMapOf(short k1, double v1,
            short k2, double v2, short k3, double v3,
            short k4, double v4, short k5, double v5);
}

