/*
 * Copyright 2014 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.openhft.collect.map;

import net.openhft.collect.*;
import net.openhft.function.ShortCharConsumer;
import javax.annotation.Nullable;

import java.util.Map;


/**
 * An immutable factory of {@code ShortCharMap}s.
 *
 * @see ShortCharMap
 */
public interface ShortCharMapFactory {

    

    

    

    

    

    
    

    
    



    char getDefaultValue();

    /**
     * @see ShortCharMap#defaultValue()
     */
    ShortCharMapFactory withDefaultValue(char defaultValue);

     ShortCharMap newMutableMap();

     ShortCharMap newMutableMap(int expectedSize);

    


     ShortCharMap newMutableMap(Map<Short, Character> map1,
            Map<Short, Character> map2, int expectedSize);

     ShortCharMap newMutableMap(Map<Short, Character> map1,
            Map<Short, Character> map2, Map<Short, Character> map3, int expectedSize);

     ShortCharMap newMutableMap(Map<Short, Character> map1,
            Map<Short, Character> map2, Map<Short, Character> map3,
            Map<Short, Character> map4, int expectedSize);

     ShortCharMap newMutableMap(Map<Short, Character> map1,
            Map<Short, Character> map2, Map<Short, Character> map3,
            Map<Short, Character> map4, Map<Short, Character> map5, int expectedSize);

    

    
     ShortCharMap newMutableMap(Map<Short, Character> map);

     ShortCharMap newMutableMap(Map<Short, Character> map1,
            Map<Short, Character> map2);

     ShortCharMap newMutableMap(Map<Short, Character> map1,
            Map<Short, Character> map2, Map<Short, Character> map3);

     ShortCharMap newMutableMap(Map<Short, Character> map1,
            Map<Short, Character> map2, Map<Short, Character> map3,
            Map<Short, Character> map4);

     ShortCharMap newMutableMap(Map<Short, Character> map1,
            Map<Short, Character> map2, Map<Short, Character> map3,
            Map<Short, Character> map4, Map<Short, Character> map5);


     ShortCharMap newMutableMap(
            net.openhft.function.Consumer<ShortCharConsumer> entriesSupplier);

     ShortCharMap newMutableMap(
            net.openhft.function.Consumer<ShortCharConsumer> entriesSupplier,
            int expectedSize);

     ShortCharMap newMutableMap(short[] keys, char[] values);

     ShortCharMap newMutableMap(short[] keys, char[] values,
            int expectedSize);

     ShortCharMap newMutableMap(Short[] keys, Character[] values);

     ShortCharMap newMutableMap(Short[] keys, Character[] values,
            int expectedSize);

     ShortCharMap newMutableMap(Iterable<Short> keys,
            Iterable<Character> values);

     ShortCharMap newMutableMap(Iterable<Short> keys,
            Iterable<Character> values, int expectedSize);


     ShortCharMap newMutableMapOf(short k1, char v1);

     ShortCharMap newMutableMapOf(short k1, char v1,
            short k2, char v2);

     ShortCharMap newMutableMapOf(short k1, char v1,
            short k2, char v2, short k3, char v3);

     ShortCharMap newMutableMapOf(short k1, char v1,
            short k2, char v2, short k3, char v3,
            short k4, char v4);

     ShortCharMap newMutableMapOf(short k1, char v1,
            short k2, char v2, short k3, char v3,
            short k4, char v4, short k5, char v5);
     ShortCharMap newUpdatableMap();

     ShortCharMap newUpdatableMap(int expectedSize);

    


     ShortCharMap newUpdatableMap(Map<Short, Character> map1,
            Map<Short, Character> map2, int expectedSize);

     ShortCharMap newUpdatableMap(Map<Short, Character> map1,
            Map<Short, Character> map2, Map<Short, Character> map3, int expectedSize);

     ShortCharMap newUpdatableMap(Map<Short, Character> map1,
            Map<Short, Character> map2, Map<Short, Character> map3,
            Map<Short, Character> map4, int expectedSize);

     ShortCharMap newUpdatableMap(Map<Short, Character> map1,
            Map<Short, Character> map2, Map<Short, Character> map3,
            Map<Short, Character> map4, Map<Short, Character> map5, int expectedSize);

    

    
     ShortCharMap newUpdatableMap(Map<Short, Character> map);

     ShortCharMap newUpdatableMap(Map<Short, Character> map1,
            Map<Short, Character> map2);

     ShortCharMap newUpdatableMap(Map<Short, Character> map1,
            Map<Short, Character> map2, Map<Short, Character> map3);

     ShortCharMap newUpdatableMap(Map<Short, Character> map1,
            Map<Short, Character> map2, Map<Short, Character> map3,
            Map<Short, Character> map4);

     ShortCharMap newUpdatableMap(Map<Short, Character> map1,
            Map<Short, Character> map2, Map<Short, Character> map3,
            Map<Short, Character> map4, Map<Short, Character> map5);


     ShortCharMap newUpdatableMap(
            net.openhft.function.Consumer<ShortCharConsumer> entriesSupplier);

     ShortCharMap newUpdatableMap(
            net.openhft.function.Consumer<ShortCharConsumer> entriesSupplier,
            int expectedSize);

     ShortCharMap newUpdatableMap(short[] keys, char[] values);

     ShortCharMap newUpdatableMap(short[] keys, char[] values,
            int expectedSize);

     ShortCharMap newUpdatableMap(Short[] keys, Character[] values);

     ShortCharMap newUpdatableMap(Short[] keys, Character[] values,
            int expectedSize);

     ShortCharMap newUpdatableMap(Iterable<Short> keys,
            Iterable<Character> values);

     ShortCharMap newUpdatableMap(Iterable<Short> keys,
            Iterable<Character> values, int expectedSize);


     ShortCharMap newUpdatableMapOf(short k1, char v1);

     ShortCharMap newUpdatableMapOf(short k1, char v1,
            short k2, char v2);

     ShortCharMap newUpdatableMapOf(short k1, char v1,
            short k2, char v2, short k3, char v3);

     ShortCharMap newUpdatableMapOf(short k1, char v1,
            short k2, char v2, short k3, char v3,
            short k4, char v4);

     ShortCharMap newUpdatableMapOf(short k1, char v1,
            short k2, char v2, short k3, char v3,
            short k4, char v4, short k5, char v5);

    


     ShortCharMap newImmutableMap(Map<Short, Character> map1,
            Map<Short, Character> map2, int expectedSize);

     ShortCharMap newImmutableMap(Map<Short, Character> map1,
            Map<Short, Character> map2, Map<Short, Character> map3, int expectedSize);

     ShortCharMap newImmutableMap(Map<Short, Character> map1,
            Map<Short, Character> map2, Map<Short, Character> map3,
            Map<Short, Character> map4, int expectedSize);

     ShortCharMap newImmutableMap(Map<Short, Character> map1,
            Map<Short, Character> map2, Map<Short, Character> map3,
            Map<Short, Character> map4, Map<Short, Character> map5, int expectedSize);

    

    
     ShortCharMap newImmutableMap(Map<Short, Character> map);

     ShortCharMap newImmutableMap(Map<Short, Character> map1,
            Map<Short, Character> map2);

     ShortCharMap newImmutableMap(Map<Short, Character> map1,
            Map<Short, Character> map2, Map<Short, Character> map3);

     ShortCharMap newImmutableMap(Map<Short, Character> map1,
            Map<Short, Character> map2, Map<Short, Character> map3,
            Map<Short, Character> map4);

     ShortCharMap newImmutableMap(Map<Short, Character> map1,
            Map<Short, Character> map2, Map<Short, Character> map3,
            Map<Short, Character> map4, Map<Short, Character> map5);


     ShortCharMap newImmutableMap(
            net.openhft.function.Consumer<ShortCharConsumer> entriesSupplier);

     ShortCharMap newImmutableMap(
            net.openhft.function.Consumer<ShortCharConsumer> entriesSupplier,
            int expectedSize);

     ShortCharMap newImmutableMap(short[] keys, char[] values);

     ShortCharMap newImmutableMap(short[] keys, char[] values,
            int expectedSize);

     ShortCharMap newImmutableMap(Short[] keys, Character[] values);

     ShortCharMap newImmutableMap(Short[] keys, Character[] values,
            int expectedSize);

     ShortCharMap newImmutableMap(Iterable<Short> keys,
            Iterable<Character> values);

     ShortCharMap newImmutableMap(Iterable<Short> keys,
            Iterable<Character> values, int expectedSize);


     ShortCharMap newImmutableMapOf(short k1, char v1);

     ShortCharMap newImmutableMapOf(short k1, char v1,
            short k2, char v2);

     ShortCharMap newImmutableMapOf(short k1, char v1,
            short k2, char v2, short k3, char v3);

     ShortCharMap newImmutableMapOf(short k1, char v1,
            short k2, char v2, short k3, char v3,
            short k4, char v4);

     ShortCharMap newImmutableMapOf(short k1, char v1,
            short k2, char v2, short k3, char v3,
            short k4, char v4, short k5, char v5);
}

