/*
 * Copyright 2014 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.openhft.collect.map;

import net.openhft.collect.*;
import net.openhft.function.ShortByteConsumer;
import javax.annotation.Nullable;

import java.util.Map;


/**
 * An immutable factory of {@code ShortByteMap}s.
 *
 * @see ShortByteMap
 */
public interface ShortByteMapFactory {

    

    

    

    

    

    
    

    
    



    byte getDefaultValue();

    /**
     * @see ShortByteMap#defaultValue()
     */
    ShortByteMapFactory withDefaultValue(byte defaultValue);

     ShortByteMap newMutableMap();

     ShortByteMap newMutableMap(int expectedSize);

    


     ShortByteMap newMutableMap(Map<Short, Byte> map1,
            Map<Short, Byte> map2, int expectedSize);

     ShortByteMap newMutableMap(Map<Short, Byte> map1,
            Map<Short, Byte> map2, Map<Short, Byte> map3, int expectedSize);

     ShortByteMap newMutableMap(Map<Short, Byte> map1,
            Map<Short, Byte> map2, Map<Short, Byte> map3,
            Map<Short, Byte> map4, int expectedSize);

     ShortByteMap newMutableMap(Map<Short, Byte> map1,
            Map<Short, Byte> map2, Map<Short, Byte> map3,
            Map<Short, Byte> map4, Map<Short, Byte> map5, int expectedSize);

    

    
     ShortByteMap newMutableMap(Map<Short, Byte> map);

     ShortByteMap newMutableMap(Map<Short, Byte> map1,
            Map<Short, Byte> map2);

     ShortByteMap newMutableMap(Map<Short, Byte> map1,
            Map<Short, Byte> map2, Map<Short, Byte> map3);

     ShortByteMap newMutableMap(Map<Short, Byte> map1,
            Map<Short, Byte> map2, Map<Short, Byte> map3,
            Map<Short, Byte> map4);

     ShortByteMap newMutableMap(Map<Short, Byte> map1,
            Map<Short, Byte> map2, Map<Short, Byte> map3,
            Map<Short, Byte> map4, Map<Short, Byte> map5);


     ShortByteMap newMutableMap(
            net.openhft.function.Consumer<ShortByteConsumer> entriesSupplier);

     ShortByteMap newMutableMap(
            net.openhft.function.Consumer<ShortByteConsumer> entriesSupplier,
            int expectedSize);

     ShortByteMap newMutableMap(short[] keys, byte[] values);

     ShortByteMap newMutableMap(short[] keys, byte[] values,
            int expectedSize);

     ShortByteMap newMutableMap(Short[] keys, Byte[] values);

     ShortByteMap newMutableMap(Short[] keys, Byte[] values,
            int expectedSize);

     ShortByteMap newMutableMap(Iterable<Short> keys,
            Iterable<Byte> values);

     ShortByteMap newMutableMap(Iterable<Short> keys,
            Iterable<Byte> values, int expectedSize);


     ShortByteMap newMutableMapOf(short k1, byte v1);

     ShortByteMap newMutableMapOf(short k1, byte v1,
            short k2, byte v2);

     ShortByteMap newMutableMapOf(short k1, byte v1,
            short k2, byte v2, short k3, byte v3);

     ShortByteMap newMutableMapOf(short k1, byte v1,
            short k2, byte v2, short k3, byte v3,
            short k4, byte v4);

     ShortByteMap newMutableMapOf(short k1, byte v1,
            short k2, byte v2, short k3, byte v3,
            short k4, byte v4, short k5, byte v5);
     ShortByteMap newUpdatableMap();

     ShortByteMap newUpdatableMap(int expectedSize);

    


     ShortByteMap newUpdatableMap(Map<Short, Byte> map1,
            Map<Short, Byte> map2, int expectedSize);

     ShortByteMap newUpdatableMap(Map<Short, Byte> map1,
            Map<Short, Byte> map2, Map<Short, Byte> map3, int expectedSize);

     ShortByteMap newUpdatableMap(Map<Short, Byte> map1,
            Map<Short, Byte> map2, Map<Short, Byte> map3,
            Map<Short, Byte> map4, int expectedSize);

     ShortByteMap newUpdatableMap(Map<Short, Byte> map1,
            Map<Short, Byte> map2, Map<Short, Byte> map3,
            Map<Short, Byte> map4, Map<Short, Byte> map5, int expectedSize);

    

    
     ShortByteMap newUpdatableMap(Map<Short, Byte> map);

     ShortByteMap newUpdatableMap(Map<Short, Byte> map1,
            Map<Short, Byte> map2);

     ShortByteMap newUpdatableMap(Map<Short, Byte> map1,
            Map<Short, Byte> map2, Map<Short, Byte> map3);

     ShortByteMap newUpdatableMap(Map<Short, Byte> map1,
            Map<Short, Byte> map2, Map<Short, Byte> map3,
            Map<Short, Byte> map4);

     ShortByteMap newUpdatableMap(Map<Short, Byte> map1,
            Map<Short, Byte> map2, Map<Short, Byte> map3,
            Map<Short, Byte> map4, Map<Short, Byte> map5);


     ShortByteMap newUpdatableMap(
            net.openhft.function.Consumer<ShortByteConsumer> entriesSupplier);

     ShortByteMap newUpdatableMap(
            net.openhft.function.Consumer<ShortByteConsumer> entriesSupplier,
            int expectedSize);

     ShortByteMap newUpdatableMap(short[] keys, byte[] values);

     ShortByteMap newUpdatableMap(short[] keys, byte[] values,
            int expectedSize);

     ShortByteMap newUpdatableMap(Short[] keys, Byte[] values);

     ShortByteMap newUpdatableMap(Short[] keys, Byte[] values,
            int expectedSize);

     ShortByteMap newUpdatableMap(Iterable<Short> keys,
            Iterable<Byte> values);

     ShortByteMap newUpdatableMap(Iterable<Short> keys,
            Iterable<Byte> values, int expectedSize);


     ShortByteMap newUpdatableMapOf(short k1, byte v1);

     ShortByteMap newUpdatableMapOf(short k1, byte v1,
            short k2, byte v2);

     ShortByteMap newUpdatableMapOf(short k1, byte v1,
            short k2, byte v2, short k3, byte v3);

     ShortByteMap newUpdatableMapOf(short k1, byte v1,
            short k2, byte v2, short k3, byte v3,
            short k4, byte v4);

     ShortByteMap newUpdatableMapOf(short k1, byte v1,
            short k2, byte v2, short k3, byte v3,
            short k4, byte v4, short k5, byte v5);

    


     ShortByteMap newImmutableMap(Map<Short, Byte> map1,
            Map<Short, Byte> map2, int expectedSize);

     ShortByteMap newImmutableMap(Map<Short, Byte> map1,
            Map<Short, Byte> map2, Map<Short, Byte> map3, int expectedSize);

     ShortByteMap newImmutableMap(Map<Short, Byte> map1,
            Map<Short, Byte> map2, Map<Short, Byte> map3,
            Map<Short, Byte> map4, int expectedSize);

     ShortByteMap newImmutableMap(Map<Short, Byte> map1,
            Map<Short, Byte> map2, Map<Short, Byte> map3,
            Map<Short, Byte> map4, Map<Short, Byte> map5, int expectedSize);

    

    
     ShortByteMap newImmutableMap(Map<Short, Byte> map);

     ShortByteMap newImmutableMap(Map<Short, Byte> map1,
            Map<Short, Byte> map2);

     ShortByteMap newImmutableMap(Map<Short, Byte> map1,
            Map<Short, Byte> map2, Map<Short, Byte> map3);

     ShortByteMap newImmutableMap(Map<Short, Byte> map1,
            Map<Short, Byte> map2, Map<Short, Byte> map3,
            Map<Short, Byte> map4);

     ShortByteMap newImmutableMap(Map<Short, Byte> map1,
            Map<Short, Byte> map2, Map<Short, Byte> map3,
            Map<Short, Byte> map4, Map<Short, Byte> map5);


     ShortByteMap newImmutableMap(
            net.openhft.function.Consumer<ShortByteConsumer> entriesSupplier);

     ShortByteMap newImmutableMap(
            net.openhft.function.Consumer<ShortByteConsumer> entriesSupplier,
            int expectedSize);

     ShortByteMap newImmutableMap(short[] keys, byte[] values);

     ShortByteMap newImmutableMap(short[] keys, byte[] values,
            int expectedSize);

     ShortByteMap newImmutableMap(Short[] keys, Byte[] values);

     ShortByteMap newImmutableMap(Short[] keys, Byte[] values,
            int expectedSize);

     ShortByteMap newImmutableMap(Iterable<Short> keys,
            Iterable<Byte> values);

     ShortByteMap newImmutableMap(Iterable<Short> keys,
            Iterable<Byte> values, int expectedSize);


     ShortByteMap newImmutableMapOf(short k1, byte v1);

     ShortByteMap newImmutableMapOf(short k1, byte v1,
            short k2, byte v2);

     ShortByteMap newImmutableMapOf(short k1, byte v1,
            short k2, byte v2, short k3, byte v3);

     ShortByteMap newImmutableMapOf(short k1, byte v1,
            short k2, byte v2, short k3, byte v3,
            short k4, byte v4);

     ShortByteMap newImmutableMapOf(short k1, byte v1,
            short k2, byte v2, short k3, byte v3,
            short k4, byte v4, short k5, byte v5);
}

