/*
 * Copyright 2014 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.openhft.collect.map;

import net.openhft.collect.*;
import net.openhft.function.ObjLongConsumer;
import javax.annotation.Nullable;

import java.util.Map;


/**
 * An immutable factory of {@code ObjLongMap}s.
 *
 * @see ObjLongMap
 */
public interface ObjLongMapFactory<K> {

    

    

    

    

    

    
    

    
    


    @Nullable Equivalence<K> getKeyEquivalence();

    long getDefaultValue();

    /**
     * @see ObjLongMap#defaultValue()
     */
    ObjLongMapFactory<K> withDefaultValue(long defaultValue);

    <K2 extends K>
     ObjLongMap<K2> newMutableMap();

    <K2 extends K>
     ObjLongMap<K2> newMutableMap(int expectedSize);

    

    /**
     * If the specified map has the same key equivalence with this factory,
     * {@code expectedSize} is ignored.
     */
    <K2 extends K>
     ObjLongMap<K2> newMutableMap(Map<? extends K2, Long> map, int expectedSize);

    <K2 extends K>
     ObjLongMap<K2> newMutableMap(Map<? extends K2, Long> map1,
            Map<? extends K2, Long> map2, int expectedSize);

    <K2 extends K>
     ObjLongMap<K2> newMutableMap(Map<? extends K2, Long> map1,
            Map<? extends K2, Long> map2, Map<? extends K2, Long> map3, int expectedSize);

    <K2 extends K>
     ObjLongMap<K2> newMutableMap(Map<? extends K2, Long> map1,
            Map<? extends K2, Long> map2, Map<? extends K2, Long> map3,
            Map<? extends K2, Long> map4, int expectedSize);

    <K2 extends K>
     ObjLongMap<K2> newMutableMap(Map<? extends K2, Long> map1,
            Map<? extends K2, Long> map2, Map<? extends K2, Long> map3,
            Map<? extends K2, Long> map4, Map<? extends K2, Long> map5, int expectedSize);

    

    
    <K2 extends K>
     ObjLongMap<K2> newMutableMap(Map<? extends K2, Long> map);

    <K2 extends K>
     ObjLongMap<K2> newMutableMap(Map<? extends K2, Long> map1,
            Map<? extends K2, Long> map2);

    <K2 extends K>
     ObjLongMap<K2> newMutableMap(Map<? extends K2, Long> map1,
            Map<? extends K2, Long> map2, Map<? extends K2, Long> map3);

    <K2 extends K>
     ObjLongMap<K2> newMutableMap(Map<? extends K2, Long> map1,
            Map<? extends K2, Long> map2, Map<? extends K2, Long> map3,
            Map<? extends K2, Long> map4);

    <K2 extends K>
     ObjLongMap<K2> newMutableMap(Map<? extends K2, Long> map1,
            Map<? extends K2, Long> map2, Map<? extends K2, Long> map3,
            Map<? extends K2, Long> map4, Map<? extends K2, Long> map5);


    <K2 extends K>
     ObjLongMap<K2> newMutableMap(
            net.openhft.function.Consumer<ObjLongConsumer<K2>> entriesSupplier);

    <K2 extends K>
     ObjLongMap<K2> newMutableMap(
            net.openhft.function.Consumer<ObjLongConsumer<K2>> entriesSupplier,
            int expectedSize);

    <K2 extends K>
     ObjLongMap<K2> newMutableMap(K2[] keys, long[] values);

    <K2 extends K>
     ObjLongMap<K2> newMutableMap(K2[] keys, long[] values,
            int expectedSize);

    <K2 extends K>
     ObjLongMap<K2> newMutableMap(K2[] keys, Long[] values);

    <K2 extends K>
     ObjLongMap<K2> newMutableMap(K2[] keys, Long[] values,
            int expectedSize);

    <K2 extends K>
     ObjLongMap<K2> newMutableMap(Iterable<? extends K2> keys,
            Iterable<Long> values);

    <K2 extends K>
     ObjLongMap<K2> newMutableMap(Iterable<? extends K2> keys,
            Iterable<Long> values, int expectedSize);


    <K2 extends K>
     ObjLongMap<K2> newMutableMapOf(K2 k1, long v1);

    <K2 extends K>
     ObjLongMap<K2> newMutableMapOf(K2 k1, long v1,
            K2 k2, long v2);

    <K2 extends K>
     ObjLongMap<K2> newMutableMapOf(K2 k1, long v1,
            K2 k2, long v2, K2 k3, long v3);

    <K2 extends K>
     ObjLongMap<K2> newMutableMapOf(K2 k1, long v1,
            K2 k2, long v2, K2 k3, long v3,
            K2 k4, long v4);

    <K2 extends K>
     ObjLongMap<K2> newMutableMapOf(K2 k1, long v1,
            K2 k2, long v2, K2 k3, long v3,
            K2 k4, long v4, K2 k5, long v5);
    <K2 extends K>
     ObjLongMap<K2> newUpdatableMap();

    <K2 extends K>
     ObjLongMap<K2> newUpdatableMap(int expectedSize);

    

    /**
     * If the specified map has the same key equivalence with this factory,
     * {@code expectedSize} is ignored.
     */
    <K2 extends K>
     ObjLongMap<K2> newUpdatableMap(Map<? extends K2, Long> map, int expectedSize);

    <K2 extends K>
     ObjLongMap<K2> newUpdatableMap(Map<? extends K2, Long> map1,
            Map<? extends K2, Long> map2, int expectedSize);

    <K2 extends K>
     ObjLongMap<K2> newUpdatableMap(Map<? extends K2, Long> map1,
            Map<? extends K2, Long> map2, Map<? extends K2, Long> map3, int expectedSize);

    <K2 extends K>
     ObjLongMap<K2> newUpdatableMap(Map<? extends K2, Long> map1,
            Map<? extends K2, Long> map2, Map<? extends K2, Long> map3,
            Map<? extends K2, Long> map4, int expectedSize);

    <K2 extends K>
     ObjLongMap<K2> newUpdatableMap(Map<? extends K2, Long> map1,
            Map<? extends K2, Long> map2, Map<? extends K2, Long> map3,
            Map<? extends K2, Long> map4, Map<? extends K2, Long> map5, int expectedSize);

    

    
    <K2 extends K>
     ObjLongMap<K2> newUpdatableMap(Map<? extends K2, Long> map);

    <K2 extends K>
     ObjLongMap<K2> newUpdatableMap(Map<? extends K2, Long> map1,
            Map<? extends K2, Long> map2);

    <K2 extends K>
     ObjLongMap<K2> newUpdatableMap(Map<? extends K2, Long> map1,
            Map<? extends K2, Long> map2, Map<? extends K2, Long> map3);

    <K2 extends K>
     ObjLongMap<K2> newUpdatableMap(Map<? extends K2, Long> map1,
            Map<? extends K2, Long> map2, Map<? extends K2, Long> map3,
            Map<? extends K2, Long> map4);

    <K2 extends K>
     ObjLongMap<K2> newUpdatableMap(Map<? extends K2, Long> map1,
            Map<? extends K2, Long> map2, Map<? extends K2, Long> map3,
            Map<? extends K2, Long> map4, Map<? extends K2, Long> map5);


    <K2 extends K>
     ObjLongMap<K2> newUpdatableMap(
            net.openhft.function.Consumer<ObjLongConsumer<K2>> entriesSupplier);

    <K2 extends K>
     ObjLongMap<K2> newUpdatableMap(
            net.openhft.function.Consumer<ObjLongConsumer<K2>> entriesSupplier,
            int expectedSize);

    <K2 extends K>
     ObjLongMap<K2> newUpdatableMap(K2[] keys, long[] values);

    <K2 extends K>
     ObjLongMap<K2> newUpdatableMap(K2[] keys, long[] values,
            int expectedSize);

    <K2 extends K>
     ObjLongMap<K2> newUpdatableMap(K2[] keys, Long[] values);

    <K2 extends K>
     ObjLongMap<K2> newUpdatableMap(K2[] keys, Long[] values,
            int expectedSize);

    <K2 extends K>
     ObjLongMap<K2> newUpdatableMap(Iterable<? extends K2> keys,
            Iterable<Long> values);

    <K2 extends K>
     ObjLongMap<K2> newUpdatableMap(Iterable<? extends K2> keys,
            Iterable<Long> values, int expectedSize);


    <K2 extends K>
     ObjLongMap<K2> newUpdatableMapOf(K2 k1, long v1);

    <K2 extends K>
     ObjLongMap<K2> newUpdatableMapOf(K2 k1, long v1,
            K2 k2, long v2);

    <K2 extends K>
     ObjLongMap<K2> newUpdatableMapOf(K2 k1, long v1,
            K2 k2, long v2, K2 k3, long v3);

    <K2 extends K>
     ObjLongMap<K2> newUpdatableMapOf(K2 k1, long v1,
            K2 k2, long v2, K2 k3, long v3,
            K2 k4, long v4);

    <K2 extends K>
     ObjLongMap<K2> newUpdatableMapOf(K2 k1, long v1,
            K2 k2, long v2, K2 k3, long v3,
            K2 k4, long v4, K2 k5, long v5);

    

    /**
     * If the specified map has the same key equivalence with this factory,
     * {@code expectedSize} is ignored.
     */
    <K2 extends K>
     ObjLongMap<K2> newImmutableMap(Map<? extends K2, Long> map, int expectedSize);

    <K2 extends K>
     ObjLongMap<K2> newImmutableMap(Map<? extends K2, Long> map1,
            Map<? extends K2, Long> map2, int expectedSize);

    <K2 extends K>
     ObjLongMap<K2> newImmutableMap(Map<? extends K2, Long> map1,
            Map<? extends K2, Long> map2, Map<? extends K2, Long> map3, int expectedSize);

    <K2 extends K>
     ObjLongMap<K2> newImmutableMap(Map<? extends K2, Long> map1,
            Map<? extends K2, Long> map2, Map<? extends K2, Long> map3,
            Map<? extends K2, Long> map4, int expectedSize);

    <K2 extends K>
     ObjLongMap<K2> newImmutableMap(Map<? extends K2, Long> map1,
            Map<? extends K2, Long> map2, Map<? extends K2, Long> map3,
            Map<? extends K2, Long> map4, Map<? extends K2, Long> map5, int expectedSize);

    

    
    <K2 extends K>
     ObjLongMap<K2> newImmutableMap(Map<? extends K2, Long> map);

    <K2 extends K>
     ObjLongMap<K2> newImmutableMap(Map<? extends K2, Long> map1,
            Map<? extends K2, Long> map2);

    <K2 extends K>
     ObjLongMap<K2> newImmutableMap(Map<? extends K2, Long> map1,
            Map<? extends K2, Long> map2, Map<? extends K2, Long> map3);

    <K2 extends K>
     ObjLongMap<K2> newImmutableMap(Map<? extends K2, Long> map1,
            Map<? extends K2, Long> map2, Map<? extends K2, Long> map3,
            Map<? extends K2, Long> map4);

    <K2 extends K>
     ObjLongMap<K2> newImmutableMap(Map<? extends K2, Long> map1,
            Map<? extends K2, Long> map2, Map<? extends K2, Long> map3,
            Map<? extends K2, Long> map4, Map<? extends K2, Long> map5);


    <K2 extends K>
     ObjLongMap<K2> newImmutableMap(
            net.openhft.function.Consumer<ObjLongConsumer<K2>> entriesSupplier);

    <K2 extends K>
     ObjLongMap<K2> newImmutableMap(
            net.openhft.function.Consumer<ObjLongConsumer<K2>> entriesSupplier,
            int expectedSize);

    <K2 extends K>
     ObjLongMap<K2> newImmutableMap(K2[] keys, long[] values);

    <K2 extends K>
     ObjLongMap<K2> newImmutableMap(K2[] keys, long[] values,
            int expectedSize);

    <K2 extends K>
     ObjLongMap<K2> newImmutableMap(K2[] keys, Long[] values);

    <K2 extends K>
     ObjLongMap<K2> newImmutableMap(K2[] keys, Long[] values,
            int expectedSize);

    <K2 extends K>
     ObjLongMap<K2> newImmutableMap(Iterable<? extends K2> keys,
            Iterable<Long> values);

    <K2 extends K>
     ObjLongMap<K2> newImmutableMap(Iterable<? extends K2> keys,
            Iterable<Long> values, int expectedSize);


    <K2 extends K>
     ObjLongMap<K2> newImmutableMapOf(K2 k1, long v1);

    <K2 extends K>
     ObjLongMap<K2> newImmutableMapOf(K2 k1, long v1,
            K2 k2, long v2);

    <K2 extends K>
     ObjLongMap<K2> newImmutableMapOf(K2 k1, long v1,
            K2 k2, long v2, K2 k3, long v3);

    <K2 extends K>
     ObjLongMap<K2> newImmutableMapOf(K2 k1, long v1,
            K2 k2, long v2, K2 k3, long v3,
            K2 k4, long v4);

    <K2 extends K>
     ObjLongMap<K2> newImmutableMapOf(K2 k1, long v1,
            K2 k2, long v2, K2 k3, long v3,
            K2 k4, long v4, K2 k5, long v5);
}

