/*
 * Copyright 2014 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.openhft.collect.map;

import net.openhft.collect.*;
import net.openhft.function.LongShortConsumer;
import javax.annotation.Nullable;

import java.util.Map;


/**
 * An immutable factory of {@code LongShortMap}s.
 *
 * @see LongShortMap
 */
public interface LongShortMapFactory {

    

    

    

    

    

    
    

    
    



    short getDefaultValue();

    /**
     * @see LongShortMap#defaultValue()
     */
    LongShortMapFactory withDefaultValue(short defaultValue);

     LongShortMap newMutableMap();

     LongShortMap newMutableMap(int expectedSize);

    


     LongShortMap newMutableMap(Map<Long, Short> map1,
            Map<Long, Short> map2, int expectedSize);

     LongShortMap newMutableMap(Map<Long, Short> map1,
            Map<Long, Short> map2, Map<Long, Short> map3, int expectedSize);

     LongShortMap newMutableMap(Map<Long, Short> map1,
            Map<Long, Short> map2, Map<Long, Short> map3,
            Map<Long, Short> map4, int expectedSize);

     LongShortMap newMutableMap(Map<Long, Short> map1,
            Map<Long, Short> map2, Map<Long, Short> map3,
            Map<Long, Short> map4, Map<Long, Short> map5, int expectedSize);

    

    
     LongShortMap newMutableMap(Map<Long, Short> map);

     LongShortMap newMutableMap(Map<Long, Short> map1,
            Map<Long, Short> map2);

     LongShortMap newMutableMap(Map<Long, Short> map1,
            Map<Long, Short> map2, Map<Long, Short> map3);

     LongShortMap newMutableMap(Map<Long, Short> map1,
            Map<Long, Short> map2, Map<Long, Short> map3,
            Map<Long, Short> map4);

     LongShortMap newMutableMap(Map<Long, Short> map1,
            Map<Long, Short> map2, Map<Long, Short> map3,
            Map<Long, Short> map4, Map<Long, Short> map5);


     LongShortMap newMutableMap(
            net.openhft.function.Consumer<LongShortConsumer> entriesSupplier);

     LongShortMap newMutableMap(
            net.openhft.function.Consumer<LongShortConsumer> entriesSupplier,
            int expectedSize);

     LongShortMap newMutableMap(long[] keys, short[] values);

     LongShortMap newMutableMap(long[] keys, short[] values,
            int expectedSize);

     LongShortMap newMutableMap(Long[] keys, Short[] values);

     LongShortMap newMutableMap(Long[] keys, Short[] values,
            int expectedSize);

     LongShortMap newMutableMap(Iterable<Long> keys,
            Iterable<Short> values);

     LongShortMap newMutableMap(Iterable<Long> keys,
            Iterable<Short> values, int expectedSize);


     LongShortMap newMutableMapOf(long k1, short v1);

     LongShortMap newMutableMapOf(long k1, short v1,
            long k2, short v2);

     LongShortMap newMutableMapOf(long k1, short v1,
            long k2, short v2, long k3, short v3);

     LongShortMap newMutableMapOf(long k1, short v1,
            long k2, short v2, long k3, short v3,
            long k4, short v4);

     LongShortMap newMutableMapOf(long k1, short v1,
            long k2, short v2, long k3, short v3,
            long k4, short v4, long k5, short v5);
     LongShortMap newUpdatableMap();

     LongShortMap newUpdatableMap(int expectedSize);

    


     LongShortMap newUpdatableMap(Map<Long, Short> map1,
            Map<Long, Short> map2, int expectedSize);

     LongShortMap newUpdatableMap(Map<Long, Short> map1,
            Map<Long, Short> map2, Map<Long, Short> map3, int expectedSize);

     LongShortMap newUpdatableMap(Map<Long, Short> map1,
            Map<Long, Short> map2, Map<Long, Short> map3,
            Map<Long, Short> map4, int expectedSize);

     LongShortMap newUpdatableMap(Map<Long, Short> map1,
            Map<Long, Short> map2, Map<Long, Short> map3,
            Map<Long, Short> map4, Map<Long, Short> map5, int expectedSize);

    

    
     LongShortMap newUpdatableMap(Map<Long, Short> map);

     LongShortMap newUpdatableMap(Map<Long, Short> map1,
            Map<Long, Short> map2);

     LongShortMap newUpdatableMap(Map<Long, Short> map1,
            Map<Long, Short> map2, Map<Long, Short> map3);

     LongShortMap newUpdatableMap(Map<Long, Short> map1,
            Map<Long, Short> map2, Map<Long, Short> map3,
            Map<Long, Short> map4);

     LongShortMap newUpdatableMap(Map<Long, Short> map1,
            Map<Long, Short> map2, Map<Long, Short> map3,
            Map<Long, Short> map4, Map<Long, Short> map5);


     LongShortMap newUpdatableMap(
            net.openhft.function.Consumer<LongShortConsumer> entriesSupplier);

     LongShortMap newUpdatableMap(
            net.openhft.function.Consumer<LongShortConsumer> entriesSupplier,
            int expectedSize);

     LongShortMap newUpdatableMap(long[] keys, short[] values);

     LongShortMap newUpdatableMap(long[] keys, short[] values,
            int expectedSize);

     LongShortMap newUpdatableMap(Long[] keys, Short[] values);

     LongShortMap newUpdatableMap(Long[] keys, Short[] values,
            int expectedSize);

     LongShortMap newUpdatableMap(Iterable<Long> keys,
            Iterable<Short> values);

     LongShortMap newUpdatableMap(Iterable<Long> keys,
            Iterable<Short> values, int expectedSize);


     LongShortMap newUpdatableMapOf(long k1, short v1);

     LongShortMap newUpdatableMapOf(long k1, short v1,
            long k2, short v2);

     LongShortMap newUpdatableMapOf(long k1, short v1,
            long k2, short v2, long k3, short v3);

     LongShortMap newUpdatableMapOf(long k1, short v1,
            long k2, short v2, long k3, short v3,
            long k4, short v4);

     LongShortMap newUpdatableMapOf(long k1, short v1,
            long k2, short v2, long k3, short v3,
            long k4, short v4, long k5, short v5);

    


     LongShortMap newImmutableMap(Map<Long, Short> map1,
            Map<Long, Short> map2, int expectedSize);

     LongShortMap newImmutableMap(Map<Long, Short> map1,
            Map<Long, Short> map2, Map<Long, Short> map3, int expectedSize);

     LongShortMap newImmutableMap(Map<Long, Short> map1,
            Map<Long, Short> map2, Map<Long, Short> map3,
            Map<Long, Short> map4, int expectedSize);

     LongShortMap newImmutableMap(Map<Long, Short> map1,
            Map<Long, Short> map2, Map<Long, Short> map3,
            Map<Long, Short> map4, Map<Long, Short> map5, int expectedSize);

    

    
     LongShortMap newImmutableMap(Map<Long, Short> map);

     LongShortMap newImmutableMap(Map<Long, Short> map1,
            Map<Long, Short> map2);

     LongShortMap newImmutableMap(Map<Long, Short> map1,
            Map<Long, Short> map2, Map<Long, Short> map3);

     LongShortMap newImmutableMap(Map<Long, Short> map1,
            Map<Long, Short> map2, Map<Long, Short> map3,
            Map<Long, Short> map4);

     LongShortMap newImmutableMap(Map<Long, Short> map1,
            Map<Long, Short> map2, Map<Long, Short> map3,
            Map<Long, Short> map4, Map<Long, Short> map5);


     LongShortMap newImmutableMap(
            net.openhft.function.Consumer<LongShortConsumer> entriesSupplier);

     LongShortMap newImmutableMap(
            net.openhft.function.Consumer<LongShortConsumer> entriesSupplier,
            int expectedSize);

     LongShortMap newImmutableMap(long[] keys, short[] values);

     LongShortMap newImmutableMap(long[] keys, short[] values,
            int expectedSize);

     LongShortMap newImmutableMap(Long[] keys, Short[] values);

     LongShortMap newImmutableMap(Long[] keys, Short[] values,
            int expectedSize);

     LongShortMap newImmutableMap(Iterable<Long> keys,
            Iterable<Short> values);

     LongShortMap newImmutableMap(Iterable<Long> keys,
            Iterable<Short> values, int expectedSize);


     LongShortMap newImmutableMapOf(long k1, short v1);

     LongShortMap newImmutableMapOf(long k1, short v1,
            long k2, short v2);

     LongShortMap newImmutableMapOf(long k1, short v1,
            long k2, short v2, long k3, short v3);

     LongShortMap newImmutableMapOf(long k1, short v1,
            long k2, short v2, long k3, short v3,
            long k4, short v4);

     LongShortMap newImmutableMapOf(long k1, short v1,
            long k2, short v2, long k3, short v3,
            long k4, short v4, long k5, short v5);
}

