/*
 * Copyright 2014 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.openhft.collect.map;

import net.openhft.collect.*;
import net.openhft.function.LongObjConsumer;
import javax.annotation.Nullable;

import java.util.Map;


/**
 * An immutable factory of {@code LongObjMap}s.
 *
 * @see LongObjMap
 */
public interface LongObjMapFactory<V> {

    

    

    

    

    

    
    

    
    



    @Nullable Equivalence<V> getValueEquivalence();

    <VE> LongObjMapFactory<VE>
    withValueEquivalence(@Nullable Equivalence<VE> valueEquivalence);


    <V2 extends V> LongObjMap<V2> newMutableMap();

    <V2 extends V> LongObjMap<V2> newMutableMap(int expectedSize);

    


    <V2 extends V> LongObjMap<V2> newMutableMap(Map<Long, ? extends V2> map1,
            Map<Long, ? extends V2> map2, int expectedSize);

    <V2 extends V> LongObjMap<V2> newMutableMap(Map<Long, ? extends V2> map1,
            Map<Long, ? extends V2> map2, Map<Long, ? extends V2> map3, int expectedSize);

    <V2 extends V> LongObjMap<V2> newMutableMap(Map<Long, ? extends V2> map1,
            Map<Long, ? extends V2> map2, Map<Long, ? extends V2> map3,
            Map<Long, ? extends V2> map4, int expectedSize);

    <V2 extends V> LongObjMap<V2> newMutableMap(Map<Long, ? extends V2> map1,
            Map<Long, ? extends V2> map2, Map<Long, ? extends V2> map3,
            Map<Long, ? extends V2> map4, Map<Long, ? extends V2> map5, int expectedSize);

    

    
    <V2 extends V> LongObjMap<V2> newMutableMap(Map<Long, ? extends V2> map);

    <V2 extends V> LongObjMap<V2> newMutableMap(Map<Long, ? extends V2> map1,
            Map<Long, ? extends V2> map2);

    <V2 extends V> LongObjMap<V2> newMutableMap(Map<Long, ? extends V2> map1,
            Map<Long, ? extends V2> map2, Map<Long, ? extends V2> map3);

    <V2 extends V> LongObjMap<V2> newMutableMap(Map<Long, ? extends V2> map1,
            Map<Long, ? extends V2> map2, Map<Long, ? extends V2> map3,
            Map<Long, ? extends V2> map4);

    <V2 extends V> LongObjMap<V2> newMutableMap(Map<Long, ? extends V2> map1,
            Map<Long, ? extends V2> map2, Map<Long, ? extends V2> map3,
            Map<Long, ? extends V2> map4, Map<Long, ? extends V2> map5);


    <V2 extends V> LongObjMap<V2> newMutableMap(
            net.openhft.function.Consumer<LongObjConsumer<V2>> entriesSupplier);

    <V2 extends V> LongObjMap<V2> newMutableMap(
            net.openhft.function.Consumer<LongObjConsumer<V2>> entriesSupplier,
            int expectedSize);

    <V2 extends V> LongObjMap<V2> newMutableMap(long[] keys, V2[] values);

    <V2 extends V> LongObjMap<V2> newMutableMap(long[] keys, V2[] values,
            int expectedSize);

    <V2 extends V> LongObjMap<V2> newMutableMap(Long[] keys, V2[] values);

    <V2 extends V> LongObjMap<V2> newMutableMap(Long[] keys, V2[] values,
            int expectedSize);

    <V2 extends V> LongObjMap<V2> newMutableMap(Iterable<Long> keys,
            Iterable<? extends V2> values);

    <V2 extends V> LongObjMap<V2> newMutableMap(Iterable<Long> keys,
            Iterable<? extends V2> values, int expectedSize);


    <V2 extends V> LongObjMap<V2> newMutableMapOf(long k1, V2 v1);

    <V2 extends V> LongObjMap<V2> newMutableMapOf(long k1, V2 v1,
            long k2, V2 v2);

    <V2 extends V> LongObjMap<V2> newMutableMapOf(long k1, V2 v1,
            long k2, V2 v2, long k3, V2 v3);

    <V2 extends V> LongObjMap<V2> newMutableMapOf(long k1, V2 v1,
            long k2, V2 v2, long k3, V2 v3,
            long k4, V2 v4);

    <V2 extends V> LongObjMap<V2> newMutableMapOf(long k1, V2 v1,
            long k2, V2 v2, long k3, V2 v3,
            long k4, V2 v4, long k5, V2 v5);
    <V2 extends V> LongObjMap<V2> newUpdatableMap();

    <V2 extends V> LongObjMap<V2> newUpdatableMap(int expectedSize);

    


    <V2 extends V> LongObjMap<V2> newUpdatableMap(Map<Long, ? extends V2> map1,
            Map<Long, ? extends V2> map2, int expectedSize);

    <V2 extends V> LongObjMap<V2> newUpdatableMap(Map<Long, ? extends V2> map1,
            Map<Long, ? extends V2> map2, Map<Long, ? extends V2> map3, int expectedSize);

    <V2 extends V> LongObjMap<V2> newUpdatableMap(Map<Long, ? extends V2> map1,
            Map<Long, ? extends V2> map2, Map<Long, ? extends V2> map3,
            Map<Long, ? extends V2> map4, int expectedSize);

    <V2 extends V> LongObjMap<V2> newUpdatableMap(Map<Long, ? extends V2> map1,
            Map<Long, ? extends V2> map2, Map<Long, ? extends V2> map3,
            Map<Long, ? extends V2> map4, Map<Long, ? extends V2> map5, int expectedSize);

    

    
    <V2 extends V> LongObjMap<V2> newUpdatableMap(Map<Long, ? extends V2> map);

    <V2 extends V> LongObjMap<V2> newUpdatableMap(Map<Long, ? extends V2> map1,
            Map<Long, ? extends V2> map2);

    <V2 extends V> LongObjMap<V2> newUpdatableMap(Map<Long, ? extends V2> map1,
            Map<Long, ? extends V2> map2, Map<Long, ? extends V2> map3);

    <V2 extends V> LongObjMap<V2> newUpdatableMap(Map<Long, ? extends V2> map1,
            Map<Long, ? extends V2> map2, Map<Long, ? extends V2> map3,
            Map<Long, ? extends V2> map4);

    <V2 extends V> LongObjMap<V2> newUpdatableMap(Map<Long, ? extends V2> map1,
            Map<Long, ? extends V2> map2, Map<Long, ? extends V2> map3,
            Map<Long, ? extends V2> map4, Map<Long, ? extends V2> map5);


    <V2 extends V> LongObjMap<V2> newUpdatableMap(
            net.openhft.function.Consumer<LongObjConsumer<V2>> entriesSupplier);

    <V2 extends V> LongObjMap<V2> newUpdatableMap(
            net.openhft.function.Consumer<LongObjConsumer<V2>> entriesSupplier,
            int expectedSize);

    <V2 extends V> LongObjMap<V2> newUpdatableMap(long[] keys, V2[] values);

    <V2 extends V> LongObjMap<V2> newUpdatableMap(long[] keys, V2[] values,
            int expectedSize);

    <V2 extends V> LongObjMap<V2> newUpdatableMap(Long[] keys, V2[] values);

    <V2 extends V> LongObjMap<V2> newUpdatableMap(Long[] keys, V2[] values,
            int expectedSize);

    <V2 extends V> LongObjMap<V2> newUpdatableMap(Iterable<Long> keys,
            Iterable<? extends V2> values);

    <V2 extends V> LongObjMap<V2> newUpdatableMap(Iterable<Long> keys,
            Iterable<? extends V2> values, int expectedSize);


    <V2 extends V> LongObjMap<V2> newUpdatableMapOf(long k1, V2 v1);

    <V2 extends V> LongObjMap<V2> newUpdatableMapOf(long k1, V2 v1,
            long k2, V2 v2);

    <V2 extends V> LongObjMap<V2> newUpdatableMapOf(long k1, V2 v1,
            long k2, V2 v2, long k3, V2 v3);

    <V2 extends V> LongObjMap<V2> newUpdatableMapOf(long k1, V2 v1,
            long k2, V2 v2, long k3, V2 v3,
            long k4, V2 v4);

    <V2 extends V> LongObjMap<V2> newUpdatableMapOf(long k1, V2 v1,
            long k2, V2 v2, long k3, V2 v3,
            long k4, V2 v4, long k5, V2 v5);

    


    <V2 extends V> LongObjMap<V2> newImmutableMap(Map<Long, ? extends V2> map1,
            Map<Long, ? extends V2> map2, int expectedSize);

    <V2 extends V> LongObjMap<V2> newImmutableMap(Map<Long, ? extends V2> map1,
            Map<Long, ? extends V2> map2, Map<Long, ? extends V2> map3, int expectedSize);

    <V2 extends V> LongObjMap<V2> newImmutableMap(Map<Long, ? extends V2> map1,
            Map<Long, ? extends V2> map2, Map<Long, ? extends V2> map3,
            Map<Long, ? extends V2> map4, int expectedSize);

    <V2 extends V> LongObjMap<V2> newImmutableMap(Map<Long, ? extends V2> map1,
            Map<Long, ? extends V2> map2, Map<Long, ? extends V2> map3,
            Map<Long, ? extends V2> map4, Map<Long, ? extends V2> map5, int expectedSize);

    

    
    <V2 extends V> LongObjMap<V2> newImmutableMap(Map<Long, ? extends V2> map);

    <V2 extends V> LongObjMap<V2> newImmutableMap(Map<Long, ? extends V2> map1,
            Map<Long, ? extends V2> map2);

    <V2 extends V> LongObjMap<V2> newImmutableMap(Map<Long, ? extends V2> map1,
            Map<Long, ? extends V2> map2, Map<Long, ? extends V2> map3);

    <V2 extends V> LongObjMap<V2> newImmutableMap(Map<Long, ? extends V2> map1,
            Map<Long, ? extends V2> map2, Map<Long, ? extends V2> map3,
            Map<Long, ? extends V2> map4);

    <V2 extends V> LongObjMap<V2> newImmutableMap(Map<Long, ? extends V2> map1,
            Map<Long, ? extends V2> map2, Map<Long, ? extends V2> map3,
            Map<Long, ? extends V2> map4, Map<Long, ? extends V2> map5);


    <V2 extends V> LongObjMap<V2> newImmutableMap(
            net.openhft.function.Consumer<LongObjConsumer<V2>> entriesSupplier);

    <V2 extends V> LongObjMap<V2> newImmutableMap(
            net.openhft.function.Consumer<LongObjConsumer<V2>> entriesSupplier,
            int expectedSize);

    <V2 extends V> LongObjMap<V2> newImmutableMap(long[] keys, V2[] values);

    <V2 extends V> LongObjMap<V2> newImmutableMap(long[] keys, V2[] values,
            int expectedSize);

    <V2 extends V> LongObjMap<V2> newImmutableMap(Long[] keys, V2[] values);

    <V2 extends V> LongObjMap<V2> newImmutableMap(Long[] keys, V2[] values,
            int expectedSize);

    <V2 extends V> LongObjMap<V2> newImmutableMap(Iterable<Long> keys,
            Iterable<? extends V2> values);

    <V2 extends V> LongObjMap<V2> newImmutableMap(Iterable<Long> keys,
            Iterable<? extends V2> values, int expectedSize);


    <V2 extends V> LongObjMap<V2> newImmutableMapOf(long k1, V2 v1);

    <V2 extends V> LongObjMap<V2> newImmutableMapOf(long k1, V2 v1,
            long k2, V2 v2);

    <V2 extends V> LongObjMap<V2> newImmutableMapOf(long k1, V2 v1,
            long k2, V2 v2, long k3, V2 v3);

    <V2 extends V> LongObjMap<V2> newImmutableMapOf(long k1, V2 v1,
            long k2, V2 v2, long k3, V2 v3,
            long k4, V2 v4);

    <V2 extends V> LongObjMap<V2> newImmutableMapOf(long k1, V2 v1,
            long k2, V2 v2, long k3, V2 v3,
            long k4, V2 v4, long k5, V2 v5);
}

