/*
 * Copyright 2014 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.openhft.collect.map;

import net.openhft.collect.*;
import net.openhft.function.LongLongConsumer;
import javax.annotation.Nullable;

import java.util.Map;


/**
 * An immutable factory of {@code LongLongMap}s.
 *
 * @see LongLongMap
 */
public interface LongLongMapFactory {

    

    

    

    

    

    
    

    
    



    long getDefaultValue();

    /**
     * @see LongLongMap#defaultValue()
     */
    LongLongMapFactory withDefaultValue(long defaultValue);

     LongLongMap newMutableMap();

     LongLongMap newMutableMap(int expectedSize);

    


     LongLongMap newMutableMap(Map<Long, Long> map1,
            Map<Long, Long> map2, int expectedSize);

     LongLongMap newMutableMap(Map<Long, Long> map1,
            Map<Long, Long> map2, Map<Long, Long> map3, int expectedSize);

     LongLongMap newMutableMap(Map<Long, Long> map1,
            Map<Long, Long> map2, Map<Long, Long> map3,
            Map<Long, Long> map4, int expectedSize);

     LongLongMap newMutableMap(Map<Long, Long> map1,
            Map<Long, Long> map2, Map<Long, Long> map3,
            Map<Long, Long> map4, Map<Long, Long> map5, int expectedSize);

    

    
     LongLongMap newMutableMap(Map<Long, Long> map);

     LongLongMap newMutableMap(Map<Long, Long> map1,
            Map<Long, Long> map2);

     LongLongMap newMutableMap(Map<Long, Long> map1,
            Map<Long, Long> map2, Map<Long, Long> map3);

     LongLongMap newMutableMap(Map<Long, Long> map1,
            Map<Long, Long> map2, Map<Long, Long> map3,
            Map<Long, Long> map4);

     LongLongMap newMutableMap(Map<Long, Long> map1,
            Map<Long, Long> map2, Map<Long, Long> map3,
            Map<Long, Long> map4, Map<Long, Long> map5);


     LongLongMap newMutableMap(
            net.openhft.function.Consumer<LongLongConsumer> entriesSupplier);

     LongLongMap newMutableMap(
            net.openhft.function.Consumer<LongLongConsumer> entriesSupplier,
            int expectedSize);

     LongLongMap newMutableMap(long[] keys, long[] values);

     LongLongMap newMutableMap(long[] keys, long[] values,
            int expectedSize);

     LongLongMap newMutableMap(Long[] keys, Long[] values);

     LongLongMap newMutableMap(Long[] keys, Long[] values,
            int expectedSize);

     LongLongMap newMutableMap(Iterable<Long> keys,
            Iterable<Long> values);

     LongLongMap newMutableMap(Iterable<Long> keys,
            Iterable<Long> values, int expectedSize);


     LongLongMap newMutableMapOf(long k1, long v1);

     LongLongMap newMutableMapOf(long k1, long v1,
            long k2, long v2);

     LongLongMap newMutableMapOf(long k1, long v1,
            long k2, long v2, long k3, long v3);

     LongLongMap newMutableMapOf(long k1, long v1,
            long k2, long v2, long k3, long v3,
            long k4, long v4);

     LongLongMap newMutableMapOf(long k1, long v1,
            long k2, long v2, long k3, long v3,
            long k4, long v4, long k5, long v5);
     LongLongMap newUpdatableMap();

     LongLongMap newUpdatableMap(int expectedSize);

    


     LongLongMap newUpdatableMap(Map<Long, Long> map1,
            Map<Long, Long> map2, int expectedSize);

     LongLongMap newUpdatableMap(Map<Long, Long> map1,
            Map<Long, Long> map2, Map<Long, Long> map3, int expectedSize);

     LongLongMap newUpdatableMap(Map<Long, Long> map1,
            Map<Long, Long> map2, Map<Long, Long> map3,
            Map<Long, Long> map4, int expectedSize);

     LongLongMap newUpdatableMap(Map<Long, Long> map1,
            Map<Long, Long> map2, Map<Long, Long> map3,
            Map<Long, Long> map4, Map<Long, Long> map5, int expectedSize);

    

    
     LongLongMap newUpdatableMap(Map<Long, Long> map);

     LongLongMap newUpdatableMap(Map<Long, Long> map1,
            Map<Long, Long> map2);

     LongLongMap newUpdatableMap(Map<Long, Long> map1,
            Map<Long, Long> map2, Map<Long, Long> map3);

     LongLongMap newUpdatableMap(Map<Long, Long> map1,
            Map<Long, Long> map2, Map<Long, Long> map3,
            Map<Long, Long> map4);

     LongLongMap newUpdatableMap(Map<Long, Long> map1,
            Map<Long, Long> map2, Map<Long, Long> map3,
            Map<Long, Long> map4, Map<Long, Long> map5);


     LongLongMap newUpdatableMap(
            net.openhft.function.Consumer<LongLongConsumer> entriesSupplier);

     LongLongMap newUpdatableMap(
            net.openhft.function.Consumer<LongLongConsumer> entriesSupplier,
            int expectedSize);

     LongLongMap newUpdatableMap(long[] keys, long[] values);

     LongLongMap newUpdatableMap(long[] keys, long[] values,
            int expectedSize);

     LongLongMap newUpdatableMap(Long[] keys, Long[] values);

     LongLongMap newUpdatableMap(Long[] keys, Long[] values,
            int expectedSize);

     LongLongMap newUpdatableMap(Iterable<Long> keys,
            Iterable<Long> values);

     LongLongMap newUpdatableMap(Iterable<Long> keys,
            Iterable<Long> values, int expectedSize);


     LongLongMap newUpdatableMapOf(long k1, long v1);

     LongLongMap newUpdatableMapOf(long k1, long v1,
            long k2, long v2);

     LongLongMap newUpdatableMapOf(long k1, long v1,
            long k2, long v2, long k3, long v3);

     LongLongMap newUpdatableMapOf(long k1, long v1,
            long k2, long v2, long k3, long v3,
            long k4, long v4);

     LongLongMap newUpdatableMapOf(long k1, long v1,
            long k2, long v2, long k3, long v3,
            long k4, long v4, long k5, long v5);

    


     LongLongMap newImmutableMap(Map<Long, Long> map1,
            Map<Long, Long> map2, int expectedSize);

     LongLongMap newImmutableMap(Map<Long, Long> map1,
            Map<Long, Long> map2, Map<Long, Long> map3, int expectedSize);

     LongLongMap newImmutableMap(Map<Long, Long> map1,
            Map<Long, Long> map2, Map<Long, Long> map3,
            Map<Long, Long> map4, int expectedSize);

     LongLongMap newImmutableMap(Map<Long, Long> map1,
            Map<Long, Long> map2, Map<Long, Long> map3,
            Map<Long, Long> map4, Map<Long, Long> map5, int expectedSize);

    

    
     LongLongMap newImmutableMap(Map<Long, Long> map);

     LongLongMap newImmutableMap(Map<Long, Long> map1,
            Map<Long, Long> map2);

     LongLongMap newImmutableMap(Map<Long, Long> map1,
            Map<Long, Long> map2, Map<Long, Long> map3);

     LongLongMap newImmutableMap(Map<Long, Long> map1,
            Map<Long, Long> map2, Map<Long, Long> map3,
            Map<Long, Long> map4);

     LongLongMap newImmutableMap(Map<Long, Long> map1,
            Map<Long, Long> map2, Map<Long, Long> map3,
            Map<Long, Long> map4, Map<Long, Long> map5);


     LongLongMap newImmutableMap(
            net.openhft.function.Consumer<LongLongConsumer> entriesSupplier);

     LongLongMap newImmutableMap(
            net.openhft.function.Consumer<LongLongConsumer> entriesSupplier,
            int expectedSize);

     LongLongMap newImmutableMap(long[] keys, long[] values);

     LongLongMap newImmutableMap(long[] keys, long[] values,
            int expectedSize);

     LongLongMap newImmutableMap(Long[] keys, Long[] values);

     LongLongMap newImmutableMap(Long[] keys, Long[] values,
            int expectedSize);

     LongLongMap newImmutableMap(Iterable<Long> keys,
            Iterable<Long> values);

     LongLongMap newImmutableMap(Iterable<Long> keys,
            Iterable<Long> values, int expectedSize);


     LongLongMap newImmutableMapOf(long k1, long v1);

     LongLongMap newImmutableMapOf(long k1, long v1,
            long k2, long v2);

     LongLongMap newImmutableMapOf(long k1, long v1,
            long k2, long v2, long k3, long v3);

     LongLongMap newImmutableMapOf(long k1, long v1,
            long k2, long v2, long k3, long v3,
            long k4, long v4);

     LongLongMap newImmutableMapOf(long k1, long v1,
            long k2, long v2, long k3, long v3,
            long k4, long v4, long k5, long v5);
}

