/*
 * Copyright 2014 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.openhft.collect.map;

import net.openhft.collect.*;
import net.openhft.function.LongIntConsumer;
import javax.annotation.Nullable;

import java.util.Map;


/**
 * An immutable factory of {@code LongIntMap}s.
 *
 * @see LongIntMap
 */
public interface LongIntMapFactory {

    

    

    

    

    

    
    

    
    



    int getDefaultValue();

    /**
     * @see LongIntMap#defaultValue()
     */
    LongIntMapFactory withDefaultValue(int defaultValue);

     LongIntMap newMutableMap();

     LongIntMap newMutableMap(int expectedSize);

    


     LongIntMap newMutableMap(Map<Long, Integer> map1,
            Map<Long, Integer> map2, int expectedSize);

     LongIntMap newMutableMap(Map<Long, Integer> map1,
            Map<Long, Integer> map2, Map<Long, Integer> map3, int expectedSize);

     LongIntMap newMutableMap(Map<Long, Integer> map1,
            Map<Long, Integer> map2, Map<Long, Integer> map3,
            Map<Long, Integer> map4, int expectedSize);

     LongIntMap newMutableMap(Map<Long, Integer> map1,
            Map<Long, Integer> map2, Map<Long, Integer> map3,
            Map<Long, Integer> map4, Map<Long, Integer> map5, int expectedSize);

    

    
     LongIntMap newMutableMap(Map<Long, Integer> map);

     LongIntMap newMutableMap(Map<Long, Integer> map1,
            Map<Long, Integer> map2);

     LongIntMap newMutableMap(Map<Long, Integer> map1,
            Map<Long, Integer> map2, Map<Long, Integer> map3);

     LongIntMap newMutableMap(Map<Long, Integer> map1,
            Map<Long, Integer> map2, Map<Long, Integer> map3,
            Map<Long, Integer> map4);

     LongIntMap newMutableMap(Map<Long, Integer> map1,
            Map<Long, Integer> map2, Map<Long, Integer> map3,
            Map<Long, Integer> map4, Map<Long, Integer> map5);


     LongIntMap newMutableMap(
            net.openhft.function.Consumer<LongIntConsumer> entriesSupplier);

     LongIntMap newMutableMap(
            net.openhft.function.Consumer<LongIntConsumer> entriesSupplier,
            int expectedSize);

     LongIntMap newMutableMap(long[] keys, int[] values);

     LongIntMap newMutableMap(long[] keys, int[] values,
            int expectedSize);

     LongIntMap newMutableMap(Long[] keys, Integer[] values);

     LongIntMap newMutableMap(Long[] keys, Integer[] values,
            int expectedSize);

     LongIntMap newMutableMap(Iterable<Long> keys,
            Iterable<Integer> values);

     LongIntMap newMutableMap(Iterable<Long> keys,
            Iterable<Integer> values, int expectedSize);


     LongIntMap newMutableMapOf(long k1, int v1);

     LongIntMap newMutableMapOf(long k1, int v1,
            long k2, int v2);

     LongIntMap newMutableMapOf(long k1, int v1,
            long k2, int v2, long k3, int v3);

     LongIntMap newMutableMapOf(long k1, int v1,
            long k2, int v2, long k3, int v3,
            long k4, int v4);

     LongIntMap newMutableMapOf(long k1, int v1,
            long k2, int v2, long k3, int v3,
            long k4, int v4, long k5, int v5);
     LongIntMap newUpdatableMap();

     LongIntMap newUpdatableMap(int expectedSize);

    


     LongIntMap newUpdatableMap(Map<Long, Integer> map1,
            Map<Long, Integer> map2, int expectedSize);

     LongIntMap newUpdatableMap(Map<Long, Integer> map1,
            Map<Long, Integer> map2, Map<Long, Integer> map3, int expectedSize);

     LongIntMap newUpdatableMap(Map<Long, Integer> map1,
            Map<Long, Integer> map2, Map<Long, Integer> map3,
            Map<Long, Integer> map4, int expectedSize);

     LongIntMap newUpdatableMap(Map<Long, Integer> map1,
            Map<Long, Integer> map2, Map<Long, Integer> map3,
            Map<Long, Integer> map4, Map<Long, Integer> map5, int expectedSize);

    

    
     LongIntMap newUpdatableMap(Map<Long, Integer> map);

     LongIntMap newUpdatableMap(Map<Long, Integer> map1,
            Map<Long, Integer> map2);

     LongIntMap newUpdatableMap(Map<Long, Integer> map1,
            Map<Long, Integer> map2, Map<Long, Integer> map3);

     LongIntMap newUpdatableMap(Map<Long, Integer> map1,
            Map<Long, Integer> map2, Map<Long, Integer> map3,
            Map<Long, Integer> map4);

     LongIntMap newUpdatableMap(Map<Long, Integer> map1,
            Map<Long, Integer> map2, Map<Long, Integer> map3,
            Map<Long, Integer> map4, Map<Long, Integer> map5);


     LongIntMap newUpdatableMap(
            net.openhft.function.Consumer<LongIntConsumer> entriesSupplier);

     LongIntMap newUpdatableMap(
            net.openhft.function.Consumer<LongIntConsumer> entriesSupplier,
            int expectedSize);

     LongIntMap newUpdatableMap(long[] keys, int[] values);

     LongIntMap newUpdatableMap(long[] keys, int[] values,
            int expectedSize);

     LongIntMap newUpdatableMap(Long[] keys, Integer[] values);

     LongIntMap newUpdatableMap(Long[] keys, Integer[] values,
            int expectedSize);

     LongIntMap newUpdatableMap(Iterable<Long> keys,
            Iterable<Integer> values);

     LongIntMap newUpdatableMap(Iterable<Long> keys,
            Iterable<Integer> values, int expectedSize);


     LongIntMap newUpdatableMapOf(long k1, int v1);

     LongIntMap newUpdatableMapOf(long k1, int v1,
            long k2, int v2);

     LongIntMap newUpdatableMapOf(long k1, int v1,
            long k2, int v2, long k3, int v3);

     LongIntMap newUpdatableMapOf(long k1, int v1,
            long k2, int v2, long k3, int v3,
            long k4, int v4);

     LongIntMap newUpdatableMapOf(long k1, int v1,
            long k2, int v2, long k3, int v3,
            long k4, int v4, long k5, int v5);

    


     LongIntMap newImmutableMap(Map<Long, Integer> map1,
            Map<Long, Integer> map2, int expectedSize);

     LongIntMap newImmutableMap(Map<Long, Integer> map1,
            Map<Long, Integer> map2, Map<Long, Integer> map3, int expectedSize);

     LongIntMap newImmutableMap(Map<Long, Integer> map1,
            Map<Long, Integer> map2, Map<Long, Integer> map3,
            Map<Long, Integer> map4, int expectedSize);

     LongIntMap newImmutableMap(Map<Long, Integer> map1,
            Map<Long, Integer> map2, Map<Long, Integer> map3,
            Map<Long, Integer> map4, Map<Long, Integer> map5, int expectedSize);

    

    
     LongIntMap newImmutableMap(Map<Long, Integer> map);

     LongIntMap newImmutableMap(Map<Long, Integer> map1,
            Map<Long, Integer> map2);

     LongIntMap newImmutableMap(Map<Long, Integer> map1,
            Map<Long, Integer> map2, Map<Long, Integer> map3);

     LongIntMap newImmutableMap(Map<Long, Integer> map1,
            Map<Long, Integer> map2, Map<Long, Integer> map3,
            Map<Long, Integer> map4);

     LongIntMap newImmutableMap(Map<Long, Integer> map1,
            Map<Long, Integer> map2, Map<Long, Integer> map3,
            Map<Long, Integer> map4, Map<Long, Integer> map5);


     LongIntMap newImmutableMap(
            net.openhft.function.Consumer<LongIntConsumer> entriesSupplier);

     LongIntMap newImmutableMap(
            net.openhft.function.Consumer<LongIntConsumer> entriesSupplier,
            int expectedSize);

     LongIntMap newImmutableMap(long[] keys, int[] values);

     LongIntMap newImmutableMap(long[] keys, int[] values,
            int expectedSize);

     LongIntMap newImmutableMap(Long[] keys, Integer[] values);

     LongIntMap newImmutableMap(Long[] keys, Integer[] values,
            int expectedSize);

     LongIntMap newImmutableMap(Iterable<Long> keys,
            Iterable<Integer> values);

     LongIntMap newImmutableMap(Iterable<Long> keys,
            Iterable<Integer> values, int expectedSize);


     LongIntMap newImmutableMapOf(long k1, int v1);

     LongIntMap newImmutableMapOf(long k1, int v1,
            long k2, int v2);

     LongIntMap newImmutableMapOf(long k1, int v1,
            long k2, int v2, long k3, int v3);

     LongIntMap newImmutableMapOf(long k1, int v1,
            long k2, int v2, long k3, int v3,
            long k4, int v4);

     LongIntMap newImmutableMapOf(long k1, int v1,
            long k2, int v2, long k3, int v3,
            long k4, int v4, long k5, int v5);
}

