/*
 * Copyright 2014 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.openhft.collect.map;

import net.openhft.collect.*;
import net.openhft.function.LongFloatConsumer;
import javax.annotation.Nullable;

import java.util.Map;


/**
 * An immutable factory of {@code LongFloatMap}s.
 *
 * @see LongFloatMap
 */
public interface LongFloatMapFactory {

    

    

    

    

    

    
    

    
    



    float getDefaultValue();

    /**
     * @see LongFloatMap#defaultValue()
     */
    LongFloatMapFactory withDefaultValue(float defaultValue);

     LongFloatMap newMutableMap();

     LongFloatMap newMutableMap(int expectedSize);

    


     LongFloatMap newMutableMap(Map<Long, Float> map1,
            Map<Long, Float> map2, int expectedSize);

     LongFloatMap newMutableMap(Map<Long, Float> map1,
            Map<Long, Float> map2, Map<Long, Float> map3, int expectedSize);

     LongFloatMap newMutableMap(Map<Long, Float> map1,
            Map<Long, Float> map2, Map<Long, Float> map3,
            Map<Long, Float> map4, int expectedSize);

     LongFloatMap newMutableMap(Map<Long, Float> map1,
            Map<Long, Float> map2, Map<Long, Float> map3,
            Map<Long, Float> map4, Map<Long, Float> map5, int expectedSize);

    

    
     LongFloatMap newMutableMap(Map<Long, Float> map);

     LongFloatMap newMutableMap(Map<Long, Float> map1,
            Map<Long, Float> map2);

     LongFloatMap newMutableMap(Map<Long, Float> map1,
            Map<Long, Float> map2, Map<Long, Float> map3);

     LongFloatMap newMutableMap(Map<Long, Float> map1,
            Map<Long, Float> map2, Map<Long, Float> map3,
            Map<Long, Float> map4);

     LongFloatMap newMutableMap(Map<Long, Float> map1,
            Map<Long, Float> map2, Map<Long, Float> map3,
            Map<Long, Float> map4, Map<Long, Float> map5);


     LongFloatMap newMutableMap(
            net.openhft.function.Consumer<LongFloatConsumer> entriesSupplier);

     LongFloatMap newMutableMap(
            net.openhft.function.Consumer<LongFloatConsumer> entriesSupplier,
            int expectedSize);

     LongFloatMap newMutableMap(long[] keys, float[] values);

     LongFloatMap newMutableMap(long[] keys, float[] values,
            int expectedSize);

     LongFloatMap newMutableMap(Long[] keys, Float[] values);

     LongFloatMap newMutableMap(Long[] keys, Float[] values,
            int expectedSize);

     LongFloatMap newMutableMap(Iterable<Long> keys,
            Iterable<Float> values);

     LongFloatMap newMutableMap(Iterable<Long> keys,
            Iterable<Float> values, int expectedSize);


     LongFloatMap newMutableMapOf(long k1, float v1);

     LongFloatMap newMutableMapOf(long k1, float v1,
            long k2, float v2);

     LongFloatMap newMutableMapOf(long k1, float v1,
            long k2, float v2, long k3, float v3);

     LongFloatMap newMutableMapOf(long k1, float v1,
            long k2, float v2, long k3, float v3,
            long k4, float v4);

     LongFloatMap newMutableMapOf(long k1, float v1,
            long k2, float v2, long k3, float v3,
            long k4, float v4, long k5, float v5);
     LongFloatMap newUpdatableMap();

     LongFloatMap newUpdatableMap(int expectedSize);

    


     LongFloatMap newUpdatableMap(Map<Long, Float> map1,
            Map<Long, Float> map2, int expectedSize);

     LongFloatMap newUpdatableMap(Map<Long, Float> map1,
            Map<Long, Float> map2, Map<Long, Float> map3, int expectedSize);

     LongFloatMap newUpdatableMap(Map<Long, Float> map1,
            Map<Long, Float> map2, Map<Long, Float> map3,
            Map<Long, Float> map4, int expectedSize);

     LongFloatMap newUpdatableMap(Map<Long, Float> map1,
            Map<Long, Float> map2, Map<Long, Float> map3,
            Map<Long, Float> map4, Map<Long, Float> map5, int expectedSize);

    

    
     LongFloatMap newUpdatableMap(Map<Long, Float> map);

     LongFloatMap newUpdatableMap(Map<Long, Float> map1,
            Map<Long, Float> map2);

     LongFloatMap newUpdatableMap(Map<Long, Float> map1,
            Map<Long, Float> map2, Map<Long, Float> map3);

     LongFloatMap newUpdatableMap(Map<Long, Float> map1,
            Map<Long, Float> map2, Map<Long, Float> map3,
            Map<Long, Float> map4);

     LongFloatMap newUpdatableMap(Map<Long, Float> map1,
            Map<Long, Float> map2, Map<Long, Float> map3,
            Map<Long, Float> map4, Map<Long, Float> map5);


     LongFloatMap newUpdatableMap(
            net.openhft.function.Consumer<LongFloatConsumer> entriesSupplier);

     LongFloatMap newUpdatableMap(
            net.openhft.function.Consumer<LongFloatConsumer> entriesSupplier,
            int expectedSize);

     LongFloatMap newUpdatableMap(long[] keys, float[] values);

     LongFloatMap newUpdatableMap(long[] keys, float[] values,
            int expectedSize);

     LongFloatMap newUpdatableMap(Long[] keys, Float[] values);

     LongFloatMap newUpdatableMap(Long[] keys, Float[] values,
            int expectedSize);

     LongFloatMap newUpdatableMap(Iterable<Long> keys,
            Iterable<Float> values);

     LongFloatMap newUpdatableMap(Iterable<Long> keys,
            Iterable<Float> values, int expectedSize);


     LongFloatMap newUpdatableMapOf(long k1, float v1);

     LongFloatMap newUpdatableMapOf(long k1, float v1,
            long k2, float v2);

     LongFloatMap newUpdatableMapOf(long k1, float v1,
            long k2, float v2, long k3, float v3);

     LongFloatMap newUpdatableMapOf(long k1, float v1,
            long k2, float v2, long k3, float v3,
            long k4, float v4);

     LongFloatMap newUpdatableMapOf(long k1, float v1,
            long k2, float v2, long k3, float v3,
            long k4, float v4, long k5, float v5);

    


     LongFloatMap newImmutableMap(Map<Long, Float> map1,
            Map<Long, Float> map2, int expectedSize);

     LongFloatMap newImmutableMap(Map<Long, Float> map1,
            Map<Long, Float> map2, Map<Long, Float> map3, int expectedSize);

     LongFloatMap newImmutableMap(Map<Long, Float> map1,
            Map<Long, Float> map2, Map<Long, Float> map3,
            Map<Long, Float> map4, int expectedSize);

     LongFloatMap newImmutableMap(Map<Long, Float> map1,
            Map<Long, Float> map2, Map<Long, Float> map3,
            Map<Long, Float> map4, Map<Long, Float> map5, int expectedSize);

    

    
     LongFloatMap newImmutableMap(Map<Long, Float> map);

     LongFloatMap newImmutableMap(Map<Long, Float> map1,
            Map<Long, Float> map2);

     LongFloatMap newImmutableMap(Map<Long, Float> map1,
            Map<Long, Float> map2, Map<Long, Float> map3);

     LongFloatMap newImmutableMap(Map<Long, Float> map1,
            Map<Long, Float> map2, Map<Long, Float> map3,
            Map<Long, Float> map4);

     LongFloatMap newImmutableMap(Map<Long, Float> map1,
            Map<Long, Float> map2, Map<Long, Float> map3,
            Map<Long, Float> map4, Map<Long, Float> map5);


     LongFloatMap newImmutableMap(
            net.openhft.function.Consumer<LongFloatConsumer> entriesSupplier);

     LongFloatMap newImmutableMap(
            net.openhft.function.Consumer<LongFloatConsumer> entriesSupplier,
            int expectedSize);

     LongFloatMap newImmutableMap(long[] keys, float[] values);

     LongFloatMap newImmutableMap(long[] keys, float[] values,
            int expectedSize);

     LongFloatMap newImmutableMap(Long[] keys, Float[] values);

     LongFloatMap newImmutableMap(Long[] keys, Float[] values,
            int expectedSize);

     LongFloatMap newImmutableMap(Iterable<Long> keys,
            Iterable<Float> values);

     LongFloatMap newImmutableMap(Iterable<Long> keys,
            Iterable<Float> values, int expectedSize);


     LongFloatMap newImmutableMapOf(long k1, float v1);

     LongFloatMap newImmutableMapOf(long k1, float v1,
            long k2, float v2);

     LongFloatMap newImmutableMapOf(long k1, float v1,
            long k2, float v2, long k3, float v3);

     LongFloatMap newImmutableMapOf(long k1, float v1,
            long k2, float v2, long k3, float v3,
            long k4, float v4);

     LongFloatMap newImmutableMapOf(long k1, float v1,
            long k2, float v2, long k3, float v3,
            long k4, float v4, long k5, float v5);
}

