/*
 * Copyright 2014 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.openhft.collect.map;

import net.openhft.collect.*;
import net.openhft.function.LongDoubleConsumer;
import javax.annotation.Nullable;

import java.util.Map;


/**
 * An immutable factory of {@code LongDoubleMap}s.
 *
 * @see LongDoubleMap
 */
public interface LongDoubleMapFactory {

    

    

    

    

    

    
    

    
    



    double getDefaultValue();

    /**
     * @see LongDoubleMap#defaultValue()
     */
    LongDoubleMapFactory withDefaultValue(double defaultValue);

     LongDoubleMap newMutableMap();

     LongDoubleMap newMutableMap(int expectedSize);

    


     LongDoubleMap newMutableMap(Map<Long, Double> map1,
            Map<Long, Double> map2, int expectedSize);

     LongDoubleMap newMutableMap(Map<Long, Double> map1,
            Map<Long, Double> map2, Map<Long, Double> map3, int expectedSize);

     LongDoubleMap newMutableMap(Map<Long, Double> map1,
            Map<Long, Double> map2, Map<Long, Double> map3,
            Map<Long, Double> map4, int expectedSize);

     LongDoubleMap newMutableMap(Map<Long, Double> map1,
            Map<Long, Double> map2, Map<Long, Double> map3,
            Map<Long, Double> map4, Map<Long, Double> map5, int expectedSize);

    

    
     LongDoubleMap newMutableMap(Map<Long, Double> map);

     LongDoubleMap newMutableMap(Map<Long, Double> map1,
            Map<Long, Double> map2);

     LongDoubleMap newMutableMap(Map<Long, Double> map1,
            Map<Long, Double> map2, Map<Long, Double> map3);

     LongDoubleMap newMutableMap(Map<Long, Double> map1,
            Map<Long, Double> map2, Map<Long, Double> map3,
            Map<Long, Double> map4);

     LongDoubleMap newMutableMap(Map<Long, Double> map1,
            Map<Long, Double> map2, Map<Long, Double> map3,
            Map<Long, Double> map4, Map<Long, Double> map5);


     LongDoubleMap newMutableMap(
            net.openhft.function.Consumer<LongDoubleConsumer> entriesSupplier);

     LongDoubleMap newMutableMap(
            net.openhft.function.Consumer<LongDoubleConsumer> entriesSupplier,
            int expectedSize);

     LongDoubleMap newMutableMap(long[] keys, double[] values);

     LongDoubleMap newMutableMap(long[] keys, double[] values,
            int expectedSize);

     LongDoubleMap newMutableMap(Long[] keys, Double[] values);

     LongDoubleMap newMutableMap(Long[] keys, Double[] values,
            int expectedSize);

     LongDoubleMap newMutableMap(Iterable<Long> keys,
            Iterable<Double> values);

     LongDoubleMap newMutableMap(Iterable<Long> keys,
            Iterable<Double> values, int expectedSize);


     LongDoubleMap newMutableMapOf(long k1, double v1);

     LongDoubleMap newMutableMapOf(long k1, double v1,
            long k2, double v2);

     LongDoubleMap newMutableMapOf(long k1, double v1,
            long k2, double v2, long k3, double v3);

     LongDoubleMap newMutableMapOf(long k1, double v1,
            long k2, double v2, long k3, double v3,
            long k4, double v4);

     LongDoubleMap newMutableMapOf(long k1, double v1,
            long k2, double v2, long k3, double v3,
            long k4, double v4, long k5, double v5);
     LongDoubleMap newUpdatableMap();

     LongDoubleMap newUpdatableMap(int expectedSize);

    


     LongDoubleMap newUpdatableMap(Map<Long, Double> map1,
            Map<Long, Double> map2, int expectedSize);

     LongDoubleMap newUpdatableMap(Map<Long, Double> map1,
            Map<Long, Double> map2, Map<Long, Double> map3, int expectedSize);

     LongDoubleMap newUpdatableMap(Map<Long, Double> map1,
            Map<Long, Double> map2, Map<Long, Double> map3,
            Map<Long, Double> map4, int expectedSize);

     LongDoubleMap newUpdatableMap(Map<Long, Double> map1,
            Map<Long, Double> map2, Map<Long, Double> map3,
            Map<Long, Double> map4, Map<Long, Double> map5, int expectedSize);

    

    
     LongDoubleMap newUpdatableMap(Map<Long, Double> map);

     LongDoubleMap newUpdatableMap(Map<Long, Double> map1,
            Map<Long, Double> map2);

     LongDoubleMap newUpdatableMap(Map<Long, Double> map1,
            Map<Long, Double> map2, Map<Long, Double> map3);

     LongDoubleMap newUpdatableMap(Map<Long, Double> map1,
            Map<Long, Double> map2, Map<Long, Double> map3,
            Map<Long, Double> map4);

     LongDoubleMap newUpdatableMap(Map<Long, Double> map1,
            Map<Long, Double> map2, Map<Long, Double> map3,
            Map<Long, Double> map4, Map<Long, Double> map5);


     LongDoubleMap newUpdatableMap(
            net.openhft.function.Consumer<LongDoubleConsumer> entriesSupplier);

     LongDoubleMap newUpdatableMap(
            net.openhft.function.Consumer<LongDoubleConsumer> entriesSupplier,
            int expectedSize);

     LongDoubleMap newUpdatableMap(long[] keys, double[] values);

     LongDoubleMap newUpdatableMap(long[] keys, double[] values,
            int expectedSize);

     LongDoubleMap newUpdatableMap(Long[] keys, Double[] values);

     LongDoubleMap newUpdatableMap(Long[] keys, Double[] values,
            int expectedSize);

     LongDoubleMap newUpdatableMap(Iterable<Long> keys,
            Iterable<Double> values);

     LongDoubleMap newUpdatableMap(Iterable<Long> keys,
            Iterable<Double> values, int expectedSize);


     LongDoubleMap newUpdatableMapOf(long k1, double v1);

     LongDoubleMap newUpdatableMapOf(long k1, double v1,
            long k2, double v2);

     LongDoubleMap newUpdatableMapOf(long k1, double v1,
            long k2, double v2, long k3, double v3);

     LongDoubleMap newUpdatableMapOf(long k1, double v1,
            long k2, double v2, long k3, double v3,
            long k4, double v4);

     LongDoubleMap newUpdatableMapOf(long k1, double v1,
            long k2, double v2, long k3, double v3,
            long k4, double v4, long k5, double v5);

    


     LongDoubleMap newImmutableMap(Map<Long, Double> map1,
            Map<Long, Double> map2, int expectedSize);

     LongDoubleMap newImmutableMap(Map<Long, Double> map1,
            Map<Long, Double> map2, Map<Long, Double> map3, int expectedSize);

     LongDoubleMap newImmutableMap(Map<Long, Double> map1,
            Map<Long, Double> map2, Map<Long, Double> map3,
            Map<Long, Double> map4, int expectedSize);

     LongDoubleMap newImmutableMap(Map<Long, Double> map1,
            Map<Long, Double> map2, Map<Long, Double> map3,
            Map<Long, Double> map4, Map<Long, Double> map5, int expectedSize);

    

    
     LongDoubleMap newImmutableMap(Map<Long, Double> map);

     LongDoubleMap newImmutableMap(Map<Long, Double> map1,
            Map<Long, Double> map2);

     LongDoubleMap newImmutableMap(Map<Long, Double> map1,
            Map<Long, Double> map2, Map<Long, Double> map3);

     LongDoubleMap newImmutableMap(Map<Long, Double> map1,
            Map<Long, Double> map2, Map<Long, Double> map3,
            Map<Long, Double> map4);

     LongDoubleMap newImmutableMap(Map<Long, Double> map1,
            Map<Long, Double> map2, Map<Long, Double> map3,
            Map<Long, Double> map4, Map<Long, Double> map5);


     LongDoubleMap newImmutableMap(
            net.openhft.function.Consumer<LongDoubleConsumer> entriesSupplier);

     LongDoubleMap newImmutableMap(
            net.openhft.function.Consumer<LongDoubleConsumer> entriesSupplier,
            int expectedSize);

     LongDoubleMap newImmutableMap(long[] keys, double[] values);

     LongDoubleMap newImmutableMap(long[] keys, double[] values,
            int expectedSize);

     LongDoubleMap newImmutableMap(Long[] keys, Double[] values);

     LongDoubleMap newImmutableMap(Long[] keys, Double[] values,
            int expectedSize);

     LongDoubleMap newImmutableMap(Iterable<Long> keys,
            Iterable<Double> values);

     LongDoubleMap newImmutableMap(Iterable<Long> keys,
            Iterable<Double> values, int expectedSize);


     LongDoubleMap newImmutableMapOf(long k1, double v1);

     LongDoubleMap newImmutableMapOf(long k1, double v1,
            long k2, double v2);

     LongDoubleMap newImmutableMapOf(long k1, double v1,
            long k2, double v2, long k3, double v3);

     LongDoubleMap newImmutableMapOf(long k1, double v1,
            long k2, double v2, long k3, double v3,
            long k4, double v4);

     LongDoubleMap newImmutableMapOf(long k1, double v1,
            long k2, double v2, long k3, double v3,
            long k4, double v4, long k5, double v5);
}

